/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.Util;
import org.slf4j.Logger;

public class FileZipper
implements Closeable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path outputFile;
    private final Path tempFile;
    private final FileSystem fs;

    public FileZipper(Path outputFile) {
        this.outputFile = outputFile;
        this.tempFile = outputFile.resolveSibling(outputFile.getFileName().toString() + "_tmp");
        try {
            this.fs = Util.ZIP_FILE_SYSTEM_PROVIDER.newFileSystem(this.tempFile, (Map<String, ?>)ImmutableMap.of((Object)"create", (Object)"true"));
        }
        catch (IOException var3) {
            throw new UncheckedIOException(var3);
        }
    }

    public void add(Path path, String filename) {
        try {
            Path path1 = this.fs.getPath(File.separator, new String[0]);
            Path path2 = path1.resolve(path.toString());
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            Files.write(path2, filename.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException var5) {
            throw new UncheckedIOException(var5);
        }
    }

    public void add(Path path, File filename) {
        try {
            Path path1 = this.fs.getPath(File.separator, new String[0]);
            Path path2 = path1.resolve(path.toString());
            Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            Files.copy(filename.toPath(), path2, new CopyOption[0]);
        }
        catch (IOException var5) {
            throw new UncheckedIOException(var5);
        }
    }

    public void add(Path path) {
        block10: {
            try {
                Path path1 = this.fs.getPath(File.separator, new String[0]);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    Path path2 = path1.resolve(path.getParent().relativize(path).toString());
                    Files.copy(path2, path, new CopyOption[0]);
                    break block10;
                }
                try (Stream<Path> stream = Files.find(path, Integer.MAX_VALUE, (path5, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
                    for (Path path3 : stream.collect(Collectors.toList())) {
                        Path path4 = path1.resolve(path.relativize(path3).toString());
                        Files.createDirectories(path4.getParent(), new FileAttribute[0]);
                        Files.copy(path3, path4, new CopyOption[0]);
                    }
                }
            }
            catch (IOException var9) {
                throw new UncheckedIOException(var9);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.fs.close();
            Files.move(this.tempFile, this.outputFile, new CopyOption[0]);
            LOGGER.info("Compressed to {}", (Object)this.outputFile);
        }
        catch (IOException var2) {
            throw new UncheckedIOException(var2);
        }
    }
}

