/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.hash.Funnels;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.PrimitiveSink;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Map;
import java.util.OptionalLong;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class HttpUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    private HttpUtil() {
    }

    /*
     * Exception decompiling
     */
    public static Path downloadFile(Path saveFile, URL url, Map<String, String> requestProperties, HashFunction hashFunction, @Nullable HashCode hash, int maxSize, Proxy proxy, DownloadProgressListener progressListener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateModificationTime(Path path) {
        try {
            Files.setLastModifiedTime(path, FileTime.from(Instant.now()));
        }
        catch (IOException var2) {
            LOGGER.warn("Failed to update modification time of {}", (Object)path, (Object)var2);
        }
    }

    private static HashCode hashFile(Path path, HashFunction hashFunction) throws IOException {
        Hasher hasher = hashFunction.newHasher();
        try (OutputStream outputStream = Funnels.asOutputStream((PrimitiveSink)hasher);
             InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.transferTo(outputStream);
        }
        return hasher.hash();
    }

    private static boolean checkExistingFile(Path path, HashFunction hashFunction, HashCode expectedHash) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            HashCode hashCode = HttpUtil.hashFile(path, hashFunction);
            if (hashCode.equals((Object)expectedHash)) {
                return true;
            }
            LOGGER.warn("Mismatched hash of file {}, expected {} but found {}", new Object[]{path, expectedHash, hashCode});
        }
        return false;
    }

    private static Path cachedFilePath(Path path, HashCode hash) {
        return path.resolve(hash.toString());
    }

    private static HashCode downloadAndHash(HashFunction hashFunction, int maxSize, DownloadProgressListener progressListener, InputStream stream, Path outputPath) throws IOException {
        HashCode var11;
        try (OutputStream outputStream = Files.newOutputStream(outputPath, StandardOpenOption.CREATE);){
            int i;
            Hasher hasher = hashFunction.newHasher();
            byte[] bytes = new byte[8196];
            long l = 0L;
            while ((i = stream.read(bytes)) >= 0) {
                progressListener.downloadedBytes(l += (long)i);
                if (l > (long)maxSize) {
                    throw new IOException("Filesize was bigger than maximum allowed (got >= " + l + ", limit was " + maxSize + ")");
                }
                if (Thread.interrupted()) {
                    LOGGER.error("INTERRUPTED");
                    throw new IOException("Download interrupted");
                }
                outputStream.write(bytes, 0, i);
                hasher.putBytes(bytes, 0, i);
            }
            var11 = hasher.hash();
        }
        return var11;
    }

    public static int getAvailablePort() {
        try {
            int var1;
            try (ServerSocket serverSocket = new ServerSocket(0);){
                var1 = serverSocket.getLocalPort();
            }
            return var1;
        }
        catch (IOException var5) {
            return 25564;
        }
    }

    public static boolean isPortAvailable(int port) {
        if (port >= 0 && port <= 65535) {
            try {
                boolean var2;
                try (ServerSocket serverSocket = new ServerSocket(port);){
                    var2 = serverSocket.getLocalPort() == port;
                }
                return var2;
            }
            catch (IOException var6) {
                return false;
            }
        }
        return false;
    }

    public static interface DownloadProgressListener {
        public void requestStart();

        public void downloadStart(OptionalLong var1);

        public void downloadedBytes(long var1);

        public void requestFinished(boolean var1);
    }
}

