/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrack;
import net.minecraft.world.attribute.LerpFunction;

public class KeyframeTrackSampler<T> {
    private final Optional<Integer> periodTicks;
    private final LerpFunction<T> lerp;
    private final List<Segment<T>> segments;

    KeyframeTrackSampler(KeyframeTrack<T> track, Optional<Integer> periodTicks, LerpFunction<T> lerp) {
        this.periodTicks = periodTicks;
        this.lerp = lerp;
        this.segments = KeyframeTrackSampler.bakeSegments(track, periodTicks);
    }

    private static <T> List<Segment<T>> bakeSegments(KeyframeTrack<T> track, Optional<Integer> periodTicks) {
        List<Keyframe<T>> list = track.keyframes();
        if (list.size() == 1) {
            T object = list.getFirst().value();
            return List.of(new Segment<T>(EasingType.CONSTANT, object, 0, object, 0));
        }
        ArrayList<Segment<T>> list1 = new ArrayList<Segment<T>>();
        if (periodTicks.isPresent()) {
            Keyframe<T> keyframe = list.getFirst();
            Keyframe<T> keyframe1 = list.getLast();
            list1.add(new Segment<T>(track, keyframe1, keyframe1.ticks() - periodTicks.get(), keyframe, keyframe.ticks()));
            KeyframeTrackSampler.addSegmentsFromKeyframes(track, list, list1);
            list1.add(new Segment<T>(track, keyframe1, keyframe1.ticks(), keyframe, keyframe.ticks() + periodTicks.get()));
        } else {
            KeyframeTrackSampler.addSegmentsFromKeyframes(track, list, list1);
        }
        return List.copyOf(list1);
    }

    private static <T> void addSegmentsFromKeyframes(KeyframeTrack<T> track, List<Keyframe<T>> keyframes, List<Segment<T>> output) {
        for (int i = 0; i < keyframes.size() - 1; ++i) {
            Keyframe<T> keyframe = keyframes.get(i);
            Keyframe<T> keyframe1 = keyframes.get(i + 1);
            output.add(new Segment<T>(track, keyframe, keyframe.ticks(), keyframe1, keyframe1.ticks()));
        }
    }

    public T sample(long ticks) {
        long l = this.loopTicks(ticks);
        Segment<T> segmentAt = this.getSegmentAt(l);
        if (l <= (long)segmentAt.fromTicks) {
            return segmentAt.fromValue;
        }
        if (l >= (long)segmentAt.toTicks) {
            return segmentAt.toValue;
        }
        float f = (float)(l - (long)segmentAt.fromTicks) / (float)(segmentAt.toTicks - segmentAt.fromTicks);
        float f1 = segmentAt.easing.apply(f);
        return this.lerp.apply(f1, segmentAt.fromValue, segmentAt.toValue);
    }

    private Segment<T> getSegmentAt(long currentTicks) {
        for (Segment<T> segment : this.segments) {
            if (currentTicks >= (long)segment.toTicks) continue;
            return segment;
        }
        return this.segments.getLast();
    }

    private long loopTicks(long ticks) {
        return this.periodTicks.isPresent() ? (long)Math.floorMod(ticks, (int)this.periodTicks.get()) : ticks;
    }

    record Segment<T>(EasingType easing, T fromValue, int fromTicks, T toValue, int toTicks) {
        public Segment(KeyframeTrack<T> track, Keyframe<T> from, int fromTicks, Keyframe<T> to, int toTicks) {
            this(track.easingType(), from.value(), fromTicks, to.value(), toTicks);
        }
    }
}

