/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.logging.LogUtils;
import java.security.PrivateKey;
import java.security.Signature;
import net.minecraft.util.SignatureUpdater;
import org.slf4j.Logger;

public interface Signer {
    public static final Logger LOGGER = LogUtils.getLogger();

    public byte[] sign(SignatureUpdater var1);

    default public byte[] sign(byte[] signature) {
        return this.sign(output -> output.update(signature));
    }

    public static Signer from(PrivateKey privateKey, String algorithm) {
        return updater -> {
            try {
                Signature instance = Signature.getInstance(algorithm);
                instance.initSign(privateKey);
                updater.update(instance::update);
                return instance.sign();
            }
            catch (Exception var4) {
                throw new IllegalStateException("Failed to sign message", var4);
            }
        };
    }
}

