/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.concurrent.atomic.AtomicInteger;

public class TickThrottler {
    private final int incrementStep;
    private final int threshold;
    private final AtomicInteger count = new AtomicInteger();

    public TickThrottler(int incrementStep, int threshold) {
        this.incrementStep = incrementStep;
        this.threshold = threshold;
    }

    public void increment() {
        this.count.addAndGet(this.incrementStep);
    }

    public void tick() {
        int val;
        while ((val = this.count.get()) > 0 && !this.count.compareAndSet(val, val - 1)) {
        }
    }

    public boolean isUnderThreshold() {
        return this.count.get() < this.threshold;
    }

    public boolean isIncrementAndUnderThreshold() {
        return this.isIncrementAndUnderThreshold(this.incrementStep, this.threshold);
    }

    public boolean isIncrementAndUnderThreshold(int incrementStep, int threshold) {
        return this.count.addAndGet(incrementStep) < threshold;
    }
}

