/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class BannerEntityCustomNameToOverrideComponentFix
extends DataFix {
    public BannerEntityCustomNameToOverrideComponentFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.BLOCK_ENTITY);
        TaggedChoice.TaggedChoiceType taggedChoiceType = this.getInputSchema().findChoiceType(References.BLOCK_ENTITY);
        OpticFinder opticFinder = type.findField("CustomName");
        OpticFinder opticFinder1 = DSL.typeFinder((Type)this.getInputSchema().getType(References.TEXT_COMPONENT));
        return this.fixTypeEverywhereTyped("Banner entity custom_name to item_name component fix", type, typed -> {
            Object first = ((Pair)typed.get(taggedChoiceType.finder())).getFirst();
            return first.equals("minecraft:banner") ? this.fix((Typed<?>)typed, (OpticFinder<Pair<String, String>>)opticFinder1, (OpticFinder<?>)opticFinder) : typed;
        });
    }

    private Typed<?> fix(Typed<?> data, OpticFinder<Pair<String, String>> textComponentTypeOptic, OpticFinder<?> customNameOptic) {
        Optional optional = data.getOptionalTyped(customNameOptic).flatMap(typed -> typed.getOptional(textComponentTypeOptic).map(Pair::getSecond));
        boolean isPresent = optional.flatMap(LegacyComponentDataFixUtils::extractTranslationString).filter(string -> string.equals("block.minecraft.ominous_banner")).isPresent();
        return isPresent ? Util.writeAndReadTypedOrThrow(data, data.getType(), dynamic -> {
            Dynamic dynamic1 = dynamic.createMap(Map.of(dynamic.createString("minecraft:item_name"), dynamic.createString((String)optional.get()), dynamic.createString("minecraft:hide_additional_tooltip"), dynamic.emptyMap()));
            return dynamic.set("components", dynamic1).remove("CustomName");
        }) : data;
    }
}

