/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.References;

public class FixProjectileStoredItem
extends DataFix {
    private static final String EMPTY_POTION = "minecraft:empty";

    public FixProjectileStoredItem(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.ENTITY);
        Type type1 = this.getOutputSchema().getType(References.ENTITY);
        return this.fixTypeEverywhereTyped("Fix AbstractArrow item type", type, type1, ExtraDataFixUtils.chainAllFilters(this.fixChoice("minecraft:trident", FixProjectileStoredItem::castUnchecked), this.fixChoice("minecraft:arrow", FixProjectileStoredItem::fixArrow), this.fixChoice("minecraft:spectral_arrow", FixProjectileStoredItem::fixSpectralArrow)));
    }

    private Function<Typed<?>, Typed<?>> fixChoice(String itemId, SubFixer<?> fixer) {
        Type choiceType = this.getInputSchema().getChoiceType(References.ENTITY, itemId);
        Type choiceType1 = this.getOutputSchema().getChoiceType(References.ENTITY, itemId);
        return FixProjectileStoredItem.fixChoiceCap(itemId, fixer, choiceType, choiceType1);
    }

    private static <T> Function<Typed<?>, Typed<?>> fixChoiceCap(String itemId, SubFixer<?> fixer, Type<?> oldType, Type<T> newType) {
        OpticFinder opticFinder = DSL.namedChoice((String)itemId, oldType);
        return typed -> typed.updateTyped(opticFinder, newType, typed1 -> fixer.fix((Typed<?>)typed1, newType));
    }

    private static <T> Typed<T> fixArrow(Typed<?> typed, Type<T> newType) {
        return Util.writeAndReadTypedOrThrow(typed, newType, dynamic -> dynamic.set("item", FixProjectileStoredItem.createItemStack(dynamic, FixProjectileStoredItem.getArrowType(dynamic))));
    }

    private static String getArrowType(Dynamic<?> arrowTag) {
        return arrowTag.get("Potion").asString(EMPTY_POTION).equals(EMPTY_POTION) ? "minecraft:arrow" : "minecraft:tipped_arrow";
    }

    private static <T> Typed<T> fixSpectralArrow(Typed<?> typed, Type<T> newType) {
        return Util.writeAndReadTypedOrThrow(typed, newType, dynamic -> dynamic.set("item", FixProjectileStoredItem.createItemStack(dynamic, "minecraft:spectral_arrow")));
    }

    private static Dynamic<?> createItemStack(Dynamic<?> dynamic, String itemId) {
        return dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("id")), (Object)((Object)dynamic.createString(itemId)), (Object)((Object)dynamic.createString("Count")), (Object)((Object)dynamic.createInt(1))));
    }

    private static <T> Typed<T> castUnchecked(Typed<?> typed, Type<T> newType) {
        return new Typed(newType, typed.getOps(), typed.getValue());
    }

    static interface SubFixer<F> {
        public Typed<F> fix(Typed<?> var1, Type<F> var2);
    }
}

