/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.gson.JsonElement;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.fixes.References;

public class LegacyHoverEventFix
extends DataFix {
    public LegacyHoverEventFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.TEXT_COMPONENT).findFieldType("hoverEvent");
        return this.createFixer(this.getInputSchema().getTypeRaw(References.TEXT_COMPONENT), type);
    }

    private <C, H extends Pair<String, ?>> TypeRewriteRule createFixer(Type<C> componentType, Type<H> hoverEventType) {
        Type type = DSL.named((String)References.TEXT_COMPONENT.typeName(), (Type)DSL.or((Type)DSL.or((Type)DSL.string(), (Type)DSL.list(componentType)), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"extra", (Type)DSL.list(componentType))), (Type)DSL.optional((Type)DSL.field((String)"separator", componentType)), (Type)DSL.optional((Type)DSL.field((String)"hoverEvent", hoverEventType)), (Type)DSL.remainderType())));
        if (!type.equals((Object)this.getInputSchema().getType(References.TEXT_COMPONENT))) {
            throw new IllegalStateException("Text component type did not match, expected " + String.valueOf(type) + " but got " + String.valueOf(this.getInputSchema().getType(References.TEXT_COMPONENT)));
        }
        return this.fixTypeEverywhere("LegacyHoverEventFix", type, dynamicOps -> pair -> pair.mapSecond(either -> either.mapRight(pair1 -> pair1.mapSecond(pair2 -> pair2.mapSecond(pair3 -> {
            Dynamic dynamic = (Dynamic)((Object)((Object)((Object)((Object)((Object)((Object)((Object)pair3.getSecond())))))));
            Optional optional = dynamic.get("hoverEvent").result();
            if (optional.isEmpty()) {
                return pair3;
            }
            Optional optional1 = ((Dynamic)((Object)((Object)((Object)((Object)((Object)((Object)((Object)optional.get())))))))).get("value").result();
            if (optional1.isEmpty()) {
                return pair3;
            }
            String string = ((Either)pair3.getFirst()).left().map(Pair::getFirst).orElse("");
            Pair pair4 = (Pair)this.fixHoverEvent(hoverEventType, string, (Dynamic)((Object)((Object)((Object)((Object)((Object)((Object)((Object)optional.get()))))))));
            return pair3.mapFirst(either1 -> Either.left(pair4));
        })))));
    }

    private <H> H fixHoverEvent(Type<H> type, String action, Dynamic<?> data) {
        return "show_text".equals(action) ? LegacyHoverEventFix.fixShowTextHover(type, data) : LegacyHoverEventFix.createPlaceholderHover(type, data);
    }

    private static <H> H fixShowTextHover(Type<H> type, Dynamic<?> data) {
        Dynamic<?> dynamic = data.renameField("value", "contents");
        return (H)Util.readTypedOrThrow(type, dynamic).getValue();
    }

    private static <H> H createPlaceholderHover(Type<H> type, Dynamic<?> data) {
        JsonElement jsonElement = (JsonElement)data.convert(JsonOps.INSTANCE).getValue();
        Dynamic<Map<String, Map<String, CallSite>>> dynamic = new Dynamic<Map<String, Map<String, CallSite>>>((DynamicOps<Map<String, Map<String, CallSite>>>)JavaOps.INSTANCE, Map.of("action", "show_text", "contents", Map.of("text", "Legacy hoverEvent: " + GsonHelper.toStableString(jsonElement))));
        return (H)Util.readTypedOrThrow(type, dynamic).getValue();
    }
}

