/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.LongStream;
import net.minecraft.util.datafix.fixes.References;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class StructuresBecomeConfiguredFix
extends DataFix {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, Conversion> CONVERSION_MAP = ImmutableMap.builder().put((Object)"mineshaft", (Object)Conversion.biomeMapped(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)Conversion.biomeMapped(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)Conversion.biomeMapped(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)Conversion.biomeMapped(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)Conversion.biomeMapped(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)Conversion.trivial("minecraft:pillager_outpost")).put((Object)"mansion", (Object)Conversion.trivial("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)Conversion.trivial("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)Conversion.trivial("minecraft:desert_pyramid")).put((Object)"igloo", (Object)Conversion.trivial("minecraft:igloo")).put((Object)"swamp_hut", (Object)Conversion.trivial("minecraft:swamp_hut")).put((Object)"stronghold", (Object)Conversion.trivial("minecraft:stronghold")).put((Object)"monument", (Object)Conversion.trivial("minecraft:monument")).put((Object)"fortress", (Object)Conversion.trivial("minecraft:fortress")).put((Object)"endcity", (Object)Conversion.trivial("minecraft:end_city")).put((Object)"buried_treasure", (Object)Conversion.trivial("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)Conversion.trivial("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)Conversion.trivial("minecraft:bastion_remnant")).build();

    public StructuresBecomeConfiguredFix(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.CHUNK);
        Type type1 = this.getInputSchema().getType(References.CHUNK);
        return this.writeFixAndRead("StucturesToConfiguredStructures", type, type1, this::fix);
    }

    private Dynamic<?> fix(Dynamic<?> data) {
        return data.update("structures", structures -> structures.update("starts", starts -> this.updateStarts((Dynamic<?>)((Object)((Object)starts)), data)).update("References", references -> this.updateReferences((Dynamic<?>)((Object)((Object)references)), data)));
    }

    private Dynamic<?> updateStarts(Dynamic<?> starts, Dynamic<?> data) {
        Map<Dynamic, Dynamic> map = starts.getMapValues().result().orElse(Map.of());
        HashMap map1 = Maps.newHashMap();
        map.forEach((dynamic, dynamic1) -> {
            if (!dynamic1.get("id").asString("INVALID").equals("INVALID")) {
                Dynamic<?> dynamic2 = this.findUpdatedStructureType((Dynamic<?>)((Object)dynamic), data);
                if (dynamic2 == null) {
                    LOGGER.warn("Encountered unknown structure in datafixer: {}", (Object)dynamic.asString("<missing key>"));
                } else {
                    map1.computeIfAbsent(dynamic2, dynamic3 -> dynamic1.set("id", dynamic2));
                }
            }
        });
        return data.createMap(map1);
    }

    private Dynamic<?> updateReferences(Dynamic<?> references, Dynamic<?> data) {
        Map<Dynamic, Dynamic> map = references.getMapValues().result().orElse(Map.of());
        HashMap map1 = Maps.newHashMap();
        map.forEach((dynamic, dynamic1) -> {
            if (dynamic1.asLongStream().count() != 0L) {
                Dynamic<?> dynamic2 = this.findUpdatedStructureType((Dynamic<?>)((Object)dynamic), data);
                if (dynamic2 == null) {
                    LOGGER.warn("Encountered unknown structure in datafixer: {}", (Object)dynamic.asString("<missing key>"));
                } else {
                    map1.compute(dynamic2, (dynamic3, dynamic4) -> dynamic4 == null ? dynamic1 : dynamic1.createLongList(LongStream.concat(dynamic4.asLongStream(), dynamic1.asLongStream())));
                }
            }
        });
        return data.createMap(map1);
    }

    private @Nullable Dynamic<?> findUpdatedStructureType(Dynamic<?> structureName, Dynamic<?> data) {
        Optional<String> optional;
        String string = structureName.asString("UNKNOWN").toLowerCase(Locale.ROOT);
        Conversion conversion = CONVERSION_MAP.get(string);
        if (conversion == null) {
            return null;
        }
        String string1 = conversion.fallback;
        if (!conversion.biomeMapping().isEmpty() && (optional = this.guessConfiguration(data, conversion)).isPresent()) {
            string1 = optional.get();
        }
        return data.createString(string1);
    }

    private Optional<String> guessConfiguration(Dynamic<?> data, Conversion conversion) {
        Object2IntArrayMap map = new Object2IntArrayMap();
        data.get("sections").asList(Function.identity()).forEach(dynamic -> dynamic.get("biomes").get("palette").asList(Function.identity()).forEach(dynamic1 -> {
            String string = conversion.biomeMapping().get(dynamic1.asString(""));
            if (string != null) {
                map.mergeInt((Object)string, 1, Integer::sum);
            }
        }));
        return map.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map(Map.Entry::getKey);
    }

    record Conversion(Map<String, String> biomeMapping, String fallback) {
        public static Conversion trivial(String fallback) {
            return new Conversion(Map.of(), fallback);
        }

        public static Conversion biomeMapped(Map<List<String>, String> biomeMapping, String fallback) {
            return new Conversion(Conversion.unpack(biomeMapping), fallback);
        }

        private static Map<String, String> unpack(Map<List<String>, String> mapping) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<List<String>, String> entry : mapping.entrySet()) {
                entry.getKey().forEach(string -> builder.put(string, (Object)((String)entry.getValue())));
            }
            return builder.build();
        }
    }
}

