/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenSettingsFix
extends DataFix {
    private static final String VILLAGE = "minecraft:village";
    private static final String DESERT_PYRAMID = "minecraft:desert_pyramid";
    private static final String IGLOO = "minecraft:igloo";
    private static final String JUNGLE_TEMPLE = "minecraft:jungle_pyramid";
    private static final String SWAMP_HUT = "minecraft:swamp_hut";
    private static final String PILLAGER_OUTPOST = "minecraft:pillager_outpost";
    private static final String END_CITY = "minecraft:endcity";
    private static final String WOODLAND_MANSION = "minecraft:mansion";
    private static final String OCEAN_MONUMENT = "minecraft:monument";
    private static final ImmutableMap<String, StructureFeatureConfiguration> DEFAULTS = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureFeatureConfiguration(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureFeatureConfiguration(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureFeatureConfiguration(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureFeatureConfiguration(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureFeatureConfiguration(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureFeatureConfiguration(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureFeatureConfiguration(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureFeatureConfiguration(80, 20, 10387319)).build();

    public WorldGenSettingsFix(Schema outputSchema) {
        super(outputSchema, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(References.WORLD_GEN_SETTINGS), typed -> typed.update(DSL.remainderFinder(), WorldGenSettingsFix::fix));
    }

    private static <T> Dynamic<T> noise(long seed, DynamicLike<T> data, Dynamic<T> settings, Dynamic<T> biomeNoise) {
        return data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:noise")), (Object)((Object)data.createString("biome_source")), biomeNoise, (Object)((Object)data.createString("seed")), (Object)((Object)data.createLong(seed)), (Object)((Object)data.createString("settings")), settings));
    }

    private static <T> Dynamic<T> vanillaBiomeSource(Dynamic<T> data, long seed, boolean legacyBiomeInitLayer, boolean largeBiomes) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)data.createString("type"), (Object)data.createString("minecraft:vanilla_layered")).put((Object)data.createString("seed"), (Object)data.createLong(seed)).put((Object)data.createString("large_biomes"), (Object)data.createBoolean(largeBiomes));
        if (legacyBiomeInitLayer) {
            builder.put((Object)data.createString("legacy_biome_init_layer"), (Object)data.createBoolean(legacyBiomeInitLayer));
        }
        return data.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> fix(Dynamic<T> data) {
        Dynamic<T> dynamic;
        DynamicOps ops = data.getOps();
        long _long = data.get("RandomSeed").asLong(0L);
        Optional optional = data.get("generatorName").asString().map(string1 -> string1.toLowerCase(Locale.ROOT)).result();
        Optional optional1 = data.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> optional.equals(Optional.of("customized")) ? data.get("generatorOptions").asString().result() : Optional.empty());
        boolean flag = false;
        if (optional.equals(Optional.of("customized"))) {
            dynamic = WorldGenSettingsFix.defaultOverworld(data, _long);
        } else if (optional.isEmpty()) {
            dynamic = WorldGenSettingsFix.defaultOverworld(data, _long);
        } else {
            String _boolean;
            switch (_boolean = (String)optional.get()) {
                case "flat": {
                    OptionalDynamic<T> optionalDynamic = data.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> map = WorldGenSettingsFix.fixFlatStructures(ops, optionalDynamic);
                    dynamic = data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:flat")), (Object)((Object)data.createString("settings")), (Object)((Object)data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("structures")), (Object)((Object)data.createMap(map)), (Object)((Object)data.createString("layers")), (Object)((Object)optionalDynamic.get("layers").result().orElseGet(() -> data.createList(Stream.of(data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("height")), (Object)((Object)data.createInt(1)), (Object)((Object)data.createString("block")), (Object)((Object)data.createString("minecraft:bedrock")))), data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("height")), (Object)((Object)data.createInt(2)), (Object)((Object)data.createString("block")), (Object)((Object)data.createString("minecraft:dirt")))), data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("height")), (Object)((Object)data.createInt(1)), (Object)((Object)data.createString("block")), (Object)((Object)data.createString("minecraft:grass_block")))))))), (Object)((Object)data.createString("biome")), (Object)((Object)data.createString(optionalDynamic.get("biome").asString("minecraft:plains"))))))));
                    break;
                }
                case "debug_all_block_states": {
                    dynamic = data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:debug"))));
                    break;
                }
                case "buffet": {
                    Dynamic dynamic3;
                    Dynamic dynamic1;
                    OptionalDynamic<T> optionalDynamic1 = data.get("generatorOptions");
                    OptionalDynamic optionalDynamic2 = optionalDynamic1.get("chunk_generator");
                    Optional optional2 = optionalDynamic2.get("type").asString().result();
                    if (Objects.equals(optional2, Optional.of("minecraft:caves"))) {
                        dynamic1 = data.createString("minecraft:caves");
                        flag = true;
                    } else {
                        dynamic1 = Objects.equals(optional2, Optional.of("minecraft:floating_islands")) ? data.createString("minecraft:floating_islands") : data.createString("minecraft:overworld");
                    }
                    Dynamic dynamic2 = optionalDynamic1.get("biome_source").result().orElseGet(() -> data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:fixed")))));
                    if (dynamic2.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String string = dynamic2.get("options").get("biomes").asStream().findFirst().flatMap(dynamic4 -> dynamic4.asString().result()).orElse("minecraft:ocean");
                        dynamic3 = dynamic2.remove("options").set("biome", data.createString(string));
                    } else {
                        dynamic3 = dynamic2;
                    }
                    dynamic = WorldGenSettingsFix.noise(_long, data, dynamic1, dynamic3);
                    break;
                }
                default: {
                    boolean flag1 = ((String)optional.get()).equals("default");
                    boolean flag2 = ((String)optional.get()).equals("default_1_1") || flag1 && data.get("generatorVersion").asInt(0) == 0;
                    boolean flag3 = ((String)optional.get()).equals("amplified");
                    boolean flag4 = ((String)optional.get()).equals("largebiomes");
                    dynamic = WorldGenSettingsFix.noise(_long, data, data.createString(flag3 ? "minecraft:amplified" : "minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(data, _long, flag2, flag4));
                }
            }
        }
        boolean _boolean = data.get("MapFeatures").asBoolean(true);
        boolean _boolean1 = data.get("BonusChest").asBoolean(false);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(ops.createString("seed"), ops.createLong(_long));
        builder.put(ops.createString("generate_features"), ops.createBoolean(_boolean));
        builder.put(ops.createString("bonus_chest"), ops.createBoolean(_boolean1));
        builder.put(ops.createString("dimensions"), WorldGenSettingsFix.vanillaLevels(data, _long, dynamic, flag));
        optional1.ifPresent(string1 -> builder.put(ops.createString("legacy_custom_options"), ops.createString(string1)));
        return new Dynamic<Object>(ops, ops.createMap((Map)builder.build()));
    }

    protected static <T> Dynamic<T> defaultOverworld(Dynamic<T> data, long seed) {
        return WorldGenSettingsFix.noise(seed, data, data.createString("minecraft:overworld"), WorldGenSettingsFix.vanillaBiomeSource(data, seed, false, false));
    }

    protected static <T> T vanillaLevels(Dynamic<T> data, long seed, Dynamic<T> generator, boolean caves) {
        DynamicOps ops = data.getOps();
        return (T)ops.createMap((Map)ImmutableMap.of((Object)ops.createString("minecraft:overworld"), (Object)ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString("minecraft:overworld" + (caves ? "_caves" : "")), (Object)ops.createString("generator"), generator.getValue())), (Object)ops.createString("minecraft:the_nether"), (Object)ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString("minecraft:the_nether"), (Object)ops.createString("generator"), WorldGenSettingsFix.noise(seed, data, data.createString("minecraft:nether"), data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:multi_noise")), (Object)((Object)data.createString("seed")), (Object)((Object)data.createLong(seed)), (Object)((Object)data.createString("preset")), (Object)((Object)data.createString("minecraft:nether"))))).getValue())), (Object)ops.createString("minecraft:the_end"), (Object)ops.createMap((Map)ImmutableMap.of((Object)ops.createString("type"), (Object)ops.createString("minecraft:the_end"), (Object)ops.createString("generator"), WorldGenSettingsFix.noise(seed, data, data.createString("minecraft:end"), data.createMap((Map)ImmutableMap.of((Object)((Object)data.createString("type")), (Object)((Object)data.createString("minecraft:the_end")), (Object)((Object)data.createString("seed")), (Object)((Object)data.createLong(seed))))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> fixFlatStructures(DynamicOps<T> ops, OptionalDynamic<T> generatorOptions) {
        MutableInt mutableInt = new MutableInt(32);
        MutableInt mutableInt1 = new MutableInt(3);
        MutableInt mutableInt2 = new MutableInt(128);
        MutableBoolean mutableBoolean = new MutableBoolean(false);
        HashMap map = Maps.newHashMap();
        if (generatorOptions.result().isEmpty()) {
            mutableBoolean.setTrue();
            map.put(VILLAGE, (StructureFeatureConfiguration)DEFAULTS.get((Object)VILLAGE));
        }
        generatorOptions.get("structures").flatMap(Dynamic::getMapValues).ifSuccess(map1 -> map1.forEach((dynamic, dynamic1) -> dynamic1.getMapValues().result().ifPresent(map2 -> map2.forEach((dynamic2, dynamic3) -> {
            String string = dynamic.asString("");
            String string1 = dynamic2.asString("");
            String string2 = dynamic3.asString("");
            if ("stronghold".equals(string)) {
                mutableBoolean.setTrue();
                switch (string1) {
                    case "distance": {
                        mutableInt.setValue(WorldGenSettingsFix.getInt(string2, mutableInt.intValue(), 1));
                        return;
                    }
                    case "spread": {
                        mutableInt1.setValue(WorldGenSettingsFix.getInt(string2, mutableInt1.intValue(), 1));
                        return;
                    }
                    case "count": {
                        mutableInt2.setValue(WorldGenSettingsFix.getInt(string2, mutableInt2.intValue(), 1));
                        return;
                    }
                }
            } else {
                switch (string1) {
                    case "distance": {
                        switch (string) {
                            case "village": {
                                WorldGenSettingsFix.setSpacing(map, VILLAGE, string2, 9);
                                return;
                            }
                            case "biome_1": {
                                WorldGenSettingsFix.setSpacing(map, DESERT_PYRAMID, string2, 9);
                                WorldGenSettingsFix.setSpacing(map, IGLOO, string2, 9);
                                WorldGenSettingsFix.setSpacing(map, JUNGLE_TEMPLE, string2, 9);
                                WorldGenSettingsFix.setSpacing(map, SWAMP_HUT, string2, 9);
                                WorldGenSettingsFix.setSpacing(map, PILLAGER_OUTPOST, string2, 9);
                                return;
                            }
                            case "endcity": {
                                WorldGenSettingsFix.setSpacing(map, END_CITY, string2, 1);
                                return;
                            }
                            case "mansion": {
                                WorldGenSettingsFix.setSpacing(map, WOODLAND_MANSION, string2, 1);
                                return;
                            }
                        }
                        return;
                    }
                    case "separation": {
                        if ("oceanmonument".equals(string)) {
                            StructureFeatureConfiguration structureFeatureConfiguration = map.getOrDefault(OCEAN_MONUMENT, (StructureFeatureConfiguration)DEFAULTS.get((Object)OCEAN_MONUMENT));
                            int _int = WorldGenSettingsFix.getInt(string2, structureFeatureConfiguration.separation, 1);
                            map.put(OCEAN_MONUMENT, new StructureFeatureConfiguration(_int, structureFeatureConfiguration.separation, structureFeatureConfiguration.salt));
                        }
                        return;
                    }
                    case "spacing": {
                        if ("oceanmonument".equals(string)) {
                            WorldGenSettingsFix.setSpacing(map, OCEAN_MONUMENT, string2, 1);
                        }
                        return;
                    }
                }
            }
        }))));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)generatorOptions.createString("structures"), (Object)generatorOptions.createMap(map.entrySet().stream().collect(Collectors.toMap(entry -> generatorOptions.createString((String)entry.getKey()), entry -> ((StructureFeatureConfiguration)entry.getValue()).serialize(ops)))));
        if (mutableBoolean.isTrue()) {
            builder.put((Object)generatorOptions.createString("stronghold"), (Object)generatorOptions.createMap((Map)ImmutableMap.of((Object)((Object)generatorOptions.createString("distance")), (Object)((Object)generatorOptions.createInt(mutableInt.intValue())), (Object)((Object)generatorOptions.createString("spread")), (Object)((Object)generatorOptions.createInt(mutableInt1.intValue())), (Object)((Object)generatorOptions.createString("count")), (Object)((Object)generatorOptions.createInt(mutableInt2.intValue())))));
        }
        return builder.build();
    }

    private static int getInt(String string, int defaultValue) {
        return NumberUtils.toInt((String)string, (int)defaultValue);
    }

    private static int getInt(String string, int defaultValue, int minValue) {
        return Math.max(minValue, WorldGenSettingsFix.getInt(string, defaultValue));
    }

    private static void setSpacing(Map<String, StructureFeatureConfiguration> map, String structure, String spacing, int minValue) {
        StructureFeatureConfiguration structureFeatureConfiguration = map.getOrDefault(structure, (StructureFeatureConfiguration)DEFAULTS.get((Object)structure));
        int _int = WorldGenSettingsFix.getInt(spacing, structureFeatureConfiguration.spacing, minValue);
        map.put(structure, new StructureFeatureConfiguration(_int, structureFeatureConfiguration.separation, structureFeatureConfiguration.salt));
    }

    static final class StructureFeatureConfiguration {
        public static final Codec<StructureFeatureConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(config -> config.spacing), (App)Codec.INT.fieldOf("separation").forGetter(config -> config.separation), (App)Codec.INT.fieldOf("salt").forGetter(config -> config.salt)).apply((Applicative)instance, StructureFeatureConfiguration::new));
        final int spacing;
        final int separation;
        final int salt;

        public StructureFeatureConfiguration(int spacing, int separation, int salt) {
            this.spacing = spacing;
            this.separation = separation;
            this.salt = salt;
        }

        public <T> Dynamic<T> serialize(DynamicOps<T> ops) {
            return new Dynamic<Object>(ops, CODEC.encodeStart(ops, (Object)this).result().orElse(ops.emptyMap()));
        }
    }
}

