/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import net.minecraft.util.Util;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;
import org.jspecify.annotations.Nullable;

public abstract class CachedParseState<S>
implements ParseState<S> {
    private @Nullable PositionCache[] positionCache = new PositionCache[256];
    private final ErrorCollector<S> errorCollector;
    private final Scope scope = new Scope();
    private @Nullable SimpleControl[] controlCache = new SimpleControl[16];
    private int nextControlToReturn;
    private final Silent silent = new Silent();

    protected CachedParseState(ErrorCollector<S> errorCollector) {
        this.errorCollector = errorCollector;
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    @Override
    public <T> @Nullable T parse(NamedRule<S, T> rule) {
        CacheEntry<Object> cacheEntry;
        T object;
        int i = this.mark();
        PositionCache cacheForPosition = this.getCacheForPosition(i);
        int i1 = cacheForPosition.findKeyIndex(rule.name());
        if (i1 != -1) {
            CacheEntry value = cacheForPosition.getValue(i1);
            if (value != null) {
                if (value == CacheEntry.NEGATIVE) {
                    return null;
                }
                this.restore(value.markAfterParse);
                return value.value;
            }
        } else {
            i1 = cacheForPosition.allocateNewEntry(rule.name());
        }
        if ((object = rule.value().parse(this)) == null) {
            cacheEntry = CacheEntry.NEGATIVE;
        } else {
            int i2 = this.mark();
            cacheEntry = new CacheEntry<T>(object, i2);
        }
        cacheForPosition.setValue(i1, cacheEntry);
        return object;
    }

    private PositionCache getCacheForPosition(int position) {
        PositionCache positionCache;
        int i = this.positionCache.length;
        if (position >= i) {
            int i1 = Util.growByHalf(i, position + 1);
            PositionCache[] positionCaches = new PositionCache[i1];
            System.arraycopy(this.positionCache, 0, positionCaches, 0, i);
            this.positionCache = positionCaches;
        }
        if ((positionCache = this.positionCache[position]) == null) {
            this.positionCache[position] = positionCache = new PositionCache();
        }
        return positionCache;
    }

    @Override
    public Control acquireControl() {
        SimpleControl simpleControl;
        int i1;
        int i = this.controlCache.length;
        if (this.nextControlToReturn >= i) {
            i1 = Util.growByHalf(i, this.nextControlToReturn + 1);
            SimpleControl[] simpleControls = new SimpleControl[i1];
            System.arraycopy(this.controlCache, 0, simpleControls, 0, i);
            this.controlCache = simpleControls;
        }
        if ((simpleControl = this.controlCache[i1 = this.nextControlToReturn++]) == null) {
            this.controlCache[i1] = simpleControl = new SimpleControl();
        } else {
            simpleControl.reset();
        }
        return simpleControl;
    }

    @Override
    public void releaseControl() {
        --this.nextControlToReturn;
    }

    @Override
    public ParseState<S> silent() {
        return this.silent;
    }

    static class PositionCache {
        public static final int ENTRY_STRIDE = 2;
        private static final int NOT_FOUND = -1;
        private Object[] atomCache = new Object[16];
        private int nextKey;

        PositionCache() {
        }

        public int findKeyIndex(Atom<?> atom) {
            for (int i = 0; i < this.nextKey; i += 2) {
                if (this.atomCache[i] != atom) continue;
                return i;
            }
            return -1;
        }

        public int allocateNewEntry(Atom<?> entry) {
            int i = this.nextKey;
            this.nextKey += 2;
            int i1 = i + 1;
            int i2 = this.atomCache.length;
            if (i1 >= i2) {
                int i3 = Util.growByHalf(i2, i1 + 1);
                Object[] objects = new Object[i3];
                System.arraycopy(this.atomCache, 0, objects, 0, i2);
                this.atomCache = objects;
            }
            this.atomCache[i] = entry;
            return i;
        }

        public <T> @Nullable CacheEntry<T> getValue(int index) {
            return (CacheEntry)this.atomCache[index + 1];
        }

        public void setValue(int index, CacheEntry<?> value) {
            this.atomCache[index + 1] = value;
        }
    }

    static class SimpleControl
    implements Control {
        private boolean hasCut;

        SimpleControl() {
        }

        @Override
        public void cut() {
            this.hasCut = true;
        }

        @Override
        public boolean hasCut() {
            return this.hasCut;
        }

        public void reset() {
            this.hasCut = false;
        }
    }

    class Silent
    implements ParseState<S> {
        private final ErrorCollector<S> silentCollector = new ErrorCollector.Nop();

        Silent() {
        }

        @Override
        public ErrorCollector<S> errorCollector() {
            return this.silentCollector;
        }

        @Override
        public Scope scope() {
            return CachedParseState.this.scope();
        }

        @Override
        public <T> @Nullable T parse(NamedRule<S, T> rule) {
            return CachedParseState.this.parse(rule);
        }

        @Override
        public S input() {
            return CachedParseState.this.input();
        }

        @Override
        public int mark() {
            return CachedParseState.this.mark();
        }

        @Override
        public void restore(int cursor) {
            CachedParseState.this.restore(cursor);
        }

        @Override
        public Control acquireControl() {
            return CachedParseState.this.acquireControl();
        }

        @Override
        public void releaseControl() {
            CachedParseState.this.releaseControl();
        }

        @Override
        public ParseState<S> silent() {
            return this;
        }
    }

    record CacheEntry<T>(@Nullable T value, int markAfterParse) {
        public static final CacheEntry<?> NEGATIVE = new CacheEntry<Object>(null, -1);

        public static <T> CacheEntry<T> negativeEntry() {
            return NEGATIVE;
        }
    }
}

