/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Util;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Term;
import org.jspecify.annotations.Nullable;

public final class Scope {
    private static final int NOT_FOUND = -1;
    private static final Object FRAME_START_MARKER = new Object(){

        public String toString() {
            return "frame";
        }
    };
    private static final int ENTRY_STRIDE = 2;
    private @Nullable Object[] stack = new Object[128];
    private int topEntryKeyIndex = 0;
    private int topMarkerKeyIndex = 0;
    private int depth;
    private static final Term<?> INCREASING_DEPTH_TERM = (parseState, scope, control) -> {
        if (++scope.depth > 512) {
            parseState.errorCollector().store(parseState.mark(), new IllegalStateException("Too deep"));
            return false;
        }
        return true;
    };
    private static final Term<?> DECREASING_DEPTH_TERM = (parseState, scope, control) -> {
        --scope.depth;
        return true;
    };

    public Scope() {
        this.stack[0] = FRAME_START_MARKER;
        this.stack[1] = null;
    }

    private int valueIndex(Atom<?> name) {
        for (int i = this.topEntryKeyIndex; i > this.topMarkerKeyIndex; i -= 2) {
            Object object = this.stack[i];
            assert (object instanceof Atom);
            if (object != name) continue;
            return i + 1;
        }
        return -1;
    }

    public int valueIndexForAny(Atom<?> ... names) {
        for (int i = this.topEntryKeyIndex; i > this.topMarkerKeyIndex; i -= 2) {
            Object object = this.stack[i];
            assert (object instanceof Atom);
            for (Atom<?> atom : names) {
                if (atom != object) continue;
                return i + 1;
            }
        }
        return -1;
    }

    private void ensureCapacity(int requiredCapacity) {
        int i1 = this.topEntryKeyIndex + 1;
        int i2 = i1 + requiredCapacity * 2;
        int i = this.stack.length;
        if (i2 >= i) {
            int i3 = Util.growByHalf(i, i2 + 1);
            Object[] objects = new Object[i3];
            System.arraycopy(this.stack, 0, objects, 0, i);
            this.stack = objects;
        }
        assert (this.validateStructure());
    }

    private void setupNewFrame() {
        this.topEntryKeyIndex += 2;
        this.stack[this.topEntryKeyIndex] = FRAME_START_MARKER;
        this.stack[this.topEntryKeyIndex + 1] = this.topMarkerKeyIndex;
        this.topMarkerKeyIndex = this.topEntryKeyIndex;
    }

    public void pushFrame() {
        this.ensureCapacity(1);
        this.setupNewFrame();
        assert (this.validateStructure());
    }

    private int getPreviousMarkerIndex(int markerIndex) {
        return (Integer)this.stack[markerIndex + 1];
    }

    public void popFrame() {
        assert (this.topMarkerKeyIndex != 0);
        this.topEntryKeyIndex = this.topMarkerKeyIndex - 2;
        this.topMarkerKeyIndex = this.getPreviousMarkerIndex(this.topMarkerKeyIndex);
        assert (this.validateStructure());
    }

    public void splitFrame() {
        int i = this.topMarkerKeyIndex;
        int i1 = (this.topEntryKeyIndex - this.topMarkerKeyIndex) / 2;
        this.ensureCapacity(i1 + 1);
        this.setupNewFrame();
        int i2 = i + 2;
        int i3 = this.topEntryKeyIndex;
        for (int i4 = 0; i4 < i1; ++i4) {
            i3 += 2;
            Object object = this.stack[i2];
            assert (object != null);
            this.stack[i3] = object;
            this.stack[i3 + 1] = null;
            i2 += 2;
        }
        this.topEntryKeyIndex = i3;
        assert (this.validateStructure());
    }

    public void clearFrameValues() {
        for (int i = this.topEntryKeyIndex; i > this.topMarkerKeyIndex; i -= 2) {
            assert (this.stack[i] instanceof Atom);
            this.stack[i + 1] = null;
        }
        assert (this.validateStructure());
    }

    public void mergeFrame() {
        int previousMarkerIndex;
        int i = previousMarkerIndex = this.getPreviousMarkerIndex(this.topMarkerKeyIndex);
        int i1 = this.topMarkerKeyIndex;
        while (i1 < this.topEntryKeyIndex) {
            i += 2;
            Object object = this.stack[i1 += 2];
            assert (object instanceof Atom);
            Object object1 = this.stack[i1 + 1];
            Object object2 = this.stack[i];
            if (object2 != object) {
                this.stack[i] = object;
                this.stack[i + 1] = object1;
                continue;
            }
            if (object1 == null) continue;
            this.stack[i + 1] = object1;
        }
        this.topEntryKeyIndex = i;
        this.topMarkerKeyIndex = previousMarkerIndex;
        assert (this.validateStructure());
    }

    public <T> void put(Atom<T> atom, @Nullable T value) {
        int i = this.valueIndex(atom);
        if (i != -1) {
            this.stack[i] = value;
        } else {
            this.ensureCapacity(1);
            this.topEntryKeyIndex += 2;
            this.stack[this.topEntryKeyIndex] = atom;
            this.stack[this.topEntryKeyIndex + 1] = value;
        }
        assert (this.validateStructure());
    }

    public <T> @Nullable T get(Atom<T> atom) {
        int i = this.valueIndex(atom);
        return (T)(i != -1 ? this.stack[i] : null);
    }

    public <T> T getOrThrow(Atom<T> atom) {
        int i = this.valueIndex(atom);
        if (i == -1) {
            throw new IllegalArgumentException("No value for atom " + String.valueOf(atom));
        }
        return (T)this.stack[i];
    }

    public <T> T getOrDefault(Atom<T> atom, T defaultValue) {
        int i = this.valueIndex(atom);
        return (T)(i != -1 ? this.stack[i] : defaultValue);
    }

    @SafeVarargs
    public final <T> @Nullable T getAny(Atom<? extends T> ... atoms) {
        int i = this.valueIndexForAny(atoms);
        return (T)(i != -1 ? this.stack[i] : null);
    }

    @SafeVarargs
    public final <T> T getAnyOrThrow(Atom<? extends T> ... atoms) {
        int i = this.valueIndexForAny(atoms);
        if (i == -1) {
            throw new IllegalArgumentException("No value for atoms " + Arrays.toString(atoms));
        }
        return (T)this.stack[i];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean flag = true;
        for (int i = 0; i <= this.topEntryKeyIndex; i += 2) {
            Object object = this.stack[i];
            Object object1 = this.stack[i + 1];
            if (object == FRAME_START_MARKER) {
                stringBuilder.append('|');
                flag = true;
                continue;
            }
            if (!flag) {
                stringBuilder.append(',');
            }
            flag = false;
            stringBuilder.append(object).append(':').append(object1);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    public Map<Atom<?>, ?> lastFrame() {
        HashMap<Atom, Object> map = new HashMap<Atom, Object>();
        for (int i = this.topEntryKeyIndex; i > this.topMarkerKeyIndex; i -= 2) {
            Object object = this.stack[i];
            Object object1 = this.stack[i + 1];
            map.put((Atom)object, object1);
        }
        return map;
    }

    public boolean hasOnlySingleFrame() {
        for (int i = this.topEntryKeyIndex; i > 0; --i) {
            if (this.stack[i] != FRAME_START_MARKER) continue;
            return false;
        }
        if (this.stack[0] != FRAME_START_MARKER) {
            throw new IllegalStateException("Corrupted stack");
        }
        return true;
    }

    private boolean validateStructure() {
        Object object;
        assert (this.topMarkerKeyIndex >= 0);
        assert (this.topEntryKeyIndex >= this.topMarkerKeyIndex);
        for (int i = 0; i <= this.topEntryKeyIndex; i += 2) {
            object = this.stack[i];
            if (object == FRAME_START_MARKER || object instanceof Atom) continue;
            return false;
        }
        int ix = this.topMarkerKeyIndex;
        while (ix != 0) {
            object = this.stack[ix];
            if (object != FRAME_START_MARKER) {
                return false;
            }
            ix = this.getPreviousMarkerIndex(ix);
        }
        return true;
    }

    public static <S> Term<S> increaseDepth() {
        return INCREASING_DEPTH_TERM;
    }

    public static <S> Term<S> decreaseDepth() {
        return DECREASING_DEPTH_TERM;
    }
}

