/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;

public class WeightedRandom {
    private WeightedRandom() {
    }

    public static <T> int getTotalWeight(List<T> elements, ToIntFunction<T> weightGetter) {
        long l = 0L;
        for (T object : elements) {
            l += (long)weightGetter.applyAsInt(object);
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static <T> Optional<T> getRandomItem(RandomSource random, List<T> elements, int totalWeight, ToIntFunction<T> weightGetter) {
        if (totalWeight < 0) {
            throw Util.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (totalWeight == 0) {
            return Optional.empty();
        }
        int randomInt = random.nextInt(totalWeight);
        return WeightedRandom.getWeightedItem(elements, randomInt, weightGetter);
    }

    public static <T> Optional<T> getWeightedItem(List<T> elements, int index, ToIntFunction<T> weightGetter) {
        for (T object : elements) {
            if ((index -= weightGetter.applyAsInt(object)) >= 0) continue;
            return Optional.of(object);
        }
        return Optional.empty();
    }

    public static <T> Optional<T> getRandomItem(RandomSource random, List<T> elements, ToIntFunction<T> weightGetter) {
        return WeightedRandom.getRandomItem(random, elements, WeightedRandom.getTotalWeight(elements, weightGetter), weightGetter);
    }
}

