/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface TaskScheduler<R extends Runnable>
extends AutoCloseable {
    public String name();

    public void schedule(R var1);

    @Override
    default public void close() {
    }

    public R wrapRunnable(Runnable var1);

    default public <Source> CompletableFuture<Source> scheduleWithResult(Consumer<CompletableFuture<Source>> resultConsumer) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.schedule(this.wrapRunnable(() -> resultConsumer.accept(completableFuture)));
        return completableFuture;
    }

    public static TaskScheduler<Runnable> wrapExecutor(final String name, final Executor executor) {
        return new TaskScheduler<Runnable>(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public void schedule(Runnable task) {
                executor.execute(task);
            }

            @Override
            public Runnable wrapRunnable(Runnable runnable) {
                return runnable;
            }

            public String toString() {
                return name;
            }
        };
    }
}

