/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.serialization.Codec;
import io.papermc.paper.annotation.DoNotUse;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public record LockCode(ItemPredicate predicate) {
    public static final LockCode NO_LOCK = new LockCode(ItemPredicate.Builder.item().build());
    public static final Codec<LockCode> CODEC = ItemPredicate.CODEC.xmap(LockCode::new, LockCode::predicate);
    public static final String TAG_LOCK = "lock";

    public boolean unlocksWith(ItemStack stack) {
        return this.predicate.test(stack);
    }

    public void addToTag(ValueOutput output) {
        if (this != NO_LOCK) {
            output.store(TAG_LOCK, CODEC, this);
        }
    }

    @DoNotUse
    @Deprecated
    public boolean canUnlock(Player player) {
        return this.canUnlock(player, player.getMainHandItem());
    }

    public boolean canUnlock(Player player, ItemStack item) {
        return player.isSpectator() || this.unlocksWith(item);
    }

    public static LockCode fromTag(ValueInput input) {
        return input.read(TAG_LOCK, CODEC).orElse(NO_LOCK);
    }
}

