/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.mojang.serialization.DataResult;
import net.minecraft.util.Mth;

public interface AttributeRange<Value> {
    public static final AttributeRange<Float> UNIT_FLOAT = AttributeRange.ofFloat(0.0f, 1.0f);
    public static final AttributeRange<Float> NON_NEGATIVE_FLOAT = AttributeRange.ofFloat(0.0f, Float.POSITIVE_INFINITY);

    public static <Value> AttributeRange<Value> any() {
        return new AttributeRange<Value>(){

            @Override
            public DataResult<Value> validate(Value value) {
                return DataResult.success(value);
            }

            @Override
            public Value sanitize(Value value) {
                return value;
            }
        };
    }

    public static AttributeRange<Float> ofFloat(final float min, final float max) {
        return new AttributeRange<Float>(){

            @Override
            public DataResult<Float> validate(Float value) {
                return value.floatValue() >= min && value.floatValue() <= max ? DataResult.success((Object)value) : DataResult.error(() -> value + " is not in range [" + min + "; " + max + "]");
            }

            @Override
            public Float sanitize(Float value) {
                return Float.valueOf(value.floatValue() >= min && value.floatValue() <= max ? value.floatValue() : Mth.clamp(value.floatValue(), min, max));
            }
        };
    }

    public DataResult<Value> validate(Value var1);

    public Value sanitize(Value var1);
}

