/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.Util;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.attribute.modifier.AttributeModifier;
import org.jspecify.annotations.Nullable;

public final class EnvironmentAttributeMap {
    public static final EnvironmentAttributeMap EMPTY = new EnvironmentAttributeMap(Map.of());
    public static final Codec<EnvironmentAttributeMap> CODEC = Codec.lazyInitialized(() -> Codec.dispatchedMap(EnvironmentAttributes.CODEC, Util.memoize(Entry::createCodec)).xmap(EnvironmentAttributeMap::new, environmentAttributeMap -> environmentAttributeMap.entries));
    public static final Codec<EnvironmentAttributeMap> NETWORK_CODEC = CODEC.xmap(EnvironmentAttributeMap::filterSyncable, EnvironmentAttributeMap::filterSyncable);
    public static final Codec<EnvironmentAttributeMap> CODEC_ONLY_POSITIONAL = CODEC.validate(environmentAttributeMap -> {
        List<EnvironmentAttribute> list = environmentAttributeMap.keySet().stream().filter(environmentAttribute -> !environmentAttribute.isPositional()).toList();
        return !list.isEmpty() ? DataResult.error(() -> "The following attributes cannot be positional: " + String.valueOf(list)) : DataResult.success((Object)environmentAttributeMap);
    });
    final Map<EnvironmentAttribute<?>, Entry<?, ?>> entries;

    private static EnvironmentAttributeMap filterSyncable(EnvironmentAttributeMap attributes) {
        return new EnvironmentAttributeMap(Map.copyOf(Maps.filterKeys(attributes.entries, EnvironmentAttribute::isSyncable)));
    }

    EnvironmentAttributeMap(Map<EnvironmentAttribute<?>, Entry<?, ?>> entries) {
        this.entries = entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public <Value> @Nullable Entry<Value, ?> get(EnvironmentAttribute<Value> attribute) {
        return this.entries.get(attribute);
    }

    public <Value> Value applyModifier(EnvironmentAttribute<Value> attribute, Value value) {
        Entry<Value, ?> entry = this.get(attribute);
        return entry != null ? entry.applyModifier(value) : value;
    }

    public boolean contains(EnvironmentAttribute<?> attribute) {
        return this.entries.containsKey(attribute);
    }

    public Set<EnvironmentAttribute<?>> keySet() {
        return this.entries.keySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof EnvironmentAttributeMap)) return false;
        EnvironmentAttributeMap environmentAttributeMap = (EnvironmentAttributeMap)other;
        if (!this.entries.equals(environmentAttributeMap.entries)) return false;
        return true;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return this.entries.toString();
    }

    public static class Builder {
        private final Map<EnvironmentAttribute<?>, Entry<?, ?>> entries = new HashMap();

        Builder() {
        }

        public Builder putAll(EnvironmentAttributeMap attributes) {
            this.entries.putAll(attributes.entries);
            return this;
        }

        public <Value, Parameter> Builder modify(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Parameter> modifier, Parameter argument) {
            attribute.type().checkAllowedModifier(modifier);
            this.entries.put(attribute, new Entry<Value, Parameter>(argument, modifier));
            return this;
        }

        public <Value> Builder set(EnvironmentAttribute<Value> attribute, Value value) {
            return this.modify(attribute, AttributeModifier.override(), value);
        }

        public EnvironmentAttributeMap build() {
            return this.entries.isEmpty() ? EMPTY : new EnvironmentAttributeMap(Map.copyOf(this.entries));
        }
    }

    public record Entry<Value, Argument>(Argument argument, AttributeModifier<Value, Argument> modifier) {
        private static <Value> Codec<Entry<Value, ?>> createCodec(EnvironmentAttribute<Value> attribute) {
            Codec codec = attribute.type().modifierCodec().dispatch("modifier", Entry::modifier, Util.memoize(attributeModifier -> Entry.createFullCodec(attribute, attributeModifier)));
            return Codec.either(attribute.valueCodec(), (Codec)codec).xmap(either -> either.map(object -> new Entry(object, AttributeModifier.override()), entry -> entry), entry -> entry.modifier == AttributeModifier.override() ? Either.left(entry.argument()) : Either.right(entry));
        }

        private static <Value, Argument> MapCodec<Entry<Value, Argument>> createFullCodec(EnvironmentAttribute<Value> attribute, AttributeModifier<Value, Argument> modifier) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)modifier.argumentCodec(attribute).fieldOf("argument").forGetter(Entry::argument)).apply((Applicative)instance, object -> new Entry(object, modifier)));
        }

        public Value applyModifier(Value value) {
            return this.modifier.apply(value, this.argument);
        }
    }
}

