/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.attribute;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.attribute.EnvironmentAttribute;
import net.minecraft.world.attribute.EnvironmentAttributeLayer;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.attribute.SpatialAttributeInterpolator;
import net.minecraft.world.attribute.WeatherAttributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.timeline.Timeline;
import org.jspecify.annotations.Nullable;

public class EnvironmentAttributeSystem
implements EnvironmentAttributeReader {
    private final Map<EnvironmentAttribute<?>, ValueSampler<?>> attributeSamplers = new Reference2ObjectOpenHashMap();

    EnvironmentAttributeSystem(Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> layersByAttribute) {
        layersByAttribute.forEach((attribute, layers) -> this.attributeSamplers.put((EnvironmentAttribute<?>)attribute, this.bakeLayerSampler((EnvironmentAttribute)attribute, (List<? extends EnvironmentAttributeLayer<?>>)layers)));
    }

    private <Value> ValueSampler<Value> bakeLayerSampler(EnvironmentAttribute<Value> attribute, List<? extends EnvironmentAttributeLayer<?>> untypedLayers) {
        Object e;
        ArrayList list = new ArrayList(untypedLayers);
        Value object = attribute.defaultValue();
        while (!list.isEmpty() && (e = list.getFirst()) instanceof EnvironmentAttributeLayer.Constant) {
            EnvironmentAttributeLayer.Constant constant = (EnvironmentAttributeLayer.Constant)e;
            object = constant.applyConstant(object);
            list.removeFirst();
        }
        boolean flag = list.stream().anyMatch(environmentAttributeLayer -> environmentAttributeLayer instanceof EnvironmentAttributeLayer.Positional);
        return new ValueSampler<Value>(attribute, object, List.copyOf(list), flag);
    }

    public static Builder builder() {
        return new Builder();
    }

    static void addDefaultLayers(Builder builder, Level level) {
        RegistryAccess registryAccess = level.registryAccess();
        BiomeManager biomeManager = level.getBiomeManager();
        LongSupplier longSupplier = level::getDayTime;
        EnvironmentAttributeSystem.addDimensionLayer(builder, level.dimensionType());
        EnvironmentAttributeSystem.addBiomeLayer(builder, registryAccess.lookupOrThrow(Registries.BIOME), biomeManager);
        level.dimensionType().timelines().forEach(holder -> builder.addTimelineLayer((Holder<Timeline>)holder, longSupplier));
        if (level.canHaveWeather()) {
            WeatherAttributes.addBuiltinLayers(builder, WeatherAttributes.WeatherAccess.from(level));
        }
    }

    private static void addDimensionLayer(Builder builder, DimensionType dimensionType) {
        builder.addConstantLayer(dimensionType.attributes());
    }

    private static void addBiomeLayer(Builder builder, HolderLookup<Biome> biomes, BiomeManager biomeManager) {
        Stream stream = biomes.listElements().flatMap(reference -> ((Biome)reference.value()).getAttributes().keySet().stream()).distinct();
        stream.forEach(environmentAttribute -> EnvironmentAttributeSystem.addBiomeLayerForAttribute(builder, environmentAttribute, biomeManager));
    }

    private static <Value> void addBiomeLayerForAttribute(Builder builder, EnvironmentAttribute<Value> attribute, BiomeManager biomeManager) {
        builder.addPositionalLayer(attribute, (baseValue, pos, biomeInterpolator) -> {
            if (biomeInterpolator != null && attribute.isSpatiallyInterpolated()) {
                return biomeInterpolator.applyAttributeLayer(attribute, baseValue);
            }
            Holder<Biome> noiseBiomeAtPosition = biomeManager.getNoiseBiomeAtPosition(pos.x, pos.y, pos.z);
            return noiseBiomeAtPosition.value().getAttributes().applyModifier(attribute, baseValue);
        });
    }

    public void invalidateTickCache() {
        this.attributeSamplers.values().forEach(ValueSampler::invalidateTickCache);
    }

    private <Value> @Nullable ValueSampler<Value> getValueSampler(EnvironmentAttribute<Value> attribute) {
        return this.attributeSamplers.get(attribute);
    }

    @Override
    public <Value> Value getDimensionValue(EnvironmentAttribute<Value> attribute) {
        if (SharedConstants.IS_RUNNING_IN_IDE && attribute.isPositional()) {
            throw new IllegalStateException("Position must always be provided for positional attribute " + String.valueOf(attribute));
        }
        ValueSampler<Value> valueSampler = this.getValueSampler(attribute);
        return valueSampler == null ? attribute.defaultValue() : valueSampler.getDimensionValue();
    }

    @Override
    public <Value> Value getValue(EnvironmentAttribute<Value> attribute, Vec3 pos, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
        ValueSampler<Value> valueSampler = this.getValueSampler(attribute);
        return valueSampler == null ? attribute.defaultValue() : valueSampler.getValue(pos, biomeInterpolator);
    }

    @VisibleForTesting
    <Value> Value getConstantBaseValue(EnvironmentAttribute<Value> attribute) {
        ValueSampler<Value> valueSampler = this.getValueSampler(attribute);
        return valueSampler != null ? valueSampler.baseValue : attribute.defaultValue();
    }

    @VisibleForTesting
    boolean isAffectedByPosition(EnvironmentAttribute<?> attribute) {
        ValueSampler<?> valueSampler = this.getValueSampler(attribute);
        return valueSampler != null && valueSampler.isAffectedByPosition;
    }

    static class ValueSampler<Value> {
        private final EnvironmentAttribute<Value> attribute;
        final Value baseValue;
        private final List<EnvironmentAttributeLayer<Value>> layers;
        final boolean isAffectedByPosition;
        private @Nullable Value cachedTickValue;
        private int cacheTickId;

        ValueSampler(EnvironmentAttribute<Value> attribute, Value baseValue, List<EnvironmentAttributeLayer<Value>> layers, boolean isAffectedByPosition) {
            this.attribute = attribute;
            this.baseValue = baseValue;
            this.layers = layers;
            this.isAffectedByPosition = isAffectedByPosition;
        }

        public void invalidateTickCache() {
            this.cachedTickValue = null;
            ++this.cacheTickId;
        }

        public Value getDimensionValue() {
            if (this.cachedTickValue != null) {
                return this.cachedTickValue;
            }
            Value object = this.computeValueNotPositional();
            this.cachedTickValue = object;
            return object;
        }

        public Value getValue(Vec3 vec3, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
            return !this.isAffectedByPosition ? this.getDimensionValue() : this.computeValuePositional(vec3, biomeInterpolator);
        }

        private Value computeValuePositional(Vec3 vec3, @Nullable SpatialAttributeInterpolator biomeInterpolator) {
            Value object = this.baseValue;
            for (EnvironmentAttributeLayer<Value> environmentAttributeLayer : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer2;
                Objects.requireNonNull(environmentAttributeLayer);
                int n = 0;
                object = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.Constant.class, EnvironmentAttributeLayer.TimeBased.class, EnvironmentAttributeLayer.Positional.class}, environmentAttributeLayer2, n)) {
                    case 0 -> {
                        EnvironmentAttributeLayer.Constant constant = (EnvironmentAttributeLayer.Constant)environmentAttributeLayer2;
                        yield constant.applyConstant(object);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.TimeBased timeBased = (EnvironmentAttributeLayer.TimeBased)environmentAttributeLayer2;
                        yield timeBased.applyTimeBased(object, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.Positional positional = (EnvironmentAttributeLayer.Positional)environmentAttributeLayer2;
                        yield positional.applyPositional(object, Objects.requireNonNull(vec3), biomeInterpolator);
                    }
                    default -> throw new MatchException(null, null);
                };
            }
            return this.attribute.sanitizeValue(object);
        }

        private Value computeValueNotPositional() {
            Value object = this.baseValue;
            for (EnvironmentAttributeLayer<Value> environmentAttributeLayer : this.layers) {
                EnvironmentAttributeLayer<Value> environmentAttributeLayer2;
                Objects.requireNonNull(environmentAttributeLayer);
                int n = 0;
                object = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnvironmentAttributeLayer.Constant.class, EnvironmentAttributeLayer.TimeBased.class, EnvironmentAttributeLayer.Positional.class}, environmentAttributeLayer2, n)) {
                    case 0 -> {
                        EnvironmentAttributeLayer.Constant constant = (EnvironmentAttributeLayer.Constant)environmentAttributeLayer2;
                        yield constant.applyConstant(object);
                    }
                    case 1 -> {
                        EnvironmentAttributeLayer.TimeBased timeBased = (EnvironmentAttributeLayer.TimeBased)environmentAttributeLayer2;
                        yield timeBased.applyTimeBased(object, this.cacheTickId);
                    }
                    case 2 -> {
                        EnvironmentAttributeLayer.Positional positional = (EnvironmentAttributeLayer.Positional)environmentAttributeLayer2;
                        yield object;
                    }
                    default -> throw new MatchException(null, null);
                };
            }
            return this.attribute.sanitizeValue(object);
        }
    }

    public static class Builder {
        private final Map<EnvironmentAttribute<?>, List<EnvironmentAttributeLayer<?>>> layersByAttribute = new HashMap();

        Builder() {
        }

        public Builder addDefaultLayers(Level level) {
            EnvironmentAttributeSystem.addDefaultLayers(this, level);
            return this;
        }

        public Builder addConstantLayer(EnvironmentAttributeMap attributes) {
            for (EnvironmentAttribute<?> environmentAttribute : attributes.keySet()) {
                this.addConstantEntry(environmentAttribute, attributes);
            }
            return this;
        }

        private <Value> Builder addConstantEntry(EnvironmentAttribute<Value> attribute, EnvironmentAttributeMap attributes) {
            EnvironmentAttributeMap.Entry<Value, ?> entry = attributes.get(attribute);
            if (entry == null) {
                throw new IllegalArgumentException("Missing attribute " + String.valueOf(attribute));
            }
            return this.addConstantLayer(attribute, entry::applyModifier);
        }

        public <Value> Builder addConstantLayer(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.Constant<Value> layer) {
            return this.addLayer(attribute, layer);
        }

        public <Value> Builder addTimeBasedLayer(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.TimeBased<Value> layer) {
            return this.addLayer(attribute, layer);
        }

        public <Value> Builder addPositionalLayer(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer.Positional<Value> layer) {
            return this.addLayer(attribute, layer);
        }

        private <Value> Builder addLayer(EnvironmentAttribute<Value> attribute, EnvironmentAttributeLayer<Value> layer) {
            this.layersByAttribute.computeIfAbsent(attribute, environmentAttribute -> new ArrayList()).add(layer);
            return this;
        }

        public Builder addTimelineLayer(Holder<Timeline> timeline, LongSupplier dayTimeGetter) {
            for (EnvironmentAttribute<?> environmentAttribute : timeline.value().attributes()) {
                this.addTimelineLayerForAttribute(timeline, environmentAttribute, dayTimeGetter);
            }
            return this;
        }

        private <Value> void addTimelineLayerForAttribute(Holder<Timeline> timeline, EnvironmentAttribute<Value> attribute, LongSupplier dayTimeGetter) {
            this.addTimeBasedLayer(attribute, timeline.value().createTrackSampler(attribute, dayTimeGetter));
        }

        public EnvironmentAttributeSystem build() {
            return new EnvironmentAttributeSystem(this.layersByAttribute);
        }
    }
}

