/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityEffectTickEvent;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class MobEffectInstance
implements Comparable<MobEffectInstance> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int INFINITE_DURATION = -1;
    public static final int MIN_AMPLIFIER = 0;
    public static final int MAX_AMPLIFIER = 255;
    public static final Codec<MobEffectInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffect.CODEC.fieldOf("id").forGetter(MobEffectInstance::getEffect), (App)Details.MAP_CODEC.forGetter(MobEffectInstance::asDetails)).apply((Applicative)instance, MobEffectInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobEffectInstance> STREAM_CODEC = StreamCodec.composite(MobEffect.STREAM_CODEC, MobEffectInstance::getEffect, Details.STREAM_CODEC, MobEffectInstance::asDetails, MobEffectInstance::new);
    private final Holder<MobEffect> effect;
    private int duration;
    private int amplifier;
    private boolean ambient;
    private boolean visible;
    private boolean showIcon;
    public @Nullable MobEffectInstance hiddenEffect;
    private final BlendState blendState = new BlendState();

    public MobEffectInstance(Holder<MobEffect> effect) {
        this(effect, 0, 0);
    }

    public MobEffectInstance(Holder<MobEffect> effect, int duration) {
        this(effect, duration, 0);
    }

    public MobEffectInstance(Holder<MobEffect> effect, int duration, int amplifier) {
        this(effect, duration, amplifier, false, true);
    }

    public MobEffectInstance(Holder<MobEffect> effect, int duration, int amplifier, boolean ambient, boolean visible) {
        this(effect, duration, amplifier, ambient, visible, visible);
    }

    public MobEffectInstance(Holder<MobEffect> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon) {
        this(effect, duration, amplifier, ambient, visible, showIcon, null);
    }

    public MobEffectInstance(Holder<MobEffect> effect, int duration, int amplifier, boolean ambient, boolean visible, boolean showIcon, @Nullable MobEffectInstance hiddenEffect) {
        this.effect = effect;
        this.duration = duration;
        this.amplifier = Mth.clamp(amplifier, 0, 255);
        this.ambient = ambient;
        this.visible = visible;
        this.showIcon = showIcon;
        this.hiddenEffect = hiddenEffect;
    }

    public MobEffectInstance(MobEffectInstance other) {
        this.effect = other.effect;
        this.setDetailsFrom(other);
    }

    private MobEffectInstance(Holder<MobEffect> effect, Details details) {
        this(effect, details.duration(), details.amplifier(), details.ambient(), details.showParticles(), details.showIcon(), details.hiddenEffect().map(details1 -> new MobEffectInstance(effect, (Details)details1)).orElse(null));
    }

    private Details asDetails() {
        return new Details(this.getAmplifier(), this.getDuration(), this.isAmbient(), this.isVisible(), this.showIcon(), Optional.ofNullable(this.hiddenEffect).map(MobEffectInstance::asDetails));
    }

    public float getBlendFactor(net.minecraft.world.entity.LivingEntity entity, float delta) {
        return this.blendState.getFactor(entity, delta);
    }

    public ParticleOptions getParticleOptions() {
        return this.effect.value().createParticleOptions(this);
    }

    void setDetailsFrom(MobEffectInstance effectInstance) {
        this.duration = effectInstance.duration;
        this.amplifier = effectInstance.amplifier;
        this.ambient = effectInstance.ambient;
        this.visible = effectInstance.visible;
        this.showIcon = effectInstance.showIcon;
    }

    public boolean update(MobEffectInstance other) {
        if (!this.effect.equals(other.effect)) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        boolean flag = false;
        if (other.amplifier > this.amplifier) {
            if (other.isShorterDurationThan(this)) {
                MobEffectInstance mobEffectInstance = this.hiddenEffect;
                this.hiddenEffect = new MobEffectInstance(this);
                this.hiddenEffect.hiddenEffect = mobEffectInstance;
            }
            this.amplifier = other.amplifier;
            this.duration = other.duration;
            flag = true;
        } else if (this.isShorterDurationThan(other)) {
            if (other.amplifier == this.amplifier) {
                this.duration = other.duration;
                flag = true;
            } else if (this.hiddenEffect == null) {
                this.hiddenEffect = new MobEffectInstance(other);
            } else {
                this.hiddenEffect.update(other);
            }
        }
        if (!other.ambient && this.ambient || flag) {
            this.ambient = other.ambient;
            flag = true;
        }
        if (other.visible != this.visible) {
            this.visible = other.visible;
            flag = true;
        }
        if (other.showIcon != this.showIcon) {
            this.showIcon = other.showIcon;
            flag = true;
        }
        return flag;
    }

    public boolean isShorterDurationThan(MobEffectInstance other) {
        return !this.isInfiniteDuration() && (this.duration < other.duration || other.isInfiniteDuration());
    }

    public boolean isInfiniteDuration() {
        return this.duration == -1;
    }

    public boolean endsWithin(int duration) {
        return !this.isInfiniteDuration() && this.duration <= duration;
    }

    public MobEffectInstance withScaledDuration(float scale) {
        MobEffectInstance mobEffectInstance = new MobEffectInstance(this);
        mobEffectInstance.duration = mobEffectInstance.mapDuration(duration -> Math.max(Mth.floor((float)duration * scale), 1));
        return mobEffectInstance;
    }

    public int mapDuration(Int2IntFunction mapper) {
        return !this.isInfiniteDuration() && this.duration != 0 ? mapper.applyAsInt(this.duration) : this.duration;
    }

    public Holder<MobEffect> getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean showIcon() {
        return this.showIcon;
    }

    public boolean tickServer(ServerLevel level, net.minecraft.world.entity.LivingEntity entity, Runnable onEffectUpdated) {
        int i;
        if (!this.hasRemainingDuration()) {
            return false;
        }
        int n = i = this.isInfiniteDuration() ? entity.tickCount : this.duration;
        if (this.effect.value().shouldApplyEffectTickThisTick(i, this.amplifier) && new EntityEffectTickEvent((LivingEntity)entity.getBukkitLivingEntity(), CraftPotionEffectType.minecraftHolderToBukkit(this.effect), this.amplifier).callEvent() && !this.effect.value().applyEffectTick(level, entity, this.amplifier)) {
            return false;
        }
        this.tickDownDuration();
        if (this.downgradeToHiddenEffect()) {
            onEffectUpdated.run();
        }
        return this.hasRemainingDuration();
    }

    public void tickClient() {
        if (this.hasRemainingDuration()) {
            this.tickDownDuration();
            this.downgradeToHiddenEffect();
        }
        this.blendState.tick(this);
    }

    private boolean hasRemainingDuration() {
        return this.isInfiniteDuration() || this.duration > 0;
    }

    private void tickDownDuration() {
        if (this.hiddenEffect != null) {
            this.hiddenEffect.tickDownDuration();
        }
        this.duration = this.mapDuration(duration -> duration - 1);
    }

    private boolean downgradeToHiddenEffect() {
        if (this.duration == 0 && this.hiddenEffect != null) {
            this.setDetailsFrom(this.hiddenEffect);
            this.hiddenEffect = this.hiddenEffect.hiddenEffect;
            return true;
        }
        return false;
    }

    public void onEffectStarted(net.minecraft.world.entity.LivingEntity entity) {
        this.effect.value().onEffectStarted(entity, this.amplifier);
    }

    public void onMobRemoved(ServerLevel level, net.minecraft.world.entity.LivingEntity entity, Entity.RemovalReason reason) {
        this.effect.value().onMobRemoved(level, entity, this.amplifier, reason);
    }

    public void onMobHurt(ServerLevel level, net.minecraft.world.entity.LivingEntity entity, DamageSource damageSource, float amount) {
        this.effect.value().onMobHurt(level, entity, this.amplifier, damageSource, amount);
    }

    public String getDescriptionId() {
        return this.effect.value().getDescriptionId();
    }

    public String toString() {
        String string = this.amplifier > 0 ? this.getDescriptionId() + " x " + (this.amplifier + 1) + ", Duration: " + this.describeDuration() : this.getDescriptionId() + ", Duration: " + this.describeDuration();
        if (!this.visible) {
            string = string + ", Particles: false";
        }
        if (!this.showIcon) {
            string = string + ", Show Icon: false";
        }
        return string;
    }

    private String describeDuration() {
        return this.isInfiniteDuration() ? "infinite" : Integer.toString(this.duration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof MobEffectInstance)) return false;
        MobEffectInstance mobEffectInstance = (MobEffectInstance)other;
        if (this.duration != mobEffectInstance.duration) return false;
        if (this.amplifier != mobEffectInstance.amplifier) return false;
        if (this.ambient != mobEffectInstance.ambient) return false;
        if (this.visible != mobEffectInstance.visible) return false;
        if (this.showIcon != mobEffectInstance.showIcon) return false;
        if (!this.effect.equals(mobEffectInstance.effect)) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = this.effect.hashCode();
        hashCode = 31 * hashCode + this.duration;
        hashCode = 31 * hashCode + this.amplifier;
        hashCode = 31 * hashCode + (this.ambient ? 1 : 0);
        hashCode = 31 * hashCode + (this.visible ? 1 : 0);
        return 31 * hashCode + (this.showIcon ? 1 : 0);
    }

    @Override
    public int compareTo(MobEffectInstance other) {
        int i = 32147;
        return !(this.getDuration() > 32147 && other.getDuration() > 32147 || this.isAmbient() && other.isAmbient()) ? ComparisonChain.start().compareFalseFirst(this.isAmbient(), other.isAmbient()).compareFalseFirst(this.isInfiniteDuration(), other.isInfiniteDuration()).compare(this.getDuration(), other.getDuration()).compare(this.getEffect().value().getColor(), other.getEffect().value().getColor()).result() : ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(other.isAmbient())).compare(this.getEffect().value().getColor(), other.getEffect().value().getColor()).result();
    }

    public void onEffectAdded(net.minecraft.world.entity.LivingEntity livingEntity) {
        this.effect.value().onEffectAdded(livingEntity, this.amplifier);
    }

    public boolean is(Holder<MobEffect> effect) {
        return this.effect.equals(effect);
    }

    public void copyBlendState(MobEffectInstance effectInstance) {
        this.blendState.copyFrom(effectInstance.blendState);
    }

    public void skipBlending() {
        this.blendState.setImmediate(this);
    }

    static class BlendState {
        private float factor;
        private float factorPreviousFrame;

        BlendState() {
        }

        public void setImmediate(MobEffectInstance effectInstance) {
            this.factorPreviousFrame = this.factor = BlendState.hasEffect(effectInstance) ? 1.0f : 0.0f;
        }

        public void copyFrom(BlendState blendState) {
            this.factor = blendState.factor;
            this.factorPreviousFrame = blendState.factorPreviousFrame;
        }

        public void tick(MobEffectInstance effect) {
            float f;
            this.factorPreviousFrame = this.factor;
            boolean hasEffect = BlendState.hasEffect(effect);
            float f2 = f = hasEffect ? 1.0f : 0.0f;
            if (this.factor != f) {
                int i;
                MobEffect mobEffect = effect.getEffect().value();
                int n = i = hasEffect ? mobEffect.getBlendInDurationTicks() : mobEffect.getBlendOutDurationTicks();
                if (i == 0) {
                    this.factor = f;
                } else {
                    float f1 = 1.0f / (float)i;
                    this.factor += Mth.clamp(f - this.factor, -f1, f1);
                }
            }
        }

        private static boolean hasEffect(MobEffectInstance effect) {
            return !effect.endsWithin(effect.getEffect().value().getBlendOutAdvanceTicks());
        }

        public float getFactor(net.minecraft.world.entity.LivingEntity entity, float delta) {
            if (entity.isRemoved()) {
                this.factorPreviousFrame = this.factor;
            }
            return Mth.lerp(delta, this.factorPreviousFrame, this.factor);
        }
    }

    record Details(int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, Optional<Details> hiddenEffect) {
        public static final MapCodec<Details> MAP_CODEC = MapCodec.recursive((String)"MobEffectInstance.Details", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.UNSIGNED_BYTE.optionalFieldOf("amplifier", (Object)0).forGetter(Details::amplifier), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(Details::duration), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(Details::ambient), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(Details::showParticles), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(details -> Optional.of(details.showIcon())), (App)codec.optionalFieldOf("hidden_effect").forGetter(Details::hiddenEffect)).apply((Applicative)instance, Details::create)));
        public static final StreamCodec<FriendlyByteBuf, Details> STREAM_CODEC = StreamCodec.recursive(codec -> StreamCodec.composite(ByteBufCodecs.VAR_INT, Details::amplifier, ByteBufCodecs.VAR_INT, Details::duration, ByteBufCodecs.BOOL, Details::ambient, ByteBufCodecs.BOOL, Details::showParticles, ByteBufCodecs.BOOL, Details::showIcon, codec.apply(ByteBufCodecs::increaseDepth).apply(ByteBufCodecs::optional), Details::hiddenEffect, Details::new));

        private static Details create(int amplifier, int duration, boolean ambient, boolean showParticles, Optional<Boolean> showIcon, Optional<Details> hiddenEffect) {
            return new Details(amplifier, duration, ambient, showParticles, showIcon.orElse(showParticles), hiddenEffect);
        }
    }
}

