/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentTable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jspecify.annotations.Nullable;

public interface EquipmentUser {
    public void setItemSlot(EquipmentSlot var1, ItemStack var2);

    public ItemStack getItemBySlot(EquipmentSlot var1);

    public void setDropChance(EquipmentSlot var1, float var2);

    default public void equip(EquipmentTable equipmentTable, LootParams params) {
        this.equip(equipmentTable.lootTable(), params, equipmentTable.slotDropChances());
    }

    default public void equip(ResourceKey<LootTable> equipmentLootTable, LootParams params, Map<EquipmentSlot, Float> slotDropChances) {
        this.equip(equipmentLootTable, params, 0L, slotDropChances);
    }

    default public void equip(ResourceKey<LootTable> equipmentLootTable, LootParams params, long seed, Map<EquipmentSlot, Float> slotDropChances) {
        LootTable lootTable = params.getLevel().getServer().reloadableRegistries().getLootTable(equipmentLootTable);
        if (lootTable != LootTable.EMPTY) {
            ObjectArrayList<ItemStack> randomItems = lootTable.getRandomItems(params, seed);
            ArrayList<EquipmentSlot> list = new ArrayList<EquipmentSlot>();
            for (ItemStack itemStack : randomItems) {
                EquipmentSlot equipmentSlot = this.resolveSlot(itemStack, list);
                if (equipmentSlot == null) continue;
                ItemStack itemStack1 = equipmentSlot.limit(itemStack);
                this.setItemSlot(equipmentSlot, itemStack1);
                Float _float = slotDropChances.get(equipmentSlot);
                if (_float != null) {
                    this.setDropChance(equipmentSlot, _float.floatValue());
                }
                list.add(equipmentSlot);
            }
        }
    }

    default public @Nullable EquipmentSlot resolveSlot(ItemStack stack, List<EquipmentSlot> excludedSlots) {
        if (stack.isEmpty()) {
            return null;
        }
        Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
        if (equippable != null) {
            EquipmentSlot equipmentSlot = equippable.slot();
            if (!excludedSlots.contains(equipmentSlot)) {
                return equipmentSlot;
            }
        } else if (!excludedSlots.contains(EquipmentSlot.MAINHAND)) {
            return EquipmentSlot.MAINHAND;
        }
        return null;
    }
}

