/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import com.destroystokyo.paper.event.player.PlayerAttackEntityCooldownResetEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityAttemptSpinAttackEvent;
import io.papermc.paper.event.entity.EntityEquipmentChangedEvent;
import io.papermc.paper.event.entity.EntityKnockbackEvent;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.util.TriState;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.KineticWeapon;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class LivingEntity
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_SLEEPING_POS = "sleeping_pos";
    public static final String TAG_EQUIPMENT = "equipment";
    public static final String TAG_BRAIN = "Brain";
    public static final String TAG_FALL_FLYING = "FallFlying";
    public static final String TAG_HURT_TIME = "HurtTime";
    public static final String TAG_DEATH_TIME = "DeathTime";
    public static final String TAG_HURT_BY_TIMESTAMP = "HurtByTimestamp";
    public static final String TAG_HEALTH = "Health";
    private static final Identifier SPEED_MODIFIER_POWDER_SNOW_ID = Identifier.withDefaultNamespace("powder_snow");
    private static final Identifier SPRINTING_MODIFIER_ID = Identifier.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SADDLE_OFFSET = 106;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    protected static final float INPUT_FRICTION = 0.98f;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final float BASE_JUMP_POWER = 0.42f;
    protected static final float DEFAULT_KNOCKBACK = 0.4f;
    protected static final int INVULNERABLE_DURATION = 20;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    public static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final EntityDataAccessor<Byte> DATA_LIVING_ENTITY_FLAGS = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.PARTICLES);
    private static final EntityDataAccessor<Boolean> DATA_EFFECT_AMBIENCE_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEPING_POS_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    private static final float WATER_FLOAT_IMPULSE = 0.04f;
    public static final Predicate<LivingEntity> PLAYER_NOT_WEARING_DISGUISE_ITEM = entity -> {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack itemBySlot = player.getItemBySlot(EquipmentSlot.HEAD);
            return !itemBySlot.is(ItemTags.GAZE_DISGUISE_EQUIPMENT);
        }
        return true;
    };
    private static final Dynamic<?> EMPTY_BRAIN = new Dynamic(JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMap attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = Maps.newHashMap();
    private final Map<EquipmentSlot, ItemStack> lastEquipmentItems = Util.makeEnumMap(EquipmentSlot.class, slot -> ItemStack.EMPTY);
    public boolean swinging;
    private boolean discardFriction = false;
    public InteractionHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    protected int itemSwapTicker;
    public final WalkAnimationState walkAnimation = new WalkAnimationState();
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    public final ElytraAnimationState elytraAnimationState = new ElytraAnimationState(this);
    public @Nullable EntityReference<Player> lastHurtByPlayer;
    public int lastHurtByPlayerMemoryTime;
    protected boolean dead;
    protected int noActionTime;
    public float lastHurt;
    public boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected InterpolationHandler interpolation = new InterpolationHandler(this);
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty = true;
    public @Nullable EntityReference<LivingEntity> lastHurtByMob;
    public int lastHurtByMobTimestamp;
    private @Nullable LivingEntity lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem = ItemStack.EMPTY;
    public int useItemRemaining;
    protected int fallFlyTicks;
    private long lastKineticHitFeedbackTime = Integer.MIN_VALUE;
    private BlockPos lastPos;
    private Optional<BlockPos> lastClimbablePos = Optional.empty();
    private @Nullable DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    protected @Nullable ItemStack autoSpinAttackItemStack;
    protected @Nullable Object2LongMap<Entity> recentKineticEnemies;
    private float swimAmount;
    private float swimAmountO;
    protected Brain<?> brain;
    protected boolean skipDropExperience;
    private final EnumMap<EquipmentSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> activeLocationDependentEnchantments = new EnumMap(EquipmentSlot.class);
    protected final EntityEquipment equipment;
    private Waypoint.Icon locatorBarIcon = new Waypoint.Icon();
    public int expToDrop;
    public List<Entity.DefaultDrop> drops = new ArrayList<Entity.DefaultDrop>();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    public boolean silentDeath = false;
    public TriState frictionState = TriState.NOT_SET;
    public int invulnerableDuration = 20;
    private boolean isTickingEffects = false;
    private final List<ProcessableEffect> effectsToProcess = Lists.newArrayList();
    protected boolean clearEquipmentSlots = true;
    protected Set<EquipmentSlot> clearedEquipmentSlots = new HashSet<EquipmentSlot>();
    protected long lastJumpTime = 0L;
    protected long eatStartTime;
    protected int totalEatTimeTicks;

    public CraftLivingEntity getBukkitLivingEntity() {
        return (CraftLivingEntity)super.getBukkitEntity();
    }

    protected LivingEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(type));
        this.craftAttributes = new CraftAttributeMap(this.attributes);
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(this.getMaxHealth()));
        this.equipment = this.createEquipment();
        this.blocksBuilding = true;
        this.reapplyPosition();
        this.setYRot(this.random.nextFloat() * ((float)Math.PI * 2));
        this.yHeadRot = this.getYRot();
        this.brain = this.makeBrain(EMPTY_BRAIN);
    }

    @Override
    public @Nullable LivingEntity asLivingEntity() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment createEquipment() {
        return new EntityEquipment();
    }

    public Brain<?> getBrain() {
        return this.brain;
    }

    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return this.brainProvider().makeBrain(dynamic);
    }

    @Override
    public void kill(ServerLevel level) {
        this.hurtServer(level, this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityType<?> entityType) {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        builder.define(DATA_EFFECT_PARTICLES, List.of());
        builder.define(DATA_EFFECT_AMBIENCE_ID, false);
        builder.define(DATA_ARROW_COUNT_ID, 0);
        builder.define(DATA_STINGER_COUNT_ID, 0);
        builder.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        builder.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return AttributeSupplier.builder().add(Attributes.MAX_HEALTH).add(Attributes.KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.MAX_ABSORPTION).add(Attributes.STEP_HEIGHT).add(Attributes.SCALE).add(Attributes.GRAVITY).add(Attributes.SAFE_FALL_DISTANCE).add(Attributes.FALL_DAMAGE_MULTIPLIER).add(Attributes.JUMP_STRENGTH).add(Attributes.OXYGEN_BONUS).add(Attributes.BURNING_TIME).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(Attributes.WATER_MOVEMENT_EFFICIENCY).add(Attributes.MOVEMENT_EFFICIENCY).add(Attributes.ATTACK_KNOCKBACK).add(Attributes.CAMERA_DISTANCE).add(Attributes.WAYPOINT_TRANSMIT_RANGE);
    }

    @Override
    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        Level level;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (onGround && this.fallDistance > 0.0) {
                this.onChangedBlock(serverLevel, pos);
                double d = Math.max(0, Mth.floor(this.calculateFallPower(this.fallDistance)));
                if (d > 0.0 && !state.isAir()) {
                    double d1;
                    double x = this.getX();
                    double y1 = this.getY();
                    double z = this.getZ();
                    BlockPos blockPos = this.blockPosition();
                    if (pos.getX() != blockPos.getX() || pos.getZ() != blockPos.getZ()) {
                        d1 = x - (double)pos.getX() - 0.5;
                        double d2 = z - (double)pos.getZ() - 0.5;
                        double max = Math.max(Math.abs(d1), Math.abs(d2));
                        x = (double)pos.getX() + 0.5 + d1 / max * 0.5;
                        z = (double)pos.getZ() + 0.5 + d2 / max * 0.5;
                    }
                    d1 = Math.min((double)0.2f + d / 15.0, 2.5);
                    int i = (int)(150.0 * d1);
                    if (this instanceof ServerPlayer) {
                        serverLevel.sendParticlesSource((ServerPlayer)this, new BlockParticleOption(ParticleTypes.BLOCK, state), false, false, x, y1, z, i, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        serverLevel.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, state), x, y1, z, i, 0.0, 0.0, 0.0, 0.15f);
                    }
                }
            }
        }
        super.checkFallDamage(y, onGround, state, pos);
        if (onGround) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public boolean canBreatheUnderwater() {
        return this.getType().is(EntityTypeTags.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float partialTick) {
        return Mth.lerp(partialTick, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        LivingEntity lastHurtByMob;
        Level level;
        Level level2;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((level2 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            EnchantmentHelper.tickEffects(serverLevel, this);
        }
        super.baseTick();
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("livingEntityBaseTick");
        if (this.isAlive() && (level = this.level()) instanceof ServerLevel) {
            double damagePerBlock;
            double d;
            ServerLevel serverLevel1 = (ServerLevel)level;
            boolean flag = this instanceof Player;
            if (this.isInWall()) {
                this.hurtServer(serverLevel1, this.damageSources().inWall(), 1.0f);
            } else if (flag && !serverLevel1.getWorldBorder().isWithinBounds(this.getBoundingBox()) && (d = serverLevel1.getWorldBorder().getDistanceToBorder(this) + serverLevel1.getWorldBorder().getSafeZone()) < 0.0 && (damagePerBlock = serverLevel1.getWorldBorder().getDamagePerBlock()) > 0.0) {
                this.hurtServer(serverLevel1, this.damageSources().outOfBorder(), Math.max(1, Mth.floor(-d * damagePerBlock)));
            }
            if (this.isEyeInFluid(FluidTags.WATER) && !serverLevel1.getBlockState(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean flag1;
                boolean bl = flag1 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!flag || !((Player)this).getAbilities().invulnerable);
                if (flag1) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.shouldTakeDrowningDamage()) {
                        this.setAirSupply(0);
                        serverLevel1.broadcastEntityEvent(this, (byte)67);
                        this.hurtServer(serverLevel1, this.damageSources().drown(), 2.0f);
                    }
                } else if (this.getAirSupply() < this.getMaxAirSupply() && MobEffectUtil.shouldEffectsRefillAirsupply(this)) {
                    this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
                }
                if (this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            BlockPos blockPos = this.blockPosition();
            if (!Objects.equal((Object)this.lastPos, (Object)blockPos)) {
                this.lastPos = blockPos;
                this.onChangedBlock(serverLevel1, blockPos);
            }
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof ServerPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerMemoryTime > 0) {
            --this.lastHurtByPlayerMemoryTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if ((lastHurtByMob = this.getLastHurtByMob()) != null) {
            if (!lastHurtByMob.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        profilerFiller.pop();
    }

    protected boolean shouldTakeDrowningDamage() {
        return this.getAirSupply() <= -20;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return Mth.lerp((float)this.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    public float getLuck() {
        return 0.0f;
    }

    protected void removeFrost() {
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attribute != null && attribute.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            attribute.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int ticksFrozen;
        if (!this.getBlockStateOnLegacy().isAir() && (ticksFrozen = this.getTicksFrozen()) > 0) {
            AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attribute == null) {
                return;
            }
            float f = -0.05f * this.getPercentFrozen();
            attribute.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(ServerLevel level, BlockPos pos) {
        EnchantmentHelper.runLocationChangedEffects(level, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public final float getScale() {
        AttributeMap attributes = this.getAttributes();
        return attributes == null ? 1.0f : this.sanitizeScale((float)attributes.getValue(Attributes.SCALE));
    }

    protected float sanitizeScale(float scale) {
        return scale;
    }

    public boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot(ServerLevel level) {
        return !this.isBaby() && level.getGameRules().get(GameRules.MOB_DROPS) != false;
    }

    protected int decreaseAirSupply(int currentAirSupply) {
        AttributeInstance attribute = this.getAttribute(Attributes.OXYGEN_BONUS);
        double value = attribute != null ? attribute.getValue() : 0.0;
        return value > 0.0 && this.random.nextDouble() >= 1.0 / (value + 1.0) ? currentAirSupply : currentAirSupply - 1;
    }

    protected int increaseAirSupply(int currentAirSupply) {
        return Math.min(currentAirSupply + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(ServerLevel level, @Nullable Entity killer) {
        return EnchantmentHelper.processMobExperience(level, killer, this, this.getBaseExperienceReward(level));
    }

    protected int getBaseExperienceReward(ServerLevel level) {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    public @Nullable LivingEntity getLastHurtByMob() {
        return EntityReference.getLivingEntity(this.lastHurtByMob, this.level());
    }

    public @Nullable Player getLastHurtByPlayer() {
        return EntityReference.getPlayer(this.lastHurtByPlayer, this.level());
    }

    @Override
    public LivingEntity getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(Player player, int memoryTime) {
        this.setLastHurtByPlayer(EntityReference.of(player), memoryTime);
    }

    public void setLastHurtByPlayer(UUID uuid, int memoryTime) {
        this.setLastHurtByPlayer(EntityReference.of(uuid), memoryTime);
    }

    private void setLastHurtByPlayer(EntityReference<Player> player, int memoryTime) {
        this.lastHurtByPlayer = player;
        this.lastHurtByPlayerMemoryTime = memoryTime;
    }

    public void setLastHurtByMob(@Nullable LivingEntity livingEntity) {
        this.lastHurtByMob = EntityReference.of(livingEntity);
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    public @Nullable LivingEntity getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity entity) {
        this.lastHurtMob = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int noActionTime) {
        this.noActionTime = noActionTime;
    }

    public boolean shouldDiscardFriction() {
        return !this.frictionState.toBooleanOrElse(!this.discardFriction);
    }

    public void setDiscardFriction(boolean discardFriction) {
        this.discardFriction = discardFriction;
    }

    protected boolean doesEmitEquipEvent(EquipmentSlot slot) {
        return true;
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldItem, ItemStack newItem) {
        this.onEquipItem(slot, oldItem, newItem, false);
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldItem, ItemStack newItem, boolean silent) {
        if (!(this.level().isClientSide() || this.isSpectator() || ItemStack.isSameItemSameComponents(oldItem, newItem) || this.firstTick)) {
            Equippable equippable = newItem.get(DataComponents.EQUIPPABLE);
            if (!this.isSilent() && equippable != null && slot == equippable.slot() && !silent) {
                this.level().playSeededSound(null, this.getX(), this.getY(), this.getZ(), this.getEquipSound(slot, newItem, equippable), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
            }
            if (this.doesEmitEquipEvent(slot)) {
                this.gameEvent(equippable != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
            }
        }
    }

    protected Holder<SoundEvent> getEquipSound(EquipmentSlot slot, ItemStack stack, Equippable equippable) {
        return equippable.equipSound();
    }

    @Override
    public void remove(Entity.RemovalReason reason, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable EntityRemoveEvent.Cause eventCause) {
        Level level;
        if ((reason == Entity.RemovalReason.KILLED || reason == Entity.RemovalReason.DISCARDED) && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerOnDeathMobEffects(serverLevel, reason);
        }
        super.remove(reason, eventCause);
        this.brain.clearMemories();
    }

    @Override
    public void onRemoval(Entity.RemovalReason reason) {
        super.onRemoval(reason);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getWaypointManager().untrackWaypoint(this);
        }
    }

    protected void triggerOnDeathMobEffects(ServerLevel level, Entity.RemovalReason removalReason) {
        for (MobEffectInstance mobEffectInstance : this.getActiveEffects()) {
            mobEffectInstance.onMobRemoved(level, this, removalReason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.activeEffects.clear();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput output) {
        if (this.frictionState != TriState.NOT_SET) {
            output.putString("Paper.FrictionState", this.frictionState.toString());
        }
        output.putFloat(TAG_HEALTH, this.getHealth());
        output.putShort(TAG_HURT_TIME, (short)this.hurtTime);
        output.putInt(TAG_HURT_BY_TIMESTAMP, this.lastHurtByMobTimestamp);
        output.putShort(TAG_DEATH_TIME, (short)this.deathTime);
        output.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        output.store(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC, this.getAttributes().pack());
        if (!this.activeEffects.isEmpty()) {
            output.store(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf(), List.copyOf(this.activeEffects.values()));
        }
        output.putBoolean(TAG_FALL_FLYING, this.isFallFlying());
        this.getSleepingPos().ifPresent(blockPos -> output.store(TAG_SLEEPING_POS, BlockPos.CODEC, blockPos));
        DataResult dataResult = this.brain.serializeStart(NbtOps.INSTANCE).map(tag -> new Dynamic<Tag>(NbtOps.INSTANCE, (Tag)tag));
        dataResult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(dynamic -> output.store(TAG_BRAIN, Codec.PASSTHROUGH, dynamic));
        if (this.lastHurtByPlayer != null) {
            this.lastHurtByPlayer.store(output, "last_hurt_by_player");
            output.putInt("last_hurt_by_player_memory_time", this.lastHurtByPlayerMemoryTime);
        }
        if (this.lastHurtByMob != null) {
            this.lastHurtByMob.store(output, "last_hurt_by_mob");
            output.putInt("ticks_since_last_hurt_by_mob", this.tickCount - this.lastHurtByMobTimestamp);
        }
        if (!this.equipment.isEmpty()) {
            output.store(TAG_EQUIPMENT, EntityEquipment.CODEC, this.equipment);
        }
        if (this.locatorBarIcon.hasData()) {
            output.store("locator_bar_icon", Waypoint.Icon.CODEC, this.locatorBarIcon);
        }
    }

    public final @Nullable ItemEntity drop(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        return this.drop(stack, randomizeMotion, includeThrower, true, null);
    }

    public @Nullable ItemEntity drop(ItemStack stack, boolean randomizeMotion, boolean includeThrower, boolean callEvent, @Nullable Consumer<Item> entityOperation) {
        if (stack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide()) {
            this.swing(InteractionHand.MAIN_HAND);
            return null;
        }
        ItemEntity itemEntity = this.createItemStackToDrop(stack, randomizeMotion, includeThrower);
        if (itemEntity != null) {
            CraftEntity craftEntity;
            if (entityOperation != null) {
                entityOperation.accept((Item)itemEntity.getBukkitEntity());
            }
            if (callEvent && (craftEntity = this.getBukkitEntity()) instanceof org.bukkit.entity.Player) {
                org.bukkit.entity.Player player = (org.bukkit.entity.Player)craftEntity;
                Item drop = (Item)itemEntity.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack inHandItem = player.getInventory().getItemInMainHand();
                    if (includeThrower && inHandItem.getAmount() == 0) {
                        player.getInventory().setItemInMainHand(drop.getItemStack());
                    } else if (includeThrower && inHandItem.isSimilar(drop.getItemStack()) && inHandItem.getAmount() < inHandItem.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        inHandItem.setAmount(inHandItem.getAmount() + 1);
                        player.getInventory().setItemInMainHand(inHandItem);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.level().addFreshEntity(itemEntity);
        }
        return itemEntity;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput input) {
        float absorptionAmount = input.getFloatOr("AbsorptionAmount", 0.0f);
        if (Float.isNaN(absorptionAmount)) {
            absorptionAmount = 0.0f;
        }
        this.internalSetAbsorptionAmount(absorptionAmount);
        input.getString("Paper.FrictionState").ifPresent(frictionState -> {
            try {
                this.frictionState = TriState.valueOf((String)frictionState);
            }
            catch (Exception ignored) {
                LOGGER.error("Unknown friction state {} for {}", frictionState, (Object)this);
            }
        });
        if (this.level() != null && !this.level().isClientSide()) {
            input.read(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC).ifPresent(this.getAttributes()::apply);
        }
        List list = input.read(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf()).orElse(List.of());
        this.activeEffects.clear();
        for (MobEffectInstance mobEffectInstance : list) {
            this.activeEffects.put(mobEffectInstance.getEffect(), mobEffectInstance);
            this.effectsDirty = true;
        }
        input.read("Bukkit.MaxHealth", Codec.DOUBLE).ifPresent(maxHealth -> this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)maxHealth));
        this.setHealth(input.getFloatOr(TAG_HEALTH, this.getMaxHealth()));
        this.hurtTime = input.getShortOr(TAG_HURT_TIME, (short)0);
        this.deathTime = input.getShortOr(TAG_DEATH_TIME, (short)0);
        this.lastHurtByMobTimestamp = input.getIntOr(TAG_HURT_BY_TIMESTAMP, 0);
        input.getString("Team").ifPresent(string -> {
            boolean flag;
            Scoreboard scoreboard = this.level().getScoreboard();
            PlayerTeam playerTeam = scoreboard.getPlayerTeam((String)string);
            if (!this.level().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof Player)) {
                playerTeam = null;
            }
            boolean bl = flag = playerTeam != null && scoreboard.addPlayerToTeam(this.getStringUUID(), playerTeam);
            if (!flag) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", string);
            }
        });
        this.setSharedFlag(7, input.getBooleanOr(TAG_FALL_FLYING, false));
        input.read(TAG_SLEEPING_POS, BlockPos.CODEC).ifPresentOrElse(blockPos -> {
            if (this.position().distanceToSqr(blockPos.getX(), blockPos.getY(), blockPos.getZ()) < (double)Mth.square(16)) {
                this.setSleepingPos((BlockPos)blockPos);
                this.entityData.set(Entity.DATA_POSE, Pose.SLEEPING);
                if (!this.firstTick) {
                    this.setPosToBed((BlockPos)blockPos);
                }
            }
        }, this::clearSleepingPos);
        input.read(TAG_BRAIN, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.brain = this.makeBrain((Dynamic<?>)((Object)dynamic));
        });
        this.lastHurtByPlayer = EntityReference.read(input, "last_hurt_by_player");
        this.lastHurtByPlayerMemoryTime = input.getIntOr("last_hurt_by_player_memory_time", 0);
        this.lastHurtByMob = EntityReference.read(input, "last_hurt_by_mob");
        this.lastHurtByMobTimestamp = input.getIntOr("ticks_since_last_hurt_by_mob", 0) + this.tickCount;
        this.equipment.setAll(input.read(TAG_EQUIPMENT, EntityEquipment.CODEC).orElseGet(EntityEquipment::new));
        this.locatorBarIcon = input.read("locator_bar_icon", Waypoint.Icon.CODEC).orElseGet(Waypoint.Icon::new);
    }

    @Override
    public void updateDataBeforeSync() {
        super.updateDataBeforeSync();
        this.updateDirtyEffects();
    }

    protected void tickEffects() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Iterator<Object> iterator = this.activeEffects.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder holder = (Holder)iterator.next();
                    MobEffectInstance mobEffectInstance = this.activeEffects.get(holder);
                    if (!mobEffectInstance.tickServer(serverLevel, this, () -> this.onEffectUpdated(mobEffectInstance, true, null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.onEffectsRemoved(List.of(mobEffectInstance));
                        continue;
                    }
                    if (mobEffectInstance.getDuration() % 600 != 0) continue;
                    this.onEffectUpdated(mobEffectInstance, false, null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect effect : this.effectsToProcess) {
                if (effect.effect != null) {
                    this.addEffect(effect.effect, effect.cause);
                    continue;
                }
                this.removeEffect(effect.type, effect.cause);
            }
            this.effectsToProcess.clear();
        } else {
            for (MobEffectInstance mobEffectInstance1 : this.activeEffects.values()) {
                mobEffectInstance1.tickClient();
            }
            List<ParticleOptions> list = this.entityData.get(DATA_EFFECT_PARTICLES);
            if (!list.isEmpty()) {
                int i1;
                boolean flag = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
                int i = this.isInvisible() ? 15 : 4;
                int n = i1 = flag ? 5 : 1;
                if (this.random.nextInt(i * i1) == 0) {
                    this.level().addParticle(Util.getRandom(list, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    private void updateDirtyEffects() {
        if (this.effectsDirty) {
            this.updateInvisibilityStatus();
            this.updateGlowingStatus();
            this.effectsDirty = false;
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
        } else {
            this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
            this.updateSynchronizedMobEffectParticles();
        }
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleOptions> list = this.activeEffects.values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, list);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, LivingEntity.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean isCurrentlyGlowing = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != isCurrentlyGlowing) {
            this.setSharedFlag(6, isCurrentlyGlowing);
        }
    }

    public double getVisibilityPercent(@Nullable Entity lookingEntity) {
        double d = 1.0;
        if (this.isDiscrete()) {
            d *= 0.8;
        }
        if (this.isInvisible()) {
            float armorCoverPercentage = this.getArmorCoverPercentage();
            if (armorCoverPercentage < 0.1f) {
                armorCoverPercentage = 0.1f;
            }
            d *= 0.7 * (double)armorCoverPercentage;
        }
        if (lookingEntity != null) {
            ItemStack itemBySlot = this.getItemBySlot(EquipmentSlot.HEAD);
            EntityType<?> type = lookingEntity.getType();
            if (type == EntityType.SKELETON && itemBySlot.is(Items.SKELETON_SKULL) || type == EntityType.ZOMBIE && itemBySlot.is(Items.ZOMBIE_HEAD) || type == EntityType.PIGLIN && itemBySlot.is(Items.PIGLIN_HEAD) || type == EntityType.PIGLIN_BRUTE && itemBySlot.is(Items.PIGLIN_HEAD) || type == EntityType.CREEPER && itemBySlot.is(Items.CREEPER_HEAD)) {
                d *= 0.5;
            }
        }
        return d;
    }

    public boolean canAttack(LivingEntity target) {
        return (!(target instanceof Player) || this.level().getDifficulty() != Difficulty.PEACEFUL) && target.canBeSeenAsEnemy();
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffectInstance> effects) {
        for (MobEffectInstance mobEffectInstance : effects) {
            if (!mobEffectInstance.isVisible() || mobEffectInstance.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.activeEffects.isEmpty()) {
            return false;
        }
        LinkedList<MobEffectInstance> toRemove = new LinkedList<MobEffectInstance>();
        Iterator<MobEffectInstance> iterator = this.activeEffects.values().iterator();
        while (iterator.hasNext()) {
            MobEffectInstance effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.onEffectsRemoved(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffect> effect) {
        return this.activeEffects.containsKey(effect);
    }

    public @Nullable MobEffectInstance getEffect(Holder<MobEffect> effect) {
        return this.activeEffects.get(effect);
    }

    public float getEffectBlendFactor(Holder<MobEffect> effect, float partialTick) {
        MobEffectInstance effect1 = this.getEffect(effect);
        return effect1 != null ? effect1.getBlendFactor(this, partialTick) : 0.0f;
    }

    public final boolean addEffect(MobEffectInstance effectInstance) {
        return this.addEffect(effectInstance, (Entity)null);
    }

    public boolean addEffect(MobEffectInstance effectInstance, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, null, cause);
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return this.addEffect(effectInstance, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(effectInstance, entity, cause, true);
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause, boolean fireEvent) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effectInstance, cause));
            return true;
        }
        if (!this.canBeAffected(effectInstance)) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.activeEffects.get(effectInstance.getEffect());
        boolean flag = false;
        boolean override = false;
        boolean addAsHiddenEffect = false;
        if (mobEffectInstance != null) {
            override = new MobEffectInstance(mobEffectInstance).update(effectInstance);
            boolean bl = addAsHiddenEffect = mobEffectInstance.getAmplifier() > effectInstance.getAmplifier() && mobEffectInstance.isShorterDurationThan(effectInstance);
        }
        if (fireEvent) {
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobEffectInstance, effectInstance, cause, override);
            override = event.isOverride();
            if (event.isCancelled()) {
                return false;
            }
        }
        if (mobEffectInstance == null) {
            this.activeEffects.put(effectInstance.getEffect(), effectInstance);
            this.onEffectAdded(effectInstance, entity);
            flag = true;
            effectInstance.onEffectAdded(this);
        } else if (override) {
            mobEffectInstance.update(effectInstance);
            this.onEffectUpdated(mobEffectInstance, true, entity);
            flag = true;
        } else if (addAsHiddenEffect) {
            if (mobEffectInstance.hiddenEffect == null) {
                mobEffectInstance.hiddenEffect = new MobEffectInstance(effectInstance);
            } else {
                mobEffectInstance.hiddenEffect.update(effectInstance);
            }
        }
        effectInstance.onEffectStarted(this);
        return flag;
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        if (this.getType().is(EntityTypeTags.IMMUNE_TO_INFESTED)) {
            return !effectInstance.is(MobEffects.INFESTED);
        }
        return this.getType().is(EntityTypeTags.IMMUNE_TO_OOZING) ? !effectInstance.is(MobEffects.OOZING) : !this.getType().is(EntityTypeTags.IGNORES_POISON_AND_REGEN) || !effectInstance.is(MobEffects.REGENERATION) && !effectInstance.is(MobEffects.POISON);
    }

    public void forceAddEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (this.canBeAffected(effectInstance)) {
            MobEffectInstance mobEffectInstance = this.activeEffects.put(effectInstance.getEffect(), effectInstance);
            if (mobEffectInstance == null) {
                this.onEffectAdded(effectInstance, entity);
            } else {
                effectInstance.copyBlendState(mobEffectInstance);
                this.onEffectUpdated(effectInstance, true, entity);
            }
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM);
    }

    public final @Nullable MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> effect) {
        return this.removeEffectNoUpdate(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public @Nullable MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> effect, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(effect, cause));
            return null;
        }
        MobEffectInstance effectInstance = this.activeEffects.get(effect);
        if (effectInstance == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effectInstance, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.activeEffects.remove(effect);
    }

    public boolean removeEffect(Holder<MobEffect> effect) {
        return this.removeEffect(effect, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffect> effect, EntityPotionEffectEvent.Cause cause) {
        MobEffectInstance mobEffectInstance = this.removeEffectNoUpdate(effect, cause);
        if (mobEffectInstance != null) {
            this.onEffectsRemoved(List.of(mobEffectInstance));
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            effectInstance.getEffect().value().addAttributeModifiers(this.getAttributes(), effectInstance.getAmplifier());
            this.sendEffectToPassengers(effectInstance);
        }
    }

    public void sendEffectToPassengers(MobEffectInstance effectInstance) {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), effectInstance, false));
        }
    }

    protected void onEffectUpdated(MobEffectInstance effectInstance, boolean forced, @Nullable Entity entity) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            if (forced) {
                MobEffect mobEffect = effectInstance.getEffect().value();
                mobEffect.removeAttributeModifiers(this.getAttributes());
                mobEffect.addAttributeModifiers(this.getAttributes(), effectInstance.getAmplifier());
                this.refreshDirtyAttributes();
            }
            this.sendEffectToPassengers(effectInstance);
        }
    }

    protected void onEffectsRemoved(Collection<MobEffectInstance> effects) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            for (MobEffectInstance mobEffectInstance : effects) {
                mobEffectInstance.getEffect().value().removeAttributeModifiers(this.getAttributes());
                for (Entity entity : this.getPassengers()) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    serverPlayer.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), mobEffectInstance.getEffect()));
                }
            }
            this.refreshDirtyAttributes();
        }
    }

    private void refreshDirtyAttributes() {
        Set<AttributeInstance> attributesToUpdate = this.getAttributes().getAttributesToUpdate();
        for (AttributeInstance attributeInstance : attributesToUpdate) {
            this.onAttributeUpdated(attributeInstance.getAttribute());
        }
        attributesToUpdate.clear();
    }

    protected void onAttributeUpdated(Holder<Attribute> attribute) {
        Level maxHealth3;
        if (attribute.is(Attributes.MAX_HEALTH)) {
            float maxHealth2 = this.getMaxHealth();
            if (this.getHealth() > maxHealth2) {
                this.setHealth(maxHealth2);
            }
        } else if (attribute.is(Attributes.MAX_ABSORPTION)) {
            float maxHealth3 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > maxHealth3) {
                this.setAbsorptionAmount(maxHealth3);
            }
        } else if (attribute.is(Attributes.SCALE)) {
            this.refreshDimensions();
        } else if (attribute.is(Attributes.WAYPOINT_TRANSMIT_RANGE) && (maxHealth3 = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)maxHealth3;
            ServerWaypointManager waypointManager = serverLevel.getWaypointManager();
            if (this.attributes.getValue(attribute) > 0.0) {
                waypointManager.trackWaypoint(this);
            } else {
                waypointManager.untrackWaypoint(this);
            }
        }
    }

    public void heal(float amount) {
        this.heal(amount, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason) {
        this.heal(amount, regainReason, false);
    }

    public void heal(float amount, EntityRegainHealthEvent.RegainReason regainReason, boolean isFastRegen) {
        float health = this.getHealth();
        if (health > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)amount, regainReason, isFastRegen);
            if (this.valid) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.setHealth((float)((double)this.getHealth() + event.getAmount()));
            }
        }
    }

    public float getHealth() {
        LivingEntity livingEntity = this;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            return (float)player.getBukkitEntity().getHealth();
        }
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float health) {
        if (Float.isNaN(health)) {
            health = this.getMaxHealth();
            if (this.valid) {
                System.err.println("[NAN-HEALTH] " + this.getScoreboardName() + " had NaN health set");
            }
        }
        if (this instanceof ServerPlayer) {
            CraftPlayer player = ((ServerPlayer)this).getBukkitEntity();
            if (health < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)health > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(health);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(Mth.clamp(health, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        Entity entity;
        boolean flag2;
        boolean flag;
        if (this.isInvulnerableTo(level, damageSource)) {
            return false;
        }
        if (this.isRemoved() || this.dead || this.getHealth() <= 0.0f) {
            return false;
        }
        if (damageSource.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        ItemStack useItem = this.getUseItem();
        float originAmount = amount;
        float f1 = this.applyItemBlocking(level, damageSource, amount, true);
        boolean bl = flag = f1 > 0.0f;
        if (Float.isNaN(amount) || Float.isInfinite(amount)) {
            amount = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f && !damageSource.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (amount <= this.lastHurt) {
                return false;
            }
            event = this.handleEntityDamage(damageSource, amount, this.lastHurt);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof ServerPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.lastHurt = amount;
            flag1 = false;
        } else {
            event = this.handleEntityDamage(damageSource, amount, 0.0f);
            amount = this.computeAmountFromEntityDamageEvent(event);
            if (!this.actuallyHurt(level, damageSource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            if (this instanceof ServerPlayer && event.getDamage() == 0.0 && originAmount == 0.0f) {
                return false;
            }
            this.lastHurt = amount;
            this.invulnerableTime = this.invulnerableDuration;
            this.hurtTime = this.hurtDuration = 10;
        }
        this.resolveMobResponsibleForDamage(damageSource);
        this.resolvePlayerResponsibleForDamage(damageSource);
        if (flag1) {
            BlocksAttacks blocksAttacks = useItem.get(DataComponents.BLOCKS_ATTACKS);
            if (flag && blocksAttacks != null) {
                blocksAttacks.onBlocked(level, this);
            } else {
                level.broadcastDamageEvent(this, damageSource);
            }
            if (!damageSource.is(DamageTypeTags.NO_IMPACT) && !flag) {
                this.markHurt();
            }
            if (!damageSource.is(DamageTypeTags.NO_KNOCKBACK)) {
                double d = 0.0;
                double d1 = 0.0;
                Entity entity2 = damageSource.getDirectEntity();
                if (entity2 instanceof Projectile) {
                    Projectile projectile = (Projectile)entity2;
                    DoubleDoubleImmutablePair doubleDoubleImmutablePair = projectile.calculateHorizontalHurtKnockbackDirection(this, damageSource);
                    d = -doubleDoubleImmutablePair.leftDouble();
                    d1 = -doubleDoubleImmutablePair.rightDouble();
                } else if (damageSource.getSourcePosition() != null) {
                    d = damageSource.getSourcePosition().x() - this.getX();
                    d1 = damageSource.getSourcePosition().z() - this.getZ();
                }
                if (Math.abs(d) > 200.0) {
                    d = Math.random() - Math.random();
                }
                if (Math.abs(d1) > 200.0) {
                    d1 = Math.random() - Math.random();
                }
                this.knockback(0.4f, d, d1, damageSource.getDirectEntity(), damageSource.getDirectEntity() == null ? EntityKnockbackEvent.Cause.DAMAGE : EntityKnockbackEvent.Cause.ENTITY_ATTACK);
                if (!flag) {
                    this.indicateDamage(d, d1);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(damageSource)) {
                this.silentDeath = !flag1;
                this.die(damageSource);
                this.silentDeath = false;
            }
        } else if (flag1) {
            this.playHurtSound(damageSource);
            this.playSecondaryHurtSound(damageSource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = damageSource;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance mobEffectInstance : this.getActiveEffects()) {
                mobEffectInstance.onMobHurt(level, this, damageSource, amount);
            }
        }
        if ((entity = this) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger(serverPlayer, damageSource, originAmount, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                serverPlayer.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f1 * 10.0f));
            }
        }
        if ((entity = damageSource.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerx = (ServerPlayer)entity;
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(serverPlayerx, this, damageSource, originAmount, amount, flag);
        }
        return flag2;
    }

    public float applyItemBlocking(ServerLevel level, DamageSource damageSource, float damageAmount) {
        return this.applyItemBlocking(level, damageSource, damageAmount, false);
    }

    public float applyItemBlocking(ServerLevel level, DamageSource damageSource, float damageAmount, boolean dryRun) {
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemBlockingWith = this.getItemBlockingWith();
        if (itemBlockingWith == null) {
            return 0.0f;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksAttacks != null) {
            if (!blocksAttacks.bypassedBy().map(damageSource::is).orElse(false).booleanValue()) {
                double acos;
                AbstractArrow abstractArrow;
                Entity entity = damageSource.getDirectEntity();
                if (entity instanceof AbstractArrow && (abstractArrow = (AbstractArrow)entity).getPierceLevel() > 0) {
                    return 0.0f;
                }
                Vec3 sourcePosition = damageSource.getSourcePosition();
                if (sourcePosition != null) {
                    Vec3 vec3 = this.calculateViewVector(0.0f, this.getYHeadRot());
                    Vec3 vec31 = sourcePosition.subtract(this.position());
                    vec31 = new Vec3(vec31.x, 0.0, vec31.z).normalize();
                    acos = Math.acos(vec31.dot(vec3));
                } else {
                    acos = 3.1415927410125732;
                }
                float f = blocksAttacks.resolveBlockedDamage(damageSource, damageAmount, acos);
                if (!dryRun) {
                    LivingEntity livingEntity;
                    Entity entity2;
                    blocksAttacks.hurtBlockingItem(this.level(), itemBlockingWith, this, this.getUsedItemHand(), f);
                    if (f > 0.0f && !damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity2 = damageSource.getDirectEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).distanceToSqr(this) <= Mth.square(200.0)) {
                        this.blockUsingItem(level, livingEntity);
                    }
                }
                return f;
            }
        }
        return 0.0f;
    }

    public boolean canBlockAttack(DamageSource damageSource, float damageAmount) {
        if (damageAmount <= 0.0f) {
            return false;
        }
        ItemStack itemBlockingWith = this.getItemBlockingWith();
        if (itemBlockingWith == null) {
            return false;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksAttacks != null) {
            if (!blocksAttacks.bypassedBy().map(damageSource::is).orElse(false).booleanValue()) {
                AbstractArrow abstractArrow;
                Entity entity = damageSource.getDirectEntity();
                return !(entity instanceof AbstractArrow) || (abstractArrow = (AbstractArrow)entity).getPierceLevel() <= 0;
            }
        }
        return false;
    }

    public float resolveBlockedDamage(DamageSource damageSource, float damageAmount) {
        double acos;
        Vec3 sourcePosition = damageSource.getSourcePosition();
        if (sourcePosition != null) {
            Vec3 vec3 = this.calculateViewVector(0.0f, this.getYHeadRot());
            Vec3 vec31 = sourcePosition.subtract(this.position());
            vec31 = new Vec3(vec31.x, 0.0, vec31.z).normalize();
            acos = Math.acos(vec31.dot(vec3));
        } else {
            acos = 3.1415927410125732;
        }
        BlocksAttacks blocksAttacks = this.getItemBlockingWith().get(DataComponents.BLOCKS_ATTACKS);
        return blocksAttacks.resolveBlockedDamage(damageSource, damageAmount, acos);
    }

    public void blockingItemEffects(ServerLevel level, DamageSource damageSource, float f) {
        LivingEntity livingEntity;
        Entity entity;
        ItemStack itemBlockingWith = this.getItemBlockingWith();
        if (itemBlockingWith == null) {
            return;
        }
        BlocksAttacks blocksAttacks = itemBlockingWith.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksAttacks == null) {
            return;
        }
        blocksAttacks.hurtBlockingItem(this.level(), itemBlockingWith, this, this.getUsedItemHand(), f);
        if (f > 0.0f && !damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity = damageSource.getDirectEntity()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).distanceToSqr(this) <= Mth.square(200.0)) {
            this.blockUsingItem(level, livingEntity);
        }
    }

    public void playSecondaryHurtSound(DamageSource damageSource) {
        if (damageSource.is(DamageTypes.THORNS)) {
            SoundSource soundSource = this instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            this.level().playSound(null, this.position().x, this.position().y, this.position().z, SoundEvents.THORNS_HIT, soundSource);
        }
    }

    protected void resolveMobResponsibleForDamage(DamageSource damageSource) {
        Entity entity = damageSource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(damageSource.is(DamageTypeTags.NO_ANGER) || damageSource.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                this.setLastHurtByMob(livingEntity);
            }
        }
    }

    protected @Nullable Player resolvePlayerResponsibleForDamage(DamageSource damageSource) {
        Wolf wolf;
        Entity entity = damageSource.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.setLastHurtByPlayer(player, 100);
        } else if (entity instanceof Wolf && (wolf = (Wolf)entity).isTame()) {
            if (wolf.getOwnerReference() != null) {
                this.setLastHurtByPlayer(wolf.getOwnerReference().getUUID(), 100);
            } else {
                this.lastHurtByPlayer = null;
                this.lastHurtByPlayerMemoryTime = 0;
            }
        }
        return EntityReference.getPlayer(this.lastHurtByPlayer, this.level());
    }

    private float computeAmountFromEntityDamageEvent(EntityDamageEvent event) {
        float amount = 0.0f;
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
        amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        return amount += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
    }

    protected void blockUsingItem(ServerLevel level, LivingEntity entity) {
        entity.blockedByItem(this);
    }

    protected void blockedByItem(LivingEntity entity) {
        entity.knockback(0.5, entity.getX() - this.getX(), entity.getZ() - this.getZ(), this, EntityKnockbackEvent.Cause.SHIELD_BLOCK);
    }

    private boolean checkTotemDeathProtection(DamageSource damageSource) {
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack itemStack = null;
        DeathProtection deathProtection = null;
        InteractionHand hand = null;
        ItemStack itemInHand = ItemStack.EMPTY;
        for (InteractionHand interactionHand : InteractionHand.values()) {
            itemInHand = this.getItemInHand(interactionHand);
            deathProtection = itemInHand.get(DataComponents.DEATH_PROTECTION);
            if (deathProtection == null) continue;
            hand = interactionHand;
            itemStack = itemInHand.copy();
            break;
        }
        org.bukkit.inventory.EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((org.bukkit.entity.LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemStack == null);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            deathProtection = null;
        } else {
            LivingEntity livingEntity;
            if (!itemInHand.isEmpty() && itemStack != null) {
                itemInHand.shrink(1);
            }
            if (deathProtection == null) {
                deathProtection = DeathProtection.TOTEM_OF_UNDYING;
            }
            if (itemStack != null && (livingEntity = this) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                serverPlayer.awardStat(Stats.ITEM_USED.get(itemStack.getItem()));
                CriteriaTriggers.USED_TOTEM.trigger(serverPlayer, itemStack);
                itemStack.causeUseVibration(this, GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            deathProtection.applyEffects(itemStack, this);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return deathProtection != null;
    }

    public @Nullable DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource damageSource) {
        this.makeSound(this.getHurtSound(damageSource));
    }

    public void makeSound(@Nullable SoundEvent sound) {
        if (sound != null) {
            this.playSound(sound, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    private void breakItem(ItemStack stack) {
        if (!stack.isEmpty()) {
            Holder<SoundEvent> holder = stack.get(DataComponents.BREAK_SOUND);
            if (holder != null && !this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), holder.value(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(stack, 5);
        }
    }

    public void die(DamageSource damageSource) {
        if (!this.isRemoved() && !this.dead) {
            Entity entity = damageSource.getEntity();
            LivingEntity killCredit = this.getKillCredit();
            this.dead = true;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                EntityDeathEvent deathEvent;
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity instanceof Creeper) {
                    Creeper creeper = (Creeper)entity;
                    creeper.killedEntity((ServerLevel)this.level(), this, damageSource);
                }
                if ((deathEvent = this.dropAllDeathLoot(serverLevel, damageSource)) == null || !deathEvent.isCancelled()) {
                    if (this instanceof Mob) {
                        for (EquipmentSlot slot : this.clearedEquipmentSlots) {
                            this.setItemSlot(slot, ItemStack.EMPTY);
                        }
                        this.clearedEquipmentSlots.clear();
                    }
                    if (this.isSleeping()) {
                        this.stopSleeping();
                    }
                    if (!this.level().isClientSide() && this.hasCustomName() && SpigotConfig.logNamedDeaths) {
                        LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
                    }
                    this.getCombatTracker().recheckStatus();
                    if (entity != null) {
                        entity.killedEntity((ServerLevel)this.level(), this, damageSource);
                    }
                    this.gameEvent(GameEvent.ENTITY_DIE);
                } else {
                    this.dead = false;
                    this.setHealth((float)deathEvent.getReviveHealth());
                    if (entity instanceof Creeper) {
                        Creeper creeper = (Creeper)entity;
                        if (creeper.droppedSkulls) {
                            creeper.droppedSkulls = false;
                        }
                    }
                }
                this.createWitherRose(killCredit);
            }
            if (this.dead) {
                this.level().broadcastEntityEvent(this, (byte)3);
                this.setPose(Pose.DYING);
            }
        }
    }

    protected void createWitherRose(@Nullable LivingEntity entitySource) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean var6 = false;
            if (this.dead && entitySource instanceof WitherBoss) {
                if (serverLevel.getGameRules().get(GameRules.MOB_GRIEFING).booleanValue()) {
                    BlockPos blockPos = this.blockPosition();
                    BlockState blockState = Blocks.WITHER_ROSE.defaultBlockState();
                    if (this.level().getBlockState(blockPos).isAir() && blockState.canSurvive(this.level(), blockPos)) {
                        var6 = CraftEventFactory.handleBlockFormEvent(this.level(), blockPos, blockState, 3, this);
                    }
                }
                if (!var6) {
                    ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)itemEntity.getBukkitEntity());
                    if (!event.callEvent()) {
                        return;
                    }
                    this.level().addFreshEntity(itemEntity);
                }
            }
        }
    }

    protected EntityDeathEvent dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        boolean flag = this.lastHurtByPlayerMemoryTime > 0;
        this.dropEquipment(level);
        if (this.shouldDropLoot(level)) {
            this.dropFromLootTable(level, damageSource, flag);
            boolean prev = this.clearEquipmentSlots;
            this.clearEquipmentSlots = false;
            this.clearedEquipmentSlots.clear();
            this.dropCustomDeathLoot(level, damageSource, flag);
            this.clearEquipmentSlots = prev;
        }
        EntityDeathEvent deathEvent = CraftEventFactory.callEntityDeathEvent(this, damageSource, this.drops, () -> {
            LivingEntity killer = this.getKillCredit();
            if (killer != null) {
                killer.awardKillScore(this, damageSource);
            }
        });
        this.postDeathDropItems(deathEvent);
        this.drops = new ArrayList<Entity.DefaultDrop>();
        this.dropExperience(level, damageSource.getEntity());
        return deathEvent;
    }

    protected void dropEquipment(ServerLevel level) {
    }

    protected void postDeathDropItems(EntityDeathEvent event) {
    }

    public int getExpReward(ServerLevel level, @Nullable Entity entity) {
        if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerMemoryTime > 0 && this.shouldDropExperience() && level.getGameRules().get(GameRules.MOB_DROPS).booleanValue())) {
            return this.getExperienceReward(level, entity);
        }
        return 0;
    }

    protected void dropExperience(ServerLevel level, @Nullable Entity entity) {
        if (!(this instanceof EnderDragon)) {
            ExperienceOrb.awardWithDirection(level, this.position(), Vec3.ZERO, this.expToDrop, this instanceof ServerPlayer ? ExperienceOrb.SpawnReason.PLAYER_DEATH : ExperienceOrb.SpawnReason.ENTITY_DEATH, entity, this);
            this.expToDrop = 0;
        }
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource damageSource, boolean recentlyHit) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity attacker, DamageSource damageSource) {
        float f;
        float f2 = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback(serverLevel, this.getWeaponItem(), attacker, damageSource, f2) / 2.0f;
        } else {
            f = f2 / 2.0f;
        }
        return f;
    }

    protected void dropFromLootTable(ServerLevel level, DamageSource damageSource, boolean playerKill) {
        Optional<ResourceKey<LootTable>> lootTable = this.getLootTable();
        if (!lootTable.isEmpty()) {
            this.dropFromLootTable(level, damageSource, playerKill, lootTable.get());
        }
    }

    public void dropFromLootTable(ServerLevel level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable) {
        this.dropFromLootTable(level, damageSource, playerKill, lootTable, itemStack -> this.spawnAtLocation(level, (ItemStack)itemStack));
    }

    public void dropFromLootTable(ServerLevel level, DamageSource damageSource, boolean playerKill, ResourceKey<LootTable> lootTable, Consumer<ItemStack> dropConsumer) {
        LootTable lootTable1 = level.getServer().reloadableRegistries().getLootTable(lootTable);
        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, damageSource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, damageSource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, damageSource.getDirectEntity());
        Player lastHurtByPlayer = this.getLastHurtByPlayer();
        if (playerKill && lastHurtByPlayer != null) {
            builder = builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, lastHurtByPlayer).withLuck(lastHurtByPlayer.getLuck());
        }
        LootParams lootParams = builder.create(LootContextParamSets.ENTITY);
        lootTable1.getRandomItems(lootParams, this.getLootTableSeed(), dropConsumer);
    }

    public boolean dropFromEntityInteractLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, @Nullable Entity entity, ItemStack tool, BiConsumer<ServerLevel, ItemStack> dropConsumer) {
        return this.dropFromLootTable(level, lootTable, builder -> builder.withParameter(LootContextParams.TARGET_ENTITY, this).withOptionalParameter(LootContextParams.INTERACTING_ENTITY, entity).withParameter(LootContextParams.TOOL, tool).create(LootContextParamSets.ENTITY_INTERACT), dropConsumer);
    }

    public boolean dropFromGiftLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, BiConsumer<ServerLevel, ItemStack> dropConsumer) {
        return this.dropFromLootTable(level, lootTable, builder -> builder.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.GIFT), dropConsumer);
    }

    protected void dropFromShearingLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, ItemStack shears, BiConsumer<ServerLevel, ItemStack> dropConsumer) {
        this.dropFromLootTable(level, lootTable, builder -> builder.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.TOOL, shears).create(LootContextParamSets.SHEARING), dropConsumer);
    }

    protected boolean dropFromLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, Function<LootParams.Builder, LootParams> paramsBuilder, BiConsumer<ServerLevel, ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.getServer().reloadableRegistries().getLootTable(lootTable);
        ObjectArrayList<ItemStack> randomItems = lootTable1.getRandomItems(lootParams = paramsBuilder.apply(new LootParams.Builder(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public void knockback(double strength, double x, double z) {
        this.knockback(strength, x, z, null, EntityKnockbackEvent.Cause.UNKNOWN);
    }

    public void knockback(double strength, double x, double z, @Nullable Entity attacker, EntityKnockbackEvent.Cause eventCause) {
        strength *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        Vec3 deltaMovement = this.getDeltaMovement();
        while (x * x + z * z < (double)1.0E-5f) {
            x = (this.random.nextDouble() - this.random.nextDouble()) * 0.01;
            z = (this.random.nextDouble() - this.random.nextDouble()) * 0.01;
        }
        Vec3 vec3 = new Vec3(x, 0.0, z).normalize().scale(strength);
        Vec3 finalVelocity = new Vec3(deltaMovement.x / 2.0 - vec3.x, this.onGround() ? Math.min(0.4, deltaMovement.y / 2.0 + strength) : deltaMovement.y, deltaMovement.z / 2.0 - vec3.z);
        Vec3 diff = finalVelocity.subtract(deltaMovement);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, attacker, eventCause, strength, diff);
        if (event.isCancelled()) {
            return;
        }
        this.needsSync = true;
        this.setDeltaMovement(deltaMovement.add(event.getKnockback().getX(), event.getKnockback().getY(), event.getKnockback().getZ()));
    }

    public void indicateDamage(double xDistance, double zDistance) {
    }

    public @Nullable SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.GENERIC_HURT;
    }

    public @Nullable SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    public SoundEvent getFallDamageSound(int height) {
        return height > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AABB getHitbox() {
        AABB boundingBox = this.getBoundingBox();
        Entity vehicle = this.getVehicle();
        if (vehicle != null) {
            Vec3 passengerRidingPosition = vehicle.getPassengerRidingPosition(this);
            return boundingBox.setMinY(Math.max(passengerRidingPosition.y, boundingBox.minY));
        }
        return boundingBox;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments(EquipmentSlot slot) {
        return (Map)this.activeLocationDependentEnchantments.computeIfAbsent(slot, equipmentSlot -> new Reference2ObjectArrayMap());
    }

    public void lungeForwardMaybe() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            EnchantmentHelper.doLungeEffects(serverLevel, this);
        }
    }

    public Fallsounds getFallSounds() {
        return new Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    public Optional<BlockPos> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPos blockPos = this.blockPosition();
        BlockState inBlockState = this.getInBlockState();
        if (this.isFallFlying() && inBlockState.is(BlockTags.CAN_GLIDE_THROUGH)) {
            return false;
        }
        if (inBlockState.is(BlockTags.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(blockPos);
            return true;
        }
        if (inBlockState.getBlock() instanceof TrapDoorBlock && this.trapdoorUsableAsLadder(blockPos, inBlockState)) {
            this.lastClimbablePos = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPos pos, BlockState state) {
        if (!state.getValue(TrapDoorBlock.OPEN).booleanValue()) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(pos.below());
        return blockState.is(Blocks.LADDER) && blockState.getValue(LadderBlock.FACING) == state.getValue(HorizontalDirectionalBlock.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f && !this.dead;
    }

    public boolean isLookingAtMe(LivingEntity entity, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3 vec3 = entity.getViewVector(1.0f).normalize();
        for (double d : yValues) {
            Vec3 vec31 = new Vec3(this.getX() - entity.getX(), d - entity.getEyeY(), this.getZ() - entity.getZ());
            double len = vec31.length();
            vec31 = vec31.normalize();
            double d1 = vec3.dot(vec31);
            double d2 = scaleByDistance ? len : 1.0;
            if (!(d1 > 1.0 - tolerance / d2) || !entity.hasLineOfSight(this, visual ? ClipContext.Block.VISUAL : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, d)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float distanceOffset) {
        return Mth.floor(distanceOffset + 3.0f);
    }

    @Override
    public boolean causeFallDamage(double fallDistance, float damageMultiplier, DamageSource damageSource) {
        boolean flag = super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
        int i = this.calculateFallDamage(fallDistance, damageMultiplier);
        if (i > 0) {
            if (!this.hurtServer((ServerLevel)this.level(), damageSource, i)) {
                return true;
            }
            this.playSound(this.getFallDamageSound(i), 1.0f, 1.0f);
            this.playBlockFallSound();
            return true;
        }
        return flag;
    }

    protected int calculateFallDamage(double fallDistance, float damageMultiplier) {
        if (this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        double d = this.calculateFallPower(fallDistance);
        return Mth.floor(d * (double)damageMultiplier * this.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER));
    }

    private double calculateFallPower(double fallDistance) {
        return fallDistance + 1.0E-6 - this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
    }

    protected void playBlockFallSound() {
        if (!this.isSilent()) {
            int floor = Mth.floor(this.getX());
            int floor1 = Mth.floor(this.getY() - (double)0.2f);
            int floor2 = Mth.floor(this.getZ());
            BlockState blockState = this.level().getBlockState(new BlockPos(floor, floor1, floor2));
            if (!blockState.isAir()) {
                SoundType soundType = blockState.getSoundType();
                this.playSound(soundType.getFallSound(), soundType.getVolume() * 0.5f, soundType.getPitch() * 0.75f);
            }
        }
    }

    @Override
    public void animateHurt(float yaw) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return Mth.floor(this.getAttributeValue(Attributes.ARMOR));
    }

    protected void hurtArmor(DamageSource damageSource, float damageAmount) {
    }

    protected void hurtHelmet(DamageSource damageSource, float damageAmount) {
    }

    protected void doHurtEquipment(DamageSource damageSource, float damageAmount, EquipmentSlot ... slots) {
        if (!(damageAmount <= 0.0f)) {
            int i = (int)Math.max(1.0f, damageAmount / 4.0f);
            for (EquipmentSlot equipmentSlot : slots) {
                ItemStack itemBySlot = this.getItemBySlot(equipmentSlot);
                Equippable equippable = itemBySlot.get(DataComponents.EQUIPPABLE);
                if (equippable == null || !equippable.damageOnHurt() || !itemBySlot.isDamageableItem() || !itemBySlot.canBeHurtBy(damageSource)) continue;
                itemBySlot.hurtAndBreak(i, this, equipmentSlot);
            }
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource damageSource, float damageAmount) {
        if (!damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            damageAmount = CombatRules.getDamageAfterAbsorb(this, damageAmount, damageSource, this.getArmorValue(), (float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return damageAmount;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damageSource, float damageAmount) {
        float damageProtection;
        if (damageSource.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return damageAmount;
        }
        if (damageAmount <= 0.0f) {
            return 0.0f;
        }
        if (damageSource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return damageAmount;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            damageProtection = EnchantmentHelper.getDamageProtection(serverLevel, this, damageSource);
        } else {
            damageProtection = 0.0f;
        }
        if (damageProtection > 0.0f) {
            damageAmount = CombatRules.getDamageAfterMagicAbsorb(damageAmount, damageProtection);
        }
        return damageAmount;
    }

    private EntityDamageEvent handleEntityDamage(DamageSource damagesource, float amount, float invulnerabilityRelatedLastDamage) {
        float originalDamage = amount;
        com.google.common.base.Function invulnerabilityReductionEquation = mod -> {
            if (invulnerabilityRelatedLastDamage == 0.0f) {
                return 0.0;
            }
            if (mod.floatValue() < invulnerabilityRelatedLastDamage) {
                return 0.0;
            }
            return -invulnerabilityRelatedLastDamage;
        };
        float originalInvulnerabilityReduction = ((Double)invulnerabilityReductionEquation.apply((Object)amount)).floatValue();
        com.google.common.base.Function freezing = mod -> {
            if (damagesource.is(DamageTypeTags.IS_FREEZING) && this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                return -(mod - mod * 5.0);
            }
            return -0.0;
        };
        float freezingModifier = ((Double)freezing.apply((Object)(amount += originalInvulnerabilityReduction))).floatValue();
        com.google.common.base.Function hardHat = mod -> {
            if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                return -(mod - mod * 0.75);
            }
            return -0.0;
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(amount += freezingModifier))).floatValue();
        com.google.common.base.Function blocking = mod -> {
            if (!this.canBlockAttack(damagesource, mod.floatValue())) {
                return 0.0;
            }
            return -this.resolveBlockedDamage(damagesource, mod.floatValue());
        };
        float blockingModifier = ((Double)blocking.apply((Object)(amount += hardHatModifier))).floatValue();
        com.google.common.base.Function armor = mod -> -(mod - (double)this.getDamageAfterArmorAbsorb(damagesource, mod.floatValue()));
        float armorModifier = ((Double)armor.apply((Object)(amount += blockingModifier))).floatValue();
        com.google.common.base.Function resistance = mod -> {
            if (!damagesource.is(DamageTypeTags.BYPASSES_EFFECTS) && this.hasEffect(MobEffects.RESISTANCE) && !damagesource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
                int i = (this.getEffect(MobEffects.RESISTANCE).getAmplifier() + 1) * 5;
                int j = 25 - i;
                float f1 = mod.floatValue() * (float)j;
                return -(mod - (double)Math.max(f1 / 25.0f, 0.0f));
            }
            return -0.0;
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(amount += armorModifier))).floatValue();
        com.google.common.base.Function magic = mod -> -(mod - (double)this.getDamageAfterMagicAbsorb(damagesource, mod.floatValue()));
        float magicModifier = ((Double)magic.apply((Object)(amount += resistanceModifier))).floatValue();
        com.google.common.base.Function absorption = mod -> -Math.max(mod - Math.max(mod - (double)this.getAbsorptionAmount(), 0.0), 0.0);
        float absorptionModifier = ((Double)absorption.apply((Object)(amount += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, (com.google.common.base.Function<Double, Double>)freezing, (com.google.common.base.Function<Double, Double>)hardHat, (com.google.common.base.Function<Double, Double>)blocking, (com.google.common.base.Function<Double, Double>)armor, (com.google.common.base.Function<Double, Double>)resistance, (com.google.common.base.Function<Double, Double>)magic, (com.google.common.base.Function<Double, Double>)absorption, (damageModifierDoubleMap, damageModifierFunctionMap) -> {
            damageModifierFunctionMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, invulnerabilityReductionEquation);
            damageModifierDoubleMap.put(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION, Double.valueOf(originalInvulnerabilityReduction));
        });
    }

    protected boolean actuallyHurt(ServerLevel level, DamageSource damageSource, float amount, EntityDamageEvent event) {
        if (!this.isInvulnerableTo(level, damageSource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damageSource.getEntity() instanceof Player) {
                if (damageSource.getEntity() instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)damageSource.getEntity();
                    if (new PlayerAttackEntityCooldownResetEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), player.getAttackStrengthScale(0.0f)).callEvent()) {
                        player.resetOnlyAttackStrengthTicker();
                    }
                } else {
                    ((Player)damageSource.getEntity()).resetOnlyAttackStrengthTicker();
                }
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof ServerPlayer) {
                    ((ServerPlayer)this).awardStat(Stats.DAMAGE_RESISTED, Math.round(f3 * 10.0f));
                } else if (damageSource.getEntity() instanceof ServerPlayer) {
                    ((ServerPlayer)damageSource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f3 * 10.0f));
                }
            }
            if (damageSource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                float helmetDamage = (float)event.getDamage();
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                this.hurtHelmet(damageSource, helmetDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING));
            }
            if (!damageSource.is(DamageTypeTags.BYPASSES_ARMOR)) {
                float armorDamage = (float)event.getDamage();
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.INVULNERABILITY_REDUCTION);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING);
                armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
                this.hurtArmor(damageSource, armorDamage += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.blockingItemEffects(level, damageSource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof Player;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.setAbsorptionAmount(Math.max(this.getAbsorptionAmount() - absorptionModifier, 0.0f));
            float f1 = absorptionModifier;
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = this) instanceof Player) {
                Player player = (Player)entity;
                player.awardStat(Stats.DAMAGE_ABSORBED, Math.round(f1 * 10.0f));
            }
            if (f1 > 0.0f && f1 < 3.4028235E37f && (entity = damageSource.getEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f1 * 10.0f));
            }
            if (amount > 0.0f || !human) {
                if (human) {
                    ((Player)this).causeFoodExhaustion(damageSource.getFoodExhaustion(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (amount < 3.4028235E37f) {
                        ((Player)this).awardStat(Stats.DAMAGE_TAKEN, Math.round(amount * 10.0f));
                    }
                }
                this.getCombatTracker().recordDamage(damageSource, amount);
                this.setHealth(this.getHealth() - amount);
                if (!human) {
                    this.setAbsorptionAmount(this.getAbsorptionAmount() - amount);
                }
                this.gameEvent(GameEvent.ENTITY_DAMAGE);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof ServerPlayer) {
                    CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, damageSource, originalDamage, amount, true);
                    f1 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f1 > 0.0f && f1 < 3.4028235E37f) {
                        ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damageSource.getEntity() instanceof ServerPlayer) {
                    CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)damageSource.getEntity(), this, damageSource, originalDamage, amount, true);
                }
                return !GlobalConfiguration.get().unsupportedSettings.skipVanillaDamageTickWhenShieldBlocked;
            }
            return true;
        }
        return true;
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    public @Nullable LivingEntity getKillCredit() {
        if (this.lastHurtByPlayer != null) {
            return this.lastHurtByPlayer.getEntity(this.level(), Player.class);
        }
        return this.lastHurtByMob != null ? this.lastHurtByMob.getEntity(this.level(), LivingEntity.class) : null;
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(Attributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(Attributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int count) {
        this.setArrowCount(count, false);
    }

    public final void setArrowCount(int count, boolean reset) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.getArrowCount(), count, reset);
        if (event.isCancelled()) {
            return;
        }
        this.entityData.set(DATA_ARROW_COUNT_ID, event.getNewAmount());
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int stingerCount) {
        this.entityData.set(DATA_STINGER_COUNT_ID, stingerCount);
    }

    private int getCurrentSwingDuration() {
        ItemStack itemInHand = this.getItemInHand(InteractionHand.MAIN_HAND);
        int duration = itemInHand.getSwingAnimation().duration();
        if (MobEffectUtil.hasDigSpeed(this)) {
            return duration - (1 + MobEffectUtil.getDigSpeedAmplification(this));
        }
        return this.hasEffect(MobEffects.MINING_FATIGUE) ? duration + (1 + this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) * 2 : duration;
    }

    public void swing(InteractionHand hand) {
        this.swing(hand, false);
    }

    public void swing(InteractionHand hand, boolean updateSelf) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = hand;
            if (this.level() instanceof ServerLevel) {
                ClientboundAnimatePacket clientboundAnimatePacket = new ClientboundAnimatePacket(this, hand == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache chunkSource = ((ServerLevel)this.level()).getChunkSource();
                if (updateSelf) {
                    chunkSource.sendToTrackingPlayersAndSelf(this, clientboundAnimatePacket);
                } else {
                    chunkSource.sendToTrackingPlayers(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource damageSource) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = this.invulnerableDuration;
        this.hurtTime = this.hurtDuration = 10;
        SoundEvent hurtSound = this.getHurtSound(damageSource);
        if (hurtSound != null) {
            this.playSound(hurtSound, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.lastDamageSource = damageSource;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte id) {
        switch (id) {
            case 2: {
                this.onKineticHit();
                break;
            }
            case 3: {
                SoundEvent deathSound = this.getDeathSound();
                if (deathSound != null) {
                    this.playSound(deathSound, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 46: {
                int i = 128;
                for (int i1 = 0; i1 < 128; ++i1) {
                    double d = (double)i1 / 127.0;
                    float f = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = Mth.lerp(d, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double d2 = Mth.lerp(d, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double d3 = Mth.lerp(d, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(ParticleTypes.PORTAL, d1, d2, d3, f, f1, f2);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.FEET));
                break;
            }
            case 54: {
                HoneyBlock.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.BODY));
                break;
            }
            case 67: {
                this.makeDrownParticles();
                break;
            }
            case 68: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.SADDLE));
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    public float getTicksSinceLastKineticHitFeedback(float partialTick) {
        return this.lastKineticHitFeedbackTime < 0L ? 0.0f : (float)(this.level().getGameTime() - this.lastKineticHitFeedbackTime) + partialTick;
    }

    public void makePoofParticles() {
        for (int i = 0; i < 20; ++i) {
            double d = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.level().addParticle(ParticleTypes.POOF, this.getRandomX(1.0) - d * 10.0, this.getRandomY() - d1 * 10.0, this.getRandomZ(1.0) - d2 * 10.0, d, d1, d2);
        }
    }

    private void makeDrownParticles() {
        Vec3 deltaMovement = this.getDeltaMovement();
        for (int i = 0; i < 8; ++i) {
            double d = this.random.triangle(0.0, 1.0);
            double d1 = this.random.triangle(0.0, 1.0);
            double d2 = this.random.triangle(0.0, 1.0);
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d, this.getY() + d1, this.getZ() + d2, deltaMovement.x, deltaMovement.y, deltaMovement.z);
        }
    }

    private void onKineticHit() {
        if (this.level().getGameTime() - this.lastKineticHitFeedbackTime > 10L) {
            this.lastKineticHitFeedbackTime = this.level().getGameTime();
            KineticWeapon kineticWeapon = this.useItem.get(DataComponents.KINETIC_WEAPON);
            if (kineticWeapon != null) {
                kineticWeapon.makeLocalHitSound(this);
            }
        }
    }

    private void swapHandItems() {
        ItemStack itemBySlot = this.getItemBySlot(EquipmentSlot.OFFHAND);
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, itemBySlot);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), this.level().getWorld().getVoidDamageAmount());
    }

    protected void updateSwingTime() {
        int currentSwingDuration = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= currentSwingDuration) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)currentSwingDuration;
    }

    public @Nullable AttributeInstance getAttribute(Holder<Attribute> attribute) {
        return this.getAttributes().getInstance(attribute);
    }

    public double getAttributeValue(Holder<Attribute> attribute) {
        return this.getAttributes().getValue(attribute);
    }

    public double getAttributeBaseValue(Holder<Attribute> attribute) {
        return this.getAttributes().getBaseValue(attribute);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    public ItemStack getItemHeldByArm(HumanoidArm arm) {
        return this.getMainArm() == arm ? this.getMainHandItem() : this.getOffhandItem();
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public AttackRange entityAttackRange() {
        AttackRange attackRange = this.getActiveItem().get(DataComponents.ATTACK_RANGE);
        return attackRange != null ? attackRange : AttackRange.defaultFor(this);
    }

    public ItemStack getActiveItem() {
        return this.isUsingItem() ? this.getUseItem() : this.getMainHandItem();
    }

    public boolean isHolding(net.minecraft.world.item.Item item) {
        return this.isHolding((ItemStack itemStack) -> itemStack.is(item));
    }

    public boolean isHolding(Predicate<ItemStack> predicate) {
        return predicate.test(this.getMainHandItem()) || predicate.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (hand == InteractionHand.OFF_HAND) {
            return this.getItemBySlot(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
    }

    public void setItemInHand(InteractionHand hand, ItemStack stack) {
        if (hand == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != InteractionHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)hand));
            }
            this.setItemSlot(EquipmentSlot.OFFHAND, stack);
        }
    }

    public boolean hasItemInSlot(EquipmentSlot slot) {
        return !this.getItemBySlot(slot).isEmpty();
    }

    public boolean canUseSlot(EquipmentSlot slot) {
        return true;
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        return this.equipment.get(slot);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack, boolean silent) {
        this.onEquipItem(slot, this.equipment.set(slot, stack), stack, silent);
    }

    public float getArmorCoverPercentage() {
        int i = 0;
        int i1 = 0;
        for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
            if (equipmentSlot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack itemBySlot = this.getItemBySlot(equipmentSlot);
            if (!itemBySlot.isEmpty()) {
                ++i1;
            }
            ++i;
        }
        return i > 0 ? (float)i1 / (float)i : 0.0f;
    }

    @Override
    public void setSprinting(boolean sprinting) {
        super.setSprinting(sprinting);
        AttributeInstance attribute = this.getAttribute(Attributes.MOVEMENT_SPEED);
        attribute.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (sprinting) {
            attribute.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    public float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity entity) {
        if (!this.isSleeping()) {
            super.push(entity);
        }
    }

    private void dismountVehicle(Entity vehicle) {
        Vec3 vec3;
        if (this.isRemoved()) {
            vec3 = this.position();
        } else if (!vehicle.isRemoved() && !this.level().getBlockState(vehicle.blockPosition()).is(BlockTags.PORTALS)) {
            vec3 = vehicle.getDismountLocationForPassenger(this);
        } else {
            boolean flag;
            double max = Math.max(this.getY(), vehicle.getY());
            vec3 = new Vec3(this.getX(), max, this.getZ());
            boolean bl = flag = this.getBbWidth() <= 4.0f && this.getBbHeight() <= 4.0f;
            if (flag) {
                double d = (double)this.getBbHeight() / 2.0;
                Vec3 vec31 = vec3.add(0.0, d, 0.0);
                VoxelShape voxelShape = Shapes.create(AABB.ofSize(vec31, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()));
                vec3 = this.level().findFreePosition(this, voxelShape, vec31, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).map(vec32 -> vec32.add(0.0, -d, 0.0)).orElse(vec3);
            }
        }
        this.dismountTo(vec3.x, vec3.y, vec3.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float multiplier) {
        return (float)this.getAttributeValue(Attributes.JUMP_STRENGTH) * multiplier * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP_BOOST) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP_BOOST).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float jumpPower = this.getJumpPower();
        if (!(jumpPower <= 1.0E-5f)) {
            Vec3 deltaMovement = this.getDeltaMovement();
            long time = System.nanoTime();
            boolean canCrit = true;
            if (this instanceof Player) {
                canCrit = false;
                if (time - this.lastJumpTime > 250000000L) {
                    this.lastJumpTime = time;
                    canCrit = true;
                }
            }
            this.setDeltaMovement(deltaMovement.x, Math.max((double)jumpPower, deltaMovement.y), deltaMovement.z);
            if (this.isSprinting()) {
                float f = this.getYRot() * ((float)Math.PI / 180);
                if (canCrit) {
                    this.addDeltaMovement(new Vec3((double)(-Mth.sin(f)) * 0.2, 0.0, (double)Mth.cos(f) * 0.2));
                }
            }
            this.needsSync = true;
        }
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<Fluid> fluidTag) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(FluidState fluidState) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(Attributes.GRAVITY);
    }

    protected double getEffectiveGravity() {
        boolean flag = this.getDeltaMovement().y <= 0.0;
        return flag && this.hasEffect(MobEffects.SLOW_FALLING) ? Math.min(this.getGravity(), 0.01) : this.getGravity();
    }

    public void travel(Vec3 travelVector) {
        if (this.shouldTravelInFluid(this.level().getFluidState(this.blockPosition()))) {
            this.travelInFluid(travelVector);
        } else if (this.isFallFlying()) {
            this.travelFallFlying(travelVector);
        } else {
            this.travelInAir(travelVector);
        }
    }

    protected boolean shouldTravelInFluid(FluidState fluidState) {
        return (this.isInWater() || this.isInLava()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluidState);
    }

    protected void travelFlying(Vec3 relative, float amount) {
        this.travelFlying(relative, 0.02f, 0.02f, amount);
    }

    protected void travelFlying(Vec3 relative, float inWaterAmount, float inLavaAmount, float amount) {
        if (this.isInWater()) {
            this.moveRelative(inWaterAmount, relative);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(inLavaAmount, relative);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            this.moveRelative(amount, relative);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.91f));
        }
    }

    private void travelInAir(Vec3 travelVector) {
        BlockPos blockPosBelowThatAffectsMyMovement = this.getBlockPosBelowThatAffectsMyMovement();
        float f = this.onGround() ? this.level().getBlockState(blockPosBelowThatAffectsMyMovement).getBlock().getFriction() : 1.0f;
        float f1 = f * 0.91f;
        Vec3 vec3 = this.handleRelativeFrictionAndCalculateMovement(travelVector, f);
        double d = vec3.y;
        MobEffectInstance effect = this.getEffect(MobEffects.LEVITATION);
        d = effect != null ? (d += (0.05 * (double)(effect.getAmplifier() + 1) - vec3.y) * 0.2) : (!this.level().isClientSide() || this.level().hasChunkAt(blockPosBelowThatAffectsMyMovement) ? (d -= this.getEffectiveGravity()) : (this.getY() > (double)this.level().getMinY() ? -0.1 : 0.0));
        if (this.shouldDiscardFriction()) {
            this.setDeltaMovement(vec3.x, d, vec3.z);
        } else {
            float f2 = this instanceof FlyingAnimal ? f1 : 0.98f;
            this.setDeltaMovement(vec3.x * (double)f1, d * (double)f2, vec3.z * (double)f1);
        }
    }

    private void travelInFluid(Vec3 travelVector) {
        boolean flag = this.getDeltaMovement().y <= 0.0;
        double y = this.getY();
        double effectiveGravity = this.getEffectiveGravity();
        if (this.isInWater()) {
            this.travelInWater(travelVector, effectiveGravity, flag, y);
            this.floatInWaterWhileRidden();
        } else {
            this.travelInLava(travelVector, effectiveGravity, flag, y);
        }
    }

    protected void travelInWater(Vec3 travelVector, double gravity, boolean isFalling, double previousY) {
        float f = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
        float f1 = 0.02f;
        float f2 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
        if (!this.onGround()) {
            f2 *= 0.5f;
        }
        if (f2 > 0.0f) {
            f += (0.54600006f - f) * f2;
            f1 += (this.getSpeed() - f1) * f2;
        }
        if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
            f = 0.96f;
        }
        this.moveRelative(f1, travelVector);
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 deltaMovement = this.getDeltaMovement();
        if (this.horizontalCollision && this.onClimbable()) {
            deltaMovement = new Vec3(deltaMovement.x, 0.2, deltaMovement.z);
        }
        deltaMovement = deltaMovement.multiply(f, 0.8f, f);
        this.setDeltaMovement(this.getFluidFallingAdjustedMovement(gravity, isFalling, deltaMovement));
        this.jumpOutOfFluid(previousY);
    }

    private void travelInLava(Vec3 travelVector, double gravity, boolean isFalling, double previousY) {
        this.moveRelative(0.02f, travelVector);
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
            Vec3 fluidFallingAdjustedMovement = this.getFluidFallingAdjustedMovement(gravity, isFalling, this.getDeltaMovement());
            this.setDeltaMovement(fluidFallingAdjustedMovement);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        }
        if (gravity != 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -gravity / 4.0, 0.0));
        }
        this.jumpOutOfFluid(previousY);
    }

    private void jumpOutOfFluid(double previousY) {
        Vec3 deltaMovement = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree(deltaMovement.x, deltaMovement.y + (double)0.6f - this.getY() + previousY, deltaMovement.z)) {
            this.setDeltaMovement(deltaMovement.x, 0.3f, deltaMovement.z);
        }
    }

    private void floatInWaterWhileRidden() {
        boolean isCanFloatWhileRidden = this.getType().is(EntityTypeTags.CAN_FLOAT_WHILE_RIDDEN);
        if (isCanFloatWhileRidden && this.isVehicle() && this.getFluidHeight(FluidTags.WATER) > this.getFluidJumpThreshold()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
        }
    }

    private void travelFallFlying(Vec3 travelVector) {
        if (this.onClimbable()) {
            this.travelInAir(travelVector);
            this.stopFallFlying();
        } else {
            Vec3 deltaMovement = this.getDeltaMovement();
            double d = deltaMovement.horizontalDistance();
            this.setDeltaMovement(this.updateFallFlyingMovement(deltaMovement));
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (!this.level().isClientSide()) {
                double d1 = this.getDeltaMovement().horizontalDistance();
                this.handleFallFlyingCollisions(d, d1);
            }
        }
    }

    public void stopFallFlying() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.setSharedFlag(7, true);
            this.setSharedFlag(7, false);
        }
    }

    private Vec3 updateFallFlyingMovement(Vec3 deltaMovement) {
        double d1;
        Vec3 lookAngle = this.getLookAngle();
        float f = this.getXRot() * ((float)Math.PI / 180);
        double squareRoot = Math.sqrt(lookAngle.x * lookAngle.x + lookAngle.z * lookAngle.z);
        double d = deltaMovement.horizontalDistance();
        double effectiveGravity = this.getEffectiveGravity();
        double squared = Mth.square(Math.cos(f));
        deltaMovement = deltaMovement.add(0.0, effectiveGravity * (-1.0 + squared * 0.75), 0.0);
        if (deltaMovement.y < 0.0 && squareRoot > 0.0) {
            d1 = deltaMovement.y * -0.1 * squared;
            deltaMovement = deltaMovement.add(lookAngle.x * d1 / squareRoot, d1, lookAngle.z * d1 / squareRoot);
        }
        if (f < 0.0f && squareRoot > 0.0) {
            d1 = d * (double)(-Mth.sin(f)) * 0.04;
            deltaMovement = deltaMovement.add(-lookAngle.x * d1 / squareRoot, d1 * 3.2, -lookAngle.z * d1 / squareRoot);
        }
        if (squareRoot > 0.0) {
            deltaMovement = deltaMovement.add((lookAngle.x / squareRoot * d - deltaMovement.x) * 0.1, 0.0, (lookAngle.z / squareRoot * d - deltaMovement.z) * 0.1);
        }
        return deltaMovement.multiply(0.99f, 0.98f, 0.99f);
    }

    private void handleFallFlyingCollisions(double oldSpeed, double newSpeed) {
        double d;
        float f;
        if (this.horizontalCollision && (f = (float)((d = oldSpeed - newSpeed) * 10.0 - 3.0)) > 0.0f) {
            this.playSound(this.getFallDamageSound((int)f), 1.0f, 1.0f);
            this.hurt(this.damageSources().flyIntoWall(), f);
        }
    }

    private void travelRidden(Player player, Vec3 travelVector) {
        Vec3 riddenInput = this.getRiddenInput(player, travelVector);
        this.tickRidden(player, riddenInput);
        if (this.canSimulateMovement()) {
            this.setSpeed(this.getRiddenSpeed(player));
            this.travel(riddenInput);
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
    }

    protected Vec3 getRiddenInput(Player player, Vec3 travelVector) {
        return travelVector;
    }

    protected float getRiddenSpeed(Player player) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean includeHeight) {
        float f = (float)Mth.length(this.getX() - this.xo, includeHeight ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        if (!this.isPassenger() && this.isAlive()) {
            this.updateWalkAnimation(f);
        } else {
            this.walkAnimation.stop();
        }
    }

    protected void updateWalkAnimation(float partialTick) {
        float min = Math.min(partialTick * 4.0f, 1.0f);
        this.walkAnimation.update(min, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    private Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 deltaMovement, float friction) {
        this.moveRelative(this.getFrictionInfluencedSpeed(friction), deltaMovement);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 deltaMovement1 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.wasInPowderSnow && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            deltaMovement1 = new Vec3(deltaMovement1.x, 0.2, deltaMovement1.z);
        }
        return deltaMovement1;
    }

    public Vec3 getFluidFallingAdjustedMovement(double gravity, boolean isFalling, Vec3 deltaMovement) {
        if (gravity != 0.0 && !this.isSprinting()) {
            double d = isFalling && Math.abs(deltaMovement.y - 0.005) >= 0.003 && Math.abs(deltaMovement.y - gravity / 16.0) < 0.003 ? -0.003 : deltaMovement.y - gravity / 16.0;
            return new Vec3(deltaMovement.x, d, deltaMovement.z);
        }
        return deltaMovement;
    }

    private Vec3 handleOnClimbable(Vec3 deltaMovement) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float f = 0.15f;
            double d = Mth.clamp(deltaMovement.x, (double)-0.15f, (double)0.15f);
            double d1 = Mth.clamp(deltaMovement.z, (double)-0.15f, (double)0.15f);
            double max = Math.max(deltaMovement.y, (double)-0.15f);
            if (max < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof Player) {
                max = 0.0;
            }
            deltaMovement = new Vec3(d, max, d1);
        }
        return deltaMovement;
    }

    private float getFrictionInfluencedSpeed(float friction) {
        return this.onGround() ? this.getSpeed() * (0.21600002f / (friction * friction * friction)) : this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public boolean doHurtTarget(ServerLevel level, Entity target) {
        this.setLastHurtMob(target);
        return false;
    }

    public void causeExtraKnockback(Entity target, float strength, Vec3 currentMovement) {
        if (strength > 0.0f && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.knockback(strength, Mth.sin(this.getYRot() * ((float)Math.PI / 180)), -Mth.cos(this.getYRot() * ((float)Math.PI / 180)), this, EntityKnockbackEvent.Cause.ENTITY_ATTACK);
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
        }
    }

    protected void playAttackSound() {
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.noActionTime;
    }

    @Override
    public void tick() {
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide()) {
            int stingerCount;
            int arrowCount = this.getArrowCount();
            if (arrowCount > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - arrowCount);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(arrowCount - 1);
                }
            }
            if ((stingerCount = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - stingerCount);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(stingerCount - 1);
                }
            }
            this.detectEquipmentUpdates();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (!(!this.isSleeping() || this.canInteractWithLevel() && this.checkBedExists())) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            this.aiStep();
        }
        double d = this.getX() - this.xo;
        double d1 = this.getZ() - this.zo;
        float f = (float)(d * d + d1 * d1);
        float f1 = this.yBodyRot;
        if (f > 0.0025000002f) {
            float f2 = (float)Mth.atan2(d1, d) * 57.295776f - 90.0f;
            float abs = Mth.abs(Mth.wrapDegrees(this.getYRot()) - f2);
            f1 = 95.0f < abs && abs < 265.0f ? f2 - 180.0f : f2;
        }
        if (this.attackAnim > 0.0f) {
            f1 = this.getYRot();
        }
        ProfilerFiller profilerFiller = Profiler.get();
        profilerFiller.push("headTurn");
        this.tickHeadTurn(f1);
        profilerFiller.pop();
        profilerFiller.push("rangeChecks");
        this.yRotO += (float)Math.round((this.getYRot() - this.yRotO) / 360.0f) * 360.0f;
        this.yBodyRotO += (float)Math.round((this.yBodyRot - this.yBodyRotO) / 360.0f) * 360.0f;
        this.xRotO += (float)Math.round((this.getXRot() - this.xRotO) / 360.0f) * 360.0f;
        this.yHeadRotO += (float)Math.round((this.yHeadRot - this.yHeadRotO) / 360.0f) * 360.0f;
        profilerFiller.pop();
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        this.elytraAnimationState.tick();
    }

    public boolean wasRecentlyStabbed(Entity entity, int contactCooldownTicks) {
        return this.recentKineticEnemies != null && this.recentKineticEnemies.containsKey((Object)entity) && this.level().getGameTime() - this.recentKineticEnemies.getLong((Object)entity) < (long)contactCooldownTicks;
    }

    public void rememberStabbedEntity(Entity entity) {
        if (this.recentKineticEnemies != null) {
            this.recentKineticEnemies.put((Object)entity, this.level().getGameTime());
        }
    }

    public int stabbedEntities(Predicate<Entity> filter) {
        return this.recentKineticEnemies == null ? 0 : (int)this.recentKineticEnemies.keySet().stream().filter(filter).count();
    }

    public boolean stabAttack(EquipmentSlot slot, Entity target, float damageAmount, boolean damage, boolean knockback, boolean dismount) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack itemBySlot = this.getItemBySlot(slot);
        DamageSource damageSource = itemBySlot.getDamageSource(this, () -> this.damageSources().mobAttack(this));
        float f = EnchantmentHelper.modifyDamage(serverLevel, itemBySlot, target, damageSource, damageAmount);
        Vec3 deltaMovement = target.getDeltaMovement();
        boolean flag1 = damage && target.hurtServer(serverLevel, damageSource, f);
        boolean flag = knockback | flag1;
        if (knockback) {
            this.causeExtraKnockback(target, 0.4f + this.getKnockback(target, damageSource), deltaMovement);
        }
        if (dismount && target.isPassenger()) {
            flag = true;
            target.stopRiding();
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            itemBySlot.hurtEnemy(livingEntity, this);
        }
        if (flag1) {
            EnchantmentHelper.doPostAttackEffects(serverLevel, target, damageSource);
        }
        if (!flag) {
            return false;
        }
        this.setLastHurtMob(target);
        this.playAttackSound();
        return true;
    }

    public void onAttack() {
    }

    public void detectEquipmentUpdates() {
        Map<EquipmentSlot, ItemStack> map = this.collectEquipmentChanges();
        if (map != null) {
            this.handleHandSwap(map);
            if (!map.isEmpty()) {
                this.handleEquipmentChanges(map);
            }
        }
    }

    private @Nullable Map<EquipmentSlot, ItemStack> collectEquipmentChanges() {
        ItemStack itemBySlot;
        Map map = null;
        EnumMap equipmentChanges = null;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            ItemStack itemStack = this.lastEquipmentItems.get(equipmentSlot);
            if (!this.equipmentHasChanged(itemStack, itemBySlot = this.getItemBySlot(equipmentSlot))) continue;
            org.bukkit.inventory.ItemStack oldItem = CraftItemStack.asBukkitCopy(itemStack);
            org.bukkit.inventory.ItemStack newItem = CraftItemStack.asBukkitCopy(itemBySlot);
            if (this instanceof ServerPlayer && equipmentSlot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
                new PlayerArmorChangeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), PlayerArmorChangeEvent.SlotType.valueOf((String)equipmentSlot.name()), oldItem, newItem).callEvent();
            }
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlot.class);
                equipmentChanges = Maps.newEnumMap(org.bukkit.inventory.EquipmentSlot.class);
            }
            map.put(equipmentSlot, itemBySlot);
            record EquipmentChangeImpl(org.bukkit.inventory.ItemStack oldItem, org.bukkit.inventory.ItemStack newItem) implements EntityEquipmentChangedEvent.EquipmentChange
            {
                private final org.bukkit.inventory.ItemStack oldItem;
                private final org.bukkit.inventory.ItemStack newItem;

                public org.bukkit.inventory.ItemStack oldItem() {
                    return this.oldItem.clone();
                }

                public org.bukkit.inventory.ItemStack newItem() {
                    return this.newItem.clone();
                }
            }
            equipmentChanges.put(CraftEquipmentSlot.getSlot(equipmentSlot), new EquipmentChangeImpl(oldItem, newItem));
            AttributeMap attributes = this.getAttributes();
            if (itemStack.isEmpty()) continue;
            this.stopLocationBasedEffects(itemStack, equipmentSlot, attributes);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EquipmentSlot equipmentSlot1 = (EquipmentSlot)entry.getKey();
                itemBySlot = (ItemStack)entry.getValue();
                if (itemBySlot.isEmpty() || itemBySlot.isBroken()) continue;
                itemBySlot.forEachModifier(equipmentSlot1, (holder, attributeModifier) -> {
                    AttributeInstance instance = this.attributes.getInstance((Holder<Attribute>)holder);
                    if (instance != null) {
                        instance.removeModifier(attributeModifier.id());
                        instance.addTransientModifier((AttributeModifier)attributeModifier);
                    }
                });
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                EnchantmentHelper.runLocationChangedEffects(serverLevel, itemBySlot, this, equipmentSlot1);
            }
            new EntityEquipmentChangedEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity(), equipmentChanges).callEvent();
        }
        return map;
    }

    public boolean equipmentHasChanged(ItemStack oldItem, ItemStack newItem) {
        return !ItemStack.matches(newItem, oldItem);
    }

    private void handleHandSwap(Map<EquipmentSlot, ItemStack> hands) {
        ItemStack itemStack = hands.get(EquipmentSlot.MAINHAND);
        ItemStack itemStack1 = hands.get(EquipmentSlot.OFFHAND);
        if (itemStack != null && itemStack1 != null && ItemStack.matches(itemStack, this.lastEquipmentItems.get(EquipmentSlot.OFFHAND)) && ItemStack.matches(itemStack1, this.lastEquipmentItems.get(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayers(this, new ClientboundEntityEventPacket(this, 55));
            hands.remove(EquipmentSlot.MAINHAND);
            hands.remove(EquipmentSlot.OFFHAND);
            this.lastEquipmentItems.put(EquipmentSlot.MAINHAND, itemStack.copy());
            this.lastEquipmentItems.put(EquipmentSlot.OFFHAND, itemStack1.copy());
        }
    }

    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> equipment) {
        ArrayList list = Lists.newArrayListWithCapacity((int)equipment.size());
        equipment.forEach((equipmentSlot, itemStack) -> {
            ItemStack itemStack1 = itemStack.copy();
            list.add(Pair.of((Object)equipmentSlot, (Object)itemStack1));
            this.lastEquipmentItems.put((EquipmentSlot)equipmentSlot, itemStack1);
        });
        ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayers(this, new ClientboundSetEquipmentPacket(this.getId(), list, true));
    }

    protected void tickHeadTurn(float yBodyRot) {
        float f = Mth.wrapDegrees(yBodyRot - this.yBodyRot);
        this.yBodyRot += f * 0.3f;
        float f1 = Mth.wrapDegrees(this.getYRot() - this.yBodyRot);
        float maxHeadRotationRelativeToBody = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs(f1) > maxHeadRotationRelativeToBody) {
            this.yBodyRot += f1 - (float)Mth.sign(f1) * maxHeadRotationRelativeToBody;
        }
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isInterpolating()) {
            this.getInterpolation().interpolate();
        } else if (!this.canSimulateMovement()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        this.equipment.tick(this);
        deltaMovement = this.getDeltaMovement();
        d = deltaMovement.x;
        d1 = deltaMovement.y;
        d2 = deltaMovement.z;
        if (this.getType().equals(EntityType.PLAYER)) {
            if (deltaMovement.horizontalDistanceSqr() < 9.0E-6) {
                d = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(deltaMovement.x) < 0.003) {
                d = 0.0;
            }
            if (Math.abs(deltaMovement.z) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(deltaMovement.y) < 0.003) {
            d1 = 0.0;
        }
        this.setDeltaMovement(d, d1, d2);
        profilerFiller = Profiler.get();
        profilerFiller.push("ai");
        this.applyInput();
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi() && !this.level().isClientSide()) {
            profilerFiller.push("newAi");
            this.serverAiStep();
            profilerFiller.pop();
        }
        profilerFiller.pop();
        profilerFiller.push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            fluidHeight = this.isInLava() != false ? this.getFluidHeight(FluidTags.LAVA) : this.getFluidHeight(FluidTags.WATER);
            flag = this.isInWater() != false && fluidHeight > 0.0;
            fluidJumpThreshold = this.getFluidJumpThreshold();
            if (!flag || this.onGround() && !(fluidHeight > fluidJumpThreshold)) {
                if (!this.isInLava() || this.onGround() && !(fluidHeight > fluidJumpThreshold)) {
                    if ((this.onGround() || flag && fluidHeight <= fluidJumpThreshold) && this.noJumpDelay == 0) {
                        if (new EntityJumpEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                            this.jumpFromGround();
                            this.noJumpDelay = 10;
                        } else {
                            this.setJumping(false);
                        }
                    }
                } else {
                    this.jumpInLiquid(FluidTags.LAVA);
                }
            } else {
                this.jumpInLiquid(FluidTags.WATER);
            }
        } else {
            this.noJumpDelay = 0;
        }
        profilerFiller.pop();
        profilerFiller.push("travel");
        if (this.isFallFlying()) {
            this.updateFallFlying();
        }
        boundingBox = this.getBoundingBox();
        vec3 = new Vec3(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        if (!((fluidJumpThreshold = this.getControllingPassenger()) instanceof Player)) ** GOTO lbl-1000
        player = (Player)fluidJumpThreshold;
        if (this.isAlive()) {
            this.travelRidden(player, vec3);
        } else if (this.canSimulateMovement() && this.isEffectiveAi()) {
            this.travel(vec3);
        }
        if (!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) {
            this.applyEffectsFromBlocks();
        }
        if (this.level().isClientSide()) {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
        profilerFiller.pop();
        fluidJumpThreshold = this.level();
        if (fluidJumpThreshold instanceof ServerLevel) {
            serverLevel = (ServerLevel)fluidJumpThreshold;
            profilerFiller.push("freezing");
            if (!(this.isInPowderSnow && this.canFreeze() || this.freezeLocked)) {
                this.setTicksFrozen(Math.max(0, this.getTicksFrozen() - 2));
            }
            this.removeFrost();
            this.tryAddFrost();
            if (this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
                this.hurtServer(serverLevel, this.damageSources().freeze(), 1.0f);
            }
            profilerFiller.pop();
        }
        profilerFiller.push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(boundingBox, this.getBoundingBox());
        }
        this.pushEntities();
        profilerFiller.pop();
        if (((ServerLevel)this.level()).hasEntityMoveEvent && !(this instanceof Player) && (this.xo != this.getX() || this.yo != this.getY() || this.zo != this.getZ() || this.yRotO != this.getYRot() || this.xRotO != this.getXRot())) {
            from = new Location((World)this.level().getWorld(), this.xo, this.yo, this.zo, this.yRotO, this.xRotO);
            to = new Location((World)this.level().getWorld(), this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            event = new EntityMoveEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity(), from, to.clone());
            if (!event.callEvent()) {
                this.absSnapTo(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch());
            } else if (!to.equals((Object)event.getTo())) {
                this.absSnapTo(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ(), event.getTo().getYaw(), event.getTo().getPitch());
            }
        }
        if ((var12_14 = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)var12_14;
            if (this.isSensitiveToWater() && this.isInWaterOrRain()) {
                this.hurtServer(serverLevel, this.damageSources().drown(), 1.0f);
            }
        }
    }

    protected void applyInput() {
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean isJumping() {
        return this.jumping;
    }

    protected void updateFallFlying() {
        this.checkFallDistanceAccumulation();
        if (!this.level().isClientSide()) {
            if (!this.canGlide()) {
                if (this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.setSharedFlag(7, false);
                }
                return;
            }
            int i = this.fallFlyTicks + 1;
            if (i % 10 == 0) {
                int i1 = i / 10;
                if (i1 % 2 == 0) {
                    List<EquipmentSlot> list = EquipmentSlot.VALUES.stream().filter(equipmentSlot1 -> LivingEntity.canGlideUsing(this.getItemBySlot((EquipmentSlot)equipmentSlot1), equipmentSlot1)).toList();
                    EquipmentSlot equipmentSlot = Util.getRandom(list, this.random);
                    this.getItemBySlot(equipmentSlot).hurtAndBreak(1, this, equipmentSlot);
                }
                this.gameEvent(GameEvent.ELYTRA_GLIDE);
            }
        }
    }

    protected boolean canGlide() {
        if (!(this.onGround() || this.isPassenger() || this.hasEffect(MobEffects.LEVITATION))) {
            for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
                if (!LivingEntity.canGlideUsing(this.getItemBySlot(equipmentSlot), equipmentSlot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        if (!this.isPushable()) {
            return;
        }
        PlayerTeam team = this.getTeam();
        if (team != null && ((Team)team).getCollisionRule() == Team.CollisionRule.NEVER) {
            return;
        }
        int i = ((ServerLevel)this.level()).getGameRules().get(GameRules.MAX_ENTITY_CRAMMING);
        if (i <= 0 && this.level().paperConfig().collisions.maxEntityCollisions <= 0) {
            return;
        }
        List<Entity> pushableEntities = this.level().getPushableEntities(this, this.getBoundingBox());
        if (!pushableEntities.isEmpty()) {
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (i > 0 && pushableEntities.size() > i - 1 && this.random.nextInt(4) == 0) {
                    int i1 = 0;
                    for (Entity entity : pushableEntities) {
                        if (entity.isPassenger()) continue;
                        ++i1;
                    }
                    if (i1 > i - 1) {
                        this.hurtServer(serverLevel, this.damageSources().cramming(), 6.0f);
                    }
                }
            }
            this.numCollisions = Math.max(0, this.numCollisions - this.level().paperConfig().collisions.maxEntityCollisions);
            for (Entity entity1 : pushableEntities) {
                if (this.numCollisions >= this.level().paperConfig().collisions.maxEntityCollisions) break;
                ++entity1.numCollisions;
                ++this.numCollisions;
                this.doPush(entity1);
            }
        }
    }

    protected void checkAutoSpinAttack(AABB boundingBoxBeforeSpin, AABB boundingBoxAfterSpin) {
        AABB aabb = boundingBoxBeforeSpin.minmax(boundingBoxAfterSpin);
        List<Entity> entities = this.level().getEntities(this, aabb);
        int skippedAttackedEntitiesCounter = 0;
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                ServerPlayer serverPlayer;
                LivingEntity livingEntity = this;
                if (livingEntity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)livingEntity).getBukkitEntity().canSee(entity.getBukkitEntity())) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                if (!(entity instanceof LivingEntity)) continue;
                if (!new EntityAttemptSpinAttackEvent((org.bukkit.entity.LivingEntity)this.getBukkitLivingEntity(), (org.bukkit.entity.LivingEntity)((LivingEntity)entity).getBukkitLivingEntity()).callEvent()) {
                    ++skippedAttackedEntitiesCounter;
                    continue;
                }
                this.doAutoAttackOnTouch((LivingEntity)entity);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        }
        if (this.horizontalCollision && skippedAttackedEntitiesCounter == entities.size()) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide() && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity entity) {
        entity.push(this);
    }

    protected void doAutoAttackOnTouch(LivingEntity target) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding(boolean suppressCancellation) {
        Entity vehicle = this.getVehicle();
        super.stopRiding(suppressCancellation);
        if (vehicle != null && vehicle != this.getVehicle() && !this.level().isClientSide() && vehicle.valid) {
            this.dismountVehicle(vehicle);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.resetFallDistance();
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void lerpHeadTo(float yRot, int steps) {
        this.lerpYHeadRot = yRot;
        this.lerpHeadSteps = steps;
    }

    public void setJumping(boolean jumping) {
        this.jumping = jumping;
    }

    public void onItemPickup(ItemEntity itemEntity) {
        Entity owner = EntityReference.getEntity(itemEntity.thrower, this.level()::getGlobalPlayerByUUID, Entity.class);
        if (owner instanceof ServerPlayer) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((ServerPlayer)owner, itemEntity.getItem(), this);
        }
    }

    public void take(Entity entity, int amount) {
        if (!entity.isRemoved() && !this.level().isClientSide() && (entity instanceof ItemEntity || entity instanceof AbstractArrow || entity instanceof ExperienceOrb)) {
            ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayersAndSelf(entity, new ClientboundTakeItemEntityPacket(entity.getId(), this.getId(), amount));
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        return this.hasLineOfSight(entity, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity.getEyeY());
    }

    public boolean hasLineOfSight(Entity entity, ClipContext.Block block, ClipContext.Fluid fluid, double y) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), y, entity.getZ());
        return !(vec31.distanceToSqr(vec3) > 16384.0) && this.level().clip(new ClipContext(vec3, vec31, block, fluid, this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public float getViewYRot(float partialTick) {
        return partialTick == 1.0f ? this.yHeadRot : Mth.rotLerp(partialTick, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float partialTick) {
        float f = this.attackAnim - this.oAttackAnim;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.oAttackAnim + f * partialTick;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved() && this.collides;
    }

    @Override
    public boolean isPushable() {
        return this.isCollidable(this.level().paperConfig().collisions.fixClimbingBypassingCrammingRule);
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return this.isAlive() && !this.isSpectator() && (ignoreClimbing || !this.onClimbable()) && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable() && this.collides != this.collidableExemptions.contains(entity.getUUID());
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float rotation) {
        this.yHeadRot = rotation;
    }

    @Override
    public void setYBodyRot(float offset) {
        this.yBodyRot = offset;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle portal) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(axis, portal));
    }

    public static Vec3 resetForwardDirectionOfRelativePortalPosition(Vec3 relativePortalPosition) {
        return new Vec3(relativePortalPosition.x, relativePortalPosition.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float absorptionAmount) {
        this.internalSetAbsorptionAmount(!Float.isNaN(absorptionAmount) ? Mth.clamp(absorptionAmount, 0.0f, this.getMaxAbsorption()) : 0.0f);
    }

    protected void internalSetAbsorptionAmount(float absorptionAmount) {
        this.absorptionAmount = absorptionAmount;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract HumanoidArm getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public InteractionHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    public void resyncUsingItem(ServerPlayer serverPlayer) {
        this.resendPossiblyDesyncedDataValues(List.of(DATA_LIVING_ENTITY_FLAGS), serverPlayer);
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    private @Nullable ItemEntity createItemStackToDrop(ItemStack stack, boolean randomizeMotion, boolean includeThrower) {
        if (stack.isEmpty()) {
            return null;
        }
        double d = this.getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), d, this.getZ(), stack);
        itemEntity.setPickUpDelay(40);
        if (includeThrower) {
            itemEntity.setThrower(this);
        }
        if (randomizeMotion) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            itemEntity.setDeltaMovement(-Mth.sin(f1) * f, 0.2f, Mth.cos(f1) * f);
        } else {
            float f = 0.3f;
            float f1 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float cos = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float sin = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float cos1 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f3 = 0.02f * this.random.nextFloat();
            itemEntity.setDeltaMovement((double)(-sin * cos * 0.3f) + Math.cos(f2) * (double)f3, -f1 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(cos1 * cos * 0.3f) + Math.sin(f2) * (double)f3);
        }
        return itemEntity;
    }

    protected void updateUsingItem(ItemStack usingItem) {
        boolean shouldLagCompensate;
        usingItem.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        boolean bl = shouldLagCompensate = this.useItem.has(DataComponents.FOOD) && this.eatStartTime != -1L && System.nanoTime() - this.eatStartTime > (1L + (long)this.totalEatTimeTicks) * 50L * 1000000L;
        if (!(--this.useItemRemaining != 0 && !shouldLagCompensate || this.level().isClientSide() || usingItem.useOnRelease())) {
            this.useItemRemaining = 0;
            this.completeUsingItem();
        }
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    public void setLivingEntityFlag(int key, boolean value) {
        int i = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        i = value ? (i |= key) : (i &= ~key);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)i);
    }

    public void startUsingItem(InteractionHand hand) {
        this.startUsingItem(hand, false);
    }

    public void startUsingItem(InteractionHand hand, boolean forceUpdate) {
        ItemStack itemInHand = this.getItemInHand(hand);
        if (!itemInHand.isEmpty() && !this.isUsingItem() || forceUpdate) {
            this.useItem = itemInHand;
            this.useItemRemaining = this.totalEatTimeTicks = itemInHand.getUseDuration(this);
            this.eatStartTime = System.nanoTime();
            if (!this.level().isClientSide()) {
                this.setLivingEntityFlag(1, true);
                this.setLivingEntityFlag(2, hand == InteractionHand.OFF_HAND);
                this.useItem.causeUseVibration(this, GameEvent.ITEM_INTERACT_START);
                if (this.useItem.has(DataComponents.KINETIC_WEAPON)) {
                    this.recentKineticEnemies = new Object2LongOpenHashMap();
                }
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (SLEEPING_POS_ID.equals(key)) {
            if (this.level().isClientSide()) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(key) && this.level().isClientSide()) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.totalEatTimeTicks = 0;
                this.useItemRemaining = 0;
                this.eatStartTime = -1L;
            }
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        super.lookAt(anchor, target);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float partialTick) {
        return Mth.lerp(partialTick, this.yBodyRotO, this.yBodyRot);
    }

    public void spawnItemParticles(ItemStack stack, int amount) {
        for (int i = 0; i < amount; ++i) {
            Vec3 vec3 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, (double)this.random.nextFloat() * 0.1 + 0.1, 0.0);
            vec3 = vec3.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3 = vec3.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double d = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d, 0.6);
            vec31 = vec31.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec31 = vec31.yRot(-this.getYRot() * ((float)Math.PI / 180));
            vec31 = vec31.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, stack), vec31.x, vec31.y, vec31.z, vec3.x, vec3.y + 0.05, vec3.z);
        }
    }

    public void completeUsingItem() {
        if (!this.level().isClientSide() || this.isUsingItem()) {
            InteractionHand usedItemHand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(usedItemHand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                ItemStack itemStack;
                this.startUsingItem(this.getUsedItemHand(), true);
                PlayerItemConsumeEvent event = null;
                LivingEntity livingEntity = this;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.useItem);
                    org.bukkit.inventory.EquipmentSlot hand = CraftEquipmentSlot.getHand(usedItemHand);
                    event = new PlayerItemConsumeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), craftItem, hand);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.useItem.get(DataComponents.CONSUMABLE);
                        if (consumable != null) {
                            consumable.cancelUsingItem(serverPlayer, this.useItem);
                        }
                        serverPlayer.containerMenu.forceHeldSlot(usedItemHand);
                        serverPlayer.getBukkitEntity().updateScaledHealth();
                        this.stopUsingItem();
                        return;
                    }
                    itemStack = craftItem.equals((Object)event.getItem()) ? this.useItem.finishUsingItem(this.level(), this) : CraftItemStack.asNMSCopy(event.getItem()).finishUsingItem(this.level(), this);
                } else {
                    itemStack = this.useItem.finishUsingItem(this.level(), this);
                }
                ItemStack defaultReplacement = itemStack;
                if (event != null && event.getReplacement() != null) {
                    itemStack = CraftItemStack.asNMSCopy(event.getReplacement());
                }
                if (itemStack != this.useItem) {
                    LivingEntity livingEntity2;
                    this.setItemInHand(usedItemHand, itemStack);
                    if (event != null && event.getReplacement() != null && (livingEntity2 = this) instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)livingEntity2;
                        player.containerMenu.forceHeldSlot(usedItemHand);
                    }
                }
                this.stopUsingItem();
            }
        }
    }

    public void handleExtraItemsCreatedOnUse(ItemStack stack) {
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        return this.isUsingItem() ? this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks() : 0;
    }

    public float getTicksUsingItem(float partialTick) {
        return !this.isUsingItem() ? 0.0f : (float)this.getTicksUsingItem() + partialTick;
    }

    public void releaseUsingItem() {
        ItemStack itemInHand = this.getItemInHand(this.getUsedItemHand());
        if (!this.useItem.isEmpty() && ItemStack.isSameItem(itemInHand, this.useItem)) {
            this.useItem = itemInHand;
            if (this instanceof ServerPlayer) {
                new PlayerStopUsingItemEvent((org.bukkit.entity.Player)this.getBukkitEntity(), this.useItem.asBukkitMirror(), this.getTicksUsingItem()).callEvent();
            }
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide()) {
            boolean isUsingItem = this.isUsingItem();
            this.recentKineticEnemies = null;
            this.setLivingEntityFlag(1, false);
            if (isUsingItem) {
                this.useItem.causeUseVibration(this, GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.totalEatTimeTicks = 0;
        this.useItemRemaining = 0;
        this.eatStartTime = -1L;
    }

    public boolean isBlocking() {
        return this.getItemBlockingWith() != null;
    }

    public @Nullable ItemStack getItemBlockingWith() {
        int i;
        if (!this.isUsingItem()) {
            return null;
        }
        BlocksAttacks blocksAttacks = this.useItem.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksAttacks != null && (i = this.useItem.getItem().getUseDuration(this.useItem, this) - this.useItemRemaining) >= blocksAttacks.blockDelayTicks()) {
            return this.useItem;
        }
        return null;
    }

    @Override
    public float getBukkitYaw() {
        return this.getYHeadRot();
    }

    public HitResult getRayTrace(int maxDistance, ClipContext.Fluid fluidCollisionOption) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3 start = new Vec3(this.getX(), this.getY() + (double)this.getEyeHeight(), this.getZ());
        Vector dir = this.getBukkitEntity().getLocation().getDirection().multiply(maxDistance);
        Vec3 end = new Vec3(start.x + dir.getX(), start.y + dir.getY(), start.z + dir.getZ());
        ClipContext raytrace = new ClipContext(start, end, ClipContext.Block.OUTLINE, fluidCollisionOption, this);
        return this.level().clip(raytrace);
    }

    public @Nullable EntityHitResult getTargetEntity(int maxDistance) {
        if (maxDistance < 1 || maxDistance > 120) {
            throw new IllegalArgumentException("maxDistance must be between 1-120");
        }
        Vec3 start = this.getEyePosition(1.0f);
        Vec3 direction = this.getLookAngle();
        Vec3 end = start.add(direction.x * (double)maxDistance, direction.y * (double)maxDistance, direction.z * (double)maxDistance);
        List<Entity> entityList = this.level().getEntities(this, this.getBoundingBox().expandTowards(direction.x * (double)maxDistance, direction.y * (double)maxDistance, direction.z * (double)maxDistance).inflate(1.0, 1.0, 1.0), EntitySelector.NO_SPECTATORS.and(Entity::isPickable));
        double distance = 0.0;
        EntityHitResult result = null;
        for (Entity entity : entityList) {
            Vec3 rayTrace;
            double distanceTo;
            double inflationAmount = entity.getPickRadius();
            AABB aabb = entity.getBoundingBox().inflate(inflationAmount, inflationAmount, inflationAmount);
            Optional<Vec3> rayTraceResult = aabb.clip(start, end);
            if (!rayTraceResult.isPresent() || !((distanceTo = start.distanceToSqr(rayTrace = rayTraceResult.get())) < distance) && distance != 0.0) continue;
            result = new EntityHitResult(entity, rayTrace);
            distance = distanceTo;
        }
        return result;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(Pose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double x, double y, double z, boolean broadcastTeleport) {
        return this.randomTeleport(x, y, z, broadcastTeleport, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double x, double y, double z, boolean broadcastTeleport, PlayerTeleportEvent.TeleportCause cause) {
        LivingEntity livingEntity;
        double x1 = this.getX();
        double y1 = this.getY();
        double z1 = this.getZ();
        double d = y;
        boolean flag = false;
        BlockPos blockPos = BlockPos.containing(x, y, z);
        Level level = this.level();
        if (level.hasChunkAt(blockPos)) {
            boolean flag1 = false;
            while (!flag1 && blockPos.getY() > level.getMinY()) {
                BlockPos blockPos1 = blockPos.below();
                BlockState blockState = level.getBlockState(blockPos1);
                if (blockState.blocksMotion()) {
                    flag1 = true;
                    continue;
                }
                d -= 1.0;
                blockPos = blockPos1;
            }
            if (flag1) {
                this.setPos(x, d, z);
                if (level.noCollision(this) && !level.containsAnyLiquid(this.getBoundingBox())) {
                    flag = true;
                }
                this.setPos(x1, y1, z1);
                if (flag) {
                    if (!(this instanceof ServerPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.level().getWorld(), x1, y1, z1), new Location((World)this.level().getWorld(), x, d, z));
                        this.level().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled() || teleport.getTo() == null) return Optional.empty();
                        Location to = teleport.getTo();
                        this.teleportTo(to.getX(), to.getY(), to.getZ());
                    } else if (!((ServerPlayer)this).connection.teleport(x, d, z, this.getYRot(), this.getXRot(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag) {
            return Optional.of(false);
        }
        if (broadcastTeleport) {
            level.broadcastEntityEvent(this, (byte)46);
        }
        if (!((livingEntity = this) instanceof PathfinderMob)) return Optional.of(true);
        PathfinderMob pathfinderMob = (PathfinderMob)livingEntity;
        pathfinderMob.getNavigation().stop();
        return Optional.of(true);
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPos jukebox, boolean partyParrot) {
    }

    public boolean canPickUpLoot() {
        return false;
    }

    @Override
    public final EntityDimensions getDimensions(Pose pose) {
        return pose == Pose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(pose).scale(this.getScale());
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)Pose.STANDING);
    }

    public AABB getLocalBoundsForPose(Pose pose) {
        EntityDimensions dimensions = this.getDimensions(pose);
        return new AABB(-dimensions.width() / 2.0f, 0.0, -dimensions.width() / 2.0f, dimensions.width() / 2.0f, dimensions.height(), dimensions.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose pose) {
        AABB aabb = this.getDimensions(pose).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, aabb);
    }

    @Override
    public boolean canUsePortal(boolean allowPassengers) {
        return super.canUsePortal(allowPassengers) && !this.isSleeping();
    }

    public Optional<BlockPos> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPos pos) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(pos));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPos pos) {
        BlockState blockState;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((blockState = this.level().getBlockState(pos)).getBlock() instanceof BedBlock) {
            this.level().setBlock(pos, (BlockState)blockState.setValue(BedBlock.OCCUPIED, true), 3);
        }
        this.setPose(Pose.SLEEPING);
        this.setPosToBed(pos);
        this.setSleepingPos(pos);
        this.setDeltaMovement(Vec3.ZERO);
        this.needsSync = true;
    }

    private void setPosToBed(BlockPos pos) {
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.6875, (double)pos.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(blockPos -> this.level().getBlockState((BlockPos)blockPos).getBlock() instanceof BedBlock).orElse(false);
    }

    public void stopSleeping() {
        this.getSleepingPos().filter(this.level()::hasChunkAt).ifPresent(blockPos -> {
            BlockState blockState = this.level().getBlockState((BlockPos)blockPos);
            if (blockState.getBlock() instanceof BedBlock) {
                Direction direction = blockState.getValue(HorizontalDirectionalBlock.FACING);
                this.level().setBlock((BlockPos)blockPos, (BlockState)blockState.setValue(BedBlock.OCCUPIED, false), 3);
                Vec3 vec31 = BedBlock.findStandUpPosition(this.getType(), this.level(), blockPos, direction, this.getYRot()).orElseGet(() -> {
                    BlockPos blockPos1 = blockPos.above();
                    return new Vec3((double)blockPos1.getX() + 0.5, (double)blockPos1.getY() + 0.1, (double)blockPos1.getZ() + 0.5);
                });
                Vec3 vec32 = Vec3.atBottomCenterOf(blockPos).subtract(vec31).normalize();
                float f = (float)Mth.wrapDegrees(Mth.atan2(vec32.z, vec32.x) * 180.0 / 3.1415927410125732 - 90.0);
                this.setPos(vec31.x, vec31.y, vec31.z);
                this.setYRot(f);
                this.setXRot(0.0f);
            }
        });
        Vec3 vec3 = this.position();
        this.setPose(Pose.STANDING);
        this.setPos(vec3.x, vec3.y, vec3.z);
        this.clearSleepingPos();
    }

    public @Nullable Direction getBedOrientation() {
        BlockPos blockPos = this.getSleepingPos().orElse(null);
        return blockPos != null ? BedBlock.getBedOrientation(this.level(), blockPos) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack weaponStack) {
        return ItemStack.EMPTY;
    }

    public static byte entityEventForEquipmentBreak(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAINHAND -> 47;
            case EquipmentSlot.OFFHAND -> 48;
            case EquipmentSlot.HEAD -> 49;
            case EquipmentSlot.CHEST -> 50;
            case EquipmentSlot.FEET -> 52;
            case EquipmentSlot.LEGS -> 51;
            case EquipmentSlot.BODY -> 65;
            case EquipmentSlot.SADDLE -> 68;
        };
    }

    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EquipmentSlot slot) {
        this.level().broadcastEntityEvent(this, LivingEntity.entityEventForEquipmentBreak(slot));
        this.stopLocationBasedEffects(this.getItemBySlot(slot), slot, this.attributes);
    }

    private void stopLocationBasedEffects(ItemStack stack, EquipmentSlot slot, AttributeMap attributeMap) {
        stack.forEachModifier(slot, (holder, attributeModifier) -> {
            AttributeInstance instance = attributeMap.getInstance((Holder<Attribute>)holder);
            if (instance != null) {
                instance.removeModifier((AttributeModifier)attributeModifier);
            }
        });
        EnchantmentHelper.stopLocationBasedEffects(stack, this, slot);
    }

    public final boolean canEquipWithDispenser(ItemStack stack) {
        if (this.isAlive() && !this.isSpectator()) {
            Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.dispensable()) {
                EquipmentSlot equipmentSlot = equippable.slot();
                return this.canUseSlot(equipmentSlot) && equippable.canBeEquippedBy(this.getType()) && this.getItemBySlot(equipmentSlot).isEmpty() && this.canDispenserEquipIntoSlot(equipmentSlot);
            }
            return false;
        }
        return false;
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot slot) {
        return true;
    }

    public final EquipmentSlot getEquipmentSlotForItem(ItemStack stack) {
        Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
        return equippable != null && this.canUseSlot(equippable.slot()) ? equippable.slot() : EquipmentSlot.MAINHAND;
    }

    public final boolean isEquippableInSlot(ItemStack stack, EquipmentSlot slot) {
        Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
        return equippable == null ? slot == EquipmentSlot.MAINHAND && this.canUseSlot(EquipmentSlot.MAINHAND) : slot == equippable.slot() && this.canUseSlot(equippable.slot()) && equippable.canBeEquippedBy(this.getType());
    }

    private static SlotAccess createEquipmentSlotAccess(LivingEntity entity, EquipmentSlot slot) {
        return slot != EquipmentSlot.HEAD && slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND ? SlotAccess.forEquipmentSlot(entity, slot, itemStack -> itemStack.isEmpty() || entity.getEquipmentSlotForItem((ItemStack)itemStack) == slot) : SlotAccess.forEquipmentSlot(entity, slot);
    }

    private static @Nullable EquipmentSlot getEquipmentSlot(int index) {
        if (index == 100 + EquipmentSlot.HEAD.getIndex()) {
            return EquipmentSlot.HEAD;
        }
        if (index == 100 + EquipmentSlot.CHEST.getIndex()) {
            return EquipmentSlot.CHEST;
        }
        if (index == 100 + EquipmentSlot.LEGS.getIndex()) {
            return EquipmentSlot.LEGS;
        }
        if (index == 100 + EquipmentSlot.FEET.getIndex()) {
            return EquipmentSlot.FEET;
        }
        if (index == 98) {
            return EquipmentSlot.MAINHAND;
        }
        if (index == 99) {
            return EquipmentSlot.OFFHAND;
        }
        if (index == 105) {
            return EquipmentSlot.BODY;
        }
        return index == 106 ? EquipmentSlot.SADDLE : null;
    }

    @Override
    public @Nullable SlotAccess getSlot(int slot) {
        EquipmentSlot equipmentSlot = LivingEntity.getEquipmentSlot(slot);
        return equipmentSlot != null ? LivingEntity.createEquipmentSlotAccess(this, equipmentSlot) : super.getSlot(slot);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        for (EquipmentSlot equipmentSlot : EquipmentSlotGroup.ARMOR) {
            if (!this.getItemBySlot(equipmentSlot).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) continue;
            return false;
        }
        return super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        double x = packet.getX();
        double y = packet.getY();
        double z = packet.getZ();
        float yRot = packet.getYRot();
        float xRot = packet.getXRot();
        this.syncPacketPositionCodec(x, y, z);
        this.yBodyRot = packet.getYHeadRot();
        this.yHeadRot = packet.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(packet.getId());
        this.setUUID(packet.getUUID());
        this.absSnapTo(x, y, z, yRot, xRot);
        this.setDeltaMovement(packet.getMovement());
    }

    public float getSecondsToDisableBlocking() {
        ItemStack weaponItem = this.getWeaponItem();
        Weapon weapon = weaponItem.get(DataComponents.WEAPON);
        return weapon != null && weaponItem == this.getActiveItem() ? weapon.disableBlockingForSeconds() : 0.0f;
    }

    @Override
    public float maxUpStep() {
        float f = (float)this.getAttributeValue(Attributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof Player ? Math.max(f, 1.0f) : f;
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int steps, double yRot) {
        this.yHeadRot = (float)Mth.rotLerp(1.0 / (double)steps, (double)this.yHeadRot, yRot);
    }

    @Override
    public void igniteForTicks(int ticks) {
        super.igniteForTicks(Mth.ceil((double)ticks * this.getAttributeValue(Attributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    public boolean isInvulnerableTo(ServerLevel level, DamageSource damageSource) {
        return this.isInvulnerableToBase(damageSource) || EnchantmentHelper.isImmuneToDamage(level, this, damageSource);
    }

    public static boolean canGlideUsing(ItemStack stack, EquipmentSlot slot) {
        if (!stack.has(DataComponents.GLIDER)) {
            return false;
        }
        Equippable equippable = stack.get(DataComponents.EQUIPPABLE);
        return equippable != null && slot == equippable.slot() && !stack.nextDamageWillBreak();
    }

    @VisibleForTesting
    public int getLastHurtByPlayerMemoryTime() {
        return this.lastHurtByPlayerMemoryTime;
    }

    @Override
    public boolean isTransmittingWaypoint() {
        return this.getAttributeValue(Attributes.WAYPOINT_TRANSMIT_RANGE) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.Connection> makeWaypointConnectionWith(ServerPlayer player) {
        if (this.firstTick || player == this) {
            return Optional.empty();
        }
        if (WaypointTransmitter.doesSourceIgnoreReceiver(this, player)) {
            return Optional.empty();
        }
        Waypoint.Icon icon = this.locatorBarIcon.cloneAndAssignStyle(this);
        if (WaypointTransmitter.isReallyFar(this, player)) {
            return Optional.of(new WaypointTransmitter.EntityAzimuthConnection(this, icon, player));
        }
        return !WaypointTransmitter.isChunkVisible(this.chunkPosition(), player) ? Optional.of(new WaypointTransmitter.EntityChunkConnection(this, icon, player)) : Optional.of(new WaypointTransmitter.EntityBlockConnection(this, icon, player));
    }

    @Override
    public Waypoint.Icon waypointIcon() {
        return this.locatorBarIcon;
    }

    private static class ProcessableEffect {
        private Holder<MobEffect> type;
        private MobEffectInstance effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffectInstance effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffect> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record Fallsounds(SoundEvent small, SoundEvent big) {
    }
}

