/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;

public class SetLookAndInteract {
    public static BehaviorControl<LivingEntity> create(EntityType<?> entityType, int maxDist) {
        int i = maxDist * maxDist;
        return BehaviorBuilder.create(instance -> instance.group(instance.registered(MemoryModuleType.LOOK_TARGET), instance.absent(MemoryModuleType.INTERACTION_TARGET), instance.present(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)instance, (lookTarget, interactionTarget, nearestVisibleLivingEntities) -> (level, entity, gameTime) -> {
            Optional<LivingEntity> optional = ((NearestVisibleLivingEntities)instance.get(nearestVisibleLivingEntities)).findClosest(nearEntity -> nearEntity.distanceToSqr(entity) <= (double)i && entityType.equals(nearEntity.getType()));
            if (optional.isEmpty()) {
                return false;
            }
            LivingEntity livingEntity = optional.get();
            interactionTarget.set(livingEntity);
            lookTarget.set(new EntityTracker(livingEntity, true));
            return true;
        }));
    }
}

