/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.gamerules.GameRules;

public class StopBeingAngryIfTargetDead {
    public static BehaviorControl<LivingEntity> create() {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.ANGRY_AT)).apply((Applicative)instance, angryAt -> (level, entity, gameTime) -> {
            Optional.ofNullable(level.getEntity((UUID)instance.get(angryAt))).map(target -> {
                LivingEntity livingEntity;
                return target instanceof LivingEntity ? (livingEntity = (LivingEntity)target) : null;
            }).filter(LivingEntity::isDeadOrDying).filter(target -> target.getType() != EntityType.PLAYER || level.getGameRules().get(GameRules.FORGIVE_DEAD_PLAYERS) != false).ifPresent(target -> angryAt.erase());
            return true;
        }));
    }
}

