/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.npc.villager.VillagerProfession;
import net.minecraft.world.level.pathfinder.Path;

public class YieldJobSite {
    public static BehaviorControl<Villager> create(float speedModifier) {
        return BehaviorBuilder.create(instance -> instance.group(instance.present(MemoryModuleType.POTENTIAL_JOB_SITE), instance.absent(MemoryModuleType.JOB_SITE), instance.present(MemoryModuleType.NEAREST_LIVING_ENTITIES), instance.registered(MemoryModuleType.WALK_TARGET), instance.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)instance, (potentialJobSite, jobSite, nearestLivingEntities, walkTarget, lookTarget) -> (level, villager, gameTime) -> {
            if (villager.isBaby()) {
                return false;
            }
            if (!villager.getVillagerData().profession().is(VillagerProfession.NONE)) {
                return false;
            }
            BlockPos blockPos = ((GlobalPos)instance.get(potentialJobSite)).pos();
            Optional<Holder<PoiType>> type = level.getPoiManager().getType(blockPos);
            if (type.isEmpty()) {
                return true;
            }
            ((List)instance.get(nearestLivingEntities)).stream().filter(nearEntity -> nearEntity instanceof Villager && nearEntity != villager).map(nearEntity -> (Villager)nearEntity).filter(LivingEntity::isAlive).filter(nearVillager -> YieldJobSite.nearbyWantsJobsite((Holder)type.get(), nearVillager, blockPos)).findFirst().ifPresent(nearVillager -> {
                walkTarget.erase();
                lookTarget.erase();
                potentialJobSite.erase();
                if (nearVillager.getBrain().getMemory(MemoryModuleType.JOB_SITE).isEmpty()) {
                    BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)nearVillager, blockPos, speedModifier, 1);
                    nearVillager.getBrain().setMemory(MemoryModuleType.POTENTIAL_JOB_SITE, GlobalPos.of(level.dimension(), blockPos));
                    level.debugSynchronizers().updatePoi(blockPos);
                }
            });
            return true;
        }));
    }

    private static boolean nearbyWantsJobsite(Holder<PoiType> poi, Villager villager, BlockPos pos) {
        boolean isPresent = villager.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).isPresent();
        if (isPresent) {
            return false;
        }
        Optional<GlobalPos> memory = villager.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        Holder<VillagerProfession> holder = villager.getVillagerData().profession();
        if (holder.value().heldJobSite().test(poi)) {
            return memory.isEmpty() ? YieldJobSite.canReachPos(villager, pos, poi.value()) : memory.get().pos().equals(pos);
        }
        return false;
    }

    private static boolean canReachPos(PathfinderMob mob, BlockPos pos, PoiType poiType) {
        Path path = mob.getNavigation().createPath(pos, poiType.validRange());
        return path != null && path.canReach();
    }
}

