/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.declarative;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.Const;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.kinds.OptionalBox;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Unit;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryCondition;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.jspecify.annotations.Nullable;

public class BehaviorBuilder<E extends LivingEntity, M>
implements App<Mu<E>, M> {
    private final TriggerWithResult<E, M> trigger;

    public static <E extends LivingEntity, M> BehaviorBuilder<E, M> unbox(App<Mu<E>, M> app) {
        return (BehaviorBuilder)app;
    }

    public static <E extends LivingEntity> Instance<E> instance() {
        return new Instance();
    }

    public static <E extends LivingEntity> OneShot<E> create(Function<Instance<E>, ? extends App<Mu<E>, Trigger<E>>> initializer) {
        final TriggerWithResult<E, Trigger<E>> triggerWithResult = BehaviorBuilder.get(initializer.apply(BehaviorBuilder.instance()));
        return new OneShot<E>(){

            @Override
            public boolean trigger(ServerLevel level, E entity, long gameTime) {
                Trigger trigger = (Trigger)triggerWithResult.tryTrigger(level, entity, gameTime);
                return trigger != null && trigger.trigger(level, entity, gameTime);
            }

            @Override
            public String debugString() {
                return "OneShot[" + triggerWithResult.debugString() + "]";
            }

            public String toString() {
                return this.debugString();
            }
        };
    }

    public static <E extends LivingEntity> OneShot<E> sequence(Trigger<? super E> predicateTrigger, Trigger<? super E> trigger) {
        return BehaviorBuilder.create((Instance<E> instance) -> instance.group(instance.ifTriggered(predicateTrigger)).apply((Applicative)instance, unit -> trigger::trigger));
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(Predicate<E> predicate, OneShot<? super E> trigger) {
        return BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(predicate), trigger);
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(Predicate<E> predicate) {
        return BehaviorBuilder.create((Instance<E> instance) -> instance.point((level, entity, gameTime) -> predicate.test(entity)));
    }

    public static <E extends LivingEntity> OneShot<E> triggerIf(BiPredicate<ServerLevel, E> predicate) {
        return BehaviorBuilder.create((Instance<E> instance) -> instance.point((level, entity, gameTime) -> predicate.test(level, entity)));
    }

    static <E extends LivingEntity, M> TriggerWithResult<E, M> get(App<Mu<E>, M> app) {
        return BehaviorBuilder.unbox(app).trigger;
    }

    BehaviorBuilder(TriggerWithResult<E, M> trigger) {
        this.trigger = trigger;
    }

    static <E extends LivingEntity, M> BehaviorBuilder<E, M> create(TriggerWithResult<E, M> trigger) {
        return new BehaviorBuilder<E, M>(trigger);
    }

    public static final class Instance<E extends LivingEntity>
    implements Applicative<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Mu<E>> {
        public <Value> Optional<Value> tryGet(MemoryAccessor<OptionalBox.Mu, Value> memory) {
            return OptionalBox.unbox(memory.value());
        }

        public <Value> Value get(MemoryAccessor<IdF.Mu, Value> memory) {
            return (Value)IdF.get(memory.value());
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<OptionalBox.Mu, Value>> registered(MemoryModuleType<Value> memoryType) {
            return new PureMemory(new MemoryCondition.Registered<Value>(memoryType));
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<IdF.Mu, Value>> present(MemoryModuleType<Value> memoryType) {
            return new PureMemory(new MemoryCondition.Present<Value>(memoryType));
        }

        public <Value> BehaviorBuilder<E, MemoryAccessor<Const.Mu<Unit>, Value>> absent(MemoryModuleType<Value> memoryType) {
            return new PureMemory(new MemoryCondition.Absent<Value>(memoryType));
        }

        public BehaviorBuilder<E, Unit> ifTriggered(Trigger<? super E> trigger) {
            return new TriggerWrapper<E>(trigger);
        }

        public <A> BehaviorBuilder<E, A> point(A value) {
            return new Constant(value);
        }

        public <A> BehaviorBuilder<E, A> point(Supplier<String> name, A value) {
            return new Constant(value, name);
        }

        public <A, R> Function<App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, A>, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, R>> lift1(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function<A, R>> behavior) {
            return app -> {
                final TriggerWithResult triggerWithResult = BehaviorBuilder.get(app);
                final TriggerWithResult triggerWithResult1 = BehaviorBuilder.get(behavior);
                return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                    @Override
                    public R tryTrigger(ServerLevel level, E entity, long gameTime) {
                        Object object = triggerWithResult.tryTrigger(level, entity, gameTime);
                        if (object == null) {
                            return null;
                        }
                        Function function = (Function)triggerWithResult1.tryTrigger(level, entity, gameTime);
                        return function == null ? null : (Object)function.apply(object);
                    }

                    @Override
                    public String debugString() {
                        return triggerWithResult1.debugString() + " * " + triggerWithResult.debugString();
                    }

                    public String toString() {
                        return this.debugString();
                    }
                });
            };
        }

        public <T, R> BehaviorBuilder<E, R> map(final Function<? super T, ? extends R> mapper, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T> behavior) {
            final TriggerWithResult<E, T> triggerWithResult = BehaviorBuilder.get(behavior);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel level, E entity, long gameTime) {
                    Object object = triggerWithResult.tryTrigger(level, entity, gameTime);
                    return object == null ? null : (Object)mapper.apply(object);
                }

                @Override
                public String debugString() {
                    return triggerWithResult.debugString() + ".map[" + String.valueOf(mapper) + "]";
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <A, B, R> BehaviorBuilder<E, R> ap2(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, BiFunction<A, B, R>> mapper, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, A> behavior1, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, B> behavior2) {
            final TriggerWithResult<E, A> triggerWithResult = BehaviorBuilder.get(behavior1);
            final TriggerWithResult<E, B> triggerWithResult1 = BehaviorBuilder.get(behavior2);
            final TriggerWithResult<E, BiFunction<A, B, R>> triggerWithResult2 = BehaviorBuilder.get(mapper);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel level, E entity, long gameTime) {
                    Object object = triggerWithResult.tryTrigger(level, entity, gameTime);
                    if (object == null) {
                        return null;
                    }
                    Object object1 = triggerWithResult1.tryTrigger(level, entity, gameTime);
                    if (object1 == null) {
                        return null;
                    }
                    BiFunction biFunction = (BiFunction)triggerWithResult2.tryTrigger(level, entity, gameTime);
                    return biFunction == null ? null : (Object)biFunction.apply(object, object1);
                }

                @Override
                public String debugString() {
                    return triggerWithResult2.debugString() + " * " + triggerWithResult.debugString() + " * " + triggerWithResult1.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <T1, T2, T3, R> BehaviorBuilder<E, R> ap3(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function3<T1, T2, T3, R>> mapper, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T1> behavior1, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T2> behavior2, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T3> behavior3) {
            final TriggerWithResult<E, T1> triggerWithResult = BehaviorBuilder.get(behavior1);
            final TriggerWithResult<E, T2> triggerWithResult1 = BehaviorBuilder.get(behavior2);
            final TriggerWithResult<E, T3> triggerWithResult2 = BehaviorBuilder.get(behavior3);
            final TriggerWithResult<E, Function3<T1, T2, T3, R>> triggerWithResult3 = BehaviorBuilder.get(mapper);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel level, E entity, long gameTime) {
                    Object object = triggerWithResult.tryTrigger(level, entity, gameTime);
                    if (object == null) {
                        return null;
                    }
                    Object object1 = triggerWithResult1.tryTrigger(level, entity, gameTime);
                    if (object1 == null) {
                        return null;
                    }
                    Object object2 = triggerWithResult2.tryTrigger(level, entity, gameTime);
                    if (object2 == null) {
                        return null;
                    }
                    Function3 function3 = (Function3)triggerWithResult3.tryTrigger(level, entity, gameTime);
                    return function3 == null ? null : function3.apply(object, object1, object2);
                }

                @Override
                public String debugString() {
                    return triggerWithResult3.debugString() + " * " + triggerWithResult.debugString() + " * " + triggerWithResult1.debugString() + " * " + triggerWithResult2.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        public <T1, T2, T3, T4, R> BehaviorBuilder<E, R> ap4(App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, Function4<T1, T2, T3, T4, R>> mapper, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T1> behavior1, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T2> behavior2, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T3> behavior3, App<net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder$Mu<E>, T4> behavior4) {
            final TriggerWithResult<E, T1> triggerWithResult = BehaviorBuilder.get(behavior1);
            final TriggerWithResult<E, T2> triggerWithResult1 = BehaviorBuilder.get(behavior2);
            final TriggerWithResult<E, T3> triggerWithResult2 = BehaviorBuilder.get(behavior3);
            final TriggerWithResult<E, T4> triggerWithResult3 = BehaviorBuilder.get(behavior4);
            final TriggerWithResult<E, Function4<T1, T2, T3, T4, R>> triggerWithResult4 = BehaviorBuilder.get(mapper);
            return BehaviorBuilder.create(new TriggerWithResult<E, R>(){

                @Override
                public R tryTrigger(ServerLevel level, E entity, long gameTime) {
                    Object object = triggerWithResult.tryTrigger(level, entity, gameTime);
                    if (object == null) {
                        return null;
                    }
                    Object object1 = triggerWithResult1.tryTrigger(level, entity, gameTime);
                    if (object1 == null) {
                        return null;
                    }
                    Object object2 = triggerWithResult2.tryTrigger(level, entity, gameTime);
                    if (object2 == null) {
                        return null;
                    }
                    Object object3 = triggerWithResult3.tryTrigger(level, entity, gameTime);
                    if (object3 == null) {
                        return null;
                    }
                    Function4 function4 = (Function4)triggerWithResult4.tryTrigger(level, entity, gameTime);
                    return function4 == null ? null : function4.apply(object, object1, object2, object3);
                }

                @Override
                public String debugString() {
                    return triggerWithResult4.debugString() + " * " + triggerWithResult.debugString() + " * " + triggerWithResult1.debugString() + " * " + triggerWithResult2.debugString() + " * " + triggerWithResult3.debugString();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }

        static final class Mu<E extends LivingEntity>
        implements Applicative.Mu {
            private Mu() {
            }
        }
    }

    static interface TriggerWithResult<E extends LivingEntity, R> {
        public @Nullable R tryTrigger(ServerLevel var1, E var2, long var3);

        public String debugString();
    }

    static final class TriggerWrapper<E extends LivingEntity>
    extends BehaviorBuilder<E, Unit> {
        TriggerWrapper(final Trigger<? super E> trigger) {
            super(new TriggerWithResult<E, Unit>(){

                @Override
                public @Nullable Unit tryTrigger(ServerLevel level, E entity, long gameTime) {
                    return trigger.trigger(level, entity, gameTime) ? Unit.INSTANCE : null;
                }

                @Override
                public String debugString() {
                    return "T[" + String.valueOf(trigger) + "]";
                }
            });
        }
    }

    static final class PureMemory<E extends LivingEntity, F extends K1, Value>
    extends BehaviorBuilder<E, MemoryAccessor<F, Value>> {
        PureMemory(final MemoryCondition<F, Value> trigger) {
            super(new TriggerWithResult<E, MemoryAccessor<F, Value>>(){

                @Override
                public @Nullable MemoryAccessor<F, Value> tryTrigger(ServerLevel level, E entity, long gameTime) {
                    Brain<?> brain = ((LivingEntity)entity).getBrain();
                    Optional memoryInternal = brain.getMemoryInternal(trigger.memory());
                    return memoryInternal == null ? null : trigger.createAccessor(brain, memoryInternal);
                }

                @Override
                public String debugString() {
                    return "M[" + String.valueOf(trigger) + "]";
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }
    }

    public static final class Mu<E extends LivingEntity>
    implements K1 {
    }

    static final class Constant<E extends LivingEntity, A>
    extends BehaviorBuilder<E, A> {
        Constant(A value) {
            this(value, () -> "C[" + String.valueOf(value) + "]");
        }

        Constant(final A value, final Supplier<String> name) {
            super(new TriggerWithResult<E, A>(){

                @Override
                public A tryTrigger(ServerLevel level, E entity, long gameTime) {
                    return value;
                }

                @Override
                public String debugString() {
                    return (String)name.get();
                }

                public String toString() {
                    return this.debugString();
                }
            });
        }
    }
}

