/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.equine.Llama;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.phys.Vec3;

public class LlamaFollowCaravanGoal
extends Goal {
    public final Llama llama;
    private double speedModifier;
    private static final int CARAVAN_LIMIT = 8;
    private int distCheckCounter;

    public LlamaFollowCaravanGoal(Llama llama, double speedModifier) {
        this.llama = llama;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean canUse() {
        if (!this.llama.isLeashed() && !this.llama.inCaravan()) {
            double d1;
            Llama llama1;
            List<Entity> entities = this.llama.level().getEntities(this.llama, this.llama.getBoundingBox().inflate(9.0, 4.0, 9.0), entity1 -> {
                EntityType<?> type = entity1.getType();
                return type == EntityType.LLAMA || type == EntityType.TRADER_LLAMA;
            });
            Leashable llama = null;
            double d = Double.MAX_VALUE;
            for (Entity entity : entities) {
                llama1 = (Llama)entity;
                if (!llama1.inCaravan() || llama1.hasCaravanTail() || (d1 = this.llama.distanceToSqr(llama1)) > d) continue;
                d = d1;
                llama = llama1;
            }
            if (llama == null) {
                for (Entity entityx : entities) {
                    llama1 = (Llama)entityx;
                    if (!llama1.isLeashed() || llama1.hasCaravanTail() || (d1 = this.llama.distanceToSqr(llama1)) > d) continue;
                    d = d1;
                    llama = llama1;
                }
            }
            if (llama == null) {
                return false;
            }
            if (d < 4.0) {
                return false;
            }
            if (!llama.isLeashed() && !this.firstIsLeashed((Llama)llama, 1)) {
                return false;
            }
            this.llama.joinCaravan((Llama)llama);
            return true;
        }
        return false;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.llama.inCaravan() && this.llama.getCaravanHead().isAlive() && this.firstIsLeashed(this.llama, 0)) {
            double d = this.llama.distanceToSqr(this.llama.getCaravanHead());
            if (d > 676.0) {
                if (this.speedModifier <= 3.0) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = LlamaFollowCaravanGoal.reducedTickDelay(40);
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.llama.leaveCaravan();
        this.speedModifier = 2.1;
    }

    @Override
    public void tick() {
        if (this.llama.inCaravan() && !(this.llama.getLeashHolder() instanceof LeashFenceKnotEntity)) {
            Llama caravanHead = this.llama.getCaravanHead();
            double d = this.llama.distanceTo(caravanHead);
            float f = 2.0f;
            Vec3 vec3 = new Vec3(caravanHead.getX() - this.llama.getX(), caravanHead.getY() - this.llama.getY(), caravanHead.getZ() - this.llama.getZ()).normalize().scale(Math.max(d - 2.0, 0.0));
            this.llama.getNavigation().moveTo(this.llama.getX() + vec3.x, this.llama.getY() + vec3.y, this.llama.getZ() + vec3.z, this.speedModifier);
        }
    }

    private boolean firstIsLeashed(Llama llama, int leashedQueuePosition) {
        return leashedQueuePosition <= 8 && llama.inCaravan() && (llama.getCaravanHead().isLeashed() || this.firstIsLeashed(llama.getCaravanHead(), ++leashedQueuePosition));
    }
}

