/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class WaterAvoidingRandomStrollGoal
extends RandomStrollGoal {
    public static final float PROBABILITY = 0.001f;
    protected final float probability;

    public WaterAvoidingRandomStrollGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, 0.001f);
    }

    public WaterAvoidingRandomStrollGoal(PathfinderMob mob, double speedModifier, float probability) {
        super(mob, speedModifier);
        this.probability = probability;
    }

    @Override
    protected @Nullable Vec3 getPosition() {
        if (this.mob.isInWater()) {
            Vec3 pos = LandRandomPos.getPos(this.mob, 15, 7);
            return pos == null ? super.getPosition() : pos;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos(this.mob, 10, 7) : super.getPosition();
    }
}

