/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import ca.spottedleaf.moonrise.common.misc.Delayed26WayDistancePropagator3D;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.ChunkSystemPoiManager;
import ca.spottedleaf.moonrise.patches.chunk_system.level.poi.PoiChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkHolderManager;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import io.papermc.paper.util.PoiAccess;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.SectionTracker;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.debug.DebugPoiInfo;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.jspecify.annotations.Nullable;

public class PoiManager
extends SectionStorage<PoiSection, PoiSection.Packed>
implements ChunkSystemPoiManager {
    public static final int MAX_VILLAGE_DISTANCE = 6;
    public static final int VILLAGE_SECTION_SIZE = 1;
    private final DistanceTracker distanceTracker;
    private final LongSet loadedChunks = new LongOpenHashSet();
    private final ServerLevel world;
    private final Delayed26WayDistancePropagator3D villageDistanceTracker = new Delayed26WayDistancePropagator3D();
    private static final int POI_DATA_SOURCE = 7;

    private static int convertBetweenLevels(int level) {
        return 7 - level;
    }

    private void updateDistanceTracking(long section) {
        if (this.isVillageCenter(section)) {
            this.villageDistanceTracker.setSource(section, 7);
        } else {
            this.villageDistanceTracker.removeSource(section);
        }
    }

    @Override
    public Optional<PoiSection> get(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        PoiChunk ret = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        return ret == null ? Optional.empty() : ret.getSectionForVanilla(chunkY);
    }

    @Override
    public Optional<PoiSection> getOrLoad(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        if (chunkY >= WorldUtil.getMinSection(this.world) && chunkY <= WorldUtil.getMaxSection(this.world)) {
            PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
            if (ret != null) {
                return ret.getSectionForVanilla(chunkY);
            }
            return manager.loadPoiChunk(chunkX, chunkZ).getSectionForVanilla(chunkY);
        }
        return Optional.empty();
    }

    @Override
    protected PoiSection getOrCreate(long pos) {
        int chunkX = CoordinateUtils.getChunkSectionX(pos);
        int chunkY = CoordinateUtils.getChunkSectionY(pos);
        int chunkZ = CoordinateUtils.getChunkSectionZ(pos);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Accessing poi chunk off-main");
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        PoiChunk ret = manager.getPoiChunkIfLoaded(chunkX, chunkZ, true);
        if (ret != null) {
            return ret.getOrCreateSection(chunkY);
        }
        return manager.loadPoiChunk(chunkX, chunkZ).getOrCreateSection(chunkY);
    }

    @Override
    public final ServerLevel moonrise$getWorld() {
        return this.world;
    }

    @Override
    public final void moonrise$onUnload(long coordinate) {
        int chunkX = CoordinateUtils.getChunkX(coordinate);
        int chunkZ = CoordinateUtils.getChunkZ(coordinate);
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Unloading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            long sectionPos = SectionPos.asLong(chunkX, sectionY, chunkZ);
            this.updateDistanceTracking(sectionPos);
        }
    }

    @Override
    public final void moonrise$loadInPoiChunk(PoiChunk poiChunk) {
        int chunkX = poiChunk.chunkX;
        int chunkZ = poiChunk.chunkZ;
        int minY = WorldUtil.getMinSection(this.world);
        int maxY = WorldUtil.getMaxSection(this.world);
        TickThread.ensureTickThread((Level)this.world, chunkX, chunkZ, "Loading poi chunk off-main");
        for (int sectionY = minY; sectionY <= maxY; ++sectionY) {
            PoiSection section = poiChunk.getSection(sectionY);
            if (section == null || section.moonrise$isEmpty()) continue;
            this.onSectionLoad(SectionPos.asLong(chunkX, sectionY, chunkZ));
        }
    }

    @Override
    public final void moonrise$checkConsistency(ChunkAccess chunk) {
        int chunkX = chunk.getPos().x;
        int chunkZ = chunk.getPos().z;
        int minY = WorldUtil.getMinSection(chunk);
        int maxY = WorldUtil.getMaxSection(chunk);
        LevelChunkSection[] sections = chunk.getSections();
        for (int section = minY; section <= maxY; ++section) {
            this.checkConsistencyWithBlocks(SectionPos.of(chunkX, section, chunkZ), sections[section - minY]);
        }
    }

    public PoiManager(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, RegistryAccess registryAccess, ChunkIOErrorReporter errorReporter, LevelHeightAccessor levelHeightAccessor) {
        super(new SimpleRegionStorage(info, folder, fixerUpper, sync, DataFixTypes.POI_CHUNK), PoiSection.Packed.CODEC, PoiSection::pack, PoiSection.Packed::unpack, PoiSection::new, registryAccess, errorReporter, levelHeightAccessor);
        this.distanceTracker = new DistanceTracker();
        this.world = (ServerLevel)levelHeightAccessor;
    }

    public @Nullable PoiRecord add(BlockPos pos, Holder<PoiType> type) {
        return this.getOrCreate(SectionPos.asLong(pos)).add(pos, type);
    }

    public void remove(BlockPos pos) {
        this.getOrLoad(SectionPos.asLong(pos)).ifPresent(section -> section.remove(pos));
    }

    public long getCountInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int distance, Occupancy status) {
        return this.getInRange(typePredicate, pos, distance, status).count();
    }

    public boolean existsAtPosition(ResourceKey<PoiType> poiType, BlockPos pos) {
        return this.exists(pos, holder -> holder.is(poiType));
    }

    public Stream<PoiRecord> getInSquare(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int distance, Occupancy status) {
        int i = Math.floorDiv(distance, 16) + 1;
        return ChunkPos.rangeClosed(new ChunkPos(pos), i).flatMap(chunkPos -> this.getInChunk(typePredicate, (ChunkPos)chunkPos, status)).filter(poiRecord -> {
            BlockPos pos1 = poiRecord.getPos();
            return Math.abs(pos1.getX() - pos.getX()) <= distance && Math.abs(pos1.getZ() - pos.getZ()) <= distance;
        });
    }

    public Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int distance, Occupancy status) {
        int i = distance * distance;
        return this.getInSquare(typePredicate, pos, distance, status).filter(poiRecord -> poiRecord.getPos().distSqr(pos) <= (double)i);
    }

    @VisibleForDebug
    public Stream<PoiRecord> getInChunk(Predicate<Holder<PoiType>> typePredicate, ChunkPos posChunk, Occupancy status) {
        return IntStream.rangeClosed(this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).boxed().map(integer -> this.getOrLoad(SectionPos.of(posChunk, integer).asLong())).filter(Optional::isPresent).flatMap(optional -> ((PoiSection)optional.get()).getRecords(typePredicate, status));
    }

    public Stream<BlockPos> findAll(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, Occupancy status) {
        return this.getInRange(typePredicate, pos, distance, status).map(PoiRecord::getPos).filter(posPredicate);
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllWithType(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, Occupancy status) {
        return this.getInRange(typePredicate, pos, distance, status).filter(poiRecord -> posPredicate.test(poiRecord.getPos())).map(poiRecord -> Pair.of(poiRecord.getPoiType(), (Object)poiRecord.getPos()));
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllClosestFirstWithType(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, Occupancy status) {
        return this.findAllWithType(typePredicate, posPredicate, pos, distance, status).sorted(Comparator.comparingDouble(pair -> ((BlockPos)pair.getSecond()).distSqr(pos)));
    }

    public Optional<BlockPos> find(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, Occupancy status) {
        BlockPos ret = PoiAccess.findAnyPoiPosition(this, typePredicate, posPredicate, pos, distance, status, false);
        return Optional.ofNullable(ret);
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int distance, Occupancy status) {
        BlockPos closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, null, pos, distance, distance * distance, status, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<Pair<Holder<PoiType>, BlockPos>> findClosestWithType(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int distance, Occupancy status) {
        return Optional.ofNullable(PoiAccess.findClosestPoiDataTypeAndPosition(this, typePredicate, null, pos, distance, distance * distance, status, false));
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, Occupancy status) {
        BlockPos closestPos = PoiAccess.findClosestPoiDataPosition(this, typePredicate, posPredicate, pos, distance, distance * distance, status, false);
        return Optional.ofNullable(closestPos);
    }

    public Optional<BlockPos> take(Predicate<Holder<PoiType>> typePredicate, BiPredicate<Holder<PoiType>, BlockPos> combinedTypePosPredicate, BlockPos pos, int distance) {
        PoiRecord closest = PoiAccess.findClosestPoiDataRecord(this, typePredicate, combinedTypePosPredicate, pos, distance, (double)(distance * distance), Occupancy.HAS_SPACE, false);
        return Optional.ofNullable(closest).map(poiRecord -> {
            poiRecord.acquireTicket();
            return poiRecord.getPos();
        });
    }

    public Optional<BlockPos> getRandom(Predicate<Holder<PoiType>> typePredicate, Predicate<BlockPos> posPredicate, Occupancy status, BlockPos pos, int distance, RandomSource random) {
        ArrayList<PoiRecord> list = new ArrayList<PoiRecord>();
        PoiAccess.findAnyPoiRecords(this, typePredicate, posPredicate, pos, distance, status, false, Integer.MAX_VALUE, list);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((PoiRecord)list.get(random.nextInt(list.size()))).getPos());
    }

    public boolean release(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).map(poiSection -> poiSection.release(pos)).orElseThrow(() -> Util.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(pos))));
    }

    public boolean exists(BlockPos pos, Predicate<Holder<PoiType>> typePredicate) {
        return this.getOrLoad(SectionPos.asLong(pos)).map(poiSection -> poiSection.exists(pos, typePredicate)).orElse(false);
    }

    public Optional<Holder<PoiType>> getType(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).flatMap(poiSection -> poiSection.getType(pos));
    }

    @VisibleForDebug
    public @Nullable DebugPoiInfo getDebugPoiInfo(BlockPos pos) {
        return this.getOrLoad(SectionPos.asLong(pos)).flatMap(poiSection -> poiSection.getDebugPoiInfo(pos)).orElse(null);
    }

    public int sectionsToVillage(SectionPos sectionPos) {
        this.villageDistanceTracker.propagateUpdates();
        return PoiManager.convertBetweenLevels(this.villageDistanceTracker.getLevel(CoordinateUtils.getChunkSectionKey(sectionPos)));
    }

    boolean isVillageCenter(long chunkPos) {
        Optional<PoiSection> optional = this.get(chunkPos);
        return optional != null && optional.map(poiSection -> poiSection.getRecords(holder -> holder.is(PoiTypeTags.VILLAGE), Occupancy.IS_OCCUPIED).findAny().isPresent()).orElse(false) != false;
    }

    @Override
    public void tick(BooleanSupplier aheadOfTime) {
        this.villageDistanceTracker.propagateUpdates();
    }

    @Override
    public void setDirty(long sectionPos) {
        int chunkZ;
        ChunkHolderManager manager = this.world.moonrise$getChunkTaskScheduler().chunkHolderManager;
        int chunkX = CoordinateUtils.getChunkSectionX(sectionPos);
        PoiChunk chunk = manager.getPoiChunkIfLoaded(chunkX, chunkZ = CoordinateUtils.getChunkSectionZ(sectionPos), false);
        if (chunk != null) {
            chunk.setDirty(true);
        }
        this.updateDistanceTracking(sectionPos);
    }

    @Override
    protected void onSectionLoad(long sectionKey) {
        this.updateDistanceTracking(sectionKey);
    }

    public void checkConsistencyWithBlocks(SectionPos sectionPos, LevelChunkSection levelChunkSection) {
        Util.ifElse(this.getOrLoad(sectionPos.asLong()), poiSection -> poiSection.refresh(biConsumer -> {
            if (PoiManager.mayHavePoi(levelChunkSection)) {
                this.updateFromSection(levelChunkSection, sectionPos, (BiConsumer<BlockPos, Holder<PoiType>>)biConsumer);
            }
        }), () -> {
            if (PoiManager.mayHavePoi(levelChunkSection)) {
                PoiSection poiSection = this.getOrCreate(sectionPos.asLong());
                this.updateFromSection(levelChunkSection, sectionPos, poiSection::add);
            }
        });
    }

    private static boolean mayHavePoi(LevelChunkSection section) {
        return section.maybeHas(PoiTypes::hasPoi);
    }

    private void updateFromSection(LevelChunkSection section, SectionPos sectionPos, BiConsumer<BlockPos, Holder<PoiType>> posToTypeConsumer) {
        sectionPos.blocksInside().forEach(blockPos -> {
            BlockState blockState = section.getBlockState(SectionPos.sectionRelative(blockPos.getX()), SectionPos.sectionRelative(blockPos.getY()), SectionPos.sectionRelative(blockPos.getZ()));
            PoiTypes.forState(blockState).ifPresent(holder -> posToTypeConsumer.accept((BlockPos)blockPos, (Holder<PoiType>)holder));
        });
    }

    public void ensureLoadedAndValid(LevelReader level, BlockPos pos, int radius) {
        SectionPos.aroundChunk(new ChunkPos(pos), Math.floorDiv(radius, 16), this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).map(sectionPos -> Pair.of((Object)sectionPos, this.getOrLoad(sectionPos.asLong()))).filter(pair -> ((Optional)pair.getSecond()).map(PoiSection::isValid).orElse(false) == false).map(pair -> ((SectionPos)pair.getFirst()).chunk()).forEach(chunkPos -> level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.EMPTY));
    }

    final class DistanceTracker
    extends SectionTracker {
        private final Long2ByteMap levels;

        protected DistanceTracker() {
            super(7, 16, 256);
            this.levels = new Long2ByteOpenHashMap();
            this.levels.defaultReturnValue((byte)7);
        }

        @Override
        protected int getLevelFromSource(long pos) {
            return PoiManager.this.isVillageCenter(pos) ? 0 : 7;
        }

        @Override
        protected int getLevel(long sectionPos) {
            return this.levels.get(sectionPos);
        }

        @Override
        protected void setLevel(long sectionPos, int level) {
            if (level > 6) {
                this.levels.remove(sectionPos);
            } else {
                this.levels.put(sectionPos, (byte)level);
            }
        }

        public void runAllUpdates() {
            super.runUpdates(Integer.MAX_VALUE);
        }
    }

    public static enum Occupancy {
        HAS_SPACE(PoiRecord::hasSpace),
        IS_OCCUPIED(PoiRecord::isOccupied),
        ANY(test -> true);

        private final Predicate<? super PoiRecord> test;

        private Occupancy(Predicate<? super PoiRecord> test) {
            this.test = test;
        }

        public Predicate<? super PoiRecord> getTest() {
            return this.test;
        }
    }
}

