/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;

public interface HoglinBase {
    public static final int ATTACK_ANIMATION_DURATION = 10;
    public static final float PROBABILITY_OF_SPAWNING_AS_BABY = 0.2f;

    public int getAttackAnimationRemainingTicks();

    public static boolean hurtAndThrowTarget(ServerLevel level, LivingEntity entity, LivingEntity target) {
        float f = (float)entity.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float f1 = !entity.isBaby() && (int)f > 0 ? f / 2.0f + (float)level.random.nextInt((int)f) : f;
        DamageSource damageSource = entity.damageSources().mobAttack(entity);
        boolean flag = target.hurtServer(level, damageSource, f1);
        if (flag) {
            EnchantmentHelper.doPostAttackEffects(level, target, damageSource);
            if (!entity.isBaby()) {
                HoglinBase.throwTarget(entity, target);
            }
        }
        return flag;
    }

    public static void throwTarget(LivingEntity hoglin, LivingEntity target) {
        double attributeValue1;
        double attributeValue = hoglin.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        double d = attributeValue - (attributeValue1 = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        if (!(d <= 0.0)) {
            double d1 = target.getX() - hoglin.getX();
            double d2 = target.getZ() - hoglin.getZ();
            float f = hoglin.level().random.nextInt(21) - 10;
            double d3 = d * (double)(hoglin.level().random.nextFloat() * 0.5f + 0.2f);
            Vec3 vec3 = new Vec3(d1, 0.0, d2).normalize().scale(d3).yRot(f);
            double d4 = d * (double)hoglin.level().random.nextFloat() * 0.5;
            target.push(vec3.x, d4, vec3.z, hoglin);
            target.hurtMarked = true;
        }
    }
}

