/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.zombie;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class Husk
extends Zombie {
    public Husk(EntityType<? extends Husk> type, Level level) {
        super((EntityType<? extends Zombie>)type, level);
    }

    @Override
    public boolean isSunSensitive() {
        return false;
    }

    @Override
    public SoundEvent getAmbientSound() {
        return SoundEvents.HUSK_AMBIENT;
    }

    @Override
    public SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.HUSK_HURT;
    }

    @Override
    public SoundEvent getDeathSound() {
        return SoundEvents.HUSK_DEATH;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundEvents.HUSK_STEP;
    }

    @Override
    public boolean doHurtTarget(ServerLevel level, Entity target) {
        boolean flag = super.doHurtTarget(level, target);
        if (flag && this.getMainHandItem().isEmpty() && target instanceof LivingEntity) {
            float effectiveDifficulty = level.getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            ((LivingEntity)target).addEffect(new MobEffectInstance(MobEffects.HUNGER, 140 * (int)effectiveDifficulty), this, EntityPotionEffectEvent.Cause.ATTACK);
        }
        return flag;
    }

    @Override
    protected boolean convertsInWater() {
        return true;
    }

    @Override
    protected void doUnderWaterConversion(ServerLevel level) {
        this.convertToZombieType(level, EntityType.ZOMBIE);
        if (!this.isSilent()) {
            level.levelEvent(null, 1041, this.blockPosition(), 0);
        }
    }

    @Override
    public @Nullable SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawnReason, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource random = level.getRandom();
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnReason, spawnGroupData);
        float specialMultiplier = difficulty.getSpecialMultiplier();
        if (spawnReason != EntitySpawnReason.CONVERSION) {
            this.setCanPickUpLoot(random.nextFloat() < 0.55f * specialMultiplier);
        }
        if (spawnGroupData != null) {
            spawnGroupData = new HuskGroupData((Zombie.ZombieGroupData)spawnGroupData);
            boolean bl = ((HuskGroupData)spawnGroupData).triedToSpawnCamelHusk = spawnReason != EntitySpawnReason.NATURAL;
        }
        if (spawnGroupData instanceof HuskGroupData) {
            BlockPos blockPos;
            HuskGroupData huskGroupData = (HuskGroupData)spawnGroupData;
            if (!huskGroupData.triedToSpawnCamelHusk && level.noCollision(EntityType.CAMEL_HUSK.getSpawnAABB((double)(blockPos = this.blockPosition()).getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5))) {
                huskGroupData.triedToSpawnCamelHusk = true;
                if (random.nextFloat() < 0.1f) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.IRON_SPEAR));
                    CamelHusk camelHusk = EntityType.CAMEL_HUSK.create(this.level(), EntitySpawnReason.NATURAL);
                    if (camelHusk != null) {
                        camelHusk.setPos(this.getX(), this.getY(), this.getZ());
                        camelHusk.finalizeSpawn(level, difficulty, spawnReason, null);
                        this.startRiding(camelHusk, true, true);
                        level.addFreshEntity(camelHusk);
                        Parched parched = EntityType.PARCHED.create(this.level(), EntitySpawnReason.NATURAL);
                        if (parched != null) {
                            parched.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                            parched.finalizeSpawn(level, difficulty, spawnReason, null);
                            parched.startRiding(camelHusk, false, false);
                            level.addFreshEntityWithPassengers(parched);
                        }
                    }
                }
            }
        }
        return spawnGroupData;
    }

    public static class HuskGroupData
    extends Zombie.ZombieGroupData {
        public boolean triedToSpawnCamelHusk = false;

        public HuskGroupData(Zombie.ZombieGroupData zombieGroupData) {
            super(zombieGroupData.isBaby, zombieGroupData.canSpawnJockey);
        }
    }
}

