/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile.windcharge;

import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class BreezeWindCharge
extends AbstractWindCharge {
    private static final float RADIUS = 3.0f;

    public BreezeWindCharge(EntityType<? extends AbstractWindCharge> type, Level level) {
        super(type, level);
    }

    public BreezeWindCharge(Breeze breeze, Level level) {
        super(EntityType.BREEZE_WIND_CHARGE, level, breeze, breeze.getX(), breeze.getFiringYPosition(), breeze.getZ());
    }

    @Override
    public void explode(Vec3 pos) {
        ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 3.0f, false);
        if (event.isCancelled()) {
            return;
        }
        this.level().explode(this, null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, pos.x(), pos.y(), pos.z(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.TRIGGER, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, WeightedList.of(), SoundEvents.BREEZE_WIND_CHARGE_BURST);
    }
}

