/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jspecify.annotations.Nullable;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> type, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)type, level);
    }

    public ThrownEnderpearl(Level level, LivingEntity owner, ItemStack item) {
        super(EntityType.ENDER_PEARL, owner, level, item);
    }

    @Override
    public Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwner(@Nullable EntityReference<Entity> owner) {
        this.deregisterFromCurrentOwner();
        super.setOwner(owner);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.registerEnderPearl(this);
        }
    }

    @Override
    public @Nullable Entity getOwner() {
        Entity entity;
        Level level;
        if (this.owner != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            entity = this.owner.getEntity(serverLevel, Entity.class);
        } else {
            entity = super.getOwner();
        }
        return entity;
    }

    private static @Nullable Entity findOwnerIncludingDeadPlayer(ServerLevel level, UUID id) {
        Entity entityInAnyDimension = level.getEntityInAnyDimension(id);
        return entityInAnyDimension != null ? entityInAnyDimension : level.getServer().getPlayerList().getPlayer(id);
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        result.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult result) {
        super.onHit(result);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                Entity owner = this.getOwner();
                if (owner != null && ThrownEnderpearl.isAllowedToTeleportOwner(owner, serverLevel)) {
                    Vec3 vec3 = this.oldPosition();
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)owner;
                        if (serverPlayer.connection.isAcceptingMessages()) {
                            Endermite endermite;
                            double preTeleportX = serverPlayer.getX();
                            double preTeleportY = serverPlayer.getY();
                            double preTeleportZ = serverPlayer.getZ();
                            float preTeleportYRot = serverPlayer.getYRot();
                            float preTeleportXRot = serverPlayer.getXRot();
                            ServerPlayer serverPlayer1 = serverPlayer.teleport(new TeleportTransition(serverLevel, vec3, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING, PlayerTeleportEvent.TeleportCause.ENDER_PEARL));
                            if (serverPlayer1 == null) {
                                this.discard(EntityRemoveEvent.Cause.HIT);
                                return;
                            }
                            if (this.random.nextFloat() < 0.05f && serverLevel.isSpawningMonsters() && (endermite = EntityType.ENDERMITE.create(serverLevel, EntitySpawnReason.TRIGGERED)) != null) {
                                endermite.snapTo(preTeleportX, preTeleportY, preTeleportZ, preTeleportYRot, preTeleportXRot);
                                serverLevel.addFreshEntity(endermite, CreatureSpawnEvent.SpawnReason.ENDER_PEARL);
                            }
                            if (this.isOnPortalCooldown()) {
                                owner.setPortalCooldown();
                            }
                            if (serverPlayer1 != null) {
                                serverPlayer1.resetFallDistance();
                                serverPlayer1.resetCurrentImpulseContext();
                                serverPlayer1.hurtServer(serverPlayer.level(), this.damageSources().enderPearl().eventEntityDamager(this), 5.0f);
                            }
                            this.playSound(serverLevel, vec3);
                        }
                    } else {
                        Entity entity = owner.teleport(new TeleportTransition(serverLevel, vec3, owner.getDeltaMovement(), owner.getYRot(), owner.getXRot(), TeleportTransition.DO_NOTHING));
                        if (entity != null) {
                            entity.resetFallDistance();
                        }
                        this.playSound(serverLevel, vec3);
                    }
                    this.discard(EntityRemoveEvent.Cause.HIT);
                } else {
                    this.discard(EntityRemoveEvent.Cause.HIT);
                }
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity entity, Level level) {
        if (entity.level().dimension() == level.dimension()) {
            boolean bl;
            if (!(entity instanceof LivingEntity)) {
                bl = entity.isAlive();
            } else {
                LivingEntity livingEntity = (LivingEntity)entity;
                bl = livingEntity.isAlive() && !livingEntity.isSleeping();
            }
            return bl;
        }
        return entity.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        block5: {
            block4: {
                var2_1 = this.level();
                if (!(var2_1 instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)var2_1;
                var7 = SectionPos.blockToSectionCoord(this.position().x());
                sectionPosZ = SectionPos.blockToSectionCoord(this.position().z());
                v0 = entity = this.owner != null ? ThrownEnderpearl.findOwnerIncludingDeadPlayer(serverLevel, this.owner.getUUID()) : null;
                if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
                serverPlayer = (ServerPlayer)entity;
                if (!entity.isAlive() && !serverPlayer.wonGame && serverPlayer.level().getGameRules().get(GameRules.ENDER_PEARLS_VANISH_ON_DEATH).booleanValue()) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                } else lbl-1000:
                // 2 sources

                {
                    super.tick();
                }
                if (this.isAlive()) {
                    blockPos = BlockPos.containing(this.position());
                    if ((--this.ticketTimer <= 0L || var7 != SectionPos.blockToSectionCoord(blockPos.getX()) || sectionPosZ != SectionPos.blockToSectionCoord(blockPos.getZ())) && entity instanceof ServerPlayer) {
                        serverPlayer1 = (ServerPlayer)entity;
                        this.ticketTimer = serverPlayer1.registerAndUpdateEnderPearlTicket(this);
                    }
                }
                break block5;
            }
            super.tick();
        }
    }

    private void playSound(Level level, Vec3 pos) {
        level.playSound(null, pos.x, pos.y, pos.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    public @Nullable Entity teleport(TeleportTransition teleportTransition) {
        Entity entity = super.teleport(teleportTransition);
        if (entity != null && !this.level().paperConfig().misc.legacyEnderPearlBehavior) {
            entity.placePortalTicket(BlockPos.containing(entity.position()));
        }
        return entity;
    }

    @Override
    public boolean canTeleport(Level fromLevel, Level toLevel) {
        boolean bl;
        Entity entity;
        if (fromLevel.getTypeKey() == LevelStem.END && toLevel.getTypeKey() == LevelStem.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            bl = super.canTeleport(fromLevel, toLevel) && serverPlayer.seenCredits;
        } else {
            bl = super.canTeleport(fromLevel, toLevel);
        }
        return bl;
    }

    @Override
    protected void onInsideBlock(BlockState state) {
        Entity entity;
        super.onInsideBlock(state);
        if (state.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.onInsideBlock(state);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason reason) {
        if (reason != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(reason);
    }

    @Override
    public void onAboveBubbleColumn(boolean downwards, BlockPos pos) {
        Entity.handleOnAboveBubbleColumn(this, downwards, pos);
    }

    @Override
    public void onInsideBubbleColumn(boolean downwards) {
        Entity.handleOnInsideBubbleColumn(this, downwards);
    }
}

