/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.HashedStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public static final int SLOTS_PER_ROW = 9;
    public static final int SLOT_SIZE = 18;
    public NonNullList<net.minecraft.world.item.ItemStack> lastSlots = NonNullList.create();
    public NonNullList<Slot> slots = NonNullList.create();
    public List<DataSlot> dataSlots = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack carried = net.minecraft.world.item.ItemStack.EMPTY;
    public NonNullList<RemoteSlot> remoteSlots = NonNullList.create();
    public IntList remoteDataSlots = new IntArrayList();
    private RemoteSlot remoteCarried = RemoteSlot.PLACEHOLDER;
    private int stateId;
    public final @Nullable MenuType<?> menuType;
    public final int containerId;
    public int quickcraftType = -1;
    public int quickcraftStatus;
    public final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ContainerListener> containerListeners = Lists.newArrayList();
    private @Nullable ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;
    public boolean checkReachable = true;
    private @Nullable Component title;

    public abstract InventoryView getBukkitView();

    public void transferTo(AbstractContainerMenu other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final Component getTitle() {
        if (this.title == null) {
            return Component.empty();
        }
        return this.title;
    }

    public final void setTitle(Component title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    public void startOpen() {
    }

    protected AbstractContainerMenu(@Nullable MenuType<?> menuType, int containerId) {
        this.menuType = menuType;
        this.containerId = containerId;
    }

    protected void addInventoryHotbarSlots(Container container, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot(container, i, x + i * 18, y));
        }
    }

    protected void addInventoryExtendedSlots(Container container, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot(container, i1 + (i + 1) * 9, x + i1 * 18, y + i * 18));
            }
        }
    }

    protected void addStandardInventorySlots(Container container, int x, int y) {
        this.addInventoryExtendedSlots(container, x, y);
        int i = 4;
        int i1 = 58;
        this.addInventoryHotbarSlots(container, x, y + 58);
    }

    protected static boolean stillValid(ContainerLevelAccess access, Player player, Block targetBlock) {
        return access.evaluate((level, pos) -> !level.getBlockState((BlockPos)pos).is(targetBlock) ? false : player.isWithinBlockInteractionRange((BlockPos)pos, 4.0), true);
    }

    public MenuType<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(Container container, int minSize) {
        int containerSize = container.getContainerSize();
        if (containerSize < minSize) {
            throw new IllegalArgumentException("Container size " + containerSize + " is smaller than expected " + minSize);
        }
    }

    protected static void checkContainerDataCount(ContainerData intArray, int minSize) {
        int count = intArray.getCount();
        if (count < minSize) {
            throw new IllegalArgumentException("Container data count " + count + " is smaller than expected " + minSize);
        }
    }

    public boolean isValidSlotIndex(int slotIndex) {
        return slotIndex == -1 || slotIndex == -999 || slotIndex < this.slots.size();
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.slots.size();
        this.slots.add(slot);
        this.lastSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        this.remoteSlots.add(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER);
        return slot;
    }

    protected DataSlot addDataSlot(DataSlot slot) {
        this.dataSlots.add(slot);
        this.remoteDataSlots.add(0);
        return slot;
    }

    protected void addDataSlots(ContainerData array) {
        for (int i = 0; i < array.getCount(); ++i) {
            this.addDataSlot(DataSlot.forContainer(array, i));
        }
    }

    public void addSlotListener(ContainerListener listener) {
        if (!this.containerListeners.contains(listener)) {
            this.containerListeners.add(listener);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(ContainerSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
        this.remoteCarried = synchronizer.createSlot();
        this.remoteSlots.replaceAll(remoteSlot -> synchronizer.createSlot());
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        ArrayList<net.minecraft.world.item.ItemStack> list = new ArrayList<net.minecraft.world.item.ItemStack>(this.slots.size());
        int size = this.slots.size();
        for (int i = 0; i < size; ++i) {
            net.minecraft.world.item.ItemStack item = this.slots.get(i).getItem();
            list.add(item.copy());
            this.remoteSlots.get(i).force(item);
        }
        net.minecraft.world.item.ItemStack carried = this.getCarried();
        this.remoteCarried.force(carried);
        int size1 = this.dataSlots.size();
        for (int size2 = 0; size2 < size1; ++size2) {
            this.remoteDataSlots.set(size2, this.dataSlots.get(size2).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, list, carried.copy(), this.remoteDataSlots.toIntArray());
            this.synchronizer.sendOffHandSlotChange();
        }
    }

    public void forceHeldSlot(InteractionHand hand) {
        this.sendAllDataToRemote();
    }

    public void forceHeldSlotAndArmor(InteractionHand hand) {
        this.sendAllDataToRemote();
    }

    public void forceSlot(Container container, int slot) {
        int slotsIndex = this.findSlot(container, slot).orElse(-1);
        if (slotsIndex == -1) {
            return;
        }
        net.minecraft.world.item.ItemStack item = this.slots.get(slotsIndex).getItem();
        this.remoteSlots.get(slotsIndex).force(item);
        if (this.synchronizer != null) {
            this.synchronizer.sendSlotChange(this, slotsIndex, item.copy());
        }
    }

    public void broadcastCarriedItem() {
        net.minecraft.world.item.ItemStack carried = this.getCarried();
        this.remoteCarried.force(carried);
        if (this.synchronizer != null) {
            this.synchronizer.sendCarriedChange(this, carried.copy());
        }
    }

    public void removeSlotListener(ContainerListener listener) {
        this.containerListeners.remove(listener);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        NonNullList<net.minecraft.world.item.ItemStack> list = NonNullList.create();
        for (Slot slot : this.slots) {
            list.add(slot.getItem());
        }
        return list;
    }

    public void broadcastChanges() {
        int i;
        for (i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack item = this.slots.get(i).getItem();
            com.google.common.base.Supplier supplier = Suppliers.memoize(item::copy);
            this.triggerSlotListeners(i, item, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.synchronizeSlotToRemote(i, item, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (i = 0; i < this.dataSlots.size(); ++i) {
            DataSlot dataSlot = this.dataSlots.get(i);
            int i1 = dataSlot.get();
            if (dataSlot.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(i, i1);
            }
            this.synchronizeDataSlotToRemote(i, i1);
        }
    }

    public void broadcastFullState() {
        int i;
        for (i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack item = this.slots.get(i).getItem();
            this.triggerSlotListeners(i, item, item::copy);
        }
        for (i = 0; i < this.dataSlots.size(); ++i) {
            DataSlot dataSlot = this.dataSlots.get(i);
            if (!dataSlot.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(i, dataSlot.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int slotIndex, int value) {
        for (ContainerListener containerListener : this.containerListeners) {
            containerListener.dataChanged(this, slotIndex, value);
        }
    }

    public void triggerSlotListeners(int slotIndex, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        net.minecraft.world.item.ItemStack itemStack = this.lastSlots.get(slotIndex);
        if (!net.minecraft.world.item.ItemStack.matches(itemStack, stack)) {
            net.minecraft.world.item.ItemStack itemStack1 = supplier.get();
            this.lastSlots.set(slotIndex, itemStack1);
            for (ContainerListener containerListener : this.containerListeners) {
                containerListener.slotChanged(this, slotIndex, itemStack, itemStack1);
            }
        }
    }

    public void synchronizeSlotToRemote(int slotIndex, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> supplier) {
        RemoteSlot remoteSlot;
        if (!this.suppressRemoteUpdates && !(remoteSlot = this.remoteSlots.get(slotIndex)).matches(stack)) {
            remoteSlot.force(stack);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, slotIndex, supplier.get());
            }
        }
    }

    private void synchronizeDataSlotToRemote(int slotIndex, int value) {
        int _int;
        if (!this.suppressRemoteUpdates && (_int = this.remoteDataSlots.getInt(slotIndex)) != value) {
            this.remoteDataSlots.set(slotIndex, value);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, slotIndex, value);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        net.minecraft.world.item.ItemStack carried;
        if (!this.suppressRemoteUpdates && !this.remoteCarried.matches(carried = this.getCarried())) {
            this.remoteCarried.force(carried);
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, carried.copy());
            }
        }
    }

    public void setRemoteSlot(int slot, net.minecraft.world.item.ItemStack stack) {
        this.remoteSlots.get(slot).force(stack);
    }

    public void setRemoteSlotUnsafe(int slot, HashedStack stack) {
        if (slot >= 0 && slot < this.remoteSlots.size()) {
            this.remoteSlots.get(slot).receive(stack);
        } else {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)slot, (Object)this.remoteSlots.size());
        }
    }

    public void setRemoteCarried(HashedStack stack) {
        this.remoteCarried.receive(stack);
    }

    public boolean clickMenuButton(Player player, int id) {
        return false;
    }

    public Slot getSlot(int slotIndex) {
        return this.slots.get(slotIndex);
    }

    public abstract net.minecraft.world.item.ItemStack quickMoveStack(Player var1, int var2);

    public void setSelectedBundleItemIndex(int slotIndex, int bundleItemIndex) {
        if (slotIndex >= 0 && slotIndex < this.slots.size()) {
            net.minecraft.world.item.ItemStack item = this.slots.get(slotIndex).getItem();
            BundleItem.toggleSelectedItem(item, bundleItemIndex);
        }
    }

    public void clicked(int slotIndex, int button, ClickType clickType, Player player) {
        try {
            this.doClick(slotIndex, button, clickType, player);
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.forThrowable(var8, "Container click");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Click info");
            crashReportCategory.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            crashReportCategory.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashReportCategory.setDetail("Slot Count", this.slots.size());
            crashReportCategory.setDetail("Slot", slotIndex);
            crashReportCategory.setDetail("Button", button);
            crashReportCategory.setDetail("Type", (Object)clickType);
            throw new ReportedException(crashReport);
        }
    }

    private void doClick(int slotIndex, int button, ClickType clickType, Player player) {
        block50: {
            block62: {
                block58: {
                    net.minecraft.world.item.ItemStack carried;
                    Slot slot;
                    net.minecraft.world.item.ItemStack item;
                    Inventory inventory;
                    block61: {
                        block60: {
                            block59: {
                                block55: {
                                    ClickAction clickAction;
                                    block57: {
                                        block56: {
                                            block54: {
                                                block48: {
                                                    block53: {
                                                        net.minecraft.world.item.ItemStack carried2;
                                                        block52: {
                                                            block51: {
                                                                block49: {
                                                                    inventory = player.getInventory();
                                                                    if (clickType != ClickType.QUICK_CRAFT) break block48;
                                                                    int i = this.quickcraftStatus;
                                                                    this.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader(button);
                                                                    if (i == 1 && this.quickcraftStatus == 2 || i == this.quickcraftStatus) break block49;
                                                                    this.resetQuickCraft();
                                                                    break block50;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block51;
                                                                this.resetQuickCraft();
                                                                break block50;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block52;
                                                            this.quickcraftType = AbstractContainerMenu.getQuickcraftType(button);
                                                            if (AbstractContainerMenu.isValidQuickcraftType(this.quickcraftType, player)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block50;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block53;
                                                        if (slotIndex < 0) {
                                                            return;
                                                        }
                                                        Slot slot2 = this.slots.get(slotIndex);
                                                        if (!AbstractContainerMenu.canItemQuickReplace(slot2, carried2 = this.getCarried(), true) || !slot2.mayPlace(carried2) || this.quickcraftType != 2 && carried2.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot2)) break block50;
                                                        this.quickcraftSlots.add(slot2);
                                                        break block50;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            if (this.quickcraftSlots.size() == 1) {
                                                                int i1 = this.quickcraftSlots.iterator().next().index;
                                                                this.resetQuickCraft();
                                                                this.doClick(i1, this.quickcraftType, ClickType.PICKUP, player);
                                                                return;
                                                            }
                                                            net.minecraft.world.item.ItemStack itemStack = this.getCarried().copy();
                                                            if (itemStack.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int count = this.getCarried().getCount();
                                                            Int2ObjectOpenHashMap draggedSlots = new Int2ObjectOpenHashMap();
                                                            for (Slot slot1 : this.quickcraftSlots) {
                                                                net.minecraft.world.item.ItemStack carried1 = this.getCarried();
                                                                if (slot1 == null || !AbstractContainerMenu.canItemQuickReplace(slot1, carried1, true) || !slot1.mayPlace(carried1) || this.quickcraftType != 2 && carried1.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                                int i2 = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                                int min = Math.min(itemStack.getMaxStackSize(), slot1.getMaxStackSize(itemStack));
                                                                int min1 = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, itemStack) + i2, min);
                                                                count -= min1 - i2;
                                                                draggedSlots.put(slot1.index, (Object)itemStack.copyWithCount(min1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newCarried = CraftItemStack.asCraftMirror(itemStack);
                                                            newCarried.setAmount(count);
                                                            HashMap<Integer, ItemStack> eventMap = new HashMap<Integer, ItemStack>();
                                                            for (Int2ObjectMap.Entry entry : draggedSlots.int2ObjectEntrySet()) {
                                                                eventMap.put(entry.getIntKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)entry.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCarried = this.getCarried();
                                                            this.setCarried(CraftItemStack.asNMSCopy(newCarried));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)newCarried, CraftItemStack.asBukkitCopy(oldCarried), this.quickcraftType == 1, eventMap);
                                                            event.callEvent();
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Int2ObjectMap.Entry entry : draggedSlots.int2ObjectEntrySet()) {
                                                                    view.setItem(entry.getIntKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)entry.getValue()));
                                                                }
                                                                this.setCarried(CraftItemStack.asNMSCopy(event.getCursor()));
                                                            } else {
                                                                this.setCarried(oldCarried);
                                                            }
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block50;
                                                }
                                                if (this.quickcraftStatus == 0) break block54;
                                                this.resetQuickCraft();
                                                break block50;
                                            }
                                            if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || button != 0 && button != 1) break block55;
                                            ClickAction clickAction2 = clickAction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (slotIndex != -999) break block56;
                                            if (this.getCarried().isEmpty()) break block50;
                                            if (clickAction == ClickAction.PRIMARY) {
                                                net.minecraft.world.item.ItemStack carried3 = this.getCarried();
                                                this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
                                                player.drop(carried3, true);
                                            } else {
                                                player.drop(this.getCarried().split(1), true);
                                            }
                                            break block50;
                                        }
                                        if (clickType != ClickType.QUICK_MOVE) break block57;
                                        if (slotIndex < 0) {
                                            return;
                                        }
                                        Slot slot3 = this.slots.get(slotIndex);
                                        if (!slot3.mayPickup(player)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack carried4 = this.quickMoveStack(player, slotIndex);
                                        while (!carried4.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot3.getItem(), carried4)) {
                                            carried4 = this.quickMoveStack(player, slotIndex);
                                        }
                                        break block50;
                                    }
                                    if (slotIndex < 0) {
                                        return;
                                    }
                                    Slot slot4 = this.slots.get(slotIndex);
                                    net.minecraft.world.item.ItemStack carried5 = slot4.getItem();
                                    net.minecraft.world.item.ItemStack carried2 = this.getCarried();
                                    player.updateTutorialInventoryAction(carried2, slot4.getItem(), clickAction);
                                    if (!this.tryItemClickBehaviourOverride(player, clickAction, slot4, carried5, carried2)) {
                                        if (carried5.isEmpty()) {
                                            if (!carried2.isEmpty()) {
                                                int i3 = clickAction == ClickAction.PRIMARY ? carried2.getCount() : 1;
                                                this.setCarried(slot4.safeInsert(carried2, i3));
                                            }
                                        } else if (slot4.mayPickup(player)) {
                                            if (carried2.isEmpty()) {
                                                int i3 = clickAction == ClickAction.PRIMARY ? carried5.getCount() : (carried5.getCount() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot4.tryRemove(i3, Integer.MAX_VALUE, player);
                                                optional.ifPresent(itemStack2 -> {
                                                    this.setCarried((net.minecraft.world.item.ItemStack)itemStack2);
                                                    slot4.onTake(player, (net.minecraft.world.item.ItemStack)itemStack2);
                                                });
                                            } else if (slot4.mayPlace(carried2)) {
                                                if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(carried5, carried2)) {
                                                    int i3 = clickAction == ClickAction.PRIMARY ? carried2.getCount() : 1;
                                                    this.setCarried(slot4.safeInsert(carried2, i3));
                                                } else if (carried2.getCount() <= slot4.getMaxStackSize(carried2)) {
                                                    this.setCarried(carried5);
                                                    slot4.setByPlayer(carried2);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(carried5, carried2)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot4.tryRemove(carried5.getCount(), carried2.getMaxStackSize() - carried2.getCount(), player);
                                                optional1.ifPresent(itemStack2 -> {
                                                    carried2.grow(itemStack2.getCount());
                                                    slot4.onTake(player, (net.minecraft.world.item.ItemStack)itemStack2);
                                                });
                                            }
                                        }
                                    }
                                    slot4.setChanged();
                                    if (!(player instanceof ServerPlayer)) break block50;
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    if (slot4.getMaxStackSize() != 99) {
                                        serverPlayer.connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), slot4.index, slot4.getItem()));
                                        if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                            serverPlayer.connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, this.getSlot(0).getItem()));
                                        }
                                    }
                                    break block50;
                                }
                                if (clickType != ClickType.SWAP || (button < 0 || button >= 9) && button != 40) break block58;
                                if (slotIndex < 0) {
                                    return;
                                }
                                item = inventory.getItem(button);
                                slot = this.slots.get(slotIndex);
                                carried = slot.getItem();
                                if (item.isEmpty() && carried.isEmpty()) break block50;
                                if (!item.isEmpty()) break block59;
                                if (!slot.mayPickup(player)) break block50;
                                inventory.setItem(button, carried);
                                slot.onSwapCraft(carried.getCount());
                                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
                                slot.onTake(player, carried);
                                break block50;
                            }
                            if (!carried.isEmpty()) break block60;
                            if (!slot.mayPlace(item)) break block50;
                            int maxStackSize = slot.getMaxStackSize(item);
                            if (item.getCount() > maxStackSize) {
                                slot.setByPlayer(item.split(maxStackSize));
                            } else {
                                inventory.setItem(button, net.minecraft.world.item.ItemStack.EMPTY);
                                slot.setByPlayer(item);
                            }
                            break block50;
                        }
                        if (!slot.mayPickup(player) || !slot.mayPlace(item)) break block50;
                        int maxStackSize = slot.getMaxStackSize(item);
                        if (item.getCount() <= maxStackSize) break block61;
                        slot.setByPlayer(item.split(maxStackSize));
                        slot.onTake(player, carried);
                        if (inventory.add(carried)) break block50;
                        player.drop(carried, true);
                        break block50;
                    }
                    inventory.setItem(button, carried);
                    slot.setByPlayer(item);
                    slot.onTake(player, carried);
                    break block50;
                }
                if (clickType != ClickType.CLONE || !player.hasInfiniteMaterials() || !this.getCarried().isEmpty() || slotIndex < 0) break block62;
                Slot slot2 = this.slots.get(slotIndex);
                if (!slot2.hasItem()) break block50;
                net.minecraft.world.item.ItemStack itemStack = slot2.getItem();
                this.setCarried(itemStack.copyWithCount(itemStack.getMaxStackSize()));
                break block50;
            }
            if (clickType == ClickType.THROW && this.getCarried().isEmpty() && slotIndex >= 0) {
                int i1;
                Slot slot2 = this.slots.get(slotIndex);
                int n = i1 = button == 0 ? 1 : slot2.getItem().getCount();
                if (!player.canDropItems()) {
                    return;
                }
                net.minecraft.world.item.ItemStack carried = slot2.safeTake(i1, Integer.MAX_VALUE, player);
                player.drop(carried, true);
                player.handleCreativeModeItemDrop(carried);
                if (button == 1) {
                    while (!carried.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot2.getItem(), carried)) {
                        if (!player.canDropItems()) {
                            return;
                        }
                        carried = slot2.safeTake(i1, Integer.MAX_VALUE, player);
                        if (player.drop(carried, true) != null) {
                            player.handleCreativeModeItemDrop(carried);
                            continue;
                        }
                        break;
                    }
                }
            } else if (clickType == ClickType.PICKUP_ALL && slotIndex >= 0) {
                Slot slot2x = this.slots.get(slotIndex);
                net.minecraft.world.item.ItemStack itemStack = this.getCarried();
                if (!(itemStack.isEmpty() || slot2x.hasItem() && slot2x.mayPickup(player))) {
                    int count = button == 0 ? 0 : this.slots.size() - 1;
                    int maxStackSize = button == 0 ? 1 : -1;
                    for (int i3 = 0; i3 < 2; ++i3) {
                        for (int i4 = count; i4 >= 0 && i4 < this.slots.size() && itemStack.getCount() < itemStack.getMaxStackSize(); i4 += maxStackSize) {
                            Slot slot3 = this.slots.get(i4);
                            if (!slot3.hasItem() || !AbstractContainerMenu.canItemQuickReplace(slot3, itemStack, true) || !slot3.mayPickup(player) || !this.canTakeItemForPickAll(itemStack, slot3)) continue;
                            net.minecraft.world.item.ItemStack item1 = slot3.getItem();
                            if (i3 == 0 && item1.getCount() == item1.getMaxStackSize()) continue;
                            net.minecraft.world.item.ItemStack itemStack1 = slot3.safeTake(item1.getCount(), itemStack.getMaxStackSize() - itemStack.getCount(), player);
                            itemStack.grow(itemStack1.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean tryItemClickBehaviourOverride(Player player, ClickAction action, Slot slot, net.minecraft.world.item.ItemStack clickedItem, net.minecraft.world.item.ItemStack carriedItem) {
        FeatureFlagSet featureFlagSet = player.level().enabledFeatures();
        return carriedItem.isItemEnabled(featureFlagSet) && carriedItem.overrideStackedOnOther(slot, action, player) || clickedItem.isItemEnabled(featureFlagSet) && clickedItem.overrideOtherStackedOnMe(carriedItem, slot, action, player, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack get() {
                return AbstractContainerMenu.this.getCarried();
            }

            @Override
            public boolean set(net.minecraft.world.item.ItemStack carried) {
                AbstractContainerMenu.this.setCarried(carried);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(net.minecraft.world.item.ItemStack stack, Slot slot) {
        return true;
    }

    public void removed(Player player) {
        net.minecraft.world.item.ItemStack carried;
        if (player instanceof ServerPlayer && !(carried = this.getCarried()).isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
            AbstractContainerMenu.dropOrPlaceInInventory(player, carried);
        }
    }

    private static void dropOrPlaceInInventory(Player player, net.minecraft.world.item.ItemStack stack) {
        ServerPlayer serverPlayer;
        boolean flag1;
        boolean flag = player.isRemoved() && player.getRemovalReason() != Entity.RemovalReason.CHANGED_DIMENSION;
        boolean bl = flag1 = player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected();
        if (flag || flag1) {
            player.drop(stack, false);
        } else if (player instanceof ServerPlayer) {
            player.getInventory().placeItemBackInInventory(stack);
        }
    }

    protected void clearContainer(Player player, Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            AbstractContainerMenu.dropOrPlaceInInventory(player, container.removeItemNoUpdate(i));
        }
    }

    public void slotsChanged(Container container) {
        this.broadcastChanges();
    }

    public void setItem(int slotIndex, int stateId, net.minecraft.world.item.ItemStack stack) {
        this.getSlot(slotIndex).set(stack);
        this.stateId = stateId;
    }

    public void initializeContents(int stateId, List<net.minecraft.world.item.ItemStack> items, net.minecraft.world.item.ItemStack carried) {
        for (int i = 0; i < items.size(); ++i) {
            this.getSlot(i).set(items.get(i));
        }
        this.carried = carried;
        this.stateId = stateId;
    }

    public void setData(int id, int data) {
        this.dataSlots.get(id).set(data);
    }

    public abstract boolean stillValid(Player var1);

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveItemStackTo(stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean reverseDirection, boolean isCheck) {
        int i1;
        if (isCheck) {
            stack = stack.copy();
        }
        boolean flag = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (!stack.isEmpty() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                Slot slot = this.slots.get(i);
                net.minecraft.world.item.ItemStack item = slot.getItem();
                if (isCheck) {
                    item = item.copy();
                }
                if (!item.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(stack, item)) {
                    int maxStackSize;
                    i1 = item.getCount() + stack.getCount();
                    if (i1 <= (maxStackSize = slot.getMaxStackSize(item))) {
                        stack.setCount(0);
                        item.setCount(i1);
                        if (!isCheck) {
                            slot.setChanged();
                        }
                        flag = true;
                    } else if (item.getCount() < maxStackSize) {
                        stack.shrink(maxStackSize - item.getCount());
                        item.setCount(maxStackSize);
                        if (!isCheck) {
                            slot.setChanged();
                        }
                        flag = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.isEmpty()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                Slot slotx = this.slots.get(i);
                net.minecraft.world.item.ItemStack itemx = slotx.getItem();
                if (isCheck) {
                    itemx = itemx.copy();
                }
                if (itemx.isEmpty() && slotx.mayPlace(stack)) {
                    i1 = slotx.getMaxStackSize(stack);
                    if (isCheck) {
                        stack.shrink(Math.min(stack.getCount(), i1));
                    } else {
                        slotx.setByPlayer(stack.split(Math.min(stack.getCount(), i1)));
                        slotx.setChanged();
                    }
                    flag = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public static int getQuickcraftType(int eventButton) {
        return eventButton >> 2 & 3;
    }

    public static int getQuickcraftHeader(int clickedButton) {
        return clickedButton & 3;
    }

    public static int getQuickcraftMask(int quickCraftingHeader, int quickCraftingType) {
        return quickCraftingHeader & 3 | (quickCraftingType & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int dragMode, Player player) {
        return dragMode == 0 || dragMode == 1 || dragMode == 2 && player.hasInfiniteMaterials();
    }

    public void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, net.minecraft.world.item.ItemStack stack, boolean stackSizeMatters) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.hasItem();
        return !flag && net.minecraft.world.item.ItemStack.isSameItemSameComponents(stack, slot.getItem()) ? slot.getItem().getCount() + (stackSizeMatters ? 0 : stack.getCount()) <= stack.getMaxStackSize() : flag;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> slots, int type, net.minecraft.world.item.ItemStack stack) {
        return switch (type) {
            case 0 -> Mth.floor((float)stack.getCount() / (float)slots.size());
            case 1 -> 1;
            case 2 -> stack.getMaxStackSize();
            default -> stack.getCount();
        };
    }

    public boolean canDragTo(Slot slot) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable BlockEntity blockEntity) {
        return blockEntity instanceof Container ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)blockEntity)) : 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container container) {
        if (container == null) {
            return 0;
        }
        float f = 0.0f;
        for (int i = 0; i < container.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack item = container.getItem(i);
            if (item.isEmpty()) continue;
            f += (float)item.getCount() / (float)container.getMaxStackSize(item);
        }
        return Mth.lerpDiscrete(f /= (float)container.getContainerSize(), 0, 15);
    }

    public void setCarried(net.minecraft.world.item.ItemStack stack) {
        this.carried = stack;
    }

    public net.minecraft.world.item.ItemStack getCarried() {
        if (this.carried.isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
        }
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(AbstractContainerMenu menu) {
        Slot slot;
        int i;
        HashBasedTable table = HashBasedTable.create();
        for (i = 0; i < menu.slots.size(); ++i) {
            slot = menu.slots.get(i);
            table.put((Object)slot.container, (Object)slot.getContainerSlot(), (Object)i);
        }
        for (i = 0; i < this.slots.size(); ++i) {
            slot = this.slots.get(i);
            Integer integer = (Integer)table.get((Object)slot.container, (Object)slot.getContainerSlot());
            if (integer == null) continue;
            this.lastSlots.set(i, menu.lastSlots.get(integer));
            RemoteSlot remoteSlot = menu.remoteSlots.get(integer);
            RemoteSlot remoteSlot1 = this.remoteSlots.get(i);
            if (!(remoteSlot instanceof RemoteSlot.Synchronized)) continue;
            RemoteSlot.Synchronized _synchronized = (RemoteSlot.Synchronized)remoteSlot;
            if (!(remoteSlot1 instanceof RemoteSlot.Synchronized)) continue;
            RemoteSlot.Synchronized _synchronized1 = (RemoteSlot.Synchronized)remoteSlot1;
            _synchronized1.copyFrom(_synchronized);
        }
    }

    public OptionalInt findSlot(Container container, int slotIndex) {
        for (int i = 0; i < this.slots.size(); ++i) {
            Slot slot = this.slots.get(i);
            if (slot.container != container || slotIndex != slot.getContainerSlot()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }

    protected final Supplier<BlockInventoryHolder> createBlockHolder(ContainerLevelAccess context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context was null");
        return () -> context.createBlockHolder(this);
    }
}

