/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerChangeBeaconEffectEvent;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.Location;
import org.bukkit.craftbukkit.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.inventory.view.CraftBeaconView;
import org.bukkit.craftbukkit.potion.CraftPotionEffectType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.Nullable;

public class BeaconMenu
extends AbstractContainerMenu {
    private static final int PAYMENT_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 1;
    private static final int INV_SLOT_END = 28;
    private static final int USE_ROW_SLOT_START = 28;
    private static final int USE_ROW_SLOT_END = 37;
    private static final int NO_EFFECT = 0;
    private final Container beacon;
    private final PaymentSlot paymentSlot;
    private final ContainerLevelAccess access;
    private final ContainerData beaconData;
    private @Nullable CraftBeaconView view = null;
    private final Inventory inventory;

    public BeaconMenu(int containerId, Container container) {
        this(containerId, container, new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public BeaconMenu(int containerId, Container container, ContainerData beaconData, final ContainerLevelAccess access) {
        super(MenuType.BEACON, containerId);
        this.inventory = (Inventory)container;
        this.beacon = new SimpleContainer(this, this.createBlockHolder(access), 1){

            @Override
            public boolean canPlaceItem(int slot, ItemStack stack) {
                return stack.is(ItemTags.BEACON_PAYMENT_ITEMS);
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }

            @Override
            public Location getLocation() {
                return access.getLocation();
            }
        };
        BeaconMenu.checkContainerDataCount(beaconData, 3);
        this.beaconData = beaconData;
        this.access = access;
        this.paymentSlot = new PaymentSlot(this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(beaconData);
        this.addStandardInventorySlots(container, 36, 137);
    }

    @Override
    public void removed(Player player) {
        ItemStack itemStack;
        super.removed(player);
        if (!player.level().isClientSide() && !(itemStack = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize())).isEmpty()) {
            player.drop(itemStack, false);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        if (!this.checkReachable) {
            return true;
        }
        return BeaconMenu.stillValid(this.access, player, Blocks.BEACON);
    }

    @Override
    public void setData(int id, int data) {
        super.setData(id, data);
        this.broadcastChanges();
    }

    @Override
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack item = slot.getItem();
            itemStack = item.copy();
            if (slotIndex == 0) {
                if (!this.moveItemStackTo(item, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(item, itemStack);
            } else if (!this.paymentSlot.hasItem() && this.paymentSlot.mayPlace(item) && item.getCount() == 1 ? !this.moveItemStackTo(item, 0, 1, false) : (slotIndex >= 1 && slotIndex < 28 ? !this.moveItemStackTo(item, 28, 37, false) : (slotIndex >= 28 && slotIndex < 37 ? !this.moveItemStackTo(item, 1, 28, false) : !this.moveItemStackTo(item, 1, 37, false)))) {
                return ItemStack.EMPTY;
            }
            if (item.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (item.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, item);
        }
        return itemStack;
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    public static int encodeEffect(@Nullable Holder<MobEffect> effect) {
        return effect == null ? 0 : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().getId(effect) + 1;
    }

    public static @Nullable Holder<MobEffect> decodeEffect(int effectId) {
        return effectId == 0 ? null : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().byId(effectId - 1);
    }

    public @Nullable Holder<MobEffect> getPrimaryEffect() {
        return BeaconMenu.decodeEffect(this.beaconData.get(1));
    }

    public @Nullable Holder<MobEffect> getSecondaryEffect() {
        return BeaconMenu.decodeEffect(this.beaconData.get(2));
    }

    private static @Nullable PotionEffectType convert(Optional<Holder<MobEffect>> optionalEffect) {
        return optionalEffect.map(CraftPotionEffectType::minecraftHolderToBukkit).orElse(null);
    }

    public void updateEffects(Optional<Holder<MobEffect>> primaryEffect, Optional<Holder<MobEffect>> secondaryEffect) {
        PlayerChangeBeaconEffectEvent event;
        if (secondaryEffect.isPresent() && secondaryEffect.get() != MobEffects.REGENERATION && primaryEffect.isPresent() && secondaryEffect.get() != primaryEffect.get()) {
            secondaryEffect = Optional.empty();
        }
        if (this.paymentSlot.hasItem() && (event = new PlayerChangeBeaconEffectEvent((org.bukkit.entity.Player)this.inventory.player.getBukkitEntity(), BeaconMenu.convert(primaryEffect), BeaconMenu.convert(secondaryEffect), this.access.getLocation().getBlock())).callEvent()) {
            this.beaconData.set(1, BeaconMenu.encodeEffect(event.getPrimary() == null ? null : CraftPotionEffectType.bukkitToMinecraftHolder(event.getPrimary())));
            this.beaconData.set(2, BeaconMenu.encodeEffect(event.getSecondary() == null ? null : CraftPotionEffectType.bukkitToMinecraftHolder(event.getSecondary())));
            if (event.willConsumeItem()) {
                this.paymentSlot.remove(1);
            }
            this.access.execute(Level::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    @Override
    public CraftBeaconView getBukkitView() {
        if (this.view != null) {
            return this.view;
        }
        CraftInventoryBeacon inventory = new CraftInventoryBeacon(this.beacon);
        this.view = new CraftBeaconView((HumanEntity)this.inventory.player.getBukkitEntity(), inventory, this);
        return this.view;
    }

    static class PaymentSlot
    extends Slot {
        public PaymentSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return stack.is(ItemTags.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }
}

