/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.craftbukkit.inventory.CraftBlockInventoryHolder;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.inventory.BlockInventoryHolder;

public interface ContainerLevelAccess {
    public static final ContainerLevelAccess NULL = new ContainerLevelAccess(){

        @Override
        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> levelPosConsumer) {
            return Optional.empty();
        }

        @Override
        public Location getLocation() {
            return null;
        }
    };

    public static ContainerLevelAccess create(final Level level, final BlockPos pos) {
        return new ContainerLevelAccess(){

            @Override
            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> levelPosConsumer) {
                return Optional.of(levelPosConsumer.apply(level, pos));
            }

            @Override
            public Level getWorld() {
                return level;
            }

            @Override
            public BlockPos getPosition() {
                return pos;
            }

            @Override
            public boolean isBlock() {
                return true;
            }
        };
    }

    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> var1);

    default public <T> T evaluate(BiFunction<Level, BlockPos, T> levelPosConsumer, T defaultValue) {
        return this.evaluate(levelPosConsumer).orElse(defaultValue);
    }

    default public void execute(BiConsumer<Level, BlockPos> levelPosConsumer) {
        this.evaluate((level, pos) -> {
            levelPosConsumer.accept((Level)level, (BlockPos)pos);
            return Optional.empty();
        });
    }

    default public Level getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPos getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return CraftLocation.toBukkit((Vec3i)this.getPosition(), this.getWorld());
    }

    default public boolean isBlock() {
        return false;
    }

    @Nullable
    default public BlockInventoryHolder createBlockHolder(AbstractContainerMenu menu) {
        if (!this.isBlock()) {
            return null;
        }
        return new CraftBlockInventoryHolder(this, menu.getBukkitView().getTopInventory());
    }
}

