/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import io.papermc.paper.event.player.PlayerPurchaseEvent;
import io.papermc.paper.event.player.PlayerTradeEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import org.bukkit.craftbukkit.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.inventory.CraftMerchantRecipe;
import org.bukkit.entity.Player;
import org.bukkit.inventory.MerchantRecipe;

public class MerchantResultSlot
extends Slot {
    private final MerchantContainer slots;
    private final net.minecraft.world.entity.player.Player player;
    private int removeCount;
    private final Merchant merchant;

    public MerchantResultSlot(net.minecraft.world.entity.player.Player player, Merchant merchant, MerchantContainer slots, int slot, int x, int y) {
        super(slots, slot, x, y);
        this.player = player;
        this.merchant = merchant;
        this.slots = slots;
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    @Override
    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    @Override
    protected void onQuickCraft(ItemStack stack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(stack);
    }

    @Override
    protected void checkTakeAchievements(ItemStack stack) {
        stack.onCraftedBy(this.player, this.removeCount);
        this.removeCount = 0;
    }

    @Override
    public void onTake(net.minecraft.world.entity.player.Player player, ItemStack stack) {
        MerchantOffer activeOffer = this.slots.getActiveOffer();
        PlayerTradeEvent event = null;
        if (activeOffer != null && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Merchant merchant = this.merchant;
            if (merchant instanceof AbstractVillager) {
                AbstractVillager abstractVillager = (AbstractVillager)merchant;
                event = new PlayerTradeEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.entity.AbstractVillager)abstractVillager.getBukkitEntity(), (MerchantRecipe)activeOffer.asBukkit(), true, true);
            } else {
                merchant = this.merchant;
                if (merchant instanceof CraftMerchantCustom.MinecraftMerchant) {
                    CraftMerchantCustom.MinecraftMerchant minecraftMerchant = (CraftMerchantCustom.MinecraftMerchant)merchant;
                    event = new PlayerPurchaseEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.inventory.Merchant)minecraftMerchant.getCraftMerchant(), (MerchantRecipe)activeOffer.asBukkit(), false, true);
                }
            }
            if (event != null) {
                if (!event.callEvent()) {
                    int n;
                    stack.setCount(0);
                    player.containerMenu.sendAllDataToRemote();
                    merchant = this.merchant;
                    if (merchant instanceof Villager) {
                        Villager villager = (Villager)merchant;
                        n = villager.getVillagerData().level();
                    } else {
                        n = 1;
                    }
                    int level = n;
                    serverPlayer.sendMerchantOffers(player.containerMenu.containerId, this.merchant.getOffers(), level, this.merchant.getVillagerXp(), this.merchant.showProgressBar(), this.merchant.canRestock());
                    return;
                }
                activeOffer = CraftMerchantRecipe.fromBukkit(event.getTrade()).toMinecraft();
            }
        }
        this.checkTakeAchievements(stack);
        if (activeOffer != null) {
            ItemStack item1;
            ItemStack item = this.slots.getItem(0);
            if (activeOffer.take(item, item1 = this.slots.getItem(1)) || activeOffer.take(item1, item)) {
                this.merchant.processTrade(activeOffer, (PlayerPurchaseEvent)event);
                player.awardStat(Stats.TRADED_WITH_VILLAGER);
                this.slots.setItem(0, item);
                this.slots.setItem(1, item1);
            }
            this.merchant.overrideXp(this.merchant.getVillagerXp() + activeOffer.getXp());
        }
    }
}

