/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.apache.logging.log4j.LogManager;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.jspecify.annotations.Nullable;

public class BlockItem
extends Item {
    @Deprecated
    private final Block block;

    public BlockItem(Block block, Item.Properties properties) {
        super(properties);
        this.block = block;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        return !interactionResult.consumesAction() && context.getItemInHand().has(DataComponents.CONSUMABLE) ? super.use(context.getLevel(), context.getPlayer(), context.getHand()) : interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        CraftBlockState oldBukkitState;
        if (!this.getBlock().isEnabled(context.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return InteractionResult.FAIL;
        }
        BlockState placementState = this.getPlacementState(blockPlaceContext);
        CraftBlockState bukkitState = null;
        if (this instanceof PlaceOnWaterBlockItem || this instanceof SolidBucketItem) {
            bukkitState = CraftBlockStates.getBlockState(blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos());
        }
        CraftBlockState craftBlockState = oldBukkitState = bukkitState != null ? bukkitState : CraftBlockStates.getBlockState(blockPlaceContext.getLevel(), blockPlaceContext.getClickedPos());
        if (placementState == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockPlaceContext, placementState)) {
            return InteractionResult.FAIL;
        }
        BlockPos clickedPos = blockPlaceContext.getClickedPos();
        Level level = blockPlaceContext.getLevel();
        Player player = blockPlaceContext.getPlayer();
        ItemStack itemInHand = blockPlaceContext.getItemInHand();
        BlockState blockState = level.getBlockState(clickedPos);
        if (blockState.is(placementState.getBlock())) {
            BlockPlaceEvent placeEvent;
            blockState = this.updateBlockStateFromTag(clickedPos, level, itemInHand, blockState);
            try {
                this.updateCustomBlockEntityTag(clickedPos, level, player, itemInHand, blockState);
                BlockItem.updateBlockEntityComponents(level, clickedPos, itemInHand);
            }
            catch (Exception ex) {
                oldBukkitState.revertPlace();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    LogManager.getLogger().error("Player {} tried placing invalid block", (Object)player.getScoreboardName(), (Object)ex);
                    serverPlayer.getBukkitEntity().kickPlayer("Packet processing error");
                    return InteractionResult.FAIL;
                }
                throw ex;
            }
            blockState.getBlock().setPlacedBy(level, clickedPos, blockState, player, itemInHand);
            if (bukkitState != null && (placeEvent = CraftEventFactory.callBlockPlaceEvent((ServerLevel)level, player, blockPlaceContext.getHand(), bukkitState, clickedPos)) != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                bukkitState.revertPlace();
                player.containerMenu.forceHeldSlot(blockPlaceContext.getHand());
                return InteractionResult.FAIL;
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, clickedPos, itemInHand);
            }
        }
        SoundType soundType = blockState.getSoundType();
        if (player == null) {
            level.playSound((Entity)player, clickedPos, this.getPlaceSound(blockState), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        }
        level.gameEvent(GameEvent.BLOCK_PLACE, clickedPos, GameEvent.Context.of(player, blockState));
        itemInHand.consume(1, player);
        return InteractionResult.SUCCESS.configurePaper(e -> e.placedBlockAt(clickedPos.immutable()));
    }

    protected SoundEvent getPlaceSound(BlockState state) {
        return state.getSoundType().getPlaceSound();
    }

    public @Nullable BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    private static void updateBlockEntityComponents(Level level, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            blockEntity.applyComponentsFromItemStack(stack);
            blockEntity.setChanged();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    protected @Nullable BlockState getPlacementState(BlockPlaceContext context) {
        BlockState stateForPlacement = this.getBlock().getStateForPlacement(context);
        return stateForPlacement != null && this.canPlace(context, stateForPlacement) ? stateForPlacement : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level level, ItemStack stack, BlockState state) {
        BlockItemStateProperties blockItemStateProperties = stack.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        if (blockItemStateProperties.isEmpty()) {
            return state;
        }
        BlockState blockState = blockItemStateProperties.apply(state);
        if (blockState != state) {
            level.setBlock(pos, blockState, 2);
        }
        return blockState;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        boolean canBuild = (!this.mustSurvive() || state.canSurvive(world, context.getClickedPos())) && world.checkEntityCollision(state, player, CollisionContext.placementContext(player), context.getClickedPos(), true);
        org.bukkit.entity.Player bukkitPlayer = context.getPlayer() instanceof ServerPlayer ? (org.bukkit.entity.Player)context.getPlayer().getBukkitEntity() : null;
        BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(world, context.getClickedPos()), bukkitPlayer, (BlockData)CraftBlockData.fromData(state), canBuild, CraftEquipmentSlot.getHand(context.getHand()));
        world.getCraftServer().getPluginManager().callEvent((Event)event);
        return event.isBuildable();
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return false;
        }
        TypedEntityData<BlockEntityType<?>> typedEntityData = stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (typedEntityData != null && (blockEntity = level.getBlockEntity(pos)) != null) {
            BlockEntityType<?> type = blockEntity.getType();
            if (type != typedEntityData.type()) {
                return false;
            }
            if (!type.onlyOpCanSetNbt() || player != null && (player.canUseGameMasterBlocks() || player.getAbilities().instabuild && player.getBukkitEntity().hasPermission("minecraft.nbt.place"))) {
                return typedEntityData.loadInto(blockEntity, level.registryAccess());
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack stack, @Nullable Player player) {
        TypedEntityData<BlockEntityType<?>> typedEntityData;
        if (player != null && player.permissions().hasPermission(Permissions.COMMANDS_GAMEMASTER) && (typedEntityData = stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null) {
            return typedEntityData.type().onlyOpCanSetNbt();
        }
        return false;
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> blockToItemMap, Item item) {
        blockToItemMap.put(this.getBlock(), item);
    }

    @Override
    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof ShulkerBoxBlock);
    }

    @Override
    public void onDestroyed(ItemEntity itemEntity) {
        ItemContainerContents itemContainerContents = itemEntity.getItem().set(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        if (itemContainerContents != null) {
            ItemUtils.onContainerDestroyed(itemEntity, itemContainerContents.nonEmptyItemsCopy());
        }
    }

    public static void setBlockEntityData(ItemStack stack, BlockEntityType<?> blockEntityType, TagValueOutput output) {
        output.discard("id");
        if (output.isEmpty()) {
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            BlockEntity.addEntityType(output, blockEntityType);
            stack.set(DataComponents.BLOCK_ENTITY_DATA, TypedEntityData.of(blockEntityType, output.buildResult()));
        }
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }
}

