/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Projectile;

public class FireworkRocketItem
extends Item
implements ProjectileItem {
    public static final byte[] CRAFTABLE_DURATIONS = new byte[]{1, 2, 3};
    public static final double ROCKET_PLACEMENT_OFFSET = 0.15;

    public FireworkRocketItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player != null && player.isFallFlying()) {
            return InteractionResult.PASS;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemInHand = context.getItemInHand();
            Vec3 clickLocation = context.getClickLocation();
            Direction clickedFace = context.getClickedFace();
            Projectile.Delayed<FireworkRocketEntity> fireworkRocketEntity = net.minecraft.world.entity.projectile.Projectile.spawnProjectileDelayed(new FireworkRocketEntity(level, context.getPlayer(), clickLocation.x + (double)clickedFace.getStepX() * 0.15, clickLocation.y + (double)clickedFace.getStepY() * 0.15, clickLocation.z + (double)clickedFace.getStepZ() * 0.15, itemInHand), serverLevel, itemInHand, f -> {
                f.spawningEntity = context.getPlayer() == null ? null : context.getPlayer().getUUID();
            });
            PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)context.getPlayer().getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemInHand), (Projectile)((Firework)fireworkRocketEntity.projectile().getBukkitEntity()));
            if (!event.callEvent() || !fireworkRocketEntity.attemptSpawn()) {
                return InteractionResult.PASS;
            }
            if (event.shouldConsume() && !context.getPlayer().hasInfiniteMaterials()) {
                itemInHand.shrink(1);
            } else {
                context.getPlayer().containerMenu.forceHeldSlot(context.getHand());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (player.isFallFlying()) {
            ItemStack itemInHand = player.getItemInHand(hand);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Projectile.Delayed<FireworkRocketEntity> delayed = net.minecraft.world.entity.projectile.Projectile.spawnProjectileDelayed(new FireworkRocketEntity(level, itemInHand, player), serverLevel, itemInHand, f -> {
                    f.spawningEntity = player.getUUID();
                });
                PlayerElytraBoostEvent event = new PlayerElytraBoostEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(itemInHand), (Firework)delayed.projectile().getBukkitEntity(), CraftEquipmentSlot.getHand(hand));
                if (event.callEvent() && delayed.attemptSpawn()) {
                    player.awardStat(Stats.ITEM_USED.get(this));
                    if (player.dropAllLeashConnections(null)) {
                        level.playSound(null, player, SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    if (event.shouldConsume() && !player.hasInfiniteMaterials()) {
                        itemInHand.shrink(1);
                    } else {
                        player.containerMenu.forceHeldSlot(hand);
                    }
                } else {
                    player.containerMenu.forceHeldSlot(hand);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new FireworkRocketEntity(level, stack.copyWithCount(1), pos.x(), pos.y(), pos.z(), true);
    }

    @Override
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().positionFunction(FireworkRocketItem::getEntityJustOutsideOfBlockPos).uncertainty(1.0f).power(0.5f).overrideDispenseEvent(1004).build();
    }

    private static Vec3 getEntityJustOutsideOfBlockPos(BlockSource blockSource, Direction direction) {
        return blockSource.center().add((double)direction.getStepX() * 0.5000099999997474, (double)direction.getStepY() * 0.5000099999997474, (double)direction.getStepZ() * 0.5000099999997474);
    }
}

