/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class LeadItem
extends Item {
    public LeadItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(clickedPos = context.getClickedPos());
        if (blockState.is(BlockTags.FENCES)) {
            Player player = context.getPlayer();
            if (!level.isClientSide() && player != null) {
                return LeadItem.bindPlayerMobs(player, level, clickedPos, context.getHand());
            }
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player player, Level level, BlockPos pos, InteractionHand interactionHand) {
        Entity leashFenceKnotEntity = null;
        List<Leashable> list = Leashable.leashableInArea(level, Vec3.atCenterOf(pos), leashable1 -> leashable1.getLeashHolder() == player);
        boolean flag = false;
        for (Leashable leashable : list) {
            if (leashFenceKnotEntity == null) {
                MutableBoolean created = new MutableBoolean(false);
                leashFenceKnotEntity = LeashFenceKnotEntity.getOrCreateKnot(level, pos, created);
                if (created.booleanValue()) {
                    EquipmentSlot hand = CraftEquipmentSlot.getHand(interactionHand);
                    HangingPlaceEvent event = new HangingPlaceEvent((Hanging)leashFenceKnotEntity.getBukkitEntity(), player != null ? (org.bukkit.entity.Player)player.getBukkitEntity() : null, (Block)CraftBlock.at(level, pos), BlockFace.SELF, hand);
                    level.getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        leashFenceKnotEntity.discard(null);
                        return InteractionResult.PASS;
                    }
                }
                ((LeashFenceKnotEntity)leashFenceKnotEntity).playPlacementSound();
            }
            if (!leashable.canHaveALeashAttachedTo(leashFenceKnotEntity) || !CraftEventFactory.handlePlayerLeashEntityEvent(leashable, leashFenceKnotEntity, player, interactionHand)) continue;
            leashable.setLeashedTo(leashFenceKnotEntity, true);
            flag = true;
        }
        if (flag) {
            level.gameEvent(GameEvent.BLOCK_ATTACH, pos, GameEvent.Context.of(player));
            return InteractionResult.SUCCESS_SERVER;
        }
        if (leashFenceKnotEntity != null) {
            leashFenceKnotEntity.discard(null);
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult bindPlayerMobs(Player player, Level world, BlockPos pos) {
        return LeadItem.bindPlayerMobs(player, world, pos, InteractionHand.MAIN_HAND);
    }
}

