/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.projectile.arrow.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.Projectile;

public class TridentItem
extends Item
implements ProjectileItem {
    public static final int THROW_THRESHOLD_TIME = 10;
    public static final float BASE_DAMAGE = 8.0f;
    public static final float PROJECTILE_SHOOT_POWER = 2.5f;

    public TridentItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 8.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.9f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 2, false);
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.TRIDENT;
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - timeLeft;
            if (i < 10) {
                return false;
            }
            float tridentSpinAttackStrength = EnchantmentHelper.getTridentSpinAttackStrength(stack, player);
            if (tridentSpinAttackStrength > 0.0f && !player.isInWaterOrRain()) {
                return false;
            }
            if (stack.nextDamageWillBreak()) {
                return false;
            }
            Holder<SoundEvent> holder = EnchantmentHelper.pickHighestLevel(stack, EnchantmentEffectComponents.TRIDENT_SOUND).orElse(SoundEvents.TRIDENT_THROW);
            player.awardStat(Stats.ITEM_USED.get(this));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (tridentSpinAttackStrength == 0.0f) {
                    ItemStack itemStack = stack.copyWithCount(1);
                    Projectile.Delayed<ThrownTrident> tridentDelayed = net.minecraft.world.entity.projectile.Projectile.spawnProjectileFromRotationDelayed(ThrownTrident::new, serverLevel, itemStack, player, 0.0f, 2.5f, 1.0f);
                    PlayerLaunchProjectileEvent event = new PlayerLaunchProjectileEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(stack), (Projectile)tridentDelayed.projectile().getBukkitEntity());
                    if (!event.callEvent() || !tridentDelayed.attemptSpawn()) {
                        return false;
                    }
                    ThrownTrident thrownTrident = tridentDelayed.projectile();
                    if (event.shouldConsume()) {
                        itemStack.hurtWithoutBreaking(1, player);
                    }
                    thrownTrident.pickupItemStack = itemStack.copy();
                    if (event.shouldConsume()) {
                        stack.consume(1, player);
                    }
                    if (player.hasInfiniteMaterials()) {
                        thrownTrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    level.playSound(null, thrownTrident, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return true;
                }
                stack.hurtWithoutBreaking(1, player);
            }
            if (tridentSpinAttackStrength > 0.0f) {
                float squareRoot;
                float yRot = player.getYRot();
                float xRot = player.getXRot();
                float f = -Mth.sin(yRot * ((float)Math.PI / 180)) * Mth.cos(xRot * ((float)Math.PI / 180));
                float f1 = -Mth.sin(xRot * ((float)Math.PI / 180));
                float f2 = Mth.cos(yRot * ((float)Math.PI / 180)) * Mth.cos(xRot * ((float)Math.PI / 180));
                if (!CraftEventFactory.callPlayerRiptideEvent(player, stack, f *= tridentSpinAttackStrength / (squareRoot = Mth.sqrt(f * f + f1 * f1 + f2 * f2)), f1 *= tridentSpinAttackStrength / squareRoot, f2 *= tridentSpinAttackStrength / squareRoot)) {
                    return false;
                }
                player.push(f, f1, f2);
                player.startAutoSpinAttack(20, 8.0f, stack);
                if (player.onGround()) {
                    float f3 = 1.1999999f;
                    player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                level.playSound(null, player, holder.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.nextDamageWillBreak()) {
            return InteractionResult.FAIL;
        }
        if (EnchantmentHelper.getTridentSpinAttackStrength(itemInHand, player) > 0.0f && !player.isInWaterOrRain()) {
            return InteractionResult.FAIL;
        }
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    @Override
    public net.minecraft.world.entity.projectile.Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        ThrownTrident thrownTrident = new ThrownTrident(level, pos.x(), pos.y(), pos.z(), stack.copyWithCount(1));
        thrownTrident.pickup = AbstractArrow.Pickup.ALLOWED;
        return thrownTrident;
    }
}

