/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public final class TypedEntityData<IdType>
implements TooltipProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TYPE_TAG = "id";
    final IdType type;
    final CompoundTag tag;

    public static <T> Codec<TypedEntityData<T>> codec(final Codec<T> idCodec) {
        return new Codec<TypedEntityData<T>>(){

            public <V> DataResult<Pair<TypedEntityData<T>, V>> decode(DynamicOps<V> ops, V input) {
                return CustomData.COMPOUND_TAG_CODEC.decode(ops, input).flatMap(pair -> {
                    CompoundTag compoundTag = ((CompoundTag)pair.getFirst()).copy();
                    Tag tag = compoundTag.remove(TypedEntityData.TYPE_TAG);
                    return tag == null ? DataResult.error(() -> "Expected 'id' field in " + String.valueOf(input)) : idCodec.parse(1.asNbtOps(ops), (Object)tag).map(object1 -> Pair.of(new TypedEntityData<Object>(object1, compoundTag), (Object)pair.getSecond()));
                });
            }

            public <V> DataResult<V> encode(TypedEntityData<T> input, DynamicOps<V> ops, V prefix) {
                return idCodec.encodeStart(1.asNbtOps(ops), input.type).flatMap(tag -> {
                    CompoundTag compoundTag = input.tag.copy();
                    compoundTag.put(TypedEntityData.TYPE_TAG, (Tag)tag);
                    return CustomData.COMPOUND_TAG_CODEC.encode((Object)compoundTag, ops, prefix);
                });
            }

            private static <T> DynamicOps<Tag> asNbtOps(DynamicOps<T> ops) {
                Object object;
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    object = registryOps.withParent(NbtOps.INSTANCE);
                } else {
                    object = NbtOps.INSTANCE;
                }
                return object;
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, TypedEntityData<T>> streamCodec(StreamCodec<B, T> idCodec) {
        return StreamCodec.composite(idCodec, TypedEntityData::type, ByteBufCodecs.COMPOUND_TAG, TypedEntityData::tag, TypedEntityData::new);
    }

    TypedEntityData(IdType type, CompoundTag tag) {
        this.type = type;
        this.tag = TypedEntityData.stripId(tag);
    }

    public static <IdType> TypedEntityData<IdType> decode(Codec<IdType> idTypeCodec, CompoundTag tag) {
        return (TypedEntityData)((Pair)TypedEntityData.codec(idTypeCodec).decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().orElseThrow()).getFirst();
    }

    public static TypedEntityData<EntityType<?>> decodeEntity(CompoundTag tag) {
        return TypedEntityData.decode(EntityType.CODEC, tag);
    }

    public static TypedEntityData<BlockEntityType<?>> decodeBlockEntity(CompoundTag tag) {
        return TypedEntityData.decode(BuiltInRegistries.BLOCK_ENTITY_TYPE.byNameCodec(), tag);
    }

    public CompoundTag copyTagWithEntityId() {
        CompoundTag tag = this.tag.copy();
        tag.putString(TYPE_TAG, EntityType.getKey((EntityType)this.type).toString());
        return tag;
    }

    public CompoundTag copyTagWithBlockEntityId() {
        CompoundTag tag = this.tag.copy();
        tag.putString(TYPE_TAG, BlockEntityType.getKey((BlockEntityType)this.type).toString());
        return tag;
    }

    public static <T> TypedEntityData<T> of(T type, CompoundTag tag) {
        return new TypedEntityData<T>(type, tag);
    }

    private static CompoundTag stripId(CompoundTag tag) {
        if (tag.contains(TYPE_TAG)) {
            CompoundTag compoundTag = tag.copy();
            compoundTag.remove(TYPE_TAG);
            return compoundTag;
        }
        return tag;
    }

    public IdType type() {
        return this.type;
    }

    public boolean contains(String key) {
        return this.tag.contains(key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == this) return true;
        if (!(other instanceof TypedEntityData)) return false;
        TypedEntityData typedEntityData = (TypedEntityData)other;
        if (this.type != typedEntityData.type) return false;
        if (!this.tag.equals(typedEntityData.tag)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.tag.hashCode();
    }

    public String toString() {
        return String.valueOf(this.type) + " " + String.valueOf(this.tag);
    }

    public void loadInto(Entity entity) {
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, entity.registryAccess());
            entity.saveWithoutId(tagValueOutput);
            CompoundTag compoundTag = tagValueOutput.buildResult();
            UUID uuid = entity.getUUID();
            compoundTag.merge(this.getUnsafe());
            entity.load(TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)entity.registryAccess(), compoundTag));
            entity.setUUID(uuid);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean loadInto(BlockEntity blockEntity, HolderLookup.Provider registries) {
        scopedCollector = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), TypedEntityData.LOGGER);
        try {
            tagValueOutput = TagValueOutput.createWithContext(scopedCollector, registries);
            blockEntity.saveCustomOnly(tagValueOutput);
            compoundTag = tagValueOutput.buildResult();
            compoundTag1 = compoundTag.copy();
            compoundTag.merge(this.getUnsafe());
            if (compoundTag.equals(compoundTag1)) ** GOTO lbl23
            try {
                blockEntity.loadCustomOnly(TagValueInput.create((ProblemReporter)scopedCollector, registries, compoundTag));
                blockEntity.setChanged();
                var8_9 = true;
                return var8_9;
            }
            catch (Exception var11) {
                TypedEntityData.LOGGER.warn("Failed to apply custom data to block entity at {}", (Object)blockEntity.getBlockPos(), (Object)var11);
                try {
                    blockEntity.loadCustomOnly(TagValueInput.create(scopedCollector.forChild((ProblemReporter.PathElement)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/String;, lambda$loadInto$0(), ()Ljava/lang/String;)()), registries, compoundTag1));
                }
                catch (Exception var10) {
                    TypedEntityData.LOGGER.warn("Failed to rollback block entity at {} after failure", (Object)blockEntity.getBlockPos(), (Object)var10);
                }
lbl23:
                // 3 sources

                exception = false;
            }
        }
        finally {
            scopedCollector.close();
        }
        return exception;
    }

    private CompoundTag tag() {
        return this.tag;
    }

    @Deprecated
    public CompoundTag getUnsafe() {
        return this.tag;
    }

    public CompoundTag copyTagWithoutId() {
        return this.tag.copy();
    }

    @Override
    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltipAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        if (this.type.getClass() == EntityType.class) {
            EntityType entityType = (EntityType)this.type;
            if (context.isPeaceful() && !entityType.isTypeAllowedInPeaceful()) {
                tooltipAdder.accept(Component.translatable("item.spawn_egg.peaceful").withStyle(ChatFormatting.RED));
            }
        }
    }

    private static /* synthetic */ String lambda$loadInto$0() {
        return "(rollback)";
    }
}

