/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkRocketRecipe
extends CustomRecipe {
    private static final Ingredient PAPER_INGREDIENT = Ingredient.of((ItemLike)Items.PAPER);
    private static final Ingredient GUNPOWDER_INGREDIENT = Ingredient.of((ItemLike)Items.GUNPOWDER);
    private static final Ingredient STAR_INGREDIENT = Ingredient.of((ItemLike)Items.FIREWORK_STAR);

    public FireworkRocketRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() < 2) {
            return false;
        }
        boolean flag = false;
        int i = 0;
        for (int i1 = 0; i1 < input.size(); ++i1) {
            ItemStack item = input.getItem(i1);
            if (item.isEmpty()) continue;
            if (PAPER_INGREDIENT.test(item)) {
                if (flag) {
                    return false;
                }
                flag = true;
                continue;
            }
            if (!(GUNPOWDER_INGREDIENT.test(item) ? ++i > 3 : !STAR_INGREDIENT.test(item))) continue;
            return false;
        }
        return flag && i >= 1;
    }

    @Override
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ArrayList<FireworkExplosion> list = new ArrayList<FireworkExplosion>();
        int i = 0;
        for (int i1 = 0; i1 < input.size(); ++i1) {
            FireworkExplosion fireworkExplosion;
            ItemStack item = input.getItem(i1);
            if (item.isEmpty()) continue;
            if (GUNPOWDER_INGREDIENT.test(item)) {
                ++i;
                continue;
            }
            if (!STAR_INGREDIENT.test(item) || (fireworkExplosion = item.get(DataComponents.FIREWORK_EXPLOSION)) == null) continue;
            list.add(fireworkExplosion);
        }
        ItemStack itemStack = new ItemStack(Items.FIREWORK_ROCKET, 3);
        itemStack.set(DataComponents.FIREWORKS, new Fireworks(i, list));
        return itemStack;
    }

    @Override
    public RecipeSerializer<FireworkRocketRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_ROCKET;
    }
}

