/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityExhaustionEvent;

public record ApplyExhaustion(LevelBasedValue amount) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyExhaustion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(ApplyExhaustion::amount)).apply((Applicative)instance, ApplyExhaustion::new));

    @Override
    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 origin) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.causeFoodExhaustion(this.amount.calculate(enchantmentLevel), EntityExhaustionEvent.ExhaustionReason.ENCHANTMENT_EFFECT);
        }
    }

    public MapCodec<ApplyExhaustion> codec() {
        return CODEC;
    }
}

