/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;

public interface SlotCollection {
    public static final SlotCollection EMPTY = Stream::empty;

    public Stream<ItemStack> itemCopies();

    default public SlotCollection filter(Predicate<ItemStack> filter) {
        return new Filtered(this, filter);
    }

    default public SlotCollection flatMap(Function<ItemStack, ? extends SlotCollection> mapper) {
        return new FlatMapped(this, mapper);
    }

    default public SlotCollection limit(int limit) {
        return new Limited(this, limit);
    }

    public static SlotCollection of(SlotAccess access) {
        return () -> Stream.of(access.get().copy());
    }

    public static SlotCollection of(Collection<? extends SlotAccess> slots) {
        return switch (slots.size()) {
            case 0 -> EMPTY;
            case 1 -> SlotCollection.of(slots.iterator().next());
            default -> () -> slots.stream().map(SlotAccess::get).map(ItemStack::copy);
        };
    }

    public static SlotCollection concat(SlotCollection slots1, SlotCollection slots2) {
        return () -> Stream.concat(slots1.itemCopies(), slots2.itemCopies());
    }

    public static SlotCollection concat(List<? extends SlotCollection> slots) {
        return switch (slots.size()) {
            case 0 -> EMPTY;
            case 1 -> slots.getFirst();
            case 2 -> SlotCollection.concat(slots.get(0), slots.get(1));
            default -> () -> slots.stream().flatMap(SlotCollection::itemCopies);
        };
    }

    public record Filtered(SlotCollection slots, Predicate<ItemStack> filter) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().filter(this.filter);
        }

        @Override
        public SlotCollection filter(Predicate<ItemStack> filter) {
            return new Filtered(this.slots, this.filter.and(filter));
        }
    }

    public record FlatMapped(SlotCollection slots, Function<ItemStack, ? extends SlotCollection> mapper) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().map(this.mapper).flatMap(SlotCollection::itemCopies);
        }
    }

    public record Limited(SlotCollection slots, int limit) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().limit(this.limit);
        }

        @Override
        public SlotCollection limit(int limit) {
            return new Limited(this.slots, Math.min(this.limit, limit));
        }
    }
}

