/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import io.papermc.paper.event.player.PlayerPurchaseEvent;
import java.util.OptionalInt;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.bukkit.craftbukkit.inventory.CraftMerchant;
import org.jspecify.annotations.Nullable;

public interface Merchant {
    public void setTradingPlayer(@Nullable Player var1);

    public @Nullable Player getTradingPlayer();

    public MerchantOffers getOffers();

    public void overrideOffers(MerchantOffers var1);

    default public void processTrade(MerchantOffer offer, @Nullable PlayerPurchaseEvent event) {
        this.notifyTrade(offer);
    }

    public void notifyTrade(MerchantOffer var1);

    public void notifyTradeUpdated(ItemStack var1);

    public int getVillagerXp();

    public void overrideXp(int var1);

    public boolean showProgressBar();

    public SoundEvent getNotifyTradeSound();

    default public boolean canRestock() {
        return false;
    }

    default public void openTradingScreen(Player player, Component displayName, int level) {
        MerchantOffers offers;
        OptionalInt optionalInt = player.openMenu(new SimpleMenuProvider((containerId, inventory, player1) -> new MerchantMenu(containerId, inventory, this), displayName));
        if (optionalInt.isPresent() && !(offers = this.getOffers()).isEmpty()) {
            player.sendMerchantOffers(optionalInt.getAsInt(), offers, level, this.getVillagerXp(), this.showProgressBar(), this.canRestock());
        }
    }

    public boolean isClientSide();

    public boolean stillValid(Player var1);

    public CraftMerchant getCraftMerchant();
}

