/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jspecify.annotations.Nullable;

public class MerchantOffers
extends ArrayList<MerchantOffer> {
    public static final Codec<MerchantOffers> CODEC = MerchantOffer.CODEC.listOf().optionalFieldOf("Recipes", List.of()).xmap(MerchantOffers::new, Function.identity()).codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantOffers> STREAM_CODEC = MerchantOffer.STREAM_CODEC.apply(ByteBufCodecs.collection(MerchantOffers::new));

    public MerchantOffers() {
    }

    private MerchantOffers(int size) {
        super(size);
    }

    private MerchantOffers(Collection<MerchantOffer> offers) {
        super(offers);
    }

    public @Nullable MerchantOffer getRecipeFor(ItemStack stackA, ItemStack stackB, int index) {
        if (index > 0 && index < this.size()) {
            MerchantOffer merchantOffer = (MerchantOffer)this.get(index);
            return merchantOffer.satisfiedBy(stackA, stackB) ? merchantOffer : null;
        }
        for (int i = 0; i < this.size(); ++i) {
            MerchantOffer merchantOffer1 = (MerchantOffer)this.get(i);
            if (!merchantOffer1.satisfiedBy(stackA, stackB)) continue;
            return merchantOffer1;
        }
        return null;
    }

    public MerchantOffers copy() {
        MerchantOffers list = new MerchantOffers(this.size());
        for (MerchantOffer merchantOffer : this) {
            list.add(merchantOffer.copy());
        }
        return list;
    }
}

