/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import alternate.current.wire.WireHandler;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.ThreadUnsafeRandom;
import ca.spottedleaf.moonrise.common.util.TickThread;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.ChunkSystemLevel;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkData;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.dfl.DefaultEntityLookup;
import ca.spottedleaf.moonrise.patches.chunk_system.world.ChunkSystemEntityGetter;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.destroystokyo.paper.event.block.BlockDestroyEvent;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.papermc.paper.antixray.ChunkPacketBlockController;
import io.papermc.paper.antixray.ChunkPacketBlockControllerAntiXray;
import io.papermc.paper.configuration.WorldConfiguration;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.attribute.EnvironmentAttributeSystem;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.CollectingNeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.block.CapturedBlockState;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.util.CraftSpawnCategory;
import org.bukkit.entity.Entity;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotWorldConfig;

public abstract class Level
implements LevelAccessor,
AutoCloseable,
ChunkSystemLevel,
ChunkSystemEntityGetter {
    public static final Codec<ResourceKey<Level>> RESOURCE_KEY_CODEC = ResourceKey.codec(Registries.DIMENSION);
    public static final ResourceKey<Level> OVERWORLD = ResourceKey.create(Registries.DIMENSION, Identifier.withDefaultNamespace("overworld"));
    public static final ResourceKey<Level> NETHER = ResourceKey.create(Registries.DIMENSION, Identifier.withDefaultNamespace("the_nether"));
    public static final ResourceKey<Level> END = ResourceKey.create(Registries.DIMENSION, Identifier.withDefaultNamespace("the_end"));
    public static final int MAX_LEVEL_SIZE = 30000000;
    public static final int LONG_PARTICLE_CLIP_RANGE = 512;
    public static final int SHORT_PARTICLE_CLIP_RANGE = 32;
    public static final int MAX_BRIGHTNESS = 15;
    public static final int MAX_ENTITY_SPAWN_Y = 20000000;
    public static final int MIN_ENTITY_SPAWN_Y = -20000000;
    public static final WeightedList<ExplosionParticleInfo> DEFAULT_EXPLOSION_BLOCK_PARTICLES = WeightedList.builder().add(new ExplosionParticleInfo(ParticleTypes.POOF, 0.5f, 1.0f)).add(new ExplosionParticleInfo(ParticleTypes.SMOKE, 1.0f, 1.0f)).build();
    public final List<TickingBlockEntity> blockEntityTickers = Lists.newArrayList();
    protected final CollectingNeighborUpdater neighborUpdater;
    private final List<TickingBlockEntity> pendingBlockEntityTickers = Lists.newArrayList();
    private boolean tickingBlockEntities;
    public final Thread thread;
    private final boolean isDebug;
    private int skyDarken;
    protected int randValue = RandomSource.create().nextInt();
    protected final int addend = 1013904223;
    protected float oRainLevel;
    public float rainLevel;
    protected float oThunderLevel;
    public float thunderLevel;
    public final RandomSource random = new ThreadUnsafeRandom(RandomSupport.generateUniqueSeed());
    @Deprecated
    private final RandomSource threadSafeRandom = RandomSource.createThreadSafe();
    private final Holder<DimensionType> dimensionTypeRegistration;
    public final WritableLevelData levelData;
    private final boolean isClientSide;
    private final BiomeManager biomeManager;
    private final ResourceKey<Level> dimension;
    private final RegistryAccess registryAccess;
    private final DamageSources damageSources;
    private final PalettedContainerFactory palettedContainerFactory;
    private long subTickCount;
    public final ChunkPacketBlockController chunkPacketBlockController;
    private final CraftWorld world;
    public @Nullable ChunkGenerator generator;
    public boolean captureBlockStates = false;
    public boolean captureTreeGeneration = false;
    public Map<BlockPos, CraftBlockState> capturedBlockStates = new LinkedHashMap<BlockPos, CraftBlockState>();
    public Map<BlockPos, BlockEntity> capturedTileEntities = new LinkedHashMap<BlockPos, BlockEntity>();
    public @Nullable List<ItemEntity> captureDrops;
    public final Object2LongOpenHashMap<SpawnCategory> ticksPerSpawnCategory = new Object2LongOpenHashMap();
    public int wakeupInactiveRemainingAnimals;
    public int wakeupInactiveRemainingFlying;
    public int wakeupInactiveRemainingMonsters;
    public int wakeupInactiveRemainingVillagers;
    public boolean populating;
    public final SpigotWorldConfig spigotConfig;
    private final WorldConfiguration paperConfig;
    public static @Nullable BlockPos lastPhysicsProblem;
    private int tileTickPosition;
    public final Map<ServerExplosion.CacheKey, Float> explosionDensityCache = new HashMap<ServerExplosion.CacheKey, Float>();
    public ArrayDeque<RedstoneTorchBlock.Toggle> redstoneUpdateInfos;
    private EntityLookup entityLookup;
    private final ConcurrentLong2ReferenceChainedHashTable<ChunkData> chunkData = new ConcurrentLong2ReferenceChainedHashTable();
    private static final FluidState AIR_FLUIDSTATE;
    private final int minY;
    private final int height;
    private final int maxY;
    private final int minSectionY;
    private final int maxSectionY;
    private final int sectionsCount;

    public WorldConfiguration paperConfig() {
        return this.paperConfig;
    }

    public CraftWorld getWorld() {
        return this.world;
    }

    public CraftServer getCraftServer() {
        return (CraftServer)Bukkit.getServer();
    }

    @Override
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.getChunkIfLoaded(chunkX, chunkZ) != null;
    }

    private int getTicksPerSpawn(SpawnCategory spawnCategory) {
        int perWorld = this.paperConfig().entities.spawning.ticksPerSpawn.getInt((Object)CraftSpawnCategory.toNMS(spawnCategory));
        if (perWorld >= 0) {
            return perWorld;
        }
        return this.getCraftServer().getTicksPerSpawns(spawnCategory);
    }

    public abstract ResourceKey<LevelStem> getTypeKey();

    @Override
    public final EntityLookup moonrise$getEntityLookup() {
        return this.entityLookup;
    }

    @Override
    public final void moonrise$setEntityLookup(EntityLookup entityLookup) {
        if (this.entityLookup != null && !(this.entityLookup instanceof DefaultEntityLookup)) {
            throw new IllegalStateException("Entity lookup already initialised");
        }
        this.entityLookup = entityLookup;
    }

    @Override
    public final <T extends net.minecraft.world.entity.Entity> List<T> getEntitiesOfClass(Class<T> entityClass, AABB boundingBox, Predicate<? super T> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList ret = new ArrayList();
        this.moonrise$getEntityLookup().getEntities(entityClass, null, boundingBox, ret, predicate);
        return ret;
    }

    @Override
    public final List<net.minecraft.world.entity.Entity> moonrise$getHardCollidingEntities(net.minecraft.world.entity.Entity entity, AABB box, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getHardCollidingEntities(entity, box, ret, predicate);
        return ret;
    }

    @Override
    public LevelChunk moonrise$getFullChunkIfLoaded(int chunkX, int chunkZ) {
        return (LevelChunk)this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
    }

    @Override
    public ChunkAccess moonrise$getAnyChunkIfLoaded(int chunkX, int chunkZ) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.EMPTY, false);
    }

    @Override
    public ChunkAccess moonrise$getSpecificChunkIfLoaded(int chunkX, int chunkZ, ChunkStatus leastStatus) {
        return this.getChunkSource().getChunk(chunkX, chunkZ, leastStatus, false);
    }

    @Override
    public void moonrise$midTickTasks() {
    }

    @Override
    public final ChunkData moonrise$getChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.get(chunkKey);
    }

    @Override
    public final ChunkData moonrise$getChunkData(int chunkX, int chunkZ) {
        return (ChunkData)this.chunkData.get(CoordinateUtils.getChunkKey(chunkX, chunkZ));
    }

    @Override
    public final ChunkData moonrise$requestChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.compute(chunkKey, (keyInMap, valueInMap) -> {
            if (valueInMap == null) {
                ChunkData ret = new ChunkData();
                ret.increaseRef();
                return ret;
            }
            valueInMap.increaseRef();
            return valueInMap;
        });
    }

    @Override
    public final ChunkData moonrise$releaseChunkData(long chunkKey) {
        return (ChunkData)this.chunkData.compute(chunkKey, (keyInMap, chunkData) -> chunkData.decreaseRef() == 0 ? null : chunkData);
    }

    @Override
    public boolean moonrise$areChunksLoaded(int fromX, int fromZ, int toX, int toZ) {
        ChunkSource chunkSource = this.getChunkSource();
        for (int currZ = fromZ; currZ <= toZ; ++currZ) {
            for (int currX = fromX; currX <= toX; ++currX) {
                if (chunkSource.hasChunk(currX, currZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasChunksAt(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.moonrise$areChunksLoaded(minBlockX >> 4, minBlockZ >> 4, maxBlockX >> 4, maxBlockZ >> 4);
    }

    @Override
    public ChunkAccess getChunk(int x, int z, ChunkStatus status) {
        return this.getChunk(x, z, status, true);
    }

    @Override
    public BlockPos getHeightmapPos(Heightmap.Types types, BlockPos blockPos) {
        return new BlockPos(blockPos.getX(), this.getHeight(types, blockPos.getX(), blockPos.getZ()), blockPos.getZ());
    }

    @Override
    public boolean isUnobstructed(net.minecraft.world.entity.Entity entity) {
        AABB boundingBox = entity.getBoundingBox();
        if (CollisionUtil.isEmpty(boundingBox)) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.getEntities(entity, boundingBox.inflate(-1.0E-7, -1.0E-7, -1.0E-7), null);
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            net.minecraft.world.entity.Entity otherEntity = entities.get(i);
            if (otherEntity.isSpectator() || otherEntity.isRemoved() || !otherEntity.blocksBuilding || otherEntity.isPassengerOfSameVehicle(entity)) continue;
            return false;
        }
        return true;
    }

    private static BlockHitResult miss(ClipContext clipContext) {
        Vec3 to = clipContext.getTo();
        Vec3 from = clipContext.getFrom();
        return BlockHitResult.miss(to, Direction.getApproximateNearest(from.x - to.x, from.y - to.y, from.z - to.z), BlockPos.containing(to.x, to.y, to.z));
    }

    private static BlockHitResult fastClip(Vec3 from, Vec3 to, Level level, ClipContext clipContext) {
        double adjX = 1.0E-7 * (from.x - to.x);
        double adjY = 1.0E-7 * (from.y - to.y);
        double adjZ = 1.0E-7 * (from.z - to.z);
        if (adjX == 0.0 && adjY == 0.0 && adjZ == 0.0) {
            return Level.miss(clipContext);
        }
        double toXAdj = to.x - adjX;
        double toYAdj = to.y - adjY;
        double toZAdj = to.z - adjZ;
        double fromXAdj = from.x + adjX;
        double fromYAdj = from.y + adjY;
        double fromZAdj = from.z + adjZ;
        int currX = Mth.floor(fromXAdj);
        int currY = Mth.floor(fromYAdj);
        int currZ = Mth.floor(fromZAdj);
        BlockPos.MutableBlockPos currPos = new BlockPos.MutableBlockPos();
        double diffX = toXAdj - fromXAdj;
        double diffY = toYAdj - fromYAdj;
        double diffZ = toZAdj - fromZAdj;
        double dxDouble = Math.signum(diffX);
        double dyDouble = Math.signum(diffY);
        double dzDouble = Math.signum(diffZ);
        int dx = (int)dxDouble;
        int dy = (int)dyDouble;
        int dz = (int)dzDouble;
        double normalizedDiffX = diffX == 0.0 ? Double.MAX_VALUE : dxDouble / diffX;
        double normalizedDiffY = diffY == 0.0 ? Double.MAX_VALUE : dyDouble / diffY;
        double normalizedDiffZ = diffZ == 0.0 ? Double.MAX_VALUE : dzDouble / diffZ;
        double normalizedCurrX = normalizedDiffX * (diffX > 0.0 ? 1.0 - Mth.frac(fromXAdj) : Mth.frac(fromXAdj));
        double normalizedCurrY = normalizedDiffY * (diffY > 0.0 ? 1.0 - Mth.frac(fromYAdj) : Mth.frac(fromYAdj));
        double normalizedCurrZ = normalizedDiffZ * (diffZ > 0.0 ? 1.0 - Mth.frac(fromZAdj) : Mth.frac(fromZAdj));
        LevelChunkSection[] lastChunk = null;
        PalettedContainer<BlockState> lastSection = null;
        int lastChunkX = Integer.MIN_VALUE;
        int lastChunkY = Integer.MIN_VALUE;
        int lastChunkZ = Integer.MIN_VALUE;
        int minSection = WorldUtil.getMinSection(level);
        while (true) {
            BlockState blockState;
            currPos.set(currX, currY, currZ);
            int newChunkX = currX >> 4;
            int newChunkY = currY >> 4;
            int newChunkZ = currZ >> 4;
            int chunkDiff = newChunkX ^ lastChunkX | newChunkZ ^ lastChunkZ;
            int chunkYDiff = newChunkY ^ lastChunkY;
            if ((chunkDiff | chunkYDiff) != 0) {
                int sectionY;
                if (chunkDiff != 0) {
                    lastChunk = level.getChunk(newChunkX, newChunkZ).getSections();
                }
                lastSection = (sectionY = newChunkY - minSection) >= 0 && sectionY < lastChunk.length ? lastChunk[sectionY].states : null;
                lastChunkX = newChunkX;
                lastChunkY = newChunkY;
                lastChunkZ = newChunkZ;
            }
            if (lastSection != null && !(blockState = lastSection.get(currX & 0xF | (currZ & 0xF) << 4 | (currY & 0xF) << 8)).isAir()) {
                VoxelShape fluidCollision;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockHitResult blockHit;
                VoxelShape blockCollision = clipContext.getBlockShape(blockState, level, currPos);
                BlockHitResult blockHitResult = blockHit = blockCollision.isEmpty() ? null : level.clipWithInteractionOverride(from, to, currPos, blockCollision, blockState);
                if (clipContext.fluid != ClipContext.Fluid.NONE && (fluidState = blockState.getFluidState()) != AIR_FLUIDSTATE && (fluidHit = (fluidCollision = clipContext.getFluidShape(fluidState, level, currPos)).clip(from, to, currPos)) != null) {
                    if (blockHit == null) {
                        return fluidHit;
                    }
                    return from.distanceToSqr(blockHit.getLocation()) <= from.distanceToSqr(fluidHit.getLocation()) ? blockHit : fluidHit;
                }
                if (blockHit != null) {
                    return blockHit;
                }
            }
            if (normalizedCurrX > 1.0 && normalizedCurrY > 1.0 && normalizedCurrZ > 1.0) {
                return Level.miss(clipContext);
            }
            if (normalizedCurrX < normalizedCurrY) {
                if (normalizedCurrX < normalizedCurrZ) {
                    currX += dx;
                    normalizedCurrX += normalizedDiffX;
                    continue;
                }
                currZ += dz;
                normalizedCurrZ += normalizedDiffZ;
                continue;
            }
            if (normalizedCurrY < normalizedCurrZ) {
                currY += dy;
                normalizedCurrY += normalizedDiffY;
                continue;
            }
            currZ += dz;
            normalizedCurrZ += normalizedDiffZ;
        }
    }

    @Override
    public BlockHitResult clip(ClipContext clipContext) {
        return Level.fastClip(clipContext.getFrom(), clipContext.getTo(), this, clipContext);
    }

    @Override
    public boolean collidesWithSuffocatingBlock(net.minecraft.world.entity.Entity entity, AABB box) {
        return CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, 8, (state, pos) -> state.isSuffocating(this, (BlockPos)pos));
    }

    private static VoxelShape inflateAABBToVoxel(AABB aabb, double x, double y, double z) {
        return Shapes.create(aabb.minX - x, aabb.minY - y, aabb.minZ - z, aabb.maxX + x, aabb.maxY + y, aabb.maxZ + z);
    }

    @Override
    public Optional<Vec3> findFreePosition(net.minecraft.world.entity.Entity entity, VoxelShape boundsShape, Vec3 fromPosition, double rangeX, double rangeY, double rangeZ) {
        if (boundsShape.isEmpty()) {
            return Optional.empty();
        }
        double expandByX = rangeX * 0.5;
        double expandByY = rangeY * 0.5;
        double expandByZ = rangeZ * 0.5;
        AABB collectionVolume = boundsShape.bounds().inflate(expandByX, expandByY, expandByZ);
        ArrayList<AABB> aabbs = new ArrayList<AABB>();
        ArrayList<VoxelShape> voxels = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, collectionVolume, voxels, aabbs, 4, null);
        WorldBorder worldBorder = this.getWorldBorder();
        if (worldBorder != null) {
            aabbs.removeIf(aabb -> !worldBorder.isWithinBounds((AABB)aabb));
            voxels.removeIf(shape -> !worldBorder.isWithinBounds(shape.bounds()));
        }
        int len = voxels.size();
        for (int i = 0; i < len; ++i) {
            aabbs.addAll(((VoxelShape)voxels.get(i)).toAabbs());
        }
        VoxelShape first = aabbs.isEmpty() ? Shapes.empty() : Level.inflateAABBToVoxel((AABB)aabbs.get(0), expandByX, expandByY, expandByZ);
        VoxelShape[] rest = new VoxelShape[Math.max(0, aabbs.size() - 1)];
        int len2 = aabbs.size();
        for (int i = 1; i < len2; ++i) {
            rest[i - 1] = Level.inflateAABBToVoxel((AABB)aabbs.get(i), expandByX, expandByY, expandByZ);
        }
        VoxelShape joined = Shapes.or(first, rest);
        VoxelShape freeSpace = Shapes.joinUnoptimized(boundsShape, joined, BooleanOp.ONLY_FIRST);
        return freeSpace.closestPointTo(fromPosition);
    }

    @Override
    public Optional<BlockPos> findSupportingBlock(net.minecraft.world.entity.Entity entity, AABB aabb) {
        int minSection = WorldUtil.getMinSection(this);
        int minBlockX = Mth.floor(aabb.minX - 1.0E-7) - 1;
        int maxBlockX = Mth.floor(aabb.maxX + 1.0E-7) + 1;
        int minBlockY = Math.max((minSection << 4) - 1, Mth.floor(aabb.minY - 1.0E-7) - 1);
        int maxBlockY = Math.min((WorldUtil.getMaxSection(this) << 4) + 16, Mth.floor(aabb.maxY + 1.0E-7) + 1);
        int minBlockZ = Mth.floor(aabb.minZ - 1.0E-7) - 1;
        int maxBlockZ = Mth.floor(aabb.maxZ + 1.0E-7) + 1;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        CollisionUtil.LazyEntityCollisionContext collisionShape = new CollisionUtil.LazyEntityCollisionContext(entity);
        Vec3i selected = null;
        double selectedDistance = Double.MAX_VALUE;
        Vec3 entityPos = entity.position();
        if (minBlockY > maxBlockY) {
            return Optional.empty();
        }
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkY = minBlockY >> 4;
        int maxChunkY = maxBlockY >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        ChunkSource chunkSource = this.getChunkSource();
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                ChunkAccess chunk = chunkSource.getChunk(currChunkX, currChunkZ, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                LevelChunkSection[] sections = chunk.getSections();
                for (int currChunkY = minChunkY; currChunkY <= maxChunkY; ++currChunkY) {
                    LevelChunkSection section;
                    int sectionIdx = currChunkY - minSection;
                    if (sectionIdx < 0 || sectionIdx >= sections.length || (section = sections[sectionIdx]).hasOnlyAir()) continue;
                    boolean hasSpecial = section.moonrise$hasSpecialCollidingBlocks();
                    int sectionAdjust = !hasSpecial ? 1 : 0;
                    PalettedContainer<BlockState> blocks = section.states;
                    int minXIterate = currChunkX == minChunkX ? (minBlockX & 0xF) + sectionAdjust : 0;
                    int maxXIterate = currChunkX == maxChunkX ? (maxBlockX & 0xF) - sectionAdjust : 15;
                    int minZIterate = currChunkZ == minChunkZ ? (minBlockZ & 0xF) + sectionAdjust : 0;
                    int maxZIterate = currChunkZ == maxChunkZ ? (maxBlockZ & 0xF) - sectionAdjust : 15;
                    int minYIterate = currChunkY == minChunkY ? (minBlockY & 0xF) + sectionAdjust : 0;
                    int maxYIterate = currChunkY == maxChunkY ? (maxBlockY & 0xF) - sectionAdjust : 15;
                    for (int currY = minYIterate; currY <= maxYIterate; ++currY) {
                        int blockY = currY | currChunkY << 4;
                        mutablePos.setY(blockY);
                        for (int currZ = minZIterate; currZ <= maxZIterate; ++currZ) {
                            int blockZ = currZ | currChunkZ << 4;
                            mutablePos.setZ(blockZ);
                            for (int currX = minXIterate; currX <= maxXIterate; ++currX) {
                                BlockState blockData;
                                double distance;
                                int edgeCount;
                                int localBlockIndex = currX | currZ << 4 | currY << 8;
                                int blockX = currX | currChunkX << 4;
                                mutablePos.setX(blockX);
                                int n = hasSpecial ? (blockX == minBlockX || blockX == maxBlockX ? 1 : 0) + (blockY == minBlockY || blockY == maxBlockY ? 1 : 0) + (blockZ == minBlockZ || blockZ == maxBlockZ ? 1 : 0) : (edgeCount = 0);
                                if (edgeCount == 3 || (distance = mutablePos.distToCenterSqr(entityPos)) > selectedDistance || distance == selectedDistance && selected.compareTo(mutablePos) >= 0 || (blockData = blocks.get(localBlockIndex)).moonrise$emptyContextCollisionShape()) continue;
                                VoxelShape blockCollision = blockData.moonrise$getConstantContextCollisionShape();
                                if (edgeCount != 0 && (edgeCount == 1 && !blockData.hasLargeCollisionShape() || edgeCount == 2 && blockData.getBlock() != Blocks.MOVING_PISTON) || blockCollision == null && (blockCollision = blockData.getCollisionShape(this, mutablePos, collisionShape)).isEmpty()) continue;
                                AABB shiftedAABB = aabb.move(-((double)blockX), -((double)blockY), -((double)blockZ));
                                AABB singleAABB = blockCollision.moonrise$getSingleAABBRepresentation();
                                if (singleAABB != null) {
                                    if (!CollisionUtil.voxelShapeIntersect(singleAABB, shiftedAABB)) continue;
                                    selected = mutablePos.immutable();
                                    selectedDistance = distance;
                                    continue;
                                }
                                if (!CollisionUtil.voxelShapeIntersectNoEmpty(blockCollision, shiftedAABB)) continue;
                                selected = mutablePos.immutable();
                                selectedDistance = distance;
                            }
                        }
                    }
                }
            }
        }
        return Optional.ofNullable(selected);
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMaxY() {
        return this.maxY;
    }

    @Override
    public int getSectionsCount() {
        return this.sectionsCount;
    }

    @Override
    public int getMinSectionY() {
        return this.minSectionY;
    }

    @Override
    public int getMaxSectionY() {
        return this.maxSectionY;
    }

    @Override
    public boolean isInsideBuildHeight(int blockY) {
        return blockY >= this.minY && blockY <= this.maxY;
    }

    @Override
    public boolean isOutsideBuildHeight(BlockPos pos) {
        return this.isOutsideBuildHeight(pos.getY());
    }

    @Override
    public boolean isOutsideBuildHeight(int blockY) {
        return blockY < this.minY || blockY > this.maxY;
    }

    @Override
    public int getSectionIndex(int blockY) {
        return (blockY >> 4) - this.minSectionY;
    }

    @Override
    public int getSectionIndexFromSectionY(int sectionY) {
        return sectionY - this.minSectionY;
    }

    @Override
    public int getSectionYFromSectionIndex(int sectionIdx) {
        return sectionIdx + this.minSectionY;
    }

    @Override
    public abstract Holder<Biome> getUncachedNoiseBiome(int var1, int var2, int var3);

    @Override
    public Holder<Biome> getNoiseBiome(int x, int y, int z) {
        ChunkAccess chunk = this.getChunk(x >> 2, z >> 2, ChunkStatus.BIOMES, false);
        return chunk != null ? chunk.getNoiseBiome(x, y, z) : this.getUncachedNoiseBiome(x, y, z);
    }

    protected Level(WritableLevelData levelData, ResourceKey<Level> dimension, RegistryAccess registryAccess, Holder<DimensionType> dimensionTypeRegistration, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates, @Nullable ChunkGenerator generator, @Nullable BiomeProvider biomeProvider, World.Environment environment, Function<SpigotWorldConfig, WorldConfiguration> paperWorldConfigCreator, Executor executor) {
        DimensionType dimType = dimensionTypeRegistration.value();
        this.minY = dimType.minY();
        this.height = dimType.height();
        this.maxY = this.minY + this.height - 1;
        this.minSectionY = this.minY >> 4;
        this.maxSectionY = this.maxY >> 4;
        this.sectionsCount = this.maxSectionY - this.minSectionY + 1;
        this.spigotConfig = new SpigotWorldConfig(((PrimaryLevelData)levelData).getLevelName());
        this.paperConfig = paperWorldConfigCreator.apply(this.spigotConfig);
        this.generator = generator;
        this.world = new CraftWorld((ServerLevel)this, generator, biomeProvider, environment);
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.ticksPerSpawnCategory.put((Object)spawnCategory, (long)this.getTicksPerSpawn(spawnCategory));
        }
        this.levelData = levelData;
        this.dimensionTypeRegistration = dimensionTypeRegistration;
        this.dimension = dimension;
        this.isClientSide = isClientSide;
        this.thread = Thread.currentThread();
        this.biomeManager = new BiomeManager(this, biomeZoomSeed);
        this.isDebug = isDebug;
        this.neighborUpdater = new CollectingNeighborUpdater(this, maxChainedNeighborUpdates);
        this.registryAccess = registryAccess;
        this.palettedContainerFactory = PalettedContainerFactory.create(registryAccess);
        this.damageSources = new DamageSources(registryAccess);
        this.entityLookup = new DefaultEntityLookup(this);
        this.chunkPacketBlockController = this.paperConfig().anticheat.antiXray.enabled ? new ChunkPacketBlockControllerAntiXray(this, executor) : ChunkPacketBlockController.NO_OPERATION_INSTANCE;
    }

    public final boolean checkEntityCollision(BlockState state, net.minecraft.world.entity.Entity source, CollisionContext collisionContext, BlockPos position, boolean checkCanSee) {
        VoxelShape collisionShape = state.getCollisionShape(this, position, collisionContext);
        if (collisionShape.isEmpty()) {
            return true;
        }
        if ((collisionShape = collisionShape.move(position.getX(), position.getY(), position.getZ())).isEmpty()) {
            return true;
        }
        List<net.minecraft.world.entity.Entity> entities = this.getEntities(null, collisionShape.bounds());
        int len = entities.size();
        for (int i = 0; i < len; ++i) {
            net.minecraft.world.entity.Entity entity = entities.get(i);
            if (checkCanSee && source instanceof ServerPlayer && entity instanceof ServerPlayer && !((ServerPlayer)source).getBukkitEntity().canSee(((ServerPlayer)entity).getBukkitEntity()) || entity.isRemoved() || !entity.blocksBuilding || !Shapes.joinIsNotEmpty(collisionShape, Shapes.create(entity.getBoundingBox()), BooleanOp.AND)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClientSide() {
        return this.isClientSide;
    }

    @Override
    public @Nullable MinecraftServer getServer() {
        return null;
    }

    public HitResult.Type clipDirect(Vec3 start, Vec3 end, CollisionContext context) {
        return this.clip(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, context)).getType();
    }

    public boolean isInWorldBounds(BlockPos pos) {
        return pos.isInsideBuildHeightAndWorldBoundsHorizontal(this);
    }

    public boolean isInValidBounds(BlockPos blockPos) {
        return !this.isOutsideBuildHeight(blockPos) && Level.isInValidBoundsHorizontal(blockPos);
    }

    public static boolean isInSpawnableBounds(BlockPos pos) {
        return !Level.isOutsideSpawnableHeight(pos.getY()) && Level.isInWorldBoundsHorizontal(pos);
    }

    private static boolean isInWorldBoundsHorizontal(BlockPos pos) {
        return pos.getX() >= -30000000 && pos.getZ() >= -30000000 && pos.getX() < 30000000 && pos.getZ() < 30000000;
    }

    private static boolean isInValidBoundsHorizontal(BlockPos blockPos) {
        int sectionPosX = SectionPos.blockToSectionCoord(blockPos.getX());
        int sectionPosZ = SectionPos.blockToSectionCoord(blockPos.getZ());
        return ChunkPos.isValid(sectionPosX, sectionPosZ);
    }

    private static boolean isOutsideSpawnableHeight(int y) {
        return y < -20000000 || y >= 20000000;
    }

    public final LevelChunk getChunkAt(BlockPos pos) {
        return this.getChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()));
    }

    @Override
    public final LevelChunk getChunk(int chunkX, int chunkZ) {
        ServerChunkCache cps = ((ServerLevel)this).getChunkSource();
        LevelChunk ifLoaded = cps.getChunkAtIfLoadedImmediately(chunkX, chunkZ);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        return (LevelChunk)cps.getChunk(chunkX, chunkZ, ChunkStatus.FULL, true);
    }

    @Override
    public final @Nullable ChunkAccess getChunkIfLoadedImmediately(int x, int z) {
        return ((ServerLevel)this).chunkSource.getChunkAtIfLoadedImmediately(x, z);
    }

    @Override
    public final @Nullable BlockState getBlockStateIfLoaded(BlockPos pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (this.isOutsideBuildHeight(pos)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
        return chunk == null ? null : chunk.getBlockState(pos);
    }

    @Override
    public final @Nullable FluidState getFluidIfLoaded(BlockPos pos) {
        ChunkAccess chunk = this.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
        return chunk == null ? null : chunk.getFluidState(pos);
    }

    @Override
    public final boolean hasChunkAt(BlockPos pos) {
        return this.getChunkIfLoaded(pos.getX() >> 4, pos.getZ() >> 4) != null;
    }

    public final boolean isLoadedAndInBounds(BlockPos pos) {
        return this.getWorldBorder().isWithinBounds(pos) && this.getChunkIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4) != null;
    }

    public @Nullable LevelChunk getChunkIfLoaded(int x, int z) {
        return ((ServerLevel)this).getChunkSource().getChunkAtIfLoadedImmediately(x, z);
    }

    public final @Nullable LevelChunk getChunkIfLoaded(BlockPos pos) {
        return ((ServerLevel)this).getChunkSource().getChunkAtIfLoadedImmediately(pos.getX() >> 4, pos.getZ() >> 4);
    }

    public final @Nullable BlockState getBlockStateIfLoadedAndInBounds(BlockPos pos) {
        return this.getWorldBorder().isWithinBounds(pos) ? this.getBlockStateIfLoaded(pos) : null;
    }

    @Override
    public @Nullable ChunkAccess getChunk(int x, int z, ChunkStatus chunkStatus, boolean requireChunk) {
        ChunkAccess chunk = this.getChunkSource().getChunk(x, z, chunkStatus, requireChunk);
        if (chunk == null && requireChunk) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunk;
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState state, @Block.UpdateFlags int flags) {
        return this.setBlock(pos, state, flags, 512);
    }

    @Override
    public boolean setBlock(BlockPos pos, BlockState state, @Block.UpdateFlags int flags, int recursionLeft) {
        if (this.captureTreeGeneration) {
            BlockState type = this.getBlockState(pos);
            if (!type.isDestroyable()) {
                return false;
            }
            CraftBlockState blockstate = this.capturedBlockStates.get(pos);
            if (blockstate == null) {
                blockstate = CapturedBlockState.getTreeBlockState(this, pos, flags);
                this.capturedBlockStates.put(pos.immutable(), blockstate);
            }
            blockstate.setData(state);
            blockstate.setFlags(flags);
            return true;
        }
        if (!this.isInValidBounds(pos)) {
            return false;
        }
        if (!this.isClientSide() && this.isDebug()) {
            return false;
        }
        LevelChunk chunkAt = this.getChunkAt(pos);
        Block block = state.getBlock();
        boolean captured = false;
        if (this.captureBlockStates) {
            CraftBlockState snapshot;
            if (!this.capturedBlockStates.containsKey(pos)) {
                snapshot = (CraftBlockState)CraftBlock.at(this, pos).getState();
                this.capturedBlockStates.put(pos.immutable(), snapshot);
                captured = true;
            } else {
                snapshot = this.capturedBlockStates.get(pos);
            }
            snapshot.setFlags(flags);
        }
        BlockState blockState = chunkAt.setBlockState(pos, state, flags);
        this.chunkPacketBlockController.onBlockChange(this, pos, state, blockState, flags, recursionLeft);
        if (blockState == null) {
            if (this.captureBlockStates && captured) {
                this.capturedBlockStates.remove(pos);
            }
            return false;
        }
        BlockState blockState1 = this.getBlockState(pos);
        if (!this.captureBlockStates) {
            try {
                this.notifyAndUpdatePhysics(pos, chunkAt, blockState, state, blockState1, flags, recursionLeft);
            }
            catch (StackOverflowError ex) {
                lastPhysicsProblem = pos.immutable();
            }
        }
        return true;
    }

    public void notifyAndUpdatePhysics(BlockPos pos, LevelChunk chunkAt, BlockState oldState, BlockState newState, BlockState currentState, @Block.UpdateFlags int flags, int recursionLeft) {
        BlockState state = newState;
        BlockState blockState = oldState;
        BlockState blockState1 = currentState;
        if (blockState1 == state) {
            if (blockState != blockState1) {
                this.setBlocksDirty(pos, blockState, blockState1);
            }
            if ((flags & 2) != 0 && (!this.isClientSide() || (flags & 4) == 0) && (this.isClientSide() || chunkAt == null || chunkAt.getFullStatus() != null && chunkAt.getFullStatus().isOrAfter(FullChunkStatus.FULL))) {
                this.sendBlockUpdated(pos, blockState, state, flags);
            }
            if ((flags & 1) != 0) {
                this.updateNeighborsAt(pos, blockState.getBlock());
                if (!this.isClientSide() && state.hasAnalogOutputSignal()) {
                    this.updateNeighbourForOutputSignal(pos, newState.getBlock());
                }
            }
            if ((flags & 0x10) == 0 && recursionLeft > 0) {
                int i = flags & 0xFFFFFFDE;
                blockState.updateIndirectNeighbourShapes(this, pos, i, recursionLeft - 1);
                boolean cancelledUpdates = false;
                if (((ServerLevel)this).hasPhysicsEvent) {
                    BlockPhysicsEvent event = new BlockPhysicsEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)CraftBlockData.fromData(state));
                    boolean bl = cancelledUpdates = !event.callEvent();
                }
                if (!cancelledUpdates) {
                    state.updateNeighbourShapes(this, pos, i, recursionLeft - 1);
                    state.updateIndirectNeighbourShapes(this, pos, i, recursionLeft - 1);
                }
            }
            this.updatePOIOnBlockStateChange(pos, blockState, blockState1);
        }
    }

    public void updatePOIOnBlockStateChange(BlockPos pos, BlockState oldState, BlockState newState) {
    }

    @Override
    public boolean removeBlock(BlockPos pos, boolean movedByPiston) {
        FluidState fluidState = this.getFluidState(pos);
        return this.setBlock(pos, fluidState.createLegacyBlock(), 3 | (movedByPiston ? 64 : 0));
    }

    @Override
    public boolean destroyBlock(BlockPos pos, boolean dropBlock, @Nullable net.minecraft.world.entity.Entity entity, int recursionLeft) {
        boolean flag;
        BlockState blockState = this.getBlockState(pos);
        if (blockState.isAir()) {
            return false;
        }
        FluidState fluidState = this.getFluidState(pos);
        boolean playEffect = true;
        BlockState effectType = blockState;
        int xp = blockState.getBlock().getExpDrop(blockState, (ServerLevel)this, pos, ItemStack.EMPTY, true);
        if (BlockDestroyEvent.getHandlerList().getRegisteredListeners().length > 0) {
            BlockDestroyEvent event = new BlockDestroyEvent((org.bukkit.block.Block)CraftBlock.at(this, pos), (BlockData)fluidState.createLegacyBlock().createCraftBlockData(), (BlockData)effectType.createCraftBlockData(), xp, dropBlock);
            if (!event.callEvent()) {
                return false;
            }
            effectType = ((CraftBlockData)event.getEffectBlock()).getState();
            playEffect = event.playEffect();
            dropBlock = event.willDrop();
            xp = event.getExpToDrop();
        }
        if (playEffect && !(blockState.getBlock() instanceof BaseFireBlock)) {
            this.levelEvent(2001, pos, Block.getId(effectType));
        }
        if (dropBlock) {
            BlockEntity blockEntity = blockState.hasBlockEntity() ? this.getBlockEntity(pos) : null;
            Block.dropResources(blockState, this, pos, blockEntity, entity, ItemStack.EMPTY, false);
            blockState.getBlock().popExperience((ServerLevel)this, pos, xp, entity);
        }
        if (flag = this.setBlock(pos, fluidState.createLegacyBlock(), 3, recursionLeft)) {
            this.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(entity, blockState));
        }
        return flag;
    }

    public void addDestroyBlockEffect(BlockPos pos, BlockState state) {
    }

    public boolean setBlockAndUpdate(BlockPos pos, BlockState state) {
        return this.setBlock(pos, state, 3);
    }

    public abstract void sendBlockUpdated(BlockPos var1, BlockState var2, BlockState var3, @Block.UpdateFlags int var4);

    public void setBlocksDirty(BlockPos pos, BlockState oldState, BlockState newState) {
    }

    public void updateNeighborsAt(BlockPos pos, Block block, @Nullable Orientation orientation) {
    }

    public void updateNeighborsAtExceptFromFacing(BlockPos pos, Block block, Direction facing, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockPos pos, Block block, @Nullable Orientation orientation) {
    }

    public void neighborChanged(BlockState state, BlockPos pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) {
    }

    @Override
    public void neighborShapeChanged(Direction direction, BlockPos pos, BlockPos neighborPos, BlockState neighborState, @Block.UpdateFlags int flags, int recursionLeft) {
        this.neighborUpdater.shapeUpdate(direction, neighborState, pos, neighborPos, flags, recursionLeft);
    }

    @Override
    public int getHeight(Heightmap.Types heightmapType, int x, int z) {
        int i = x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 ? (this.hasChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z)) ? this.getChunk(SectionPos.blockToSectionCoord(x), SectionPos.blockToSectionCoord(z)).getHeight(heightmapType, x & 0xF, z & 0xF) + 1 : this.getMinY()) : this.getSeaLevel() + 1;
        return i;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.getChunkSource().getLightEngine();
    }

    @Override
    public BlockState getBlockState(BlockPos pos) {
        CraftBlockState previous;
        if (this.captureTreeGeneration && (previous = this.capturedBlockStates.get(pos)) != null) {
            return previous.getHandle();
        }
        if (!this.isInValidBounds(pos)) {
            return Blocks.VOID_AIR.defaultBlockState();
        }
        ChunkAccess chunk = this.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.FULL, true);
        return chunk.getBlockState(pos);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        if (!this.isInValidBounds(pos)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        LevelChunk chunkAt = this.getChunkAt(pos);
        return chunkAt.getFluidState(pos);
    }

    public boolean isBrightOutside() {
        return !this.dimensionType().hasFixedTime() && this.skyDarken < 4;
    }

    public boolean isDarkOutside() {
        return !this.dimensionType().hasFixedTime() && !this.isBrightOutside();
    }

    @Override
    public void playSound(@Nullable net.minecraft.world.entity.Entity entity, BlockPos pos, SoundEvent sound, SoundSource category, float volume, float pitch) {
        this.playSound(entity, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound, category, volume, pitch);
    }

    public abstract void playSeededSound(@Nullable net.minecraft.world.entity.Entity var1, double var2, double var4, double var6, Holder<SoundEvent> var8, SoundSource var9, float var10, float var11, long var12);

    public void playSeededSound(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch, long seed) {
        this.playSeededSound(entity, x, y, z, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), source, volume, pitch, seed);
    }

    public abstract void playSeededSound(@Nullable net.minecraft.world.entity.Entity var1, net.minecraft.world.entity.Entity var2, Holder<SoundEvent> var3, SoundSource var4, float var5, float var6, long var7);

    public void playSound(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, SoundEvent sound, SoundSource source) {
        this.playSound(entity, x, y, z, sound, source, 1.0f, 1.0f);
    }

    public void playSound(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.playSeededSound(entity, x, y, z, sound, source, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable net.minecraft.world.entity.Entity entity, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch) {
        this.playSeededSound(entity, x, y, z, sound, source, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playSound(@Nullable net.minecraft.world.entity.Entity entity, net.minecraft.world.entity.Entity sourceEntity, SoundEvent sound, SoundSource source, float volume, float pitch) {
        this.playSeededSound(entity, sourceEntity, BuiltInRegistries.SOUND_EVENT.wrapAsHolder(sound), source, volume, pitch, this.threadSafeRandom.nextLong());
    }

    public void playLocalSound(BlockPos pos, SoundEvent sound, SoundSource source, float volume, float pitch, boolean distanceDelay) {
        this.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, sound, source, volume, pitch, distanceDelay);
    }

    public void playLocalSound(net.minecraft.world.entity.Entity entity, SoundEvent sound, SoundSource source, float volume, float pitch) {
    }

    public void playLocalSound(double x, double y, double z, SoundEvent sound, SoundSource source, float volume, float pitch, boolean distanceDelay) {
    }

    public void playPlayerSound(SoundEvent sound, SoundSource source, float volume, float pitch) {
    }

    @Override
    public void addParticle(ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void addParticle(ParticleOptions options, boolean overrideLimiter, boolean alwaysShow, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions options, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void addAlwaysVisibleParticle(ParticleOptions options, boolean overrideLimiter, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void addBlockEntityTicker(TickingBlockEntity ticker) {
        (this.tickingBlockEntities ? this.pendingBlockEntityTickers : this.blockEntityTickers).add(ticker);
    }

    public void tickBlockEntities() {
        this.tickingBlockEntities = true;
        if (!this.pendingBlockEntityTickers.isEmpty()) {
            this.blockEntityTickers.addAll(this.pendingBlockEntityTickers);
            this.pendingBlockEntityTickers.clear();
        }
        boolean runsNormally = this.tickRateManager().runsNormally();
        int tickedEntities = 0;
        ReferenceOpenHashSet toRemove = new ReferenceOpenHashSet();
        toRemove.add(null);
        this.tileTickPosition = 0;
        while (this.tileTickPosition < this.blockEntityTickers.size()) {
            TickingBlockEntity tickingBlockEntity = this.blockEntityTickers.get(this.tileTickPosition);
            if (tickingBlockEntity.isRemoved()) {
                toRemove.add((Object)tickingBlockEntity);
            } else if (runsNormally && this.shouldTickBlocksAt(tickingBlockEntity.getPos())) {
                tickingBlockEntity.tick();
                if ((++tickedEntities & 7) == 0) {
                    this.moonrise$midTickTasks();
                }
            }
            ++this.tileTickPosition;
        }
        this.blockEntityTickers.removeAll((Collection<?>)toRemove);
        this.tickingBlockEntities = false;
        this.spigotConfig.currentPrimedTnt = 0;
    }

    public <T extends net.minecraft.world.entity.Entity> void guardEntityTick(Consumer<T> action, T entity) {
        try {
            action.accept(entity);
        }
        catch (Throwable var6) {
            String msg = String.format("Entity threw exception at %s:%s,%s,%s", entity.level().getWorld().getName(), entity.getX(), entity.getY(), entity.getZ());
            MinecraftServer.LOGGER.error(msg, var6);
            this.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, var6)));
            entity.discard(EntityRemoveEvent.Cause.DISCARD);
        }
        this.moonrise$midTickTasks();
    }

    @Override
    public boolean noCollision(@Nullable net.minecraft.world.entity.Entity entity, AABB box) {
        int flags;
        if (entity instanceof ArmorStand && !entity.level().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return false;
        }
        int n = flags = entity == null ? 12 : 8;
        if (CollisionUtil.getCollisionsForBlocksOrWorldBorder(this, entity, box, null, null, flags, null)) {
            return false;
        }
        return !CollisionUtil.getEntityHardCollisions(this, entity, box, null, flags, null);
    }

    public boolean shouldTickDeath(net.minecraft.world.entity.Entity entity) {
        return true;
    }

    public boolean shouldTickBlocksAt(long chunkPos) {
        return true;
    }

    public boolean shouldTickBlocksAt(BlockPos pos) {
        return this.shouldTickBlocksAt(ChunkPos.asLong(pos));
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity source, double x, double y, double z, float radius, ExplosionInteraction explosionInteraction) {
        this.explode(source, Explosion.getDefaultDamageSource(this, source), null, x, y, z, radius, false, explosionInteraction, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity source, double x, double y, double z, float radius, boolean fire, ExplosionInteraction explosionInteraction) {
        this.explode(source, Explosion.getDefaultDamageSource(this, source), null, x, y, z, radius, fire, explosionInteraction, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, Vec3 pos, float radius, boolean fire, ExplosionInteraction explosionInteraction) {
        this.explode(source, damageSource, damageCalculator, pos.x(), pos.y(), pos.z(), radius, fire, explosionInteraction, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEvents.GENERIC_EXPLODE);
    }

    public void explode(@Nullable net.minecraft.world.entity.Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, ExplosionInteraction explosionInteraction) {
        this.explode(source, damageSource, damageCalculator, x, y, z, radius, fire, explosionInteraction, ParticleTypes.EXPLOSION, ParticleTypes.EXPLOSION_EMITTER, DEFAULT_EXPLOSION_BLOCK_PARTICLES, SoundEvents.GENERIC_EXPLODE);
    }

    public abstract void explode(@Nullable net.minecraft.world.entity.Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, ExplosionInteraction var12, ParticleOptions var13, ParticleOptions var14, WeightedList<ExplosionParticleInfo> var15, Holder<SoundEvent> var16);

    public abstract String gatherChunkSourceStats();

    @Override
    public @Nullable BlockEntity getBlockEntity(BlockPos pos) {
        BlockEntity blockEntity;
        if (!this.capturedTileEntities.isEmpty() && (blockEntity = this.capturedTileEntities.get(pos)) != null) {
            return blockEntity;
        }
        if (!this.isInValidBounds(pos)) {
            return null;
        }
        return !this.isClientSide() && !TickThread.isTickThread() ? null : this.getChunkAt(pos).getBlockEntity(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    public void setBlockEntity(BlockEntity blockEntity) {
        BlockPos blockPos = blockEntity.getBlockPos();
        if (this.isInValidBounds(blockPos)) {
            if (this.captureBlockStates) {
                this.capturedTileEntities.put(blockPos.immutable(), blockEntity);
                return;
            }
            this.getChunkAt(blockPos).addAndRegisterBlockEntity(blockEntity);
        }
    }

    public void removeBlockEntity(BlockPos pos) {
        if (this.isInValidBounds(pos)) {
            this.getChunkAt(pos).removeBlockEntity(pos);
        }
    }

    public boolean isLoaded(BlockPos pos) {
        return this.isInValidBounds(pos) && this.getChunkSource().hasChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()));
    }

    public boolean loadedAndEntityCanStandOnFace(BlockPos pos, net.minecraft.world.entity.Entity entity, Direction direction) {
        if (!this.isInValidBounds(pos)) {
            return false;
        }
        ChunkAccess chunk = this.getChunk(SectionPos.blockToSectionCoord(pos.getX()), SectionPos.blockToSectionCoord(pos.getZ()), ChunkStatus.FULL, false);
        return chunk != null && chunk.getBlockState(pos).entityCanStandOnFace(this, pos, entity, direction);
    }

    public boolean loadedAndEntityCanStandOn(BlockPos pos, net.minecraft.world.entity.Entity entity) {
        return this.loadedAndEntityCanStandOnFace(pos, entity, Direction.UP);
    }

    public void updateSkyBrightness() {
        this.skyDarken = (int)(15.0f - this.environmentAttributes().getDimensionValue(EnvironmentAttributes.SKY_LIGHT_LEVEL).floatValue());
    }

    public void setSpawnSettings(boolean spawnSettings) {
        this.getChunkSource().setSpawnSettings(spawnSettings);
    }

    public abstract void setRespawnData(LevelData.RespawnData var1);

    public abstract LevelData.RespawnData getRespawnData();

    public LevelData.RespawnData getWorldBorderAdjustedRespawnData(LevelData.RespawnData respawnData) {
        WorldBorder worldBorder = this.getWorldBorder();
        if (!worldBorder.isWithinBounds(respawnData.pos())) {
            BlockPos heightmapPos = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, BlockPos.containing(worldBorder.getCenterX(), 0.0, worldBorder.getCenterZ()));
            return LevelData.RespawnData.of(respawnData.dimension(), heightmapPos, respawnData.yaw(), respawnData.pitch());
        }
        return respawnData;
    }

    protected void prepareWeather() {
        if (this.levelData.isRaining()) {
            this.rainLevel = 1.0f;
            if (this.levelData.isThundering()) {
                this.thunderLevel = 1.0f;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.getChunkSource().close();
    }

    @Override
    public @Nullable BlockGetter getChunkForCollisions(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
    }

    @Override
    public List<net.minecraft.world.entity.Entity> getEntities(@Nullable net.minecraft.world.entity.Entity entity, AABB boundingBox, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        Profiler.get().incrementCounter("getEntities");
        ArrayList list = Lists.newArrayList();
        ArrayList<net.minecraft.world.entity.Entity> ret = new ArrayList<net.minecraft.world.entity.Entity>();
        this.moonrise$getEntityLookup().getEntities(entity, boundingBox, ret, predicate);
        PlatformHooks.get().addToGetEntities(this, entity, boundingBox, predicate, ret);
        return ret;
    }

    @Override
    public <T extends net.minecraft.world.entity.Entity> List<T> getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate) {
        ArrayList list = Lists.newArrayList();
        this.getEntities(entityTypeTest, bounds, predicate, list);
        return list;
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate, List<? super T> output) {
        this.getEntities(entityTypeTest, bounds, predicate, output, Integer.MAX_VALUE);
    }

    public <T extends net.minecraft.world.entity.Entity> void getEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AABB boundingBox, Predicate<? super T> predicate, List<? super T> into, int maxCount) {
        Profiler.get().incrementCounter("getEntities");
        if (entityTypeTest instanceof EntityType) {
            EntityType byType = (EntityType)entityTypeTest;
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities(byType, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (entityTypeTest == null) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, predicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        Class<net.minecraft.world.entity.Entity> base = entityTypeTest.getBaseClass();
        Predicate<net.minecraft.world.entity.Entity> modifiedPredicate = predicate == null ? obj -> entityTypeTest.tryCast((net.minecraft.world.entity.Entity)obj) != null : obj -> {
            net.minecraft.world.entity.Entity casted = (net.minecraft.world.entity.Entity)entityTypeTest.tryCast((net.minecraft.world.entity.Entity)obj);
            if (casted == null) {
                return false;
            }
            return predicate.test(casted);
        };
        if (base == null || base == net.minecraft.world.entity.Entity.class) {
            if (maxCount != Integer.MAX_VALUE) {
                this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate, maxCount);
                PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
                return;
            }
            this.moonrise$getEntityLookup().getEntities((net.minecraft.world.entity.Entity)null, boundingBox, into, modifiedPredicate);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        if (maxCount != Integer.MAX_VALUE) {
            this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate, maxCount);
            PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
            return;
        }
        this.moonrise$getEntityLookup().getEntities(base, null, boundingBox, into, modifiedPredicate);
        PlatformHooks.get().addToGetEntities(this, entityTypeTest, boundingBox, predicate, into, maxCount);
    }

    public Entity[] getChunkEntities(int chunkX, int chunkZ) {
        ChunkEntitySlices slices = ((ServerLevel)this).moonrise$getEntityLookup().getChunk(chunkX, chunkZ);
        if (slices == null) {
            return new Entity[0];
        }
        ArrayList<CraftEntity> ret = new ArrayList<CraftEntity>();
        for (net.minecraft.world.entity.Entity entity : slices.getAllEntities()) {
            CraftEntity bukkit = entity.getBukkitEntity();
            if (bukkit == null || !bukkit.isValid()) continue;
            ret.add(bukkit);
        }
        return ret.toArray(new Entity[0]);
    }

    public <T extends net.minecraft.world.entity.Entity> boolean hasEntities(EntityTypeTest<net.minecraft.world.entity.Entity, T> entityTypeTest, AABB bounds, Predicate<? super T> predicate) {
        Profiler.get().incrementCounter("hasEntities");
        MutableBoolean mutableBoolean = new MutableBoolean();
        this.getEntities().get(entityTypeTest, bounds, value -> {
            if (predicate.test(value)) {
                mutableBoolean.setTrue();
                return AbortableIterationConsumer.Continuation.ABORT;
            }
            if (value instanceof EnderDragon) {
                EnderDragon enderDragon = (EnderDragon)value;
                for (EnderDragonPart enderDragonPart : enderDragon.getSubEntities()) {
                    net.minecraft.world.entity.Entity entity = (net.minecraft.world.entity.Entity)entityTypeTest.tryCast(enderDragonPart);
                    if (entity == null || !predicate.test(entity)) continue;
                    mutableBoolean.setTrue();
                    return AbortableIterationConsumer.Continuation.ABORT;
                }
            }
            return AbortableIterationConsumer.Continuation.CONTINUE;
        });
        return mutableBoolean.isTrue();
    }

    public List<net.minecraft.world.entity.Entity> getPushableEntities(net.minecraft.world.entity.Entity entity, AABB boundingBox) {
        return this.getEntities(entity, boundingBox, EntitySelector.pushableBy(entity));
    }

    public abstract @Nullable net.minecraft.world.entity.Entity getEntity(int var1);

    public @Nullable net.minecraft.world.entity.Entity getEntity(UUID uuid) {
        return this.getEntities().get(uuid);
    }

    public @Nullable net.minecraft.world.entity.Entity getEntityInAnyDimension(UUID id) {
        return this.getEntity(id);
    }

    public @Nullable Player getPlayerInAnyDimension(UUID id) {
        return this.getPlayerByUUID(id);
    }

    public abstract Collection<EnderDragonPart> dragonParts();

    public void blockEntityChanged(BlockPos pos) {
        if (this.hasChunkAt(pos)) {
            this.getChunkAt(pos).markUnsaved();
        }
    }

    public void onBlockEntityAdded(BlockEntity entity) {
    }

    public long getDayTime() {
        return this.levelData.getDayTime();
    }

    public boolean mayInteract(net.minecraft.world.entity.Entity entity, BlockPos pos) {
        return true;
    }

    public void broadcastEntityEvent(net.minecraft.world.entity.Entity entity, byte state) {
    }

    public void broadcastDamageEvent(net.minecraft.world.entity.Entity entity, DamageSource damageSource) {
    }

    public void blockEvent(BlockPos pos, Block block, int eventId, int eventParam) {
        this.getBlockState(pos).triggerEvent(this, pos, eventId, eventParam);
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    public abstract TickRateManager tickRateManager();

    public float getThunderLevel(float partialTick) {
        return Mth.lerp(partialTick, this.oThunderLevel, this.thunderLevel) * this.getRainLevel(partialTick);
    }

    public void setThunderLevel(float level) {
        float f;
        this.oThunderLevel = f = Mth.clamp(level, 0.0f, 1.0f);
        this.thunderLevel = f;
    }

    public float getRainLevel(float partialTick) {
        return Mth.lerp(partialTick, this.oRainLevel, this.rainLevel);
    }

    public void setRainLevel(float level) {
        float f;
        this.oRainLevel = f = Mth.clamp(level, 0.0f, 1.0f);
        this.rainLevel = f;
    }

    public boolean canHaveWeather() {
        return this.dimensionType().hasSkyLight() && !this.dimensionType().hasCeiling() && this.dimension() != END;
    }

    public boolean isThundering() {
        return this.canHaveWeather() && (double)this.getThunderLevel(1.0f) > 0.9;
    }

    public boolean isRaining() {
        return this.canHaveWeather() && (double)this.getRainLevel(1.0f) > 0.2;
    }

    public boolean isRainingAt(BlockPos pos) {
        return this.precipitationAt(pos) == Biome.Precipitation.RAIN;
    }

    public Biome.Precipitation precipitationAt(BlockPos pos) {
        if (!this.isRaining()) {
            return Biome.Precipitation.NONE;
        }
        if (!this.canSeeSky(pos)) {
            return Biome.Precipitation.NONE;
        }
        if (this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos).getY() > pos.getY()) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = this.getBiome(pos).value();
        return biome.getPrecipitationAt(pos, this.getSeaLevel());
    }

    public abstract @Nullable MapItemSavedData getMapData(MapId var1);

    public void globalLevelEvent(int id, BlockPos pos, int data) {
    }

    public CrashReportCategory fillReportDetails(CrashReport report) {
        CrashReportCategory crashReportCategory = report.addCategory("Affected level", 1);
        crashReportCategory.setDetail("All players", () -> {
            List<? extends Player> list = this.players();
            return list.size() + " total; " + list.stream().map(Player::debugInfo).collect(Collectors.joining(", "));
        });
        crashReportCategory.setDetail("Chunk stats", this.getChunkSource()::gatherStats);
        crashReportCategory.setDetail("Level dimension", () -> this.dimension().identifier().toString());
        try {
            this.levelData.fillCrashReportCategory(crashReportCategory, this);
        }
        catch (Throwable var4) {
            crashReportCategory.setDetailError("Level Data Unobtainable", var4);
        }
        return crashReportCategory;
    }

    public abstract void destroyBlockProgress(int var1, BlockPos var2, int var3);

    public void createFireworks(double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, List<FireworkExplosion> explosions) {
    }

    public abstract Scoreboard getScoreboard();

    public void updateNeighbourForOutputSignal(BlockPos pos, Block block) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            if (!this.hasChunkAt(blockPos)) continue;
            BlockState blockState = this.getBlockState(blockPos);
            if (blockState.is(Blocks.COMPARATOR)) {
                this.neighborChanged(blockState, blockPos, block, null, false);
                continue;
            }
            if (!blockState.isRedstoneConductor(this, blockPos) || !(blockState = this.getBlockState(blockPos = blockPos.relative(direction))).is(Blocks.COMPARATOR)) continue;
            this.neighborChanged(blockState, blockPos, block, null, false);
        }
    }

    @Override
    public int getSkyDarken() {
        return this.skyDarken;
    }

    public void setSkyFlashTime(int timeFlash) {
    }

    public void sendPacketToServer(Packet<?> packet) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionTypeRegistration.value();
    }

    public Holder<DimensionType> dimensionTypeRegistration() {
        return this.dimensionTypeRegistration;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public boolean isStateAtPosition(BlockPos pos, Predicate<BlockState> state) {
        return state.test(this.getBlockState(pos));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos pos, Predicate<FluidState> predicate) {
        return predicate.test(this.getFluidState(pos));
    }

    public abstract RecipeAccess recipeAccess();

    public BlockPos getBlockRandomPos(int x, int y, int z, int yMask) {
        this.randValue = this.randValue * 3 + 1013904223;
        int i = this.randValue >> 2;
        return new BlockPos(x + (i & 0xF), y + (i >> 16 & yMask), z + (i >> 8 & 0xF));
    }

    public boolean noSave() {
        return false;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    public final boolean isDebug() {
        return this.isDebug;
    }

    public abstract LevelEntityGetter<net.minecraft.world.entity.Entity> getEntities();

    @Override
    public long nextSubTickCount() {
        return this.subTickCount++;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public DamageSources damageSources() {
        return this.damageSources;
    }

    @Override
    public abstract EnvironmentAttributeSystem environmentAttributes();

    public abstract PotionBrewing potionBrewing();

    public abstract FuelValues fuelValues();

    public int getClientLeafTintColor(BlockPos pos) {
        return 0;
    }

    public PalettedContainerFactory palettedContainerFactory() {
        return this.palettedContainerFactory;
    }

    public WireHandler getWireHandler() {
        return null;
    }

    public final int getEntityCount() {
        return this.moonrise$getEntityLookup().getEntityCount();
    }

    static {
        AIR_FLUIDSTATE = Fluids.EMPTY.defaultFluidState();
    }

    public static enum ExplosionInteraction implements StringRepresentable
    {
        NONE("none"),
        BLOCK("block"),
        MOB("mob"),
        TNT("tnt"),
        TRIGGER("trigger"),
        STANDARD("standard");

        public static final Codec<ExplosionInteraction> CODEC;
        private final String id;

        private ExplosionInteraction(String id) {
            this.id = id;
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ExplosionInteraction::values);
        }
    }
}

