/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface SignalGetter
extends BlockGetter {
    public static final Direction[] DIRECTIONS = Direction.values();

    default public int getDirectSignal(BlockPos pos, Direction direction) {
        return this.getBlockState(pos).getDirectSignal(this, pos, direction);
    }

    default public int getDirectSignalTo(BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, this.getDirectSignal(pos.below(), Direction.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getDirectSignal(pos.above(), Direction.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getDirectSignal(pos.north(), Direction.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getDirectSignal(pos.south(), Direction.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.getDirectSignal(pos.west(), Direction.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, this.getDirectSignal(pos.east(), Direction.EAST))) >= 15 ? i : i;
    }

    default public int getControlInputSignal(BlockPos pos, Direction direction, boolean diodesOnly) {
        BlockState blockState = this.getBlockState(pos);
        if (diodesOnly) {
            return DiodeBlock.isDiode(blockState) ? this.getDirectSignal(pos, direction) : 0;
        }
        if (blockState.is(Blocks.REDSTONE_BLOCK)) {
            return 15;
        }
        if (blockState.is(Blocks.REDSTONE_WIRE)) {
            return blockState.getValue(RedStoneWireBlock.POWER);
        }
        return blockState.isSignalSource() ? this.getDirectSignal(pos, direction) : 0;
    }

    default public boolean hasSignal(BlockPos pos, Direction direction) {
        return this.getSignal(pos, direction) > 0;
    }

    default public int getSignal(BlockPos pos, Direction direction) {
        BlockState blockState = this.getBlockState(pos);
        int signal = blockState.getSignal(this, pos, direction);
        return blockState.isRedstoneConductor(this, pos) ? Math.max(signal, this.getDirectSignalTo(pos)) : signal;
    }

    default public boolean hasNeighborSignal(BlockPos pos) {
        return this.getSignal(pos.below(), Direction.DOWN) > 0 || this.getSignal(pos.above(), Direction.UP) > 0 || this.getSignal(pos.north(), Direction.NORTH) > 0 || this.getSignal(pos.south(), Direction.SOUTH) > 0 || this.getSignal(pos.west(), Direction.WEST) > 0 || this.getSignal(pos.east(), Direction.EAST) > 0;
    }

    default public int getBestNeighborSignal(BlockPos pos) {
        int i = 0;
        for (Direction direction : DIRECTIONS) {
            int signal = this.getSignal(pos.relative(direction), direction);
            if (signal >= 15) {
                return 15;
            }
            if (signal <= i) continue;
            i = signal;
        }
        return i;
    }
}

