/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import org.jspecify.annotations.Nullable;

public class Climate {
    private static final boolean DEBUG_SLOW_BIOME_SEARCH = false;
    private static final float QUANTIZATION_FACTOR = 10000.0f;
    @VisibleForTesting
    protected static final int PARAMETER_COUNT = 7;

    public static TargetPoint target(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness) {
        return new TargetPoint(Climate.quantizeCoord(temperature), Climate.quantizeCoord(humidity), Climate.quantizeCoord(continentalness), Climate.quantizeCoord(erosion), Climate.quantizeCoord(depth), Climate.quantizeCoord(weirdness));
    }

    public static ParameterPoint parameters(float temperature, float humidity, float continentalness, float erosion, float depth, float weirdness, float offset) {
        return new ParameterPoint(Parameter.point(temperature), Parameter.point(humidity), Parameter.point(continentalness), Parameter.point(erosion), Parameter.point(depth), Parameter.point(weirdness), Climate.quantizeCoord(offset));
    }

    public static ParameterPoint parameters(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, float offset) {
        return new ParameterPoint(temperature, humidity, continentalness, erosion, depth, weirdness, Climate.quantizeCoord(offset));
    }

    public static long quantizeCoord(float coord) {
        return (long)(coord * 10000.0f);
    }

    public static float unquantizeCoord(long coord) {
        return (float)coord / 10000.0f;
    }

    public static Sampler empty() {
        DensityFunction densityFunction = DensityFunctions.zero();
        return new Sampler(densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, densityFunction, List.of());
    }

    public static BlockPos findSpawnPosition(List<ParameterPoint> points, Sampler sampler) {
        return new SpawnFinder(points, (Sampler)sampler).result.location();
    }

    public record TargetPoint(long temperature, long humidity, long continentalness, long erosion, long depth, long weirdness) {
        @VisibleForTesting
        protected long[] toParameterArray() {
            return new long[]{this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, 0L};
        }
    }

    public record ParameterPoint(Parameter temperature, Parameter humidity, Parameter continentalness, Parameter erosion, Parameter depth, Parameter weirdness, long offset) {
        public static final Codec<ParameterPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Parameter.CODEC.fieldOf("temperature").forGetter(point -> point.temperature), (App)Parameter.CODEC.fieldOf("humidity").forGetter(point -> point.humidity), (App)Parameter.CODEC.fieldOf("continentalness").forGetter(point -> point.continentalness), (App)Parameter.CODEC.fieldOf("erosion").forGetter(point -> point.erosion), (App)Parameter.CODEC.fieldOf("depth").forGetter(point -> point.depth), (App)Parameter.CODEC.fieldOf("weirdness").forGetter(point -> point.weirdness), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("offset").xmap(Climate::quantizeCoord, Climate::unquantizeCoord).forGetter(point -> point.offset)).apply((Applicative)instance, ParameterPoint::new));

        long fitness(TargetPoint point) {
            return Mth.square(this.temperature.distance(point.temperature)) + Mth.square(this.humidity.distance(point.humidity)) + Mth.square(this.continentalness.distance(point.continentalness)) + Mth.square(this.erosion.distance(point.erosion)) + Mth.square(this.depth.distance(point.depth)) + Mth.square(this.weirdness.distance(point.weirdness)) + Mth.square(this.offset);
        }

        protected List<Parameter> parameterSpace() {
            return ImmutableList.of((Object)this.temperature, (Object)this.humidity, (Object)this.continentalness, (Object)this.erosion, (Object)this.depth, (Object)this.weirdness, (Object)new Parameter(this.offset, this.offset));
        }
    }

    public record Parameter(long min, long max) {
        public static final Codec<Parameter> CODEC = ExtraCodecs.intervalCodec(Codec.floatRange((float)-2.0f, (float)2.0f), "min", "max", (min, max) -> min.compareTo((Float)max) > 0 ? DataResult.error(() -> "Cannon construct interval, min > max (" + min + " > " + max + ")") : DataResult.success((Object)new Parameter(Climate.quantizeCoord(min.floatValue()), Climate.quantizeCoord(max.floatValue()))), climateParameter -> Float.valueOf(Climate.unquantizeCoord(climateParameter.min())), climateParameter -> Float.valueOf(Climate.unquantizeCoord(climateParameter.max())));

        public static Parameter point(float value) {
            return Parameter.span(value, value);
        }

        public static Parameter span(float min, float max) {
            if (min > max) {
                throw new IllegalArgumentException("min > max: " + min + " " + max);
            }
            return new Parameter(Climate.quantizeCoord(min), Climate.quantizeCoord(max));
        }

        public static Parameter span(Parameter min, Parameter max) {
            if (min.min() > max.max()) {
                throw new IllegalArgumentException("min > max: " + String.valueOf(min) + " " + String.valueOf(max));
            }
            return new Parameter(min.min(), max.max());
        }

        @Override
        public String toString() {
            return this.min == this.max ? String.format(Locale.ROOT, "%d", this.min) : String.format(Locale.ROOT, "[%d-%d]", this.min, this.max);
        }

        public long distance(long pointValue) {
            long l = pointValue - this.max;
            long l1 = this.min - pointValue;
            return l > 0L ? l : Math.max(l1, 0L);
        }

        public long distance(Parameter parameter) {
            long l = parameter.min() - this.max;
            long l1 = this.min - parameter.max();
            return l > 0L ? l : Math.max(l1, 0L);
        }

        public Parameter span(@Nullable Parameter param) {
            return param == null ? this : new Parameter(Math.min(this.min, param.min()), Math.max(this.max, param.max()));
        }
    }

    public record Sampler(DensityFunction temperature, DensityFunction humidity, DensityFunction continentalness, DensityFunction erosion, DensityFunction depth, DensityFunction weirdness, List<ParameterPoint> spawnTarget) {
        public TargetPoint sample(int x, int y, int z) {
            int blockPosX = QuartPos.toBlock(x);
            int blockPosY = QuartPos.toBlock(y);
            int blockPosZ = QuartPos.toBlock(z);
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(blockPosX, blockPosY, blockPosZ);
            return Climate.target((float)this.temperature.compute(singlePointContext), (float)this.humidity.compute(singlePointContext), (float)this.continentalness.compute(singlePointContext), (float)this.erosion.compute(singlePointContext), (float)this.depth.compute(singlePointContext), (float)this.weirdness.compute(singlePointContext));
        }

        public BlockPos findSpawnPosition() {
            return this.spawnTarget.isEmpty() ? BlockPos.ZERO : Climate.findSpawnPosition(this.spawnTarget, this);
        }
    }

    static class SpawnFinder {
        private static final long MAX_RADIUS = 2048L;
        Result result;

        SpawnFinder(List<ParameterPoint> points, Sampler sampler) {
            this.result = SpawnFinder.getSpawnPositionAndFitness(points, sampler, 0, 0);
            this.radialSearch(points, sampler, 2048.0f, 512.0f);
            this.radialSearch(points, sampler, 512.0f, 32.0f);
        }

        private void radialSearch(List<ParameterPoint> point, Sampler sampler, float max, float min) {
            float f = 0.0f;
            float f1 = min;
            BlockPos blockPos = this.result.location();
            while (f1 <= max) {
                int i1;
                int i = blockPos.getX() + (int)(Math.sin(f) * (double)f1);
                Result spawnPositionAndFitness = SpawnFinder.getSpawnPositionAndFitness(point, sampler, i, i1 = blockPos.getZ() + (int)(Math.cos(f) * (double)f1));
                if (spawnPositionAndFitness.fitness() < this.result.fitness()) {
                    this.result = spawnPositionAndFitness;
                }
                if (!((double)(f += min / f1) > Math.PI * 2)) continue;
                f = 0.0f;
                f1 += min;
            }
        }

        private static Result getSpawnPositionAndFitness(List<ParameterPoint> points, Sampler sampler, int x, int z) {
            TargetPoint targetPoint = sampler.sample(QuartPos.fromBlock(x), 0, QuartPos.fromBlock(z));
            TargetPoint targetPoint1 = new TargetPoint(targetPoint.temperature(), targetPoint.humidity(), targetPoint.continentalness(), targetPoint.erosion(), 0L, targetPoint.weirdness());
            long l = Long.MAX_VALUE;
            for (ParameterPoint parameterPoint : points) {
                l = Math.min(l, parameterPoint.fitness(targetPoint1));
            }
            long l1 = Mth.square((long)x) + Mth.square((long)z);
            long l2 = l * Mth.square(2048L) + l1;
            return new Result(new BlockPos(x, 0, z), l2);
        }

        record Result(BlockPos location, long fitness) {
        }
    }

    protected static final class RTree<T> {
        private static final int CHILDREN_PER_NODE = 6;
        private final Node<T> root;
        private final ThreadLocal<@Nullable Leaf<T>> lastResult = new ThreadLocal();

        private RTree(Node<T> root) {
            this.root = root;
        }

        public static <T> RTree<T> create(List<Pair<ParameterPoint, T>> nodes) {
            if (nodes.isEmpty()) {
                throw new IllegalArgumentException("Need at least one value to build the search tree.");
            }
            int size = ((ParameterPoint)nodes.get(0).getFirst()).parameterSpace().size();
            if (size != 7) {
                throw new IllegalStateException("Expecting parameter space to be 7, got " + size);
            }
            List list = nodes.stream().map(node -> new Leaf<Object>((ParameterPoint)node.getFirst(), node.getSecond())).collect(Collectors.toCollection(ArrayList::new));
            return new RTree<T>(RTree.build(size, list));
        }

        private static <T> Node<T> build(int paramSpaceSize, List<? extends Node<T>> children) {
            if (children.isEmpty()) {
                throw new IllegalStateException("Need at least one child to build a node");
            }
            if (children.size() == 1) {
                return children.get(0);
            }
            if (children.size() <= 6) {
                children.sort(Comparator.comparingLong(child -> {
                    long l2 = 0L;
                    for (int i2 = 0; i2 < paramSpaceSize; ++i2) {
                        Parameter parameter = child.parameterSpace[i2];
                        l2 += Math.abs((parameter.min() + parameter.max()) / 2L);
                    }
                    return l2;
                }));
                return new SubTree(children);
            }
            long l = Long.MAX_VALUE;
            int i = -1;
            List<SubTree<T>> list = null;
            for (int i1 = 0; i1 < paramSpaceSize; ++i1) {
                RTree.sort(children, paramSpaceSize, i1, false);
                List<SubTree<T>> list1 = RTree.bucketize(children);
                long l1 = 0L;
                for (SubTree<T> subTree : list1) {
                    l1 += RTree.cost(subTree.parameterSpace);
                }
                if (l <= l1) continue;
                l = l1;
                i = i1;
                list = list1;
            }
            RTree.sort(list, paramSpaceSize, i, true);
            return new SubTree(list.stream().map(subTree1 -> RTree.build(paramSpaceSize, Arrays.asList(subTree1.children))).collect(Collectors.toList()));
        }

        private static <T> void sort(List<? extends Node<T>> children, int paramSpaceSize, int size, boolean absolute) {
            Comparator<Node<Node<T>>> comparator = RTree.comparator(size, absolute);
            for (int i = 1; i < paramSpaceSize; ++i) {
                comparator = comparator.thenComparing(RTree.comparator((size + i) % paramSpaceSize, absolute));
            }
            children.sort(comparator);
        }

        private static <T> Comparator<Node<T>> comparator(int size, boolean absolute) {
            return Comparator.comparingLong(node -> {
                Parameter parameter = node.parameterSpace[size];
                long l = (parameter.min() + parameter.max()) / 2L;
                return absolute ? Math.abs(l) : l;
            });
        }

        private static <T> List<SubTree<T>> bucketize(List<? extends Node<T>> nodes) {
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            int i = (int)Math.pow(6.0, Math.floor(Math.log((double)nodes.size() - 0.01) / Math.log(6.0)));
            for (Node<T> node : nodes) {
                list1.add(node);
                if (list1.size() < i) continue;
                list.add(new SubTree(list1));
                list1 = Lists.newArrayList();
            }
            if (!list1.isEmpty()) {
                list.add(new SubTree(list1));
            }
            return list;
        }

        private static long cost(Parameter[] parameters) {
            long l = 0L;
            for (Parameter parameter : parameters) {
                l += Math.abs(parameter.max() - parameter.min());
            }
            return l;
        }

        static <T> List<Parameter> buildParameterSpace(List<? extends Node<T>> children) {
            if (children.isEmpty()) {
                throw new IllegalArgumentException("SubTree needs at least one child");
            }
            int i = 7;
            ArrayList list = Lists.newArrayList();
            for (int i1 = 0; i1 < 7; ++i1) {
                list.add(null);
            }
            for (Node<T> node : children) {
                for (int i2 = 0; i2 < 7; ++i2) {
                    list.set(i2, node.parameterSpace[i2].span((Parameter)list.get(i2)));
                }
            }
            return list;
        }

        public T search(TargetPoint targetPoint, DistanceMetric<T> distanceMetric) {
            long[] longs = targetPoint.toParameterArray();
            Leaf<T> leaf = this.root.search(longs, this.lastResult.get(), distanceMetric);
            this.lastResult.set(leaf);
            return leaf.value;
        }

        static abstract class Node<T> {
            protected final Parameter[] parameterSpace;

            protected Node(List<Parameter> parameters) {
                this.parameterSpace = parameters.toArray(new Parameter[0]);
            }

            protected abstract Leaf<T> search(long[] var1, @Nullable Leaf<T> var2, DistanceMetric<T> var3);

            protected long distance(long[] values) {
                long l = 0L;
                for (int i = 0; i < 7; ++i) {
                    l += Mth.square(this.parameterSpace[i].distance(values[i]));
                }
                return l;
            }

            public String toString() {
                return Arrays.toString(this.parameterSpace);
            }
        }

        static final class SubTree<T>
        extends Node<T> {
            final Node<T>[] children;

            protected SubTree(List<? extends Node<T>> parameters) {
                this(RTree.buildParameterSpace(parameters), parameters);
            }

            protected SubTree(List<Parameter> parameters, List<? extends Node<T>> children) {
                super(parameters);
                this.children = children.toArray(new Node[0]);
            }

            @Override
            protected Leaf<T> search(long[] searchedValues, @Nullable Leaf<T> leaf, DistanceMetric<T> metric) {
                long l = leaf == null ? Long.MAX_VALUE : metric.distance(leaf, searchedValues);
                Leaf<T> leaf1 = leaf;
                for (Node<T> node : this.children) {
                    long l2;
                    long l1 = metric.distance(node, searchedValues);
                    if (l <= l1) continue;
                    Leaf<T> leaf2 = node.search(searchedValues, leaf1, metric);
                    long l3 = l2 = node == leaf2 ? l1 : metric.distance(leaf2, searchedValues);
                    if (l <= l2) continue;
                    l = l2;
                    leaf1 = leaf2;
                }
                return leaf1;
            }
        }

        static final class Leaf<T>
        extends Node<T> {
            final T value;

            Leaf(ParameterPoint parameters, T value) {
                super(parameters.parameterSpace());
                this.value = value;
            }

            @Override
            protected Leaf<T> search(long[] searchedValues, @Nullable Leaf<T> leaf, DistanceMetric<T> metric) {
                return this;
            }
        }
    }

    public static class ParameterList<T> {
        private final List<Pair<ParameterPoint, T>> values;
        private final RTree<T> index;

        public static <T> Codec<ParameterList<T>> codec(MapCodec<T> codec) {
            return ExtraCodecs.nonEmptyList(RecordCodecBuilder.create(instance -> instance.group((App)ParameterPoint.CODEC.fieldOf("parameters").forGetter(Pair::getFirst), (App)codec.forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).listOf()).xmap(ParameterList::new, ParameterList::values);
        }

        public ParameterList(List<Pair<ParameterPoint, T>> values) {
            this.values = values;
            this.index = RTree.create(values);
        }

        public List<Pair<ParameterPoint, T>> values() {
            return this.values;
        }

        public T findValue(TargetPoint targetPoint) {
            return this.findValueIndex(targetPoint);
        }

        @VisibleForTesting
        public T findValueBruteForce(TargetPoint targetPoint) {
            Iterator<Pair<ParameterPoint, T>> iterator = this.values().iterator();
            Pair<ParameterPoint, T> pair = iterator.next();
            long l = ((ParameterPoint)pair.getFirst()).fitness(targetPoint);
            Object second = pair.getSecond();
            while (iterator.hasNext()) {
                Pair<ParameterPoint, T> pair1 = iterator.next();
                long l1 = ((ParameterPoint)pair1.getFirst()).fitness(targetPoint);
                if (l1 >= l) continue;
                l = l1;
                second = pair1.getSecond();
            }
            return (T)second;
        }

        public T findValueIndex(TargetPoint targetPoint) {
            return this.findValueIndex(targetPoint, RTree.Node::distance);
        }

        protected T findValueIndex(TargetPoint targetPoint, DistanceMetric<T> distanceMetric) {
            return this.index.search(targetPoint, distanceMetric);
        }
    }

    static interface DistanceMetric<T> {
        public long distance(RTree.Node<T> var1, long[] var2);
    }
}

