/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class Block
extends BlockBehaviour
implements ItemLike {
    public static final MapCodec<Block> CODEC = Block.simpleCodec(Block::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Holder.Reference<Block> builtInRegistryHolder = BuiltInRegistries.BLOCK.createIntrusiveHolder(this);
    public static final IdMapper<BlockState> BLOCK_STATE_REGISTRY = new IdMapper();
    private static final LoadingCache<VoxelShape, Boolean> SHAPE_FULL_BLOCK_CACHE = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean load(VoxelShape shape) {
            return !Shapes.joinIsNotEmpty(Shapes.block(), shape, BooleanOp.NOT_SAME);
        }
    });
    public static final int UPDATE_NEIGHBORS = 1;
    public static final int UPDATE_CLIENTS = 2;
    public static final int UPDATE_INVISIBLE = 4;
    public static final int UPDATE_IMMEDIATE = 8;
    public static final int UPDATE_KNOWN_SHAPE = 16;
    public static final int UPDATE_SUPPRESS_DROPS = 32;
    public static final int UPDATE_MOVE_BY_PISTON = 64;
    public static final int UPDATE_SKIP_SHAPE_UPDATE_ON_WIRE = 128;
    public static final int UPDATE_SKIP_BLOCK_ENTITY_SIDEEFFECTS = 256;
    public static final int UPDATE_SKIP_ON_PLACE = 512;
    @UpdateFlags
    public static final int UPDATE_NONE = 260;
    @UpdateFlags
    public static final int UPDATE_ALL = 3;
    @UpdateFlags
    public static final int UPDATE_ALL_IMMEDIATE = 11;
    @UpdateFlags
    public static final int UPDATE_SKIP_ALL_SIDEEFFECTS = 816;
    public static final float INDESTRUCTIBLE = -1.0f;
    public static final float INSTANT = 0.0f;
    public static final int UPDATE_LIMIT = 512;
    protected final StateDefinition<Block, BlockState> stateDefinition;
    private BlockState defaultBlockState;
    private @Nullable Item item;
    private static final int CACHE_SIZE = 256;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<ShapePairKey>> OCCLUSION_CACHE = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<ShapePairKey> map = new Object2ByteLinkedOpenHashMap<ShapePairKey>(256, 0.25f){

            protected void rehash(int newN) {
            }
        };
        map.defaultReturnValue((byte)127);
        return map;
    });

    public final boolean isDestroyable() {
        return GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || this != Blocks.BARRIER && this != Blocks.BEDROCK && this != Blocks.END_PORTAL_FRAME && this != Blocks.END_PORTAL && this != Blocks.END_GATEWAY && this != Blocks.COMMAND_BLOCK && this != Blocks.REPEATING_COMMAND_BLOCK && this != Blocks.CHAIN_COMMAND_BLOCK && this != Blocks.STRUCTURE_BLOCK && this != Blocks.JIGSAW;
    }

    @Override
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public static int getId(@Nullable BlockState state) {
        if (state == null) {
            return 0;
        }
        int id = BLOCK_STATE_REGISTRY.getId(state);
        return id == -1 ? 0 : id;
    }

    public static BlockState stateById(int id) {
        BlockState blockState = BLOCK_STATE_REGISTRY.byId(id);
        return blockState == null ? Blocks.AIR.defaultBlockState() : blockState;
    }

    public static Block byItem(@Nullable Item item) {
        return item instanceof BlockItem ? ((BlockItem)item).getBlock() : Blocks.AIR;
    }

    public static BlockState pushEntitiesUp(BlockState oldState, BlockState newState, LevelAccessor level, BlockPos pos) {
        VoxelShape voxelShape = Shapes.joinUnoptimized(oldState.getCollisionShape(level, pos), newState.getCollisionShape(level, pos), BooleanOp.ONLY_SECOND).move(pos);
        if (voxelShape.isEmpty()) {
            return newState;
        }
        for (Entity entity : level.getEntities(null, voxelShape.bounds())) {
            double d = Shapes.collide(Direction.Axis.Y, entity.getBoundingBox().move(0.0, 1.0, 0.0), List.of(voxelShape), -1.0);
            entity.teleportRelative(0.0, 1.0 + d, 0.0);
        }
        return newState;
    }

    public static VoxelShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Shapes.box(x1 / 16.0, y1 / 16.0, z1 / 16.0, x2 / 16.0, y2 / 16.0, z2 / 16.0);
    }

    public static VoxelShape[] boxes(int count, IntFunction<VoxelShape> boxCreator) {
        return (VoxelShape[])IntStream.rangeClosed(0, count).mapToObj(boxCreator).toArray(VoxelShape[]::new);
    }

    public static VoxelShape cube(double size) {
        return Block.cube(size, size, size);
    }

    public static VoxelShape cube(double xSize, double ySize, double zSize) {
        double d = ySize / 2.0;
        return Block.column(xSize, zSize, 8.0 - d, 8.0 + d);
    }

    public static VoxelShape column(double size, double y1, double y2) {
        return Block.column(size, size, y1, y2);
    }

    public static VoxelShape column(double xSize, double zSize, double y1, double y2) {
        double d = xSize / 2.0;
        double d1 = zSize / 2.0;
        return Block.box(8.0 - d, y1, 8.0 - d1, 8.0 + d, y2, 8.0 + d1);
    }

    public static VoxelShape boxZ(double size, double z1, double z2) {
        return Block.boxZ(size, size, z1, z2);
    }

    public static VoxelShape boxZ(double xSize, double ySize, double z1, double z2) {
        double d = ySize / 2.0;
        return Block.boxZ(xSize, 8.0 - d, 8.0 + d, z1, z2);
    }

    public static VoxelShape boxZ(double xSize, double y1, double y2, double z1, double z2) {
        double d = xSize / 2.0;
        return Block.box(8.0 - d, y1, z1, 8.0 + d, y2, z2);
    }

    public static BlockState updateFromNeighbourShapes(BlockState currentState, LevelAccessor level, BlockPos pos) {
        BlockState blockState = currentState;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : BlockBehaviour.UPDATE_SHAPE_ORDER) {
            mutableBlockPos.setWithOffset((Vec3i)pos, direction);
            blockState = blockState.updateShape(level, level, pos, direction, mutableBlockPos, level.getBlockState(mutableBlockPos), level.getRandom());
        }
        return blockState;
    }

    public static void updateOrDestroy(BlockState oldState, BlockState newState, LevelAccessor level, BlockPos pos, @UpdateFlags int flags) {
        Block.updateOrDestroy(oldState, newState, level, pos, flags, 512);
    }

    public static void updateOrDestroy(BlockState oldState, BlockState newState, LevelAccessor level, BlockPos pos, @UpdateFlags int flags, int recursionLeft) {
        if (newState != oldState) {
            if (newState.isAir()) {
                if (!level.isClientSide()) {
                    level.destroyBlock(pos, (flags & 0x20) == 0, null, recursionLeft);
                }
            } else {
                level.setBlock(pos, newState, flags & 0xFFFFFFDF, recursionLeft);
            }
        }
    }

    public Block(BlockBehaviour.Properties properties) {
        super(properties);
        String simpleName;
        StateDefinition.Builder<Block, BlockState> builder = new StateDefinition.Builder<Block, BlockState>(this);
        this.createBlockStateDefinition(builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState(this.stateDefinition.any());
        if (SharedConstants.IS_RUNNING_IN_IDE && !(simpleName = this.getClass().getSimpleName()).endsWith("Block")) {
            LOGGER.error("Block classes should end with Block and {} doesn't.", (Object)simpleName);
        }
    }

    public static boolean isExceptionForConnection(BlockState state) {
        return state.getBlock() instanceof LeavesBlock || state.is(Blocks.BARRIER) || state.is(Blocks.CARVED_PUMPKIN) || state.is(Blocks.JACK_O_LANTERN) || state.is(Blocks.MELON) || state.is(Blocks.PUMPKIN) || state.is(BlockTags.SHULKER_BOXES);
    }

    protected static boolean dropFromBlockInteractLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, BlockState state, @Nullable BlockEntity blockEntity, @Nullable net.minecraft.world.item.ItemStack tool, @Nullable Entity entity, BiConsumer<ServerLevel, net.minecraft.world.item.ItemStack> dropConsumer) {
        return Block.dropFromLootTable(level, lootTable, builder -> builder.withParameter(LootContextParams.BLOCK_STATE, state).withOptionalParameter(LootContextParams.BLOCK_ENTITY, blockEntity).withOptionalParameter(LootContextParams.INTERACTING_ENTITY, entity).withOptionalParameter(LootContextParams.TOOL, tool).create(LootContextParamSets.BLOCK_INTERACT), dropConsumer);
    }

    protected static boolean dropFromLootTable(ServerLevel level, ResourceKey<LootTable> lootTable, Function<LootParams.Builder, LootParams> params, BiConsumer<ServerLevel, net.minecraft.world.item.ItemStack> dropConsumer) {
        LootParams lootParams;
        LootTable lootTable1 = level.getServer().reloadableRegistries().getLootTable(lootTable);
        ObjectArrayList<net.minecraft.world.item.ItemStack> randomItems = lootTable1.getRandomItems(lootParams = params.apply(new LootParams.Builder(level)));
        if (!randomItems.isEmpty()) {
            randomItems.forEach(itemStack -> dropConsumer.accept(level, (net.minecraft.world.item.ItemStack)itemStack));
            return true;
        }
        return false;
    }

    public static boolean shouldRenderFace(BlockState currentState, BlockState neighborState, Direction face) {
        VoxelShape faceOcclusionShape = neighborState.getFaceOcclusionShape(face.getOpposite());
        if (faceOcclusionShape == Shapes.block()) {
            return false;
        }
        if (currentState.skipRendering(neighborState, face)) {
            return false;
        }
        if (faceOcclusionShape == Shapes.empty()) {
            return true;
        }
        VoxelShape faceOcclusionShape1 = currentState.getFaceOcclusionShape(face);
        if (faceOcclusionShape1 == Shapes.empty()) {
            return true;
        }
        ShapePairKey shapePairKey = new ShapePairKey(faceOcclusionShape1, faceOcclusionShape);
        Object2ByteLinkedOpenHashMap<ShapePairKey> map = OCCLUSION_CACHE.get();
        byte andMoveToFirst = map.getAndMoveToFirst((Object)shapePairKey);
        if (andMoveToFirst != 127) {
            return andMoveToFirst != 0;
        }
        boolean flag = Shapes.joinIsNotEmpty(faceOcclusionShape1, faceOcclusionShape, BooleanOp.ONLY_FIRST);
        if (map.size() == 256) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst((Object)shapePairKey, (byte)(flag ? 1 : 0));
        return flag;
    }

    public static boolean canSupportRigidBlock(BlockGetter level, BlockPos pos) {
        return level.getBlockState(pos).isFaceSturdy(level, pos, Direction.UP, SupportType.RIGID);
    }

    public static boolean canSupportCenter(LevelReader level, BlockPos pos, Direction direction) {
        BlockState blockState = level.getBlockState(pos);
        return (direction != Direction.DOWN || !blockState.is(BlockTags.UNSTABLE_BOTTOM_CENTER)) && blockState.isFaceSturdy(level, pos, direction, SupportType.CENTER);
    }

    public static boolean isFaceFull(VoxelShape shape, Direction face) {
        VoxelShape faceShape = shape.getFaceShape(face);
        return Block.isShapeFullBlock(faceShape);
    }

    public static boolean isShapeFullBlock(VoxelShape shape) {
        return shape.moonrise$isFullBlock();
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
    }

    public static List<net.minecraft.world.item.ItemStack> getDrops(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.TOOL, net.minecraft.world.item.ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, blockEntity);
        return state.getDrops(builder);
    }

    public static List<net.minecraft.world.item.ItemStack> getDrops(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        LootParams.Builder builder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, Vec3.atCenterOf(pos)).withParameter(LootContextParams.TOOL, tool).withOptionalParameter(LootContextParams.THIS_ENTITY, entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, blockEntity);
        return state.getDrops(builder);
    }

    public static boolean dropResources(BlockState state, LevelAccessor levelAccessor, BlockPos pos, @Nullable BlockEntity blockEntity, BlockPos source) {
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (net.minecraft.world.item.ItemStack drop : Block.getDrops(state, serverLevel, pos, blockEntity)) {
                items.add(CraftItemStack.asBukkitCopy(drop));
            }
            Block block = state.getBlock();
            BlockBreakBlockEvent event = new BlockBreakBlockEvent((org.bukkit.block.Block)CraftBlock.at(levelAccessor, pos), (org.bukkit.block.Block)CraftBlock.at(levelAccessor, source), items);
            event.setExpToDrop(block.getExpDrop(state, serverLevel, pos, net.minecraft.world.item.ItemStack.EMPTY, true));
            event.callEvent();
            for (ItemStack drop : event.getDrops()) {
                Block.popResource((Level)serverLevel, pos, CraftItemStack.asNMSCopy(drop));
            }
            state.spawnAfterBreak(serverLevel, pos, net.minecraft.world.item.ItemStack.EMPTY, false);
            block.popExperience(serverLevel, pos, event.getExpToDrop());
        }
        return true;
    }

    public static void dropResources(BlockState state, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)level, pos, null).forEach(stack -> Block.popResource(level, pos, stack));
            state.spawnAfterBreak((ServerLevel)level, pos, net.minecraft.world.item.ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(BlockState state, LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)level, pos, blockEntity).forEach(stack -> Block.popResource((Level)((ServerLevel)level), pos, stack));
            state.spawnAfterBreak((ServerLevel)level, pos, net.minecraft.world.item.ItemStack.EMPTY, true);
        }
    }

    public static void dropResources(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool) {
        Block.dropResources(state, level, pos, blockEntity, entity, tool, true);
    }

    public static void dropResources(BlockState state, Level level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity entity, net.minecraft.world.item.ItemStack tool, boolean dropExperience) {
        if (level instanceof ServerLevel) {
            Block.getDrops(state, (ServerLevel)level, pos, blockEntity, entity, tool).forEach(stack -> Block.popResource(level, pos, stack));
            state.spawnAfterBreak((ServerLevel)level, pos, tool, dropExperience);
        }
    }

    public static void popResource(Level level, BlockPos pos, net.minecraft.world.item.ItemStack stack) {
        double d = (double)EntityType.ITEM.getHeight() / 2.0;
        double d1 = (double)pos.getX() + 0.5 + Mth.nextDouble(level.random, -0.25, 0.25);
        double d2 = (double)pos.getY() + 0.5 + Mth.nextDouble(level.random, -0.25, 0.25) - d;
        double d3 = (double)pos.getZ() + 0.5 + Mth.nextDouble(level.random, -0.25, 0.25);
        Block.popResource(level, () -> new ItemEntity(level, d1, d2, d3, stack), stack);
    }

    public static void popResourceFromFace(Level level, BlockPos pos, Direction direction, net.minecraft.world.item.ItemStack stack) {
        int stepX = direction.getStepX();
        int stepY = direction.getStepY();
        int stepZ = direction.getStepZ();
        double d = (double)EntityType.ITEM.getWidth() / 2.0;
        double d1 = (double)EntityType.ITEM.getHeight() / 2.0;
        double d2 = (double)pos.getX() + 0.5 + (stepX == 0 ? Mth.nextDouble(level.random, -0.25, 0.25) : (double)stepX * (0.5 + d));
        double d3 = (double)pos.getY() + 0.5 + (stepY == 0 ? Mth.nextDouble(level.random, -0.25, 0.25) : (double)stepY * (0.5 + d1)) - d1;
        double d4 = (double)pos.getZ() + 0.5 + (stepZ == 0 ? Mth.nextDouble(level.random, -0.25, 0.25) : (double)stepZ * (0.5 + d));
        double d5 = stepX == 0 ? Mth.nextDouble(level.random, -0.1, 0.1) : (double)stepX * 0.1;
        double d6 = stepY == 0 ? Mth.nextDouble(level.random, 0.0, 0.1) : (double)stepY * 0.1 + 0.1;
        double d7 = stepZ == 0 ? Mth.nextDouble(level.random, -0.1, 0.1) : (double)stepZ * 0.1;
        Block.popResource(level, () -> new ItemEntity(level, d2, d3, d4, stack, d5, d6, d7), stack);
    }

    private static void popResource(Level level, Supplier<ItemEntity> itemEntitySupplier, net.minecraft.world.item.ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!stack.isEmpty() && serverLevel.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) {
                ItemEntity itemEntity = itemEntitySupplier.get();
                itemEntity.setDefaultPickUpDelay();
                if (level.captureDrops != null) {
                    level.captureDrops.add(itemEntity);
                } else {
                    level.addFreshEntity(itemEntity);
                }
            }
        }
    }

    public void popExperience(ServerLevel level, BlockPos pos, int amount) {
        this.popExperience(level, pos, amount, null);
    }

    public void popExperience(ServerLevel level, BlockPos pos, int amount, @Nullable Entity entity) {
        if (level.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue()) {
            ExperienceOrb.awardWithDirection(level, Vec3.atCenterOf(pos), Vec3.ZERO, amount, ExperienceOrb.SpawnReason.BLOCK_BREAK, entity, null);
        }
    }

    public float getExplosionResistance() {
        return this.explosionResistance;
    }

    public void wasExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
    }

    public @Nullable BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState();
    }

    @Deprecated
    @DoNotUse
    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, net.minecraft.world.item.ItemStack tool) {
        this.playerDestroy(level, player, pos, state, blockEntity, tool, true, true);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, net.minecraft.world.item.ItemStack tool, boolean includeDrops, boolean dropExp) {
        player.awardStat(Stats.BLOCK_MINED.get(this));
        player.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        if (includeDrops) {
            Block.dropResources(state, level, pos, blockEntity, player, tool, dropExp);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, net.minecraft.world.item.ItemStack stack) {
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return !state.isSolid() && !state.liquid();
    }

    public MutableComponent getName() {
        return Component.translatable(this.getDescriptionId());
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, double fallDistance) {
        entity.causeFallDamage(fallDistance, 1.0f, entity.damageSources().fall());
    }

    public void updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
    }

    public float getFriction() {
        return this.friction;
    }

    public float getSpeedFactor() {
        return this.speedFactor;
    }

    public float getJumpFactor() {
        return this.jumpFactor;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        level.levelEvent(player, 2001, pos, Block.getId(state));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        this.spawnDestroyParticles(level, player, pos, state);
        if (state.is(BlockTags.GUARDED_BY_PIGLINS) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PiglinAi.angerNearbyPiglins(serverLevel, player, false);
        }
        level.gameEvent(GameEvent.BLOCK_DESTROY, pos, GameEvent.Context.of(player, state));
        return state;
    }

    public void handlePrecipitation(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
    }

    public boolean dropFromExplosion(Explosion explosion) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public StateDefinition<Block, BlockState> getStateDefinition() {
        return this.stateDefinition;
    }

    protected final void registerDefaultState(BlockState state) {
        this.defaultBlockState = state;
    }

    public final BlockState defaultBlockState() {
        return this.defaultBlockState;
    }

    public final BlockState withPropertiesOf(BlockState state) {
        BlockState blockState = this.defaultBlockState();
        for (Property<?> property : state.getBlock().getStateDefinition().getProperties()) {
            if (!blockState.hasProperty(property)) continue;
            blockState = Block.copyProperty(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState sourceState, BlockState targetState, Property<T> property) {
        return (BlockState)targetState.setValue(property, sourceState.getValue(property));
    }

    @Override
    public Item asItem() {
        if (this.item == null) {
            this.item = Item.byBlock(this);
        }
        return this.item;
    }

    public boolean hasDynamicShape() {
        return this.dynamicShape;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.BLOCK.wrapAsHolder(this).getRegisteredName() + "}";
    }

    @Override
    protected Block asBlock() {
        return this;
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> shapeGetter) {
        return arg_0 -> ((ImmutableMap)((ImmutableMap)this.stateDefinition.getPossibleStates().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), shapeGetter)))).get(arg_0);
    }

    protected Function<BlockState, VoxelShape> getShapeForEachState(Function<BlockState, VoxelShape> shapeGetter, Property<?> ... properties) {
        Map<Property, Object> map = Arrays.stream(properties).collect(Collectors.toMap(property -> property, property -> property.getPossibleValues().getFirst()));
        ImmutableMap map1 = (ImmutableMap)this.stateDefinition.getPossibleStates().stream().filter(state -> map.entrySet().stream().allMatch(entry -> state.getValue((Property)entry.getKey()) == entry.getValue())).collect(ImmutableMap.toImmutableMap(Function.identity(), shapeGetter));
        return state -> {
            for (Map.Entry entry : map.entrySet()) {
                state = Block.setValueHelper(state, (Property)entry.getKey(), entry.getValue());
            }
            return (VoxelShape)map1.get(state);
        };
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S stateHolder, Property<T> property, Object value) {
        return (S)((StateHolder)stateHolder.setValue(property, (Comparable)((Comparable)value)));
    }

    @Deprecated
    public Holder.Reference<Block> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    protected int tryDropExperience(ServerLevel level, BlockPos pos, net.minecraft.world.item.ItemStack heldItem, IntProvider amount) {
        int i = EnchantmentHelper.processBlockExperience(level, heldItem, amount.sample(level.getRandom()));
        if (i > 0) {
            return i;
        }
        return 0;
    }

    public int getExpDrop(BlockState state, ServerLevel level, BlockPos pos, net.minecraft.world.item.ItemStack stack, boolean dropExperience) {
        return 0;
    }

    record ShapePairKey(VoxelShape first, VoxelShape second) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object other) {
            if (!(other instanceof ShapePairKey)) return false;
            ShapePairKey shapePairKey = (ShapePairKey)other;
            if (this.first != shapePairKey.first) return false;
            if (this.second != shapePairKey.second) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.first) * 31 + System.identityHashCode(this.second);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.METHOD, ElementType.TYPE_USE})
    public static @interface UpdateFlags {
    }
}

